/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppMessage
extends AbstractMRMessage
implements Delayed {
    private static int _nRetries = 3;
    protected static final int DCCppProgrammingTimeout = 10000;
    private static int DCCppMessageTimeout = 5000;
    private StringBuilder myMessage;
    private String myRegex;
    private char opcode;
    private String toStringCache = null;
    private long expireTime;
    private static final Logger log = LoggerFactory.getLogger(DCCppMessage.class);

    public DCCppMessage(int len) {
        super(len);
        this.setBinary(false);
        this.setRetries(_nRetries);
        this.setTimeout(DCCppMessageTimeout);
        if (len > 30 || len < 0) {
            log.error("Invalid length in ctor: {}", (Object)len);
        }
        this._nDataChars = len;
        this.myRegex = "";
        this.myMessage = new StringBuilder(len);
    }

    public DCCppMessage(DCCppMessage message) {
        super(message);
        this.setBinary(false);
        this.setRetries(_nRetries);
        this.setTimeout(DCCppMessageTimeout);
        this.myRegex = message.myRegex;
        this.myMessage = message.myMessage;
        this.toStringCache = message.toStringCache;
    }

    public DCCppMessage(DCCppReply message) {
        super(message.getNumDataElements());
        this.setBinary(false);
        this.setRetries(_nRetries);
        this.setTimeout(DCCppMessageTimeout);
        int i = 0;
        while (i < message.getNumDataElements()) {
            this.setElement(i, message.getElement(i));
            ++i;
        }
    }

    public DCCppMessage(String s) {
        this.setBinary(false);
        this.setRetries(_nRetries);
        this.setTimeout(DCCppMessageTimeout);
        this.myMessage = new StringBuilder(s);
        this.toStringCache = s;
        this.setRegex();
        this._nDataChars = this.myMessage.length();
        this._dataChars = new int[this._nDataChars];
    }

    protected DCCppMessage(char c) {
        this.setBinary(false);
        this.setRetries(_nRetries);
        this.setTimeout(DCCppMessageTimeout);
        this.opcode = c;
        this.myMessage = new StringBuilder(Character.toString(c));
        this._nDataChars = this.myMessage.length();
    }

    protected DCCppMessage(char c, String regex) {
        this.setBinary(false);
        this.setRetries(_nRetries);
        this.setTimeout(DCCppMessageTimeout);
        this.opcode = c;
        this.myRegex = regex;
        this.myMessage = new StringBuilder(Character.toString(c));
        this._nDataChars = this.myMessage.length();
    }

    private void setRegex() {
        switch (this.myMessage.charAt(0)) {
            case 't': {
                this.myRegex = "t\\s*(\\d+)\\s+(\\d+)\\s+([-]*\\d+)\\s+([1,0])\\s*";
                break;
            }
            case 'f': {
                this.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
                break;
            }
            case 'F': {
                this.myRegex = "F\\s*([0-9]{1,4})\\s*([0-9]){1,2}\\s*([1,0])\\s*";
                break;
            }
            case '-': {
                this.myRegex = "-\\s*([0-9]{0,4})\\s*";
                break;
            }
            case 'a': {
                this.myRegex = "a\\s(\\d+)\\s(\\d+)\\s([1,0])";
                break;
            }
            case 'T': {
                if (DCCppMessage.match(this.toString(), "T\\s(\\d+)\\s(\\d+)\\s(\\d+)", "ctor") != null) {
                    this.myRegex = "T\\s(\\d+)\\s(\\d+)\\s(\\d+)";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "T\\s(\\d+)\\sDCC\\s(\\d+)\\s(\\d+)", "ctor") != null) {
                    this.myRegex = "T\\s(\\d+)\\sDCC\\s(\\d+)\\s(\\d+)";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "T\\s(\\d+)\\sSERVO\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)", "ctor") != null) {
                    this.myRegex = "T\\s(\\d+)\\sSERVO\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "T\\s(\\d+)\\sVPIN\\s(\\d+)", "ctor") != null) {
                    this.myRegex = "T\\s(\\d+)\\sVPIN\\s(\\d+)";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "T\\s*(\\d+)", "ctor") != null) {
                    this.myRegex = "T\\s*(\\d+)";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "T", "ctor") != null) {
                    this.myRegex = "T";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "T\\s(\\d+)\\s([1,0])", "ctor") != null) {
                    this.myRegex = "T\\s(\\d+)\\s([1,0])";
                    break;
                }
                this.myRegex = "";
                break;
            }
            case 'S': {
                if (DCCppMessage.match(this.toString(), "S\\s(\\d+)\\s(\\d+)\\s([1,0])", "ctor") != null) {
                    this.myRegex = "S\\s(\\d+)\\s(\\d+)\\s([1,0])";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "S\\s(\\d+)", "ctor") != null) {
                    this.myRegex = "S\\s(\\d+)";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "S", "ctor") != null) {
                    this.myRegex = "S";
                    break;
                }
                this.myRegex = "";
                break;
            }
            case 'Z': {
                if (DCCppMessage.match(this.toString(), "\\s*Z\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*", "ctor") != null) {
                    this.myRegex = "\\s*Z\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "\\s*Z\\s*(\\d+)\\s*", "ctor") != null) {
                    this.myRegex = "\\s*Z\\s*(\\d+)\\s*";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "\\s*Z\\s*", "ctor") != null) {
                    this.myRegex = "\\s*Z\\s*";
                    break;
                }
                if (DCCppMessage.match(this.toString(), "Z\\s(\\d+)\\s([1,0])", "ctor") != null) {
                    this.myRegex = "Z\\s(\\d+)\\s([1,0])";
                    break;
                }
                this.myRegex = "";
                break;
            }
            case 'w': {
                this.myRegex = "\\s*w\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*";
                break;
            }
            case 'b': {
                this.myRegex = "\\s*b\\s*(\\d+)\\s+(\\d+)\\s+([0-7])\\s+([01])\\s*";
                break;
            }
            case 'W': {
                this.myRegex = "W\\s*(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)";
                break;
            }
            case 'B': {
                this.myRegex = "B\\s*(\\d+)\\s([0-7])\\s([1,0])\\s(\\d+)\\s(\\d+)";
                break;
            }
            case 'R': {
                this.myRegex = "R\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)";
                break;
            }
            case 'V': {
                this.myRegex = "V\\s*(\\d+)\\s+(\\d+)\\s*";
                break;
            }
            case '0': 
            case '1': {
                this.myRegex = "\\s*[0,1]\\s*";
                break;
            }
            case 'c': {
                this.myRegex = "\\s*c\\s*";
                break;
            }
            case 's': {
                this.myRegex = "\\s*s\\s*";
                break;
            }
            case '#': {
                this.myRegex = "\\s*#\\s*";
                break;
            }
            case 'E': {
                this.myRegex = "E";
                break;
            }
            case 'e': {
                this.myRegex = "e";
                break;
            }
            case 'Q': {
                this.myRegex = "\\s*Q\\s*";
                break;
            }
            case 'M': {
                this.myRegex = "M\\s+(\\d+)((\\s+[0-9a-fA-F]{1,2}){2,5})\\s*";
                break;
            }
            case 'P': {
                this.myRegex = "P\\s+(\\d+)((\\s+[0-9a-fA-F]{1,2}){2,5})\\s*";
                break;
            }
            case 'L': {
                this.myRegex = "\\s*L\\s*";
                break;
            }
            case 'D': {
                this.myRegex = "\\s*D\\s.*";
                break;
            }
            case '/': {
                this.myRegex = "\\s*/\\s.*";
                break;
            }
            default: {
                this.myRegex = "";
            }
        }
    }

    @Override
    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.myMessage.toString();
        }
        return this.toStringCache;
    }

    @Override
    public String toMonitorString() {
        String text;
        switch (this.getOpCodeChar()) {
            case 't': {
                text = "Throttle Cmd: ";
                text = String.valueOf(text) + "Register: " + this.getRegisterString();
                text = String.valueOf(text) + ", Address: " + this.getAddressString();
                text = String.valueOf(text) + ", Speed: " + this.getSpeedString();
                text = String.valueOf(text) + ", Direction: " + this.getDirectionString();
                break;
            }
            case 'f': {
                text = "Function Cmd: ";
                text = String.valueOf(text) + "Address: " + this.getFuncAddressString();
                text = String.valueOf(text) + ", Byte 1: " + this.getFuncByte1String();
                text = String.valueOf(text) + ", Byte 2: " + this.getFuncByte2String();
                text = String.valueOf(text) + ", (No Reply Expected)";
                break;
            }
            case 'F': {
                text = "Function Cmd: ";
                if (this.isFunctionV2Message()) {
                    text = String.valueOf(text) + "CAB: " + this.getFuncV2CabString();
                    text = String.valueOf(text) + ", FUNC: " + this.getFuncV2FuncString();
                    text = String.valueOf(text) + ", State: " + this.getFuncV2StateString();
                    text = String.valueOf(text) + ", (No Reply Expected)";
                    break;
                }
                text = String.valueOf(text) + "Invalid syntax: '" + this.toString() + "'";
                break;
            }
            case '-': {
                text = "Forget Cab: ";
                if (this.isForgetCabMessage()) {
                    text = String.valueOf(text) + "CAB: " + (this.getForgetCabString().equals("") ? "[ALL]" : this.getForgetCabString());
                    text = String.valueOf(text) + ", (No Reply Expected)";
                    break;
                }
                text = String.valueOf(text) + "Invalid syntax: '" + this.toString() + "'";
                break;
            }
            case 'a': {
                text = "Accessory Decoder Cmd: ";
                text = String.valueOf(text) + "Address: " + this.getAccessoryAddrString();
                text = String.valueOf(text) + ", Subaddr: " + this.getAccessorySubString();
                text = String.valueOf(text) + ", State: " + this.getAccessoryStateString();
                break;
            }
            case 'T': {
                if (this.isTurnoutAddMessage()) {
                    text = "Add Turnout: ";
                    text = String.valueOf(text) + "ID: " + this.getTOIDString();
                    text = String.valueOf(text) + ", Address: " + this.getTOAddressString();
                    text = String.valueOf(text) + ", Subaddr: " + this.getTOSubAddressString();
                    break;
                }
                if (this.isTurnoutAddDCCMessage()) {
                    text = "Add Turnout DCC: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString();
                    text = String.valueOf(text) + ", Address:" + this.getTOAddressString();
                    text = String.valueOf(text) + ", Subaddr:" + this.getTOSubAddressString();
                    break;
                }
                if (this.isTurnoutAddServoMessage()) {
                    text = "Add Turnout Servo: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString();
                    text = String.valueOf(text) + ", Pin:" + this.getTOPinInt();
                    text = String.valueOf(text) + ", ThrownPos:" + this.getTOThrownPositionInt();
                    text = String.valueOf(text) + ", ClosedPos:" + this.getTOClosedPositionInt();
                    text = String.valueOf(text) + ", Profile:" + this.getTOProfileInt();
                    break;
                }
                if (this.isTurnoutAddVpinMessage()) {
                    text = "Add Turnout Vpin: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString();
                    text = String.valueOf(text) + ", Pin:" + this.getTOPinInt();
                    break;
                }
                if (this.isTurnoutDeleteMessage()) {
                    text = "Delete Turnout: ";
                    text = String.valueOf(text) + "ID: " + this.getTOIDString();
                    break;
                }
                if (this.isListTurnoutsMessage()) {
                    text = "List Turnouts...";
                    break;
                }
                if (this.isTurnoutCmdMessage()) {
                    text = "Turnout Cmd: ";
                    text = String.valueOf(text) + "ID: " + this.getTOIDString();
                    text = String.valueOf(text) + ", State: " + this.getTOStateString();
                    break;
                }
                text = "Unmatched Turnout Cmd: " + this.toString();
                break;
            }
            case 'Z': {
                if (this.isOutputCmdMessage()) {
                    text = "Output Cmd: ";
                    text = String.valueOf(text) + "ID: " + this.getOutputIDString();
                    text = String.valueOf(text) + ", State: " + this.getOutputStateString();
                    break;
                }
                if (this.isOutputAddMessage()) {
                    text = "Add Output: ";
                    text = String.valueOf(text) + "ID: " + this.getOutputIDString();
                    text = String.valueOf(text) + ", Pin: " + this.getOutputPinString();
                    text = String.valueOf(text) + ", IFlag: " + this.getOutputIFlagString();
                    break;
                }
                if (this.isOutputDeleteMessage()) {
                    text = "Delete Output: ";
                    text = String.valueOf(text) + "ID: " + this.getOutputIDString();
                    break;
                }
                if (this.isListOutputsMessage()) {
                    text = "List Outputs...";
                    break;
                }
                text = "Invalid Output Command: " + this.toString();
                break;
            }
            case 'S': {
                if (this.isSensorAddMessage()) {
                    text = "Add Sensor: ";
                    text = String.valueOf(text) + "ID: " + this.getSensorIDString();
                    text = String.valueOf(text) + ", Pin: " + this.getSensorPinString();
                    text = String.valueOf(text) + ", Pullup: " + this.getSensorPullupString();
                    break;
                }
                if (this.isSensorDeleteMessage()) {
                    text = "Delete Sensor: ";
                    text = String.valueOf(text) + "ID: " + this.getSensorIDString();
                    break;
                }
                if (this.isListSensorsMessage()) {
                    text = "List Sensors...";
                    break;
                }
                text = "Unknown Sensor Cmd...";
                break;
            }
            case 'w': {
                text = "Ops Write Byte Cmd: ";
                text = String.valueOf(text) + "Address: " + this.getOpsWriteAddrString() + ", ";
                text = String.valueOf(text) + "CV: " + this.getOpsWriteCVString() + ", ";
                text = String.valueOf(text) + "Value: " + this.getOpsWriteValueString();
                break;
            }
            case 'b': {
                text = "Ops Write Bit Cmd: ";
                text = String.valueOf(text) + "Address: " + this.getOpsWriteAddrString() + ", ";
                text = String.valueOf(text) + "CV: " + this.getOpsWriteCVString() + ", ";
                text = String.valueOf(text) + "Bit: " + this.getOpsWriteBitString() + ", ";
                text = String.valueOf(text) + "Value: " + this.getOpsWriteValueString();
                break;
            }
            case 'W': {
                text = "Prog Write Byte Cmd: ";
                text = String.valueOf(text) + "CV : " + this.getCVString();
                text = String.valueOf(text) + ", Value: " + this.getProgValueString();
                text = String.valueOf(text) + ", Callback Num: " + this.getCallbackNumString();
                text = String.valueOf(text) + ", Callback Sub: " + this.getCallbackSubString();
                break;
            }
            case 'B': {
                text = "Prog Write Bit Cmd: ";
                text = String.valueOf(text) + "CV : " + this.getCVString();
                text = String.valueOf(text) + ", Bit : " + this.getBitString();
                text = String.valueOf(text) + ", Value: " + this.getProgValueString();
                text = String.valueOf(text) + ", Callback Num: " + this.getCallbackNumString();
                text = String.valueOf(text) + ", Callback Sub: " + this.getCallbackSubString();
                break;
            }
            case 'R': {
                text = "Prog Read Cmd: ";
                text = String.valueOf(text) + "CV: " + this.getCVString();
                text = String.valueOf(text) + ", Callback Num: " + this.getCallbackNumString();
                text = String.valueOf(text) + ", Callback Sub: " + this.getCallbackSubString();
                break;
            }
            case 'V': {
                text = "Prog Verify Cmd:  ";
                text = String.valueOf(text) + "CV: " + this.getCVString();
                text = String.valueOf(text) + ", startVal: " + this.getProgValueString();
                break;
            }
            case '1': {
                text = "Track Power ON Cmd ";
                break;
            }
            case '0': {
                text = "Track Power OFF Cmd ";
                break;
            }
            case 'c': {
                text = "Read Track Current Cmd ";
                break;
            }
            case 's': {
                text = "Status Cmd ";
                break;
            }
            case '#': {
                text = "Get MaxNumSlots Cmd ";
                break;
            }
            case 'M': {
                text = "Write DCC Packet Main Cmd: ";
                text = String.valueOf(text) + "Register: " + this.getRegisterString();
                text = String.valueOf(text) + ", Packet:" + this.getPacketString();
                break;
            }
            case 'P': {
                text = "Write DCC Packet Prog Cmd: ";
                text = String.valueOf(text) + "Register: " + this.getRegisterString();
                text = String.valueOf(text) + ", Packet:" + this.getPacketString();
                break;
            }
            case 'L': {
                text = "List Register Contents Cmd: ";
                text = String.valueOf(text) + this.toString();
                break;
            }
            case 'E': {
                text = "Write to EEPROM Cmd: ";
                text = String.valueOf(text) + this.toString();
                break;
            }
            case 'e': {
                text = "Clear EEPROM Cmd: ";
                text = String.valueOf(text) + this.toString();
                break;
            }
            case 'Q': {
                text = "Query Sensor States Cmd: '" + this.toString() + "'";
                break;
            }
            case 'D': {
                text = "Diag Cmd: '" + this.toString() + "'";
                break;
            }
            case '/': {
                text = "Control Cmd: '" + this.toString() + "'";
                break;
            }
            case '!': {
                text = "eStop All Locos Cmd: '" + this.toString() + "'";
                break;
            }
            default: {
                text = "Unknown Message: '" + this.toString() + "'";
            }
        }
        return text;
    }

    @Override
    public int getNumDataElements() {
        return this.myMessage.length();
    }

    @Override
    public int getElement(int n) {
        return this.myMessage.charAt(n);
    }

    @Override
    public void setElement(int n, int v) {
        char c = (char)(v & 0xFF);
        if (n >= this.myMessage.length()) {
            this.myMessage.append(c);
        } else if (n > 0) {
            this.myMessage.setCharAt(n, c);
        }
        this.toStringCache = null;
    }

    @Override
    public void setOpCode(int i) {
        if (i > 255 || i < 0) {
            log.error("Opcode invalid: {}", (Object)i);
        }
        this.opcode = (char)(i & 0xFF);
        this.myMessage.setCharAt(0, this.opcode);
        this.toStringCache = null;
    }

    @Override
    public int getOpCode() {
        return this.opcode & 0xFF;
    }

    public char getOpCodeChar() {
        return this.myMessage.charAt(0);
    }

    @Deprecated
    public String getOpCodeString() {
        return Character.toString(this.opcode);
    }

    private int getGroupCount() {
        Matcher m = DCCppMessage.match(this.toString(), this.myRegex, "gvs");
        assert (m != null);
        return m.groupCount();
    }

    public String getValueString(int idx) {
        Matcher m = DCCppMessage.match(this.toString(), this.myRegex, "gvs");
        if (m == null) {
            log.error("DCCppMessage '{}' not matched by '{}'", (Object)this.toString(), (Object)this.myRegex);
            return "";
        }
        if (idx <= m.groupCount()) {
            return m.group(idx);
        }
        log.error("DCCppMessage value index too big. idx = {} msg = {}", (Object)idx, (Object)this);
        return "";
    }

    public int getValueInt(int idx) {
        Matcher m = DCCppMessage.match(this.toString(), this.myRegex, "gvi");
        if (m == null) {
            log.error("DCCppMessage '{}' not matched by '{}'", (Object)this.toString(), (Object)this.myRegex);
            return 0;
        }
        if (idx <= m.groupCount()) {
            return Integer.parseInt(m.group(idx));
        }
        log.error("DCCppMessage value index too big. idx = {} msg = {}", (Object)idx, (Object)this);
        return 0;
    }

    public boolean getValueBool(int idx) {
        log.debug("msg = {}, regex = {}", (Object)this, (Object)this.myRegex);
        Matcher m = DCCppMessage.match(this.toString(), this.myRegex, "gvb");
        if (m == null) {
            log.error("DCCppMessage '{}' not matched by '{}'", (Object)this.toString(), (Object)this.myRegex);
            return false;
        }
        if (idx <= m.groupCount()) {
            return !m.group(idx).equals("0");
        }
        log.error("DCCppMessage value index too big. idx = {} msg = {}", (Object)idx, (Object)this);
        return false;
    }

    public int length() {
        return this.myMessage.length();
    }

    public static void setDCCppMessageRetries(int t) {
        _nRetries = t;
    }

    public static void setDCCppMessageTimeout(int t) {
        DCCppMessageTimeout = t;
    }

    public boolean isValidMessageFormat() {
        return this.match(this.myRegex) != null;
    }

    private Matcher match(String pat) {
        return DCCppMessage.match(this.toString(), pat, "Validator");
    }

    @CheckForNull
    private static Matcher match(String s, String pat, String name) {
        Matcher m;
        block5: {
            Pattern p = Pattern.compile(pat);
            m = p.matcher(s);
            if (m.matches()) break block5;
            log.trace("No Match {} Command: '{}' Pattern: '{}'", new Object[]{name, s, pat});
            return null;
        }
        try {
            return m;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            log.error("Malformed DCC++ message syntax! s = {}", (Object)pat);
            return null;
        }
        catch (IllegalStateException illegalStateException) {
            log.error("Group called before match operation executed string= {}", (Object)s);
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            log.error("Index out of bounds string= {}", (Object)s);
            return null;
        }
    }

    public boolean isThrottleMessage() {
        return this.getOpCodeChar() == 't';
    }

    public boolean isAccessoryMessage() {
        return this.getOpCodeChar() == 'a';
    }

    public boolean isFunctionMessage() {
        return this.getOpCodeChar() == 'f';
    }

    public boolean isFunctionV2Message() {
        return this.match("F\\s*([0-9]{1,4})\\s*([0-9]){1,2}\\s*([1,0])\\s*") != null;
    }

    public boolean isForgetCabMessage() {
        return this.match("-\\s*([0-9]{0,4})\\s*") != null;
    }

    public boolean isTurnoutMessage() {
        return this.getOpCodeChar() == 'T';
    }

    public boolean isSensorMessage() {
        return this.getOpCodeChar() == 'S';
    }

    public boolean isEEPROMWriteMessage() {
        return this.getOpCodeChar() == 'E';
    }

    public boolean isEEPROMClearMessage() {
        return this.getOpCodeChar() == 'e';
    }

    public boolean isOpsWriteByteMessage() {
        return this.getOpCodeChar() == 'w';
    }

    public boolean isOpsWriteBitMessage() {
        return this.getOpCodeChar() == 'b';
    }

    public boolean isProgWriteByteMessage() {
        return this.getOpCodeChar() == 'W';
    }

    public boolean isProgWriteBitMessage() {
        return this.getOpCodeChar() == 'B';
    }

    public boolean isProgReadMessage() {
        return this.getOpCodeChar() == 'R';
    }

    public boolean isProgVerifyMessage() {
        return this.getOpCodeChar() == 'V';
    }

    public boolean isTurnoutCmdMessage() {
        return this.match("T\\s(\\d+)\\s([1,0])") != null;
    }

    public boolean isTurnoutAddMessage() {
        return this.match("T\\s(\\d+)\\s(\\d+)\\s(\\d+)") != null;
    }

    public boolean isTurnoutAddDCCMessage() {
        return this.match("T\\s(\\d+)\\sDCC\\s(\\d+)\\s(\\d+)") != null;
    }

    public boolean isTurnoutAddServoMessage() {
        return this.match("T\\s(\\d+)\\sSERVO\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)") != null;
    }

    public boolean isTurnoutAddVpinMessage() {
        return this.match("T\\s(\\d+)\\sVPIN\\s(\\d+)") != null;
    }

    public boolean isTurnoutDeleteMessage() {
        return this.match("T\\s*(\\d+)") != null;
    }

    public boolean isListTurnoutsMessage() {
        return this.match("T") != null;
    }

    public boolean isSensorAddMessage() {
        return this.match("S\\s(\\d+)\\s(\\d+)\\s([1,0])") != null;
    }

    public boolean isSensorDeleteMessage() {
        return this.match("S\\s(\\d+)") != null;
    }

    public boolean isListSensorsMessage() {
        return this.match("S") != null;
    }

    public boolean isOutputCmdMessage() {
        return this.match("Z\\s(\\d+)\\s([1,0])") != null;
    }

    public boolean isOutputAddMessage() {
        return this.match("\\s*Z\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*") != null;
    }

    public boolean isOutputDeleteMessage() {
        return this.match("\\s*Z\\s*(\\d+)\\s*") != null;
    }

    public boolean isListOutputsMessage() {
        return this.match("\\s*Z\\s*") != null;
    }

    public boolean isQuerySensorStatesMessage() {
        return this.match("\\s*Q\\s*") != null;
    }

    public boolean isWriteDccPacketMessage() {
        return this.getOpCodeChar() == 'M' || this.getOpCodeChar() == 'P';
    }

    public String getOutputIDString() {
        if (this.isOutputAddMessage() || this.isOutputDeleteMessage() || this.isOutputCmdMessage()) {
            return this.getValueString(1);
        }
        log.error("Output Parser called on non-Output message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputIDInt() {
        if (this.isOutputAddMessage() || this.isOutputDeleteMessage() || this.isOutputCmdMessage()) {
            return this.getValueInt(1);
        }
        log.error("Output Parser called on non-Output message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getOutputPinString() {
        if (this.isOutputAddMessage()) {
            return this.getValueString(2);
        }
        log.error("Output Parser called on non-Output message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputPinInt() {
        if (this.isOutputAddMessage()) {
            return this.getValueInt(2);
        }
        log.error("Output Parser called on non-Output message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getOutputIFlagString() {
        if (this.isOutputAddMessage()) {
            return this.getValueString(3);
        }
        log.error("Output Parser called on non-Output message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputIFlagInt() {
        if (this.isOutputAddMessage()) {
            return this.getValueInt(3);
        }
        log.error("Output Parser called on non-Output message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getOutputStateString() {
        if (this.isOutputCmdMessage()) {
            return this.getOutputStateInt() == 1 ? "HIGH" : "LOW";
        }
        return "Not a Turnout";
    }

    public int getOutputStateInt() {
        if (this.isOutputCmdMessage()) {
            return this.getValueInt(2);
        }
        log.error("Output Parser called on non-Output message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public boolean getOutputStateBool() {
        if (this.isOutputCmdMessage()) {
            return this.getValueInt(2) != 0;
        }
        log.error("Output Parser called on non-Output message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return false;
    }

    public String getSensorIDString() {
        if (this.isSensorAddMessage()) {
            return this.getValueString(1);
        }
        log.error("Sensor Parser called on non-Sensor message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getSensorIDInt() {
        if (this.isSensorAddMessage()) {
            return this.getValueInt(1);
        }
        log.error("Sensor Parser called on non-Sensor message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getSensorPinString() {
        if (this.isSensorAddMessage()) {
            return this.getValueString(2);
        }
        log.error("Sensor Parser called on non-Sensor message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getSensorPinInt() {
        if (this.isSensorAddMessage()) {
            return this.getValueInt(2);
        }
        log.error("Sensor Parser called on non-Sensor message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getSensorPullupString() {
        if (this.isSensorAddMessage()) {
            return this.getValueBool(3) ? "PULLUP" : "NO PULLUP";
        }
        return "Not a Sensor";
    }

    public int getSensorPullupInt() {
        if (this.isSensorAddMessage()) {
            return this.getValueInt(3);
        }
        log.error("Sensor Parser called on non-Sensor message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public boolean getSensorPullupBool() {
        if (this.isSensorAddMessage()) {
            return this.getValueBool(3);
        }
        log.error("Sensor Parser called on non-Sensor message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return false;
    }

    public String getAccessoryAddrString() {
        if (this.isAccessoryMessage()) {
            return this.getValueString(1);
        }
        log.error("Accessory Parser called on non-Accessory message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getAccessoryAddrInt() {
        if (this.isAccessoryMessage()) {
            return this.getValueInt(1);
        }
        log.error("Accessory Parser called on non-Accessory message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getAccessorySubString() {
        if (this.isAccessoryMessage()) {
            return this.getValueString(2);
        }
        log.error("Accessory Parser called on non-Accessory message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return "0";
    }

    public int getAccessorySubInt() {
        if (this.isAccessoryMessage()) {
            return this.getValueInt(2);
        }
        log.error("Accessory Parser called on non-Accessory message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public String getAccessoryStateString() {
        if (this.isAccessoryMessage()) {
            return this.getAccessoryStateInt() == 1 ? "ON" : "OFF";
        }
        return "Not an Accessory Decoder";
    }

    public int getAccessoryStateInt() {
        if (this.isAccessoryMessage()) {
            return this.getValueInt(3);
        }
        log.error("Accessory Parser called on non-Accessory message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public String getRegisterString() {
        if (this.isThrottleMessage() || this.isWriteDccPacketMessage()) {
            return this.getValueString(1);
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getRegisterInt() {
        if (this.isThrottleMessage()) {
            return this.getValueInt(1);
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getAddressString() {
        if (this.isThrottleMessage()) {
            return this.getValueString(2);
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getAddressInt() {
        if (this.isThrottleMessage()) {
            return this.getValueInt(2);
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getSpeedString() {
        if (this.isThrottleMessage()) {
            return this.getValueString(3);
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getSpeedInt() {
        if (this.isThrottleMessage()) {
            return this.getValueInt(3);
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getDirectionString() {
        if (this.isThrottleMessage()) {
            return this.getDirectionInt() == 1 ? "Forward" : "Reverse";
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "Not a Throttle";
    }

    public int getDirectionInt() {
        if (this.isThrottleMessage()) {
            return this.getValueInt(4);
        }
        log.error("Throttle Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getFuncAddressString() {
        if (this.isFunctionMessage()) {
            return this.getValueString(1);
        }
        log.error("Function Parser called on non-Function message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getFuncAddressInt() {
        if (this.isFunctionMessage()) {
            return this.getValueInt(1);
        }
        log.error("Function Parser called on non-Function message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getFuncByte1String() {
        if (this.isFunctionMessage()) {
            return this.getValueString(2);
        }
        log.error("Function Parser called on non-Function message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getFuncByte1Int() {
        if (this.isFunctionMessage()) {
            return this.getValueInt(2);
        }
        log.error("Function Parser called on non-Function message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getFuncByte2String() {
        if (this.isFunctionMessage()) {
            return this.getValueString(3);
        }
        log.error("Function Parser called on non-Function message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getFuncByte2Int() {
        if (this.isFunctionMessage()) {
            return this.getValueInt(3);
        }
        log.error("Function Parser called on non-Function message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getFuncV2CabString() {
        if (this.isFunctionV2Message()) {
            return this.getValueString(1);
        }
        log.error("Function Parser called on non-Function V2 message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public String getFuncV2FuncString() {
        if (this.isFunctionV2Message()) {
            return this.getValueString(2);
        }
        log.error("Function Parser called on non-Function V2 message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public String getFuncV2StateString() {
        if (this.isFunctionV2Message()) {
            return this.getValueString(3);
        }
        log.error("Function Parser called on non-Function V2 message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public String getForgetCabString() {
        if (this.isForgetCabMessage()) {
            return this.getValueString(1);
        }
        log.error("Function Parser called on non-Forget Cab message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public String getTOIDString() {
        if (this.isTurnoutMessage()) {
            return this.getValueString(1);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return "0";
    }

    public int getTOIDInt() {
        if (this.isTurnoutMessage()) {
            return this.getValueInt(1);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public String getTOStateString() {
        if (this.isTurnoutMessage()) {
            return this.getTOStateInt() == 1 ? "THROWN" : "CLOSED";
        }
        return "Not a Turnout";
    }

    public int getTOStateInt() {
        if (this.isTurnoutMessage()) {
            return this.getValueInt(2);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public String getTOAddressString() {
        if (this.isTurnoutAddMessage() || this.isTurnoutAddDCCMessage()) {
            return this.getValueString(2);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return "0";
    }

    public int getTOAddressInt() {
        if (this.isTurnoutAddMessage() || this.isTurnoutAddDCCMessage()) {
            return this.getValueInt(2);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public String getTOSubAddressString() {
        if (this.isTurnoutAddMessage() || this.isTurnoutAddDCCMessage()) {
            return this.getValueString(3);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return "0";
    }

    public int getTOSubAddressInt() {
        if (this.isTurnoutAddMessage() || this.isTurnoutAddDCCMessage()) {
            return this.getValueInt(3);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public int getTOThrownPositionInt() {
        if (this.isTurnoutAddServoMessage()) {
            return this.getValueInt(3);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public int getTOClosedPositionInt() {
        if (this.isTurnoutAddServoMessage()) {
            return this.getValueInt(4);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public int getTOProfileInt() {
        if (this.isTurnoutAddServoMessage()) {
            return this.getValueInt(5);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public int getTOPinInt() {
        if (this.isTurnoutAddServoMessage() || this.isTurnoutAddVpinMessage()) {
            return this.getValueInt(2);
        }
        log.error("Turnout Parser called on non-Turnout message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this);
        return 0;
    }

    public String getOpsWriteAddrString() {
        if (this.isOpsWriteByteMessage() || this.isOpsWriteBitMessage()) {
            return this.getValueString(1);
        }
        return "0";
    }

    public int getOpsWriteAddrInt() {
        if (this.isOpsWriteByteMessage() || this.isOpsWriteBitMessage()) {
            return this.getValueInt(1);
        }
        return 0;
    }

    public String getOpsWriteCVString() {
        if (this.isOpsWriteByteMessage() || this.isOpsWriteBitMessage()) {
            return this.getValueString(2);
        }
        return "0";
    }

    public int getOpsWriteCVInt() {
        if (this.isOpsWriteByteMessage() || this.isOpsWriteBitMessage()) {
            return this.getValueInt(2);
        }
        return 0;
    }

    public String getOpsWriteBitString() {
        if (this.isOpsWriteBitMessage()) {
            return this.getValueString(3);
        }
        return "0";
    }

    public int getOpsWriteBitInt() {
        if (this.isOpsWriteBitMessage()) {
            return this.getValueInt(3);
        }
        return 0;
    }

    public String getOpsWriteValueString() {
        if (this.isOpsWriteByteMessage()) {
            return this.getValueString(3);
        }
        if (this.isOpsWriteBitMessage()) {
            return this.getValueString(4);
        }
        log.error("Ops Program Parser called on non-OpsProgram message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOpsWriteValueInt() {
        if (this.isOpsWriteByteMessage()) {
            return this.getValueInt(3);
        }
        if (this.isOpsWriteBitMessage()) {
            return this.getValueInt(4);
        }
        return 0;
    }

    public String getCVString() {
        if (this.isProgWriteByteMessage() || this.isProgWriteBitMessage() || this.isProgReadMessage() || this.isProgVerifyMessage()) {
            return this.getValueString(1);
        }
        return "0";
    }

    public int getCVInt() {
        if (this.isProgWriteByteMessage() || this.isProgWriteBitMessage() || this.isProgReadMessage() || this.isProgVerifyMessage()) {
            return this.getValueInt(1);
        }
        return 0;
    }

    public String getCallbackNumString() {
        int idx;
        if (this.isProgWriteByteMessage()) {
            idx = 3;
        } else if (this.isProgWriteBitMessage()) {
            idx = 4;
        } else if (this.isProgReadMessage()) {
            idx = 2;
        } else {
            return "0";
        }
        return this.getValueString(idx);
    }

    public int getCallbackNumInt() {
        int idx;
        if (this.isProgWriteByteMessage()) {
            idx = 3;
        } else if (this.isProgWriteBitMessage()) {
            idx = 4;
        } else if (this.isProgReadMessage()) {
            idx = 2;
        } else {
            return 0;
        }
        return this.getValueInt(idx);
    }

    public String getCallbackSubString() {
        int idx;
        if (this.isProgWriteByteMessage()) {
            idx = 4;
        } else if (this.isProgWriteBitMessage()) {
            idx = 5;
        } else if (this.isProgReadMessage()) {
            idx = 3;
        } else {
            return "0";
        }
        return this.getValueString(idx);
    }

    public int getCallbackSubInt() {
        int idx;
        if (this.isProgWriteByteMessage()) {
            idx = 4;
        } else if (this.isProgWriteBitMessage()) {
            idx = 5;
        } else if (this.isProgReadMessage()) {
            idx = 3;
        } else {
            return 0;
        }
        return this.getValueInt(idx);
    }

    public String getProgValueString() {
        int idx;
        if (this.isProgWriteByteMessage() || this.isProgVerifyMessage()) {
            idx = 2;
        } else if (this.isProgWriteBitMessage()) {
            idx = 3;
        } else {
            return "0";
        }
        return this.getValueString(idx);
    }

    public int getProgValueInt() {
        int idx;
        if (this.isProgWriteByteMessage() || this.isProgVerifyMessage()) {
            idx = 2;
        } else if (this.isProgWriteBitMessage()) {
            idx = 3;
        } else {
            return 0;
        }
        return this.getValueInt(idx);
    }

    public String getBitString() {
        if (this.isProgWriteBitMessage()) {
            return this.getValueString(2);
        }
        log.error("PWBit Parser called on non-PWBit message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getBitInt() {
        if (this.isProgWriteBitMessage()) {
            return this.getValueInt(2);
        }
        return 0;
    }

    public String getPacketString() {
        if (this.isWriteDccPacketMessage()) {
            StringBuilder b = new StringBuilder();
            int i = 2;
            while (i <= this.getGroupCount() - 1) {
                b.append(this.getValueString(i));
                ++i;
            }
            return b.toString();
        }
        log.error("Write Dcc Packet parser called on non-Dcc Packet message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    @Override
    public boolean replyExpected() {
        boolean retv;
        switch (this.getOpCodeChar()) {
            case '#': 
            case '0': 
            case '1': 
            case 'B': 
            case 'L': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'V': 
            case 'W': 
            case 'Z': 
            case 'c': 
            case 's': 
            case 't': {
                retv = true;
                break;
            }
            default: {
                retv = false;
            }
        }
        return retv;
    }

    public static DCCppMessage makeAccessoryDecoderMsg(int address, int subaddress, boolean activate) {
        if (address < 0 || address > 511) {
            return null;
        }
        if (subaddress < 0 || subaddress > 3) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('a');
        m.myMessage.append(" ").append(address);
        m.myMessage.append(" ").append(subaddress);
        m.myMessage.append(" ").append(activate ? "1" : "0");
        m.myRegex = "a\\s(\\d+)\\s(\\d+)\\s([1,0])";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeAccessoryDecoderMsg(int address, boolean activate) {
        int subaddr;
        int addr;
        if (address > 0) {
            addr = (address - 1) / 4 + 1;
            subaddr = (address - 1) % 4;
        } else {
            subaddr = 0;
            addr = 0;
        }
        log.debug("makeAccessoryDecoderMsg address {}, addr {}, subaddr {}, activate {}", new Object[]{address, addr, subaddr, activate});
        return DCCppMessage.makeAccessoryDecoderMsg(addr, subaddr, activate);
    }

    public static DCCppMessage makeTurnoutCommandMsg(int id, boolean thrown) {
        if (id < 0 || id > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('T');
        m.myMessage.append(" ").append(id);
        m.myMessage.append(thrown ? " 1" : " 0");
        m.myRegex = "T\\s(\\d+)\\s([1,0])";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeOutputCmdMsg(int id, boolean state) {
        if (id < 0 || id > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('Z');
        m.myMessage.append(" ").append(id);
        m.myMessage.append(" ").append(state ? "1" : "0");
        m.myRegex = "Z\\s(\\d+)\\s([1,0])";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeOutputAddMsg(int id, int pin, int iflag) {
        if (id < 0 || id > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('Z');
        m.myMessage.append(" ").append(id);
        m.myMessage.append(" ").append(pin);
        m.myMessage.append(" ").append(iflag);
        m.myRegex = "\\s*Z\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeOutputDeleteMsg(int id) {
        if (id < 0 || id > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('Z');
        m.myMessage.append(" ").append(id);
        m.myRegex = "\\s*Z\\s*(\\d+)\\s*";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeOutputListMsg() {
        return new DCCppMessage('Z', "\\s*Z\\s*");
    }

    public static DCCppMessage makeTurnoutAddMsg(int id, int addr, int subaddr) {
        if (id < 0 || id > Short.MAX_VALUE) {
            log.error("turnout Id {} must be between {} and {}", new Object[]{id, 0, Short.MAX_VALUE});
            return null;
        }
        if (addr < 0 || addr > 511) {
            log.error("turnout address {} must be between {} and {}", new Object[]{id, 0, 511});
            return null;
        }
        if (subaddr < 0 || subaddr > 3) {
            log.error("turnout subaddress {} must be between {} and {}", new Object[]{id, 0, 3});
            return null;
        }
        DCCppMessage m = new DCCppMessage('T');
        m.myMessage.append(" ").append(id);
        m.myMessage.append(" ").append(addr);
        m.myMessage.append(" ").append(subaddr);
        m.myRegex = "T\\s(\\d+)\\s(\\d+)\\s(\\d+)";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeTurnoutDeleteMsg(int id) {
        if (id < 0 || id > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('T');
        m.myMessage.append(" ").append(id);
        m.myRegex = "T\\s*(\\d+)";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeTurnoutListMsg() {
        return new DCCppMessage('T', "T");
    }

    public static DCCppMessage makeMessage(String msg) {
        return new DCCppMessage(msg);
    }

    public static DCCppMessage makeSensorAddMsg(int id, int pin, int pullup) {
        if (id < 0 || id > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('S');
        m.myMessage.append(" ").append(id);
        m.myMessage.append(" ").append(pin);
        m.myMessage.append(" ").append(pullup);
        m.myRegex = "S\\s(\\d+)\\s(\\d+)\\s([1,0])";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeSensorDeleteMsg(int id) {
        if (id < 0 || id > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('S');
        m.myMessage.append(" ").append(id);
        m.myRegex = "S\\s(\\d+)";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeSensorListMsg() {
        return new DCCppMessage('S', "S");
    }

    public static DCCppMessage makeQuerySensorStatesMsg() {
        return new DCCppMessage('Q', "\\s*Q\\s*");
    }

    public static DCCppMessage makeWriteDirectCVMsg(int cv, int val) {
        return DCCppMessage.makeWriteDirectCVMsg(cv, val, 0, 87);
    }

    public static DCCppMessage makeWriteDirectCVMsg(int cv, int val, int callbacknum, int callbacksub) {
        if (cv < 1 || cv > 1024) {
            return null;
        }
        if (val < 0 || val > 255) {
            return null;
        }
        if (callbacknum < 0 || callbacknum > Short.MAX_VALUE) {
            return null;
        }
        if (callbacksub < 0 || callbacksub > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('W');
        m.myMessage.append(" ").append(cv);
        m.myMessage.append(" ").append(val);
        m.myMessage.append(" ").append(callbacknum);
        m.myMessage.append(" ").append(callbacksub);
        m.myRegex = "W\\s*(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)";
        m._nDataChars = m.toString().length();
        m.setTimeout(10000);
        return m;
    }

    public static DCCppMessage makeBitWriteDirectCVMsg(int cv, int bit, int val) {
        return DCCppMessage.makeBitWriteDirectCVMsg(cv, bit, val, 0, 66);
    }

    public static DCCppMessage makeBitWriteDirectCVMsg(int cv, int bit, int val, int callbacknum, int callbacksub) {
        if (cv < 1 || cv > 1024) {
            return null;
        }
        if (bit < 0 || bit > 7) {
            return null;
        }
        if (callbacknum < 0 || callbacknum > Short.MAX_VALUE) {
            return null;
        }
        if (callbacksub < 0 || callbacksub > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('B');
        m.myMessage.append(" ").append(cv);
        m.myMessage.append(" ").append(bit);
        m.myMessage.append(" ").append(val == 0 ? "0" : "1");
        m.myMessage.append(" ").append(callbacknum);
        m.myMessage.append(" ").append(callbacksub);
        m.myRegex = "B\\s*(\\d+)\\s([0-7])\\s([1,0])\\s(\\d+)\\s(\\d+)";
        m._nDataChars = m.toString().length();
        m.setTimeout(10000);
        return m;
    }

    public static DCCppMessage makeReadDirectCVMsg(int cv) {
        return DCCppMessage.makeReadDirectCVMsg(cv, 0, 82);
    }

    public static DCCppMessage makeReadDirectCVMsg(int cv, int callbacknum, int callbacksub) {
        if (cv < 1 || cv > 1024) {
            return null;
        }
        if (callbacknum < 0 || callbacknum > Short.MAX_VALUE) {
            return null;
        }
        if (callbacksub < 0 || callbacksub > Short.MAX_VALUE) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('R');
        m.myMessage.append(" ").append(cv);
        m.myMessage.append(" ").append(callbacknum);
        m.myMessage.append(" ").append(callbacksub);
        m.myRegex = "R\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)";
        m._nDataChars = m.toString().length();
        m.setTimeout(10000);
        return m;
    }

    public static DCCppMessage makeVerifyCVMsg(int cv, int startVal) {
        if (cv < 1 || cv > 1024) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('V');
        m.myMessage.append(" ").append(cv);
        m.myMessage.append(" ").append(startVal);
        m.myRegex = "V\\s*(\\d+)\\s+(\\d+)\\s*";
        m._nDataChars = m.toString().length();
        m.setTimeout(10000);
        return m;
    }

    @CheckForNull
    public static DCCppMessage makeWriteOpsModeCVMsg(int address, int cv, int val) {
        if (address < 0 || address > 10293) {
            return null;
        }
        if (cv < 1 || cv > 1024) {
            return null;
        }
        if (val < 0 || val > 255) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('w');
        m.myMessage.append(" ").append(address);
        m.myMessage.append(" ").append(cv);
        m.myMessage.append(" ").append(val);
        m.myRegex = "\\s*w\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*";
        m._nDataChars = m.toString().length();
        m.setTimeout(10000);
        return m;
    }

    public static DCCppMessage makeBitWriteOpsModeCVMsg(int address, int cv, int bit, int val) {
        if (address < 0 || address > 10293) {
            return null;
        }
        if (cv < 1 || cv > 1024) {
            return null;
        }
        if (bit < 0 || bit > 7) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('b');
        m.myMessage.append(" ").append(address);
        m.myMessage.append(" ").append(cv);
        m.myMessage.append(" ").append(bit);
        m.myMessage.append(" ").append(val == 0 ? "0" : "1");
        m.myRegex = "\\s*b\\s*(\\d+)\\s+(\\d+)\\s+([0-7])\\s+([01])\\s*";
        m._nDataChars = m.toString().length();
        m.setTimeout(10000);
        return m;
    }

    public static DCCppMessage makeSetTrackPowerMsg(boolean on) {
        return new DCCppMessage(on ? (char)'1' : '0', "\\s*[0,1]\\s*");
    }

    public static DCCppMessage makeTrackPowerOnMsg() {
        return DCCppMessage.makeSetTrackPowerMsg(true);
    }

    public static DCCppMessage makeTrackPowerOffMsg() {
        return DCCppMessage.makeSetTrackPowerMsg(false);
    }

    public static DCCppMessage makeReadTrackCurrentMsg() {
        return new DCCppMessage('c', "\\s*c\\s*");
    }

    public static DCCppMessage makeCSStatusMsg() {
        return new DCCppMessage('s', "\\s*s\\s*");
    }

    public static DCCppMessage makeCSMaxNumSlotsMsg() {
        return new DCCppMessage('#', "\\s*#\\s*");
    }

    public static DCCppMessage makeFunctionV2Message(int cab, int func, int state) {
        if (cab < 0 || cab > 10293) {
            return null;
        }
        if (func < 0 || func > 68) {
            return null;
        }
        if (state < 0 || state > 1) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('F');
        m.myMessage.append(" ").append(cab);
        m.myMessage.append(" ").append(func);
        m.myMessage.append(" ").append(state);
        m.myRegex = "F\\s*([0-9]{1,4})\\s*([0-9]){1,2}\\s*([1,0])\\s*";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeForgetCabMessage(int cab) {
        if (cab < 0 || cab > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('-');
        if (cab > 0) {
            m.myMessage.append(" ").append(cab);
        }
        m.myRegex = "-\\s*([0-9]{0,4})\\s*";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeAddressedEmergencyStop(int register, int address) {
        if (address < 0 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('t');
        m.myMessage.append(" ").append(register);
        m.myMessage.append(" ").append(address);
        m.myMessage.append(" -1 1");
        m.myRegex = "t\\s*(\\d+)\\s+(\\d+)\\s+([-]*\\d+)\\s+([1,0])\\s*";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeEmergencyStopAllMsg() {
        DCCppMessage m = new DCCppMessage('!');
        m.myRegex = "\\s*!";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeSpeedAndDirectionMsg(int register, int address, float speed, boolean isForward) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('t');
        m.myMessage.append(" ").append(register);
        m.myMessage.append(" ").append(address);
        if ((double)speed < 0.0) {
            m.myMessage.append(" -1");
        } else {
            int speedVal = Math.round(speed * 126.0f);
            speedVal = Math.min(speedVal, 126);
            m.myMessage.append(" ").append(speedVal);
        }
        m.myMessage.append(" ").append(isForward ? "1" : "0");
        m.myRegex = "t\\s*(\\d+)\\s+(\\d+)\\s+([-]*\\d+)\\s+([1,0])\\s*";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup1OpsMsg(int address, boolean f0, boolean f1, boolean f2, boolean f3, boolean f4) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte1 = 128 + (f0 ? 16 : 0);
        byte1 += f1 ? 1 : 0;
        byte1 += f2 ? 2 : 0;
        byte1 += f3 ? 4 : 0;
        m.myMessage.append(" ").append(byte1 += f4 ? 8 : 0);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup1SetMomMsg(int address, boolean f0, boolean f1, boolean f2, boolean f3, boolean f4) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte1 = 128 + (f0 ? 16 : 0);
        byte1 += f1 ? 1 : 0;
        byte1 += f2 ? 2 : 0;
        byte1 += f3 ? 4 : 0;
        m.myMessage.append(" ").append(byte1 += f4 ? 8 : 0);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup2OpsMsg(int address, boolean f5, boolean f6, boolean f7, boolean f8) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte1 = 176;
        byte1 += f5 ? 1 : 0;
        byte1 += f6 ? 2 : 0;
        byte1 += f7 ? 4 : 0;
        m.myMessage.append(" ").append(byte1 += f8 ? 8 : 0);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup2SetMomMsg(int address, boolean f5, boolean f6, boolean f7, boolean f8) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte1 = 176;
        byte1 += f5 ? 1 : 0;
        byte1 += f6 ? 2 : 0;
        byte1 += f7 ? 4 : 0;
        m.myMessage.append(" ").append(byte1 += f8 ? 8 : 0);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup3OpsMsg(int address, boolean f9, boolean f10, boolean f11, boolean f12) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte1 = 160;
        byte1 += f9 ? 1 : 0;
        byte1 += f10 ? 2 : 0;
        byte1 += f11 ? 4 : 0;
        m.myMessage.append(" ").append(byte1 += f12 ? 8 : 0);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup3SetMomMsg(int address, boolean f9, boolean f10, boolean f11, boolean f12) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte1 = 160;
        byte1 += f9 ? 1 : 0;
        byte1 += f10 ? 2 : 0;
        byte1 += f11 ? 4 : 0;
        m.myMessage.append(" ").append(byte1 += f12 ? 8 : 0);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup4OpsMsg(int address, boolean f13, boolean f14, boolean f15, boolean f16, boolean f17, boolean f18, boolean f19, boolean f20) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte2 = 0;
        byte2 += f13 ? 1 : 0;
        byte2 += f14 ? 2 : 0;
        byte2 += f15 ? 4 : 0;
        byte2 += f16 ? 8 : 0;
        byte2 += f17 ? 16 : 0;
        byte2 += f18 ? 32 : 0;
        byte2 += f19 ? 64 : 0;
        int n = f20 ? 128 : 0;
        m.myMessage.append(" ").append(222);
        m.myMessage.append(" ").append(byte2 += n);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup4SetMomMsg(int address, boolean f13, boolean f14, boolean f15, boolean f16, boolean f17, boolean f18, boolean f19, boolean f20) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte2 = 0;
        byte2 += f13 ? 1 : 0;
        byte2 += f14 ? 2 : 0;
        byte2 += f15 ? 4 : 0;
        byte2 += f16 ? 8 : 0;
        byte2 += f17 ? 16 : 0;
        byte2 += f18 ? 32 : 0;
        byte2 += f19 ? 64 : 0;
        int n = f20 ? 128 : 0;
        m.myMessage.append(" ").append(222);
        m.myMessage.append(" ").append(byte2 += n);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup5OpsMsg(int address, boolean f21, boolean f22, boolean f23, boolean f24, boolean f25, boolean f26, boolean f27, boolean f28) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte2 = 0;
        byte2 += f21 ? 1 : 0;
        byte2 += f22 ? 2 : 0;
        byte2 += f23 ? 4 : 0;
        byte2 += f24 ? 8 : 0;
        byte2 += f25 ? 16 : 0;
        byte2 += f26 ? 32 : 0;
        byte2 += f27 ? 64 : 0;
        log.debug("DCCppMessage: Byte2 = {}", (Object)(byte2 += f28 ? 128 : 0));
        m.myMessage.append(" ").append(223);
        m.myMessage.append(" ").append(byte2);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeFunctionGroup5SetMomMsg(int address, boolean f21, boolean f22, boolean f23, boolean f24, boolean f25, boolean f26, boolean f27, boolean f28) {
        if (address < 1 || address > 10293) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('f');
        m.myMessage.append(" ").append(address);
        int byte2 = 0;
        byte2 += f21 ? 1 : 0;
        byte2 += f22 ? 2 : 0;
        byte2 += f23 ? 4 : 0;
        byte2 += f24 ? 8 : 0;
        byte2 += f25 ? 16 : 0;
        byte2 += f26 ? 32 : 0;
        byte2 += f27 ? 64 : 0;
        int n = f28 ? 128 : 0;
        m.myMessage.append(" ").append(223);
        m.myMessage.append(" ").append(byte2 += n);
        m.myRegex = "f\\s(\\d+)\\s(\\d+)\\s*(\\d+)?";
        m._nDataChars = m.toString().length();
        return m;
    }

    public static DCCppMessage makeWriteDCCPacketMainMsg(int register, int numBytes, byte[] bytes) {
        if (register < 0 || register > 12 || numBytes < 2 || numBytes > 5) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('M');
        m.myMessage.append(" ").append(register);
        int k = 0;
        while (k < numBytes) {
            m.myMessage.append(" ").append(StringUtil.twoHexFromInt(bytes[k]));
            ++k;
        }
        m.myRegex = "M\\s+(\\d+)((\\s+[0-9a-fA-F]{1,2}){2,5})\\s*";
        return m;
    }

    public static DCCppMessage makeWriteDCCPacketProgMsg(int register, int numBytes, byte[] bytes) {
        if (register < 0 || register > 12 || numBytes < 2 || numBytes > 5) {
            return null;
        }
        DCCppMessage m = new DCCppMessage('P');
        m.myMessage.append(" ").append(register);
        int k = 0;
        while (k < numBytes) {
            m.myMessage.append(" ").append(StringUtil.twoHexFromInt(bytes[k]));
            ++k;
        }
        m.myRegex = "P\\s+(\\d+)((\\s+[0-9a-fA-F]{1,2}){2,5})\\s*";
        return m;
    }

    public static DCCppMessage makeListRegisterContentsMsg() {
        return new DCCppMessage('L', "\\s*L\\s*");
    }

    @Override
    public boolean equals(Object obj) {
        int otherBaseFunction;
        int myBaseFunction;
        int otherSpace2;
        int otherSpace1;
        String otherCmd;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DCCppMessage)) {
            return false;
        }
        DCCppMessage other = (DCCppMessage)obj;
        String myCmd = this.toString();
        if (myCmd.equals(otherCmd = other.toString())) {
            return true;
        }
        if (myCmd.charAt(0) != 'f' || otherCmd.charAt(0) != 'f') {
            return false;
        }
        int mySpace1 = myCmd.indexOf(32, 2);
        if (mySpace1 != (otherSpace1 = otherCmd.indexOf(32, 2))) {
            return false;
        }
        if (!myCmd.subSequence(2, mySpace1).equals(otherCmd.subSequence(2, otherSpace1))) {
            return false;
        }
        int mySpace2 = myCmd.indexOf(32, mySpace1 + 1);
        if (mySpace2 < 0) {
            mySpace2 = myCmd.length();
        }
        if ((otherSpace2 = otherCmd.indexOf(32, otherSpace1 + 1)) < 0) {
            otherSpace2 = otherCmd.length();
        }
        if ((myBaseFunction = Integer.parseInt(myCmd.substring(mySpace1 + 1, mySpace2))) == (otherBaseFunction = Integer.parseInt(otherCmd.substring(otherSpace1 + 1, otherSpace2)))) {
            return true;
        }
        return DCCppMessage.getFuncBaseByte1(myBaseFunction) == DCCppMessage.getFuncBaseByte1(otherBaseFunction);
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    private static int getFuncBaseByte1(int byte1) {
        if (byte1 == 222 || byte1 == 223) {
            return byte1;
        }
        if (byte1 < 160) {
            return 128;
        }
        if (byte1 < 176) {
            return 160;
        }
        return 176;
    }

    public void delayFor(long millis) {
        this.expireTime = System.currentTimeMillis() + millis;
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        long diff = this.expireTime - ((DCCppMessage)o).expireTime;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expireTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

