/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.dccpp.Bundle;
import jmri.jmrix.dccpp.DCCppLight;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.managers.AbstractLightManager;

public class DCCppLightManager
extends AbstractLightManager {
    private DCCppTrafficController tc = null;

    public DCCppLightManager(DCCppSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getDCCppTrafficController();
    }

    @Override
    @Nonnull
    public DCCppSystemConnectionMemo getMemo() {
        return (DCCppSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(String systemName, String userName) throws IllegalArgumentException {
        int bitNum = this.getBitFromSystemName(systemName);
        if (bitNum == 0) {
            throw new IllegalArgumentException("Invalid Bit from System Name: " + systemName);
        }
        String sName = String.valueOf(this.getSystemNamePrefix()) + bitNum;
        return new DCCppLight(this.tc, this, sName, userName);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, Short.MAX_VALUE, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

