/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppLightManager;
import jmri.jmrix.dccpp.DCCppPredefinedMeters;
import jmri.jmrix.dccpp.DCCppProgrammer;
import jmri.jmrix.dccpp.DCCppProgrammerManager;
import jmri.jmrix.dccpp.DCCppSensorManager;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppInitializationManager {
    protected DCCppSystemConnectionMemo systemMemo = null;
    DCCppPredefinedMeters predefinedMeters;
    private static final Logger log = LoggerFactory.getLogger(DCCppInitializationManager.class);

    public DCCppInitializationManager(DCCppSystemConnectionMemo memo) {
        this.systemMemo = memo;
        log.debug("Starting DCC++ Initialization Process");
        DCCppCommandStation cs = this.systemMemo.getDCCppTrafficController().getCommandStation();
        InstanceManager.setThrottleManager(this.systemMemo.getThrottleManager());
        this.systemMemo.setProgrammerManager(new DCCppProgrammerManager((Programmer)new DCCppProgrammer(this.systemMemo.getDCCppTrafficController()), this.systemMemo));
        if (this.systemMemo.getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.systemMemo.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.systemMemo.getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.systemMemo.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        this.systemMemo.setCommandStation(this.systemMemo.getDCCppTrafficController().getCommandStation());
        InstanceManager.store(this.systemMemo.getCommandStation(), CommandStation.class);
        this.systemMemo.setTurnoutManager(new DCCppTurnoutManager(this.systemMemo));
        InstanceManager.setTurnoutManager(this.systemMemo.getTurnoutManager());
        this.systemMemo.setLightManager(new DCCppLightManager(this.systemMemo));
        InstanceManager.setLightManager(this.systemMemo.getLightManager());
        this.systemMemo.setSensorManager(new DCCppSensorManager(this.systemMemo));
        InstanceManager.setSensorManager(this.systemMemo.getSensorManager());
        InstanceManager.store(this.systemMemo.getPowerManager(), PowerManager.class);
        log.debug("PowerManager: {}", (Object)InstanceManager.getDefault(PowerManager.class));
        this.predefinedMeters = new DCCppPredefinedMeters(this.systemMemo);
        this.systemMemo.register();
        String base_station = "Unknown";
        String code_build = "Unknown";
        String version = "Unknown";
        if (cs != null) {
            base_station = cs.getStationType();
            code_build = cs.getBuild();
            version = cs.getVersion();
        }
        log.info("DCC++ Initialization Complete with station type '{}', version '{}' and build '{}'", new Object[]{base_station, version, code_build});
    }
}

