/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc.swing.boardlists;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrix.dcc4pc.Dcc4PcSensorManager;
import jmri.jmrix.dcc4pc.Dcc4PcSystemConnectionMemo;
import jmri.jmrix.dcc4pc.swing.Dcc4PcNamedPaneAction;
import jmri.jmrix.dcc4pc.swing.Dcc4PcPanel;
import jmri.jmrix.dcc4pc.swing.Dcc4PcPanelInterface;
import jmri.swing.RowSorterUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardListPanel
extends Dcc4PcPanel
implements PropertyChangeListener,
Dcc4PcPanelInterface {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.dcc4pc.swing.boardlists.BoardListBundle");
    Dcc4PcSensorManager senMan;
    ReaderBoardModel _BoardModel;
    JScrollPane _BoardScrollPane;
    JLabel sourceLabel = new JLabel();
    private List<Integer> _boardListCount;
    private static final Logger log = LoggerFactory.getLogger(BoardListPanel.class);

    @Override
    public void initComponents(Dcc4PcSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.senMan = memo.getSensorManager();
        this._boardListCount = this.senMan.getBoards();
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        JPanel sourcePanel = new JPanel();
        header.add(sourcePanel);
        this.add((Component)header, "North");
        this._BoardModel = new ReaderBoardModel();
        JTable boardTable = new JTable(this._BoardModel);
        TableRowSorter<ReaderBoardModel> sorter = new TableRowSorter<ReaderBoardModel>(this._BoardModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        boardTable.setRowSelectionAllowed(false);
        boardTable.setPreferredScrollableViewportSize(new Dimension(600, 120));
        this._BoardModel.configureTable(boardTable);
        this._BoardScrollPane = new JScrollPane(boardTable);
        this._BoardModel.fireTableDataChanged();
        this.add((Component)this._BoardScrollPane, "Center");
        JPanel footer = new JPanel();
        this.add((Component)footer, "South");
    }

    @Override
    public void initComponents() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    public static class Default
    extends Dcc4PcNamedPaneAction {
        public Default() {
            super("Dcc4PC Command Monitor", new JmriJFrameInterface(), BoardListPanel.class.getName(), InstanceManager.getDefault(Dcc4PcSystemConnectionMemo.class));
        }
    }

    public class ReaderBoardModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int ADDRESS_COLUMN = 0;
        public static final int INPUTS_COLUMN = 1;
        public static final int ENCODING_COLUMN = 2;
        public static final int VERSION_COLUMN = 3;
        public static final int DESCRIPTION_COLUMN = 4;
        public static final int EDIT_COLUMN = 5;

        ReaderBoardModel() {
            if (BoardListPanel.this.senMan != null) {
                BoardListPanel.this.senMan.addPropertyChangeListener(this);
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 5) {
                return JButton.class;
            }
            return String.class;
        }

        public void configureTable(JTable table) {
            table.getTableHeader().setReorderingAllowed(true);
            table.setAutoResizeMode(0);
            int i = 0;
            while (i < table.getColumnCount()) {
                int width = this.getPreferredWidth(i);
                table.getColumnModel().getColumn(i).setPreferredWidth(width);
                ++i;
            }
            table.sizeColumnsToFit(-1);
            this.configEditColumn(table);
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 1: 
                case 3: {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                case 2: 
                case 4: 
                case 5: {
                    return new JTextField((int)22).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 1) {
                return rb.getString("ColumnInput");
            }
            if (col == 0) {
                return rb.getString("ColumnAddress");
            }
            if (col == 2) {
                return rb.getString("ColumnEncoding");
            }
            if (col == 3) {
                return rb.getString("ColumnVersion");
            }
            if (col == 4) {
                return rb.getString("ColumnDescription");
            }
            if (col == 5) {
                return "";
            }
            return "";
        }

        public void dispose() {
            if (BoardListPanel.this.senMan != null) {
                BoardListPanel.this.senMan.removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                BoardListPanel.this._boardListCount = BoardListPanel.this.senMan.getBoards();
                int length = (Integer)e.getNewValue();
                if (length == 0) {
                    BoardListPanel.this.senMan.removePropertyChangeListener(this);
                    BoardListPanel.this.senMan = null;
                }
                this.fireTableDataChanged();
            }
        }

        protected void configEditColumn(JTable table) {
            this.setColumnToHoldButton(table, 5, new JButton(rb.getString("ButtonEdit")));
        }

        protected void setColumnToHoldButton(JTable table, int column, JButton sample) {
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            table.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            table.setDefaultEditor(JButton.class, buttonEditor);
            table.setRowHeight(sample.getPreferredSize().height);
            table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 4);
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 5;
        }

        protected void editAddress(int r) {
            int boardAddress = (Integer)BoardListPanel.this._boardListCount.get(r);
            JPanel newAddressPanel = new JPanel();
            JTextField newAddressField = new JTextField(10);
            newAddressPanel.add(newAddressField);
            int retval = JOptionPane.showOptionDialog(null, rb.getString("ChangeAddress"), rb.getString("ChangeAddressTitle"), 0, 1, null, new Object[]{"Cancel", "OK", newAddressPanel}, null);
            if (retval != 1) {
                return;
            }
            BoardListPanel.this.senMan.changeBoardAddress(boardAddress, Integer.parseInt(newAddressField.getText()));
        }

        public void setSetToState(String x) {
        }

        @Override
        public int getRowCount() {
            if (BoardListPanel.this._boardListCount == null) {
                return 0;
            }
            return BoardListPanel.this._boardListCount.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (BoardListPanel.this.senMan == null) {
                return null;
            }
            if (r >= BoardListPanel.this._boardListCount.size()) {
                log.debug("row is greater than turnout list size");
                return null;
            }
            switch (c) {
                case 1: {
                    return BoardListPanel.this.senMan.getBoardInputs((Integer)BoardListPanel.this._boardListCount.get(r)) + 1;
                }
                case 0: {
                    return BoardListPanel.this._boardListCount.get(r);
                }
                case 2: {
                    return BoardListPanel.this.senMan.getBoardEncodingAsString((Integer)BoardListPanel.this._boardListCount.get(r));
                }
                case 3: {
                    return BoardListPanel.this.senMan.getBoardVersion((Integer)BoardListPanel.this._boardListCount.get(r));
                }
                case 4: {
                    return BoardListPanel.this.senMan.getBoardDescription((Integer)BoardListPanel.this._boardListCount.get(r));
                }
                case 5: {
                    return rb.getString("ButtonEdit");
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c == 5) {
                this.editAddress(r);
            }
        }
    }
}

