/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import jmri.jmrix.dcc4pc.Dcc4PcListener;
import jmri.jmrix.dcc4pc.Dcc4PcMessage;
import jmri.jmrix.dcc4pc.Dcc4PcReply;
import jmri.jmrix.dcc4pc.Dcc4PcSystemConnectionMemo;
import jmri.jmrix.dcc4pc.Dcc4PcTrafficController;
import jmri.jmrix.dcc4pc.swing.Dcc4PcPanel;
import jmri.jmrix.dcc4pc.swing.Dcc4PcPanelInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPanel
extends Dcc4PcPanel
implements Dcc4PcListener,
Dcc4PcPanelInterface {
    String appString = "Info        : ";
    String proString = "Description : ";
    String hrdString = "Serial No   : ";
    JLabel infoText = new JLabel(String.valueOf(this.appString) + "<unknown>");
    JLabel infoDescription = new JLabel(String.valueOf(this.proString) + "<unknown>");
    JLabel serialNo = new JLabel(String.valueOf(this.hrdString) + "<unknown>");
    JButton sendButton;
    Dcc4PcTrafficController tc;
    int nextPacket = -1;
    private static final Logger log = LoggerFactory.getLogger(StatusPanel.class);

    @Override
    public void initComponents(Dcc4PcSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.tc = memo.getDcc4PcTrafficController();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.infoText);
        this.add(this.infoDescription);
        this.add(this.serialNo);
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[1]);
        this.nextPacket = 0;
        if (this.tc != null) {
            this.tc.sendDcc4PcMessage(m, this);
        } else {
            log.error("no Traffic Controller Found");
        }
        this.sendButton = new JButton("Update");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Request status update from DCC4PC");
        this.add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.sendButtonActionPerformed(e);
            }
        });
    }

    @Override
    public void initComponents() {
    }

    void reset() {
        this.infoText.setText(String.valueOf(this.appString) + "<unknown>");
        this.infoDescription.setText(String.valueOf(this.proString) + "<unknown>");
        this.serialNo.setText(String.valueOf(this.hrdString) + "<unknown>");
    }

    @Override
    public void dispose() {
        if (this.tc != null) {
            this.tc.removeDcc4PcListener(this);
            this.tc = null;
        }
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        if (this.tc != null) {
            this.reset();
            Dcc4PcMessage m = new Dcc4PcMessage(new byte[1]);
            this.nextPacket = 0;
            this.tc.sendDcc4PcMessage(m, this);
        }
    }

    public void notifyReply(Dcc4PcReply r) {
    }

    public void notifyMessage(Dcc4PcMessage m) {
    }

    @Override
    public void reply(Dcc4PcReply r) {
        switch (this.nextPacket) {
            case 0: {
                this.nextPacket = -1;
                int i = 0;
                StringBuffer buf = new StringBuffer();
                while (i < 4) {
                    buf.append((char)r.getElement(i));
                    ++i;
                }
                String str = buf.toString();
                str = String.valueOf(str) + " ver ";
                str = String.valueOf(str) + r.getElement(i += 2) + ".";
                str = String.valueOf(str) + r.getElement(++i) + " Max Bus Speed : ";
                str = String.valueOf(str) + r.getElement(++i);
                this.infoText.setText(String.valueOf(this.appString) + str);
                ++i;
                Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{1});
                this.nextPacket = 1;
                this.tc.sendDcc4PcMessage(m, this);
                break;
            }
            case 1: {
                this.infoDescription.setText(String.valueOf(this.proString) + r.toString());
                Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{2});
                this.nextPacket = 2;
                this.tc.sendDcc4PcMessage(m, this);
                break;
            }
            case 2: {
                this.nextPacket = -1;
                this.serialNo.setText(String.valueOf(this.hrdString) + r.toString());
                break;
            }
        }
    }

    @Override
    public void message(Dcc4PcMessage m) {
        byte[] theByteArray = m.getFormattedMessage();
        if (theByteArray[0] == 0) {
            this.nextPacket = 0;
        } else if (theByteArray[0] == 1) {
            this.nextPacket = 1;
        } else if (theByteArray[0] == 2) {
            this.nextPacket = 2;
        }
    }

    @Override
    public void handleTimeout(Dcc4PcMessage m) {
    }
}

