/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.dcc4pc.Dcc4PcInterface;
import jmri.jmrix.dcc4pc.Dcc4PcListener;
import jmri.jmrix.dcc4pc.Dcc4PcMessage;
import jmri.jmrix.dcc4pc.Dcc4PcReply;
import jmri.jmrix.dcc4pc.Dcc4PcSystemConnectionMemo;
import jmri.jmrix.dcc4pc.serialdriver.SerialDriverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPort;

public class Dcc4PcTrafficController
extends AbstractMRTrafficController
implements Dcc4PcInterface {
    Dcc4PcSystemConnectionMemo adaptermemo;
    public static final int RETRIEVINGDATA = 100;
    protected boolean unsolicitedSensorMessageSeen = false;
    @Deprecated
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    protected static final Dcc4PcTrafficController self = null;
    Dcc4PcMessage mLastMessage;
    Dcc4PcMessage mLastSentMessage;
    SerialPort port;
    Dcc4PcReply lastIncomplete;
    boolean waitingForMore = false;
    boolean loading = false;
    final int GETMOREDATA = 1;
    boolean normalFlushReceiveChars = false;
    boolean readingData = false;
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcTrafficController.class);

    public Dcc4PcTrafficController() {
        if (log.isDebugEnabled()) {
            log.debug("creating a new Dcc4PcTrafficController object");
        }
        this.setAllowUnexpectedReply(false);
    }

    public void setAdapterMemo(Dcc4PcSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    @Override
    public synchronized void addDcc4PcListener(Dcc4PcListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeDcc4PcListener(Dcc4PcListener l) {
        this.removeListener(l);
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((Dcc4PcListener)client).message((Dcc4PcMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((Dcc4PcListener)client).reply((Dcc4PcReply)r);
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendDcc4PcMessage(Dcc4PcMessage m, Dcc4PcListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return Dcc4PcMessage.getProgMode();
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return Dcc4PcMessage.getExitProgMode();
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
    }

    @Override
    protected synchronized void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (log.isDebugEnabled()) {
            log.debug("forwardToPort message: [{}]", (Object)m);
        }
        if (this.port == null) {
            return;
        }
        this.mLastSender = reply;
        this.mLastMessage = (Dcc4PcMessage)m;
        if (!this.mLastMessage.isGetResponse()) {
            AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
            SwingUtilities.invokeLater(r);
        }
        this.forwardToPort(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardToPort(AbstractMRMessage m) {
        block18: {
            this.mLastSentMessage = (Dcc4PcMessage)m;
            byte[] msg = new byte[this.lengthOfByteStream(m)];
            int len = m.getNumDataElements();
            int i = 0;
            while (i < len) {
                msg[i] = (byte)m.getElement(i);
                ++i;
            }
            try {
                if (this.ostream != null) {
                    if (log.isDebugEnabled()) {
                        StringBuilder f = new StringBuilder("formatted message: ");
                        int i2 = 0;
                        while (i2 < msg.length) {
                            f.append(Integer.toHexString(0xFF & msg[i2]));
                            f.append(" ");
                            ++i2;
                        }
                        log.debug(new String(f));
                    }
                    while (m.getRetries() >= 0) {
                        if (this.portReadyToSend(this.controller)) {
                            this.port.setDTR(true);
                            this.ostream.write(msg);
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            catch (Exception ex) {
                                log.warn("sendMessage: Exception: {}", (Object)ex.toString());
                            }
                            this.ostream.flush();
                            this.port.setDTR(false);
                            break block18;
                        }
                        if (m.getRetries() >= 0) {
                            if (log.isDebugEnabled()) {
                                StringBuilder b = new StringBuilder("Retry message: ");
                                b.append(m.toString());
                                b.append(" attempts remaining: ");
                                b.append(m.getRetries());
                                log.debug(new String(b));
                            }
                            m.setRetries(m.getRetries() - 1);
                            try {
                                Runnable b = this.xmtRunnable;
                                synchronized (b) {
                                    this.xmtRunnable.wait(m.getTimeout());
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                log.error("retry wait interrupted");
                            }
                            continue;
                        }
                        log.warn("sendMessage: port not ready for data sending: {}", (Object)Arrays.toString(msg));
                    }
                    break block18;
                }
                this.connectionWarn();
            }
            catch (IOException | RuntimeException e) {
                this.xmtException = true;
                this.portWarn(e);
            }
        }
    }

    @Override
    public void connectPort(AbstractPortController p) {
        super.connectPort(p);
        this.port = ((SerialDriverAdapter)this.controller).getSerialPort();
    }

    @Override
    protected AbstractMRReply newReply() {
        Dcc4PcReply reply = new Dcc4PcReply();
        return reply;
    }

    @Override
    protected boolean canReceive() {
        return true;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        block6: {
            if (this.port.isDSR()) {
                return false;
            }
            try {
                if (this.controller.getInputStream().available() <= 0) break block6;
                if (this.port.isRI()) {
                    log.debug("??? Ringing true ???");
                }
                return false;
            }
            catch (IOException ex) {
                log.error("IO Exception{}", (Object)ex.toString());
                return !this.port.isDSR();
            }
        }
        if (this.port.isRI()) {
            log.debug("??? Ringing true ???");
        }
        return true;
    }

    @Override
    protected void handleTimeout(AbstractMRMessage msg, AbstractMRListener l) {
        if (l != null) {
            ((Dcc4PcListener)l).handleTimeout((Dcc4PcMessage)msg);
        }
        super.handleTimeout(msg, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOneIncomingReply() throws IOException {
        block57: {
            AbstractMRReply msg;
            block56: {
                msg = this.newReply();
                this.loadChars(msg, this.istream);
                if (this.mLastSentMessage != null) {
                    ((Dcc4PcReply)msg).setOriginalRequest(this.mLastMessage);
                    if (this.mLastSentMessage.isForChildBoard()) {
                        if (log.isDebugEnabled()) {
                            log.debug("This is a message for a child board {}", (Object)((Dcc4PcReply)msg).toHexString());
                            log.debug("Originate {}", (Object)this.mLastMessage.toString());
                        }
                        if (this.mLastSentMessage.getNumDataElements() - 1 == msg.getElement(1)) {
                            log.debug("message lengths match");
                            this.waitingForMore = true;
                            try {
                                Thread.sleep(10L);
                            }
                            catch (Exception ex) {
                                log.debug(ex.getLocalizedMessage(), (Throwable)ex);
                            }
                            this.lastIncomplete = null;
                            this.forwardToPort(Dcc4PcMessage.getResponse());
                            return;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Not all of the command was sent, we need to figure out a way to resend the bits");
                            log.debug("Original Message length {}", (Object)this.mLastSentMessage.getNumDataElements());
                            log.debug("What CID has procced in size {}", (Object)((byte)msg.getElement(1)));
                            log.debug("Reply is in error {}", (Object)((Dcc4PcReply)msg).toHexString());
                        }
                    } else if (this.mLastSentMessage.getElement(0) == 12) {
                        if (log.isDebugEnabled()) {
                            log.debug("last message was a get response {}", (Object)((Dcc4PcReply)msg).toHexString());
                        }
                        if (msg.getElement(0) == 0) {
                            ((Dcc4PcReply)msg).strip();
                            if (this.lastIncomplete != null) {
                                if (msg.getNumDataElements() != 0) {
                                    int iOrig = this.lastIncomplete.getNumDataElements();
                                    int iNew = 0;
                                    while (iNew < msg.getNumDataElements()) {
                                        this.lastIncomplete.setElement(iOrig, msg.getElement(iNew));
                                        ++iOrig;
                                        ++iNew;
                                    }
                                }
                                log.debug("Reply set as lastIncomplete");
                                msg = this.lastIncomplete;
                            }
                            ((Dcc4PcReply)msg).setError(false);
                            ((Dcc4PcReply)msg).setOriginalRequest(this.mLastMessage);
                            this.lastIncomplete = null;
                            this.waitingForMore = false;
                            this.mLastMessage = null;
                            this.mLastSentMessage = null;
                        } else {
                            if (msg.getElement(0) == 1) {
                                this.waitingForMore = true;
                                ((Dcc4PcReply)msg).strip();
                                if (this.lastIncomplete != null) {
                                    if (msg.getNumDataElements() != 0) {
                                        int iOrig = this.lastIncomplete.getNumDataElements();
                                        int iNew = 0;
                                        while (iNew < msg.getNumDataElements()) {
                                            this.lastIncomplete.setElement(iOrig, msg.getElement(iNew));
                                            ++iOrig;
                                            ++iNew;
                                        }
                                    }
                                } else if (msg.getNumDataElements() > 1) {
                                    this.lastIncomplete = (Dcc4PcReply)msg;
                                }
                                this.forwardToPort(Dcc4PcMessage.getResponse());
                                return;
                            }
                            log.debug("Reply is an error mesage");
                            ((Dcc4PcReply)msg).setError(true);
                            this.mLastMessage.setRetries(this.mLastMessage.getRetries() - 1);
                            if (this.mLastMessage.getRetries() >= 0) {
                                Runnable iOrig = this.xmtRunnable;
                                synchronized (iOrig) {
                                    this.mCurrentState = 45;
                                    this.replyInDispatch = false;
                                    this.xmtRunnable.notify();
                                }
                                return;
                            }
                        }
                    }
                } else {
                    log.debug("Last message sent was null {}", (Object)((Dcc4PcReply)msg).toHexString());
                }
                this.replyInDispatch = true;
                if (log.isDebugEnabled()) {
                    log.debug("dispatch reply of length {} contains {} state {}", new Object[]{msg.getNumDataElements(), msg.toString(), this.mCurrentState});
                }
                AbstractMRTrafficController.RcvNotifier r = this.newRcvNotifier(msg, this.mLastSender, this);
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    log.error("Unexpected exception in invokeAndWait:", (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("dispatch thread invoked");
                }
                if (msg.isUnsolicited()) break block56;
                switch (this.mCurrentState) {
                    case 25: {
                        if (msg.isRetransmittableErrorMsg()) {
                            if (log.isDebugEnabled()) {
                                log.debug("Automatic Recovery from Error Message: {}", (Object)msg.toString());
                            }
                            Runnable e = this.xmtRunnable;
                            synchronized (e) {
                                this.mCurrentState = 45;
                                this.replyInDispatch = false;
                                this.xmtRunnable.notify();
                                break;
                            }
                        }
                        Runnable e = this.xmtRunnable;
                        synchronized (e) {
                            this.mCurrentState = 15;
                            this.replyInDispatch = false;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    case 30: {
                        Runnable runnable;
                        this.mCurrentMode = 4;
                        this.replyInDispatch = false;
                        int warmUpDelay = this.enterProgModeDelayTime();
                        if (warmUpDelay != 0) {
                            try {
                                runnable = this.xmtRunnable;
                                synchronized (runnable) {
                                    this.xmtRunnable.wait(warmUpDelay);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    case 35: {
                        this.mCurrentMode = 1;
                        this.replyInDispatch = false;
                        Runnable runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    default: {
                        this.replyInDispatch = false;
                        this.unexpectedReplyStateError(this.mCurrentState, msg.toString());
                        break;
                    }
                }
                break block57;
            }
            if (log.isDebugEnabled()) {
                log.debug("Unsolicited Message Received {}", (Object)msg.toString());
            }
            this.replyInDispatch = false;
        }
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        this.readingData = false;
        int i = 0;
        block0: while (i < msg.maxSize()) {
            boolean waiting = true;
            while (waiting) {
                if (this.controller.getInputStream().available() > 0) {
                    this.readingData = true;
                    byte char1 = this.readByteProtected(istream);
                    waiting = false;
                    if (this.flushReceiveChars) {
                        this.lastIncomplete = null;
                        this.waitingForMore = false;
                        this.mLastMessage = null;
                        this.mLastSentMessage = null;
                        this.readingData = false;
                        log.warn("timeout flushes receive buffer: {}", (Object)((Dcc4PcReply)msg).toHexString());
                        msg.flush();
                        i = 0;
                        this.flushReceiveChars = false;
                        waiting = true;
                        continue;
                    }
                    if (this.canReceive()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Set data {}, {}", (Object)i, (Object)(char1 & 0xFF));
                        }
                        msg.setElement(i, char1);
                        waiting = false;
                        if (this.port.isRI()) {
                            log.debug("Ring high error");
                            ((Dcc4PcReply)msg).setError(true);
                            break block0;
                        }
                        if (!this.endOfMessage(msg)) continue;
                        break block0;
                    }
                    --i;
                    log.error("unsolicited character received: {}", (Object)Integer.toHexString(char1));
                    continue;
                }
                if (!this.port.isDSR()) {
                    if (i == 0) {
                        waiting = true;
                        continue;
                    }
                    log.debug("We have data so will break");
                    waiting = false;
                    break block0;
                }
                this.readingData = false;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transmitWait(int waitTime, int state, String InterruptMessage) {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        long endTime = currentTime + (long)waitTime;
        while (endTime > (currentTime = Calendar.getInstance().getTimeInMillis())) {
            long wait = endTime - currentTime;
            try {
                Runnable runnable = this.xmtRunnable;
                synchronized (runnable) {
                    if (this.mCurrentState != state) {
                        return;
                    }
                    this.xmtRunnable.wait(wait);
                    if (this.readingData) {
                        endTime += 10L;
                    }
                    if (this.waitingForMore) {
                        this.waitingForMore = false;
                        endTime += 200L;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                log.error(InterruptMessage);
            }
        }
        log.debug("TIMEOUT in transmitWait, mCurrentState:{} {} port dsr {} wait time {}", new Object[]{this.mCurrentState, state, this.port.isDSR(), waitTime});
    }
}

