/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.jmrix.dcc4pc.Bundle;
import jmri.jmrix.dcc4pc.Dcc4PcBoardManager;
import jmri.jmrix.dcc4pc.Dcc4PcListener;
import jmri.jmrix.dcc4pc.Dcc4PcMessage;
import jmri.jmrix.dcc4pc.Dcc4PcReply;
import jmri.jmrix.dcc4pc.Dcc4PcReporter;
import jmri.jmrix.dcc4pc.Dcc4PcReporterManager;
import jmri.jmrix.dcc4pc.Dcc4PcSensor;
import jmri.jmrix.dcc4pc.Dcc4PcSystemConnectionMemo;
import jmri.jmrix.dcc4pc.Dcc4PcTrafficController;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcSensorManager
extends AbstractSensorManager
implements Dcc4PcListener {
    Dcc4PcReporterManager reportManager;
    Runnable pollShutDownTask;
    Dcc4PcBoardManager boardManager;
    Dcc4PcTrafficController tc;
    private int board;
    private int channel;
    Thread pollThread;
    boolean stopPolling = true;
    public static final int NO_ADDRESS = 0;
    public static final int SHORT_ADDRESS = 2;
    public static final int LONG_ADDRESS = 4;
    public static final int CONSIST_ADDRESS = 8;
    private final int shortCycleInterval = 1;
    private final int pollTimeout = 600;
    private boolean awaitingReply = false;
    ConcurrentHashMap<Integer, ActiveBoard> activeBoards = new ConcurrentHashMap(5);
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcSensorManager.class);

    public Dcc4PcSensorManager(Dcc4PcTrafficController tc, Dcc4PcSystemConnectionMemo memo) {
        super(memo);
        this.tc = tc;
        this.reportManager = (Dcc4PcReporterManager)memo.get(ReporterManager.class);
        InstanceManager.store(this, Dcc4PcSensorManager.class);
        this.boardManager = new Dcc4PcBoardManager(tc, this);
        this.pollShutDownTask = this::stopPolling;
        this.startPolling();
    }

    @Override
    public Dcc4PcSensor getSensor(@Nonnull String name) {
        return (Dcc4PcSensor)super.getSensor(name);
    }

    @Override
    @Nonnull
    public Dcc4PcSystemConnectionMemo getMemo() {
        return (Dcc4PcSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        Dcc4PcSensor s = new Dcc4PcSensor(systemName, userName);
        s.setUserName(userName);
        this.extractBoardID(systemName);
        return s;
    }

    void extractBoardID(String systemName) {
        if (systemName.contains(":")) {
            int boardNo;
            int indexOfSplit = systemName.indexOf(":");
            systemName = systemName.substring(0, indexOfSplit);
            indexOfSplit = this.getSystemPrefix().length() + 1;
            systemName = systemName.substring(indexOfSplit);
            try {
                boardNo = Integer.parseInt(systemName);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Unable to find the board address from system name {}", (Object)systemName);
                return;
            }
            this.addBoard(boardNo);
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        block6: {
            if (curAddress.contains(":")) {
                this.board = 0;
                this.channel = 0;
                int seperator = curAddress.indexOf(":");
                try {
                    this.board = Integer.parseInt(curAddress.substring(0, seperator));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JmriException("Unable to convert " + curAddress + " into the cab and channel format of nn:xx");
                }
                try {
                    this.channel = Integer.parseInt(curAddress.substring(seperator + 1));
                    if (this.channel > 16 || this.channel < 1) {
                        throw new JmriException("In Address " + curAddress + " Channel number should be in the range of 1 to 16");
                    }
                    break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JmriException("Unable to convert " + curAddress + " into the cab and channel format of nn:xx");
                }
            }
            throw new JmriException("Unable to convert " + curAddress + " into the cab and channel format of nn:xx");
        }
        String iName = curAddress;
        this.addBoard(this.board);
        return String.valueOf(prefix) + this.typeLetter() + iName;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            int x = 1;
            while (x < 10) {
                if (this.channel < 16) {
                    ++this.channel;
                } else {
                    ++this.board;
                    this.channel = 1;
                }
                s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + this.board + ":" + this.channel);
                if (s == null) {
                    return String.valueOf(this.board) + ":" + this.channel;
                }
                ++x;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, String.valueOf(this.board) + ":" + this.channel));
        }
        return curAddress;
    }

    public void notifyReply(Dcc4PcReply m) {
    }

    public void notifyMessage(Dcc4PcMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPolling() {
        Dcc4PcSensorManager dcc4PcSensorManager = this;
        synchronized (dcc4PcSensorManager) {
            this.stopPolling = true;
        }
        if (this.pollThread != null) {
            try {
                this.pollThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void startPolling() {
        if (this.stopPolling && this.pollThread != null) {
            this.pollThread = null;
        }
        this.stopPolling = false;
        if (this.pollThread == null) {
            this.pollThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Dcc4PcSensorManager.this.pollManager();
                }
            }, "DCC4PC Sensor Poll");
            this.pollThread.start();
        }
    }

    void addBoard(int newBoard) {
        this.boardManager.addBoard(newBoard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reply(Dcc4PcReply r) {
        if (log.isDebugEnabled()) {
            log.debug("Reply details sm: {}", (Object)r.toHexString());
        }
        if (r.getNumDataElements() == 0 && r.getElement(0) == 0) {
            return;
        }
        if (r.getBoard() == -1) {
            log.debug("Message is not for a detection board so ignore");
            return;
        }
        if (r.isError()) {
            log.debug("Reply is in error {}", (Object)r.toHexString());
            Dcc4PcSensorManager dcc4PcSensorManager = this;
            synchronized (dcc4PcSensorManager) {
                this.awaitingReply = false;
                this.notify();
            }
        }
        if (!r.isUnsolicited()) {
            Dcc4PcSensorManager dcc4PcSensorManager = this;
            synchronized (dcc4PcSensorManager) {
                this.awaitingReply = false;
                this.notify();
            }
            if (log.isDebugEnabled()) {
                log.debug("Get Data inputs {}", (Object)r.toHexString());
            }
            if (r.getBoard() > -1) {
                class ProcessPacket
                implements Runnable {
                    Dcc4PcReply reply;
                    private final /* synthetic */ Dcc4PcReply val$r;

                    ProcessPacket(Dcc4PcReply r, Dcc4PcReply dcc4PcReply) {
                        this.val$r = dcc4PcReply;
                        this.reply = r;
                    }

                    @Override
                    public void run() {
                        ActiveBoard curBoard = Dcc4PcSensorManager.this.activeBoards.get(this.val$r.getBoard());
                        if (curBoard != null) {
                            curBoard.processInputPacket(this.reply);
                        } else {
                            log.error("Board disappeared from system {}", (Object)this.val$r.getBoard());
                        }
                    }
                }
                Thread thr = new Thread((Runnable)new ProcessPacket(r, r), "Dcc4PCSensor Process Packet for " + r.getBoard());
                try {
                    thr.start();
                }
                catch (IllegalThreadStateException ex) {
                    log.error(ex.toString());
                }
            } else {
                log.error("Do not know who this board message is for");
            }
        }
    }

    void getInputState(int[] longArray, int board) {
        String sensorPrefix = String.valueOf(this.getSystemPrefix()) + this.typeLetter() + board + ":";
        String reporterPrefix = String.valueOf(this.getSystemPrefix()) + "R" + board + ":";
        int inputNo = 1;
        int i = 0;
        while (i < 4) {
            Dcc4PcReporter r;
            int state = this.getInputState(longArray[i], inputNo);
            Dcc4PcSensor s = this.getSensor(String.valueOf(sensorPrefix) + inputNo);
            if (s != null) {
                s.setOwnState(state);
            }
            if ((r = (Dcc4PcReporter)this.reportManager.getReporter(String.valueOf(reporterPrefix) + inputNo)) != null) {
                r.setRailComState(state);
            }
            state = this.getInputState(longArray[i], ++inputNo);
            s = this.getSensor(String.valueOf(sensorPrefix) + inputNo);
            if (s != null) {
                s.setOwnState(state);
            }
            if ((r = (Dcc4PcReporter)this.reportManager.getReporter(String.valueOf(reporterPrefix) + inputNo)) != null) {
                r.setRailComState(state);
            }
            state = this.getInputState(longArray[i], ++inputNo);
            s = this.getSensor(String.valueOf(sensorPrefix) + inputNo);
            if (s != null) {
                s.setOwnState(state);
            }
            if ((r = (Dcc4PcReporter)this.reportManager.getReporter(String.valueOf(reporterPrefix) + inputNo)) != null) {
                r.setRailComState(state);
            }
            state = this.getInputState(longArray[i], ++inputNo);
            s = this.getSensor(String.valueOf(sensorPrefix) + inputNo);
            if (s != null) {
                s.setOwnState(state);
            }
            if ((r = (Dcc4PcReporter)this.reportManager.getReporter(String.valueOf(reporterPrefix) + inputNo)) != null) {
                r.setRailComState(state);
            }
            ++inputNo;
            ++i;
        }
    }

    int getInputState(int value, int input) {
        int lastbit = 7;
        switch (input) {
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                lastbit = 1;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                lastbit = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                lastbit = 5;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                lastbit = 7;
                break;
            }
        }
        int tempValue = value << 31 - lastbit;
        switch (tempValue >>> 31 - lastbit + (lastbit - 1)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 32;
            }
        }
        return 1;
    }

    public static String decodeInputState(int state) {
        String rtr;
        switch (state) {
            case 4: {
                rtr = "UnOccupied";
                break;
            }
            case 2: {
                rtr = "Occupied No RailCom Data";
                break;
            }
            case 16: {
                rtr = "Occupied RailCom Orientation A";
                break;
            }
            case 32: {
                rtr = "Occupied RailCom Orientation B";
                break;
            }
            default: {
                rtr = "Unknown";
            }
        }
        return rtr;
    }

    int decodeDuplicatePacket(int value, int seq, Dcc4PcReporter rc) {
        int lastbit = 7;
        while (seq >= 4) {
            seq -= 4;
        }
        switch (seq) {
            case 0: {
                lastbit = 1;
                break;
            }
            case 1: {
                lastbit = 3;
                break;
            }
            case 2: {
                lastbit = 5;
                break;
            }
            case 3: {
                lastbit = 7;
                break;
            }
        }
        int tempValue = value << 31 - lastbit;
        if ((tempValue >>>= 31 - lastbit + (lastbit - 1)) != 0) {
            rc.duplicatePacket(tempValue);
        }
        return tempValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollManager() {
        Dcc4PcMessage m;
        int boardAddress;
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.activeBoards.keySet()).iterator();
        while (iterator.hasNext()) {
            boardAddress = (Integer)iterator.next();
            m = Dcc4PcMessage.resetBoardData(boardAddress);
            m.setTimeout(100);
            this.tc.sendDcc4PcMessage(m, null);
        }
        while (!this.stopPolling) {
            if (this.activeBoards.isEmpty()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            iterator = ((ConcurrentHashMap.KeySetView)this.activeBoards.keySet()).iterator();
            while (iterator.hasNext()) {
                boardAddress = (Integer)iterator.next();
                if (!this.activeBoards.get(boardAddress).doNotPoll()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Poll board {}", (Object)boardAddress);
                    }
                    m = Dcc4PcMessage.pollBoard(boardAddress);
                    if (log.isDebugEnabled()) {
                        log.debug("queueing poll request for board {}", (Object)boardAddress);
                    }
                    this.tc.sendDcc4PcMessage(m, this);
                    Dcc4PcSensorManager dcc4PcSensorManager = this;
                    synchronized (dcc4PcSensorManager) {
                        this.awaitingReply = true;
                        try {
                            this.wait(600L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    int delay = 1;
                    Dcc4PcSensorManager dcc4PcSensorManager2 = this;
                    synchronized (dcc4PcSensorManager2) {
                        if (this.awaitingReply) {
                            log.warn("timeout awaiting poll response for board {}", (Object)boardAddress);
                            delay = 600;
                        }
                        try {
                            this.wait(delay);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Board set to Do Not Poll {}", (Object)boardAddress);
                }
                Dcc4PcSensorManager dcc4PcSensorManager = this;
                synchronized (dcc4PcSensorManager) {
                    if (this.stopPolling) {
                        log.debug("Polling stopped {}", (Object)this.stopPolling);
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
    }

    protected void createSensorsFromReply(Dcc4PcReply r) {
        int boardAddress = r.getBoard();
        log.debug("createSensorsFromReply: Get enabled inputs {}", (Object)r.toHexString());
        String sensorPrefix = String.valueOf(this.getSystemPrefix()) + this.typeLetter() + boardAddress + ":";
        String reporterPrefix = String.valueOf(this.getSystemPrefix()) + "R" + boardAddress + ":";
        int x = 1;
        int i = 0;
        while (i < r.getNumDataElements()) {
            int j = 0;
            while (j < 8) {
                Dcc4PcSensor s = (Dcc4PcSensor)this.createNewSensor(String.valueOf(sensorPrefix) + (j + x), null);
                this.register(s);
                s.setInput(j + x);
                this.activeBoards.get(boardAddress).addSensor(j + x, s);
                if ((r.getElement(i) & 1) == 1) {
                    s.setEnabled(true);
                }
                Dcc4PcReporter report = (Dcc4PcReporter)this.reportManager.createNewReporter(String.valueOf(reporterPrefix) + (j + x), null);
                this.activeBoards.get(boardAddress).addReporter(j + x, report);
                ++j;
            }
            x += 8;
            ++i;
        }
        this.activeBoards.get(boardAddress).setDoNotPoll(false);
        log.debug("     created {} sensors", (Object)x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTimeout(Dcc4PcMessage m) {
        if (log.isDebugEnabled()) {
            log.debug("timeout received to our last message {}", (Object)m.toString());
        }
        if (!this.stopPolling) {
            Dcc4PcSensorManager dcc4PcSensorManager = this;
            synchronized (dcc4PcSensorManager) {
                this.awaitingReply = false;
                this.notify();
            }
        }
    }

    @Override
    public void message(Dcc4PcMessage m) {
    }

    public void changeBoardAddress(int oldAddress, int newAddress) {
        ActiveBoard board = this.activeBoards.get(oldAddress);
        board.setDoNotPoll(true);
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{11, (byte)oldAddress, 3, (byte)newAddress});
        this.tc.sendDcc4PcMessage(m, null);
        this.stopPolling();
        this.activeBoards.remove(oldAddress);
        this.activeBoards.put(newAddress, board);
        board.setAddress(newAddress);
        this.startPolling();
        String sensorPrefix = String.valueOf(this.getSystemPrefix()) + this.typeLetter() + newAddress + ":";
        String reporterPrefix = String.valueOf(this.getSystemPrefix()) + "R" + newAddress + ":";
        int i = 1;
        while (i < board.getNumEnabledSensors() + 1) {
            board.getSensorAtIndex(i).setEnabled(false);
            int input = board.getSensorAtIndex(i).getInput();
            Dcc4PcSensor s = (Dcc4PcSensor)this.createNewSensor(String.valueOf(sensorPrefix) + input, null);
            this.register(s);
            s.setInput(input);
            s.setEnabled(true);
            board.addSensor(input, s);
            Dcc4PcReporter report = (Dcc4PcReporter)this.reportManager.createNewReporter(String.valueOf(reporterPrefix) + input, null);
            board.addReporter(input, report);
            ++i;
        }
        board.setDoNotPoll(false);
    }

    public List<Integer> getBoards() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Enumeration<Integer> keys = this.activeBoards.keys();
        while (keys.hasMoreElements()) {
            Integer key = keys.nextElement();
            list.add(key);
        }
        return list;
    }

    public int getBoardInputs(int board) {
        if (!this.activeBoards.containsKey(board)) {
            return -1;
        }
        return this.activeBoards.get(board).getInputs();
    }

    public String getBoardEncodingAsString(int board) {
        if (!this.activeBoards.containsKey(board)) {
            return "unknown";
        }
        return this.activeBoards.get(board).getEncodingAsString();
    }

    public String getBoardVersion(int board) {
        if (!this.activeBoards.containsKey(board)) {
            return "unknown";
        }
        return this.activeBoards.get(board).getVersion();
    }

    public String getBoardDescription(int board) {
        if (!this.activeBoards.containsKey(board)) {
            return "unknown";
        }
        return this.activeBoards.get(board).getDescription();
    }

    protected boolean isBoardCreated(int address) {
        return this.activeBoards.containsKey(address);
    }

    protected void addActiveBoard(int address, String version, int inputs, int encoding) {
        this.activeBoards.put(address, new ActiveBoard(address, version, inputs, encoding));
    }

    protected void setBoardDescription(int address, String description) {
        ActiveBoard board = this.activeBoards.get(address);
        board.setDescription(description);
    }

    protected void createSensorsForBoard(Dcc4PcReply r) {
        if (r.getBoard() == -1) {
            log.debug("Reply has no board associated with it");
            return;
        }
        class SensorMaker
        implements Runnable {
            Dcc4PcReply reply;

            SensorMaker(Dcc4PcReply r) {
                this.reply = r;
            }

            @Override
            public void run() {
                Dcc4PcSensorManager.this.createSensorsFromReply(this.reply);
            }
        }
        Thread thr = new Thread((Runnable)new SensorMaker(r), "Dcc4PCSensor Maker board " + r.getBoard());
        try {
            thr.start();
        }
        catch (IllegalThreadStateException ex) {
            log.error(ex.toString());
        }
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateTrimmedMin1NumberSystemNameFormat(name, locale);
    }

    @Override
    public void dispose() {
        this.stopPolling();
        super.dispose();
    }

    class ActiveBoard {
        int inputs;
        int encoding;
        String version;
        String description;
        int address;
        int failedRequests = 0;
        boolean doNotPoll = true;
        HashMap<Integer, Dcc4PcSensor> inputPorts = new HashMap(16);
        HashMap<Integer, Dcc4PcReporter> inputReportersPorts = new HashMap(16);
        int addr = 0;
        int dcc_addr_type = 0;
        int cvNumber = 0;
        int speed = 0;
        int[] lastDCCPacketSeen = new int[0];

        ActiveBoard(int address, String version, int inputs, int encoding) {
            this.version = version;
            this.inputs = inputs;
            this.encoding = encoding;
            this.address = address;
        }

        void setAddress(int address) {
            this.address = address;
        }

        void addFailedRequests() {
            ++this.failedRequests;
        }

        void clearFailedRequests() {
            this.failedRequests = 0;
        }

        void setDoNotPoll(boolean poll) {
            if (!poll) {
                Dcc4PcMessage m = Dcc4PcMessage.resetBoardData(this.address);
                m.setTimeout(100);
                Dcc4PcSensorManager.this.tc.sendDcc4PcMessage(m, null);
            }
            this.doNotPoll = poll;
        }

        boolean doNotPoll() {
            return this.doNotPoll;
        }

        void addSensor(int port, Dcc4PcSensor sensor) {
            this.inputPorts.put(port, sensor);
        }

        String getEncodingAsString() {
            if ((this.encoding & 1) == 1) {
                return "Supports Cooked RailCom Encoding";
            }
            return "Supports Raw RailCom Encoding";
        }

        void setDescription(String description) {
            this.description = description;
        }

        Dcc4PcSensor getSensorAtIndex(int i) {
            if (!this.inputPorts.containsKey(i)) {
                return null;
            }
            return this.inputPorts.get(i);
        }

        int getNumEnabledSensors() {
            return this.inputPorts.size();
        }

        void addReporter(int port, Dcc4PcReporter reporter) {
            this.inputReportersPorts.put(port, reporter);
        }

        Dcc4PcReporter getReporterAtIndex(int i) {
            if (!this.inputReportersPorts.containsKey(i)) {
                return null;
            }
            return this.inputReportersPorts.get(i);
        }

        synchronized void processInputPacket(Dcc4PcReply r) {
            if (log.isDebugEnabled()) {
                log.debug("==== Process Packet ====");
                log.debug(r.toHexString());
            }
            int packetTypeCmd = 0;
            int currentByteLocation = 0;
            while (currentByteLocation < r.getNumDataElements()) {
                log.debug("--- Start {} ---", (Object)currentByteLocation);
                int oldstart = currentByteLocation;
                if ((r.getElement(currentByteLocation) & 0x80) == 128) {
                    log.debug("Error at head");
                    packetTypeCmd = 3;
                    ++currentByteLocation;
                } else if ((r.getElement(currentByteLocation) & 0x40) == 64) {
                    log.debug("Correct Type 2 packet");
                    currentByteLocation = this.processPacket(r, 2, packetTypeCmd, currentByteLocation);
                } else {
                    log.debug("Correct Type 1 packet");
                    currentByteLocation = this.processPacket(r, 1, packetTypeCmd, currentByteLocation);
                }
                if (!log.isDebugEnabled()) continue;
                StringBuilder buf = new StringBuilder();
                int i = oldstart;
                while (i < currentByteLocation) {
                    buf.append(Integer.toHexString(r.getElement(i) & 0xFF)).append(",");
                    ++i;
                }
                log.debug(buf.toString());
                log.debug("--- finish packet {} ---", (Object)(currentByteLocation - 1));
            }
            log.debug("==== Finish Processing Packet ====");
        }

        public int processPacket(Dcc4PcReply r, int packetType, int packetTypeCmd, int currentByteLocation) {
            int dccpacketlength = packetType == 2 ? r.getElement(currentByteLocation) - 64 + 1 : r.getElement(currentByteLocation) + 1;
            ++currentByteLocation;
            int[] dcc_Data = new int[dccpacketlength];
            int i = 0;
            while (i < dccpacketlength) {
                dcc_Data[i] = r.getElement(currentByteLocation);
                ++currentByteLocation;
                ++i;
            }
            try {
                this.decodeDCCPacket(dcc_Data);
            }
            catch (Exception ex) {
                log.error(ex.toString(), (Throwable)ex);
            }
            if (packetType == 2) {
                Dcc4PcSensorManager.this.getInputState(Arrays.copyOfRange(r.getDataAsArray(), currentByteLocation, currentByteLocation + 4), this.address);
                currentByteLocation += 4;
            }
            ArrayList<Dcc4PcReporter> railCommDataForSensor = new ArrayList<Dcc4PcReporter>();
            int i2 = 1;
            while (i2 < this.getNumEnabledSensors() + 1) {
                if (this.getReporterAtIndex(i2).getRailComState() >= 16) {
                    if (log.isDebugEnabled()) {
                        log.debug("Adding reporter for input {}", (Object)this.getReporterAtIndex(i2).getSystemName());
                    }
                    railCommDataForSensor.add(this.getReporterAtIndex(i2));
                }
                ++i2;
            }
            int railComDupPacket = (int)Math.ceil((float)railCommDataForSensor.size() / 4.0f);
            log.debug("We have {} Byte(s) to read on data", (Object)railComDupPacket);
            log.debug("Now to handle the duplicate packet data");
            int j = 0;
            int i3 = 0;
            while (i3 < railComDupPacket) {
                int inputNo = 0;
                int dup = Dcc4PcSensorManager.this.decodeDuplicatePacket(r.getElement(currentByteLocation), inputNo, (Dcc4PcReporter)railCommDataForSensor.get(j));
                if (log.isDebugEnabled()) {
                    log.debug("Input {} - {}", (Object)((Dcc4PcReporter)railCommDataForSensor.get(j)).getDisplayName(), (Object)dup);
                }
                if (dup == 0) {
                    ++j;
                } else {
                    railCommDataForSensor.remove(j);
                }
                ++inputNo;
                if (j < railCommDataForSensor.size()) {
                    dup = Dcc4PcSensorManager.this.decodeDuplicatePacket(r.getElement(currentByteLocation), inputNo, (Dcc4PcReporter)railCommDataForSensor.get(j));
                    if (log.isDebugEnabled()) {
                        log.debug("Input {} - {}", (Object)((Dcc4PcReporter)railCommDataForSensor.get(j)).getDisplayName(), (Object)dup);
                    }
                    if (dup == 0) {
                        ++j;
                    } else {
                        railCommDataForSensor.remove(j);
                    }
                    ++inputNo;
                }
                if (j < railCommDataForSensor.size()) {
                    dup = Dcc4PcSensorManager.this.decodeDuplicatePacket(r.getElement(currentByteLocation), inputNo, (Dcc4PcReporter)railCommDataForSensor.get(j));
                    if (log.isDebugEnabled()) {
                        log.debug("Input {} - {}", (Object)((Dcc4PcReporter)railCommDataForSensor.get(j)).getDisplayName(), (Object)dup);
                    }
                    if (dup == 0) {
                        ++j;
                    } else {
                        railCommDataForSensor.remove(j);
                    }
                    ++inputNo;
                }
                if (j < railCommDataForSensor.size()) {
                    dup = Dcc4PcSensorManager.this.decodeDuplicatePacket(r.getElement(currentByteLocation), inputNo, (Dcc4PcReporter)railCommDataForSensor.get(j));
                    if (log.isDebugEnabled()) {
                        log.debug("Input {} - {}", (Object)((Dcc4PcReporter)railCommDataForSensor.get(j)).getDisplayName(), (Object)dup);
                    }
                    if (dup == 0) {
                        ++j;
                    } else {
                        railCommDataForSensor.remove(j);
                    }
                }
                ++currentByteLocation;
                ++i3;
            }
            if (log.isDebugEnabled()) {
                for (Dcc4PcReporter dcc4PcReporter : railCommDataForSensor) {
                    log.debug("Data for sensor {}", (Object)dcc4PcReporter.getDisplayName());
                }
            }
            railComDupPacket = (int)Math.ceil((float)railCommDataForSensor.size() / 2.0f);
            if (log.isDebugEnabled()) {
                log.debug("We have {} size byte(s) to read on data", (Object)railComDupPacket);
            }
            j = 0;
            i = 0;
            while (i < railComDupPacket) {
                int tempValue = r.getElement(currentByteLocation) << 28;
                ((Dcc4PcReporter)railCommDataForSensor.get(j)).setPacketLength(tempValue >>>= 28);
                if (++j < railCommDataForSensor.size()) {
                    tempValue = r.getElement(currentByteLocation) << 24;
                    ((Dcc4PcReporter)railCommDataForSensor.get(j)).setPacketLength(tempValue >>>= 28);
                    ++j;
                }
                ++currentByteLocation;
                ++i;
            }
            i = 0;
            while (i < railCommDataForSensor.size()) {
                log.debug("{} {}", (Object)((Dcc4PcReporter)railCommDataForSensor.get(i)).getDisplayName(), (Object)((Dcc4PcReporter)railCommDataForSensor.get(i)).getPacketLength());
                int[] arraytemp = new int[((Dcc4PcReporter)railCommDataForSensor.get(i)).getPacketLength()];
                j = 0;
                while (j < ((Dcc4PcReporter)railCommDataForSensor.get(i)).getPacketLength()) {
                    arraytemp[j] = 0xFF & r.getElement(currentByteLocation);
                    ++currentByteLocation;
                    ++j;
                }
                ((Dcc4PcReporter)railCommDataForSensor.get(i)).setPacket(arraytemp, this.dcc_addr_type, this.addr, this.cvNumber, this.speed, packetTypeCmd);
                ++i;
            }
            return currentByteLocation;
        }

        void decodeDCCPacket(int[] packet) {
            String addt;
            int addr_1;
            int i;
            if (Arrays.equals(packet, this.lastDCCPacketSeen)) {
                return;
            }
            int idx = 0;
            while (idx < packet.length) {
                this.lastDCCPacketSeen = (int[])packet.clone();
                ++idx;
            }
            this.speed = 0;
            this.addr = 0;
            this.dcc_addr_type = 0;
            if (log.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder();
                int i2 = 0;
                while (i2 < packet.length) {
                    buf.append(Integer.toHexString(packet[i2])).append(",");
                    ++i2;
                }
                String s = buf.toString();
                log.debug("bytes to process {}", (Object)s);
            }
            if ((packet[i = 0] & 0xFF) == 0) {
                return;
            }
            if ((packet[i] & 0xFF) == 255) {
                return;
            }
            if ((packet[i] & 0x80) == 128) {
                if ((packet[i] & 0x80) != 128) {
                    ++i;
                }
                return;
            }
            if (packet.length > 0) {
                addr_1 = packet[i] & 0xFF;
                ++i;
            } else {
                addr_1 = 0;
            }
            if (addr_1 == 0) {
                this.dcc_addr_type = 0;
            } else if (addr_1 >= 1 && addr_1 <= 127) {
                this.dcc_addr_type = 2;
                this.addr = addr_1;
            } else if (addr_1 >= 128 && addr_1 <= 191) {
                this.dcc_addr_type = 0;
            } else if (addr_1 >= 192 && addr_1 <= 231) {
                this.dcc_addr_type = 4;
                this.addr = (addr_1 & 0x3F) << 8 | packet[i] & 0xFF;
                ++i;
            } else {
                this.dcc_addr_type = 0;
            }
            switch (this.dcc_addr_type) {
                case 4: {
                    addt = "Long";
                    break;
                }
                case 2: {
                    addt = "Short";
                    break;
                }
                default: {
                    addt = "No Address";
                }
            }
            log.debug("DCC address type {} addr {}", (Object)addt, (Object)this.addr);
            if (this.dcc_addr_type != 0) {
                log.debug("Current index  {} value {}", (Object)i, (Object)(packet[i] & 0xFF));
                if ((packet[i] & 0xE0) == 224) {
                    this.cvNumber = (packet[++i] & 0xFF) + 1;
                    log.debug("CV Access cv:{}", (Object)this.cvNumber);
                } else if ((packet[i] & 0xC0) == 192) {
                    log.debug("Future");
                    if ((packet[++i] & 0x1F) == 31) {
                        ++i;
                    } else if ((packet[i] & 0x1E) == 30) {
                        ++i;
                    } else if ((packet[i] & 0x1D) == 29) {
                        ++i;
                    } else {
                        int cfr_ignored_0 = packet[i];
                    }
                } else if ((packet[i] & 0xA0) == 160) {
                    log.debug("For Function Group 2");
                    if ((packet[i] & 0x10) == 16) {
                        log.debug("Functions 5 to 8");
                        if ((packet[i] & 8) == 8) {
                            log.debug("Function 8 on");
                        } else {
                            log.debug("Function 8 off");
                        }
                        if ((packet[i] & 4) == 4) {
                            log.debug("Function 7 on");
                        } else {
                            log.debug("Function 7 off");
                        }
                        if ((packet[i] & 2) == 2) {
                            log.debug("Function 6 on");
                        } else {
                            log.debug("Function 6 off");
                        }
                        if ((packet[i] & 1) == 1) {
                            log.debug("Function 5 on");
                        } else {
                            log.debug("Function 5 off");
                        }
                    } else {
                        log.debug("Functions 9 to 12");
                        if ((packet[i] & 8) == 8) {
                            log.debug("Function 12 on");
                        } else {
                            log.debug("Function 12 off");
                        }
                        if ((packet[i] & 4) == 4) {
                            log.debug("Function 11 on");
                        } else {
                            log.debug("Function 11 off");
                        }
                        if ((packet[i] & 2) == 2) {
                            log.debug("Function 10 on");
                        } else {
                            log.debug("Function 10 off");
                        }
                        if ((packet[i] & 1) == 1) {
                            log.debug("Function 9 on");
                        } else {
                            log.debug("Function 9 off");
                        }
                    }
                } else if ((packet[i] & 0x80) == 128) {
                    log.debug("For Function Group 1");
                } else if ((packet[i] & 0x60) == 96) {
                    this.speed = (packet[i] & 0xFF) - 96;
                    log.debug("Speed for forward 14 speed steps {}", (Object)this.speed);
                } else if ((packet[i] & 0x40) == 64) {
                    this.speed = (packet[i] & 0xFF) - 64;
                    log.debug("Speed for reverse 14 speed steps {}", (Object)this.speed);
                } else if ((packet[i] & 0x20) == 32) {
                    log.debug("Advanced Op");
                    if ((packet[i] & 0x1F) == 31) {
                        log.debug("128 speed step control");
                        if ((packet[++i] & 0x80) == 128) {
                            this.speed = (packet[i] & 0xFF) - 128;
                            log.debug("Forward {}", (Object)this.speed);
                        } else {
                            this.speed = packet[i] & 0xFF;
                            log.debug("Reverse {}", (Object)this.speed);
                        }
                    }
                } else {
                    log.debug("Decoder and Consist Instruction");
                }
            }
            log.debug("---End Decode DCC Packet---");
        }

        int getInputs() {
            return this.inputs;
        }

        String getDescription() {
            return this.description;
        }

        String getVersion() {
            return this.version;
        }
    }
}

