/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import java.util.Hashtable;
import java.util.Map;
import jmri.InstanceManager;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.implementation.AbstractRailComReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcReporter
extends AbstractRailComReporter {
    transient RailComPacket[] rcPacket = new RailComPacket[3];
    int state = 1;
    int packetLength = 0;
    int addr = 0;
    int address_part_1 = 256;
    int address_part_2 = -1;
    int addr_type = -1;
    int actual_speed = -1;
    int actual_load = -1;
    int actual_temperature = -1;
    int fuelLevel = -1;
    int waterLevel = -1;
    int location = -1;
    int routing_no = -1;
    int cvNumber = -1;
    int cvvalue = -1;
    int addressp1found = 0;
    static int packetseen = 0;
    static int packetsinerror = 0;
    Hashtable<Integer, Integer> cvValues = new Hashtable();
    public static final char ACK = '\u0080';
    public static final char ACK_1 = '\u0081';
    public static final char ACK_2 = '\u0082';
    public static final char ACK_3 = '\u0083';
    public static final char ACK_4 = '\u0084';
    public static final char ACK_5 = '\u0085';
    public static final char ACK_6 = '\u0086';
    public static final char ERROR = '\u00ff';
    private static final char[] decode;
    private static final Logger log;

    static {
        char[] cArray = new char[256];
        cArray[0] = 255;
        cArray[1] = 255;
        cArray[2] = 255;
        cArray[3] = 255;
        cArray[4] = 255;
        cArray[5] = 255;
        cArray[6] = 255;
        cArray[7] = 255;
        cArray[8] = 255;
        cArray[9] = 255;
        cArray[10] = 255;
        cArray[11] = 255;
        cArray[12] = 255;
        cArray[13] = 255;
        cArray[14] = 255;
        cArray[15] = 129;
        cArray[16] = 255;
        cArray[17] = 255;
        cArray[18] = 255;
        cArray[19] = 255;
        cArray[20] = 255;
        cArray[21] = 255;
        cArray[22] = 255;
        cArray[23] = 51;
        cArray[24] = 255;
        cArray[25] = 255;
        cArray[26] = 255;
        cArray[27] = 52;
        cArray[28] = 255;
        cArray[29] = 53;
        cArray[30] = 54;
        cArray[31] = 255;
        cArray[32] = 255;
        cArray[33] = 255;
        cArray[34] = 255;
        cArray[35] = 255;
        cArray[36] = 255;
        cArray[37] = 255;
        cArray[38] = 255;
        cArray[39] = 58;
        cArray[40] = 255;
        cArray[41] = 255;
        cArray[42] = 255;
        cArray[43] = 59;
        cArray[44] = 255;
        cArray[45] = 60;
        cArray[46] = 55;
        cArray[47] = 255;
        cArray[48] = 255;
        cArray[49] = 255;
        cArray[50] = 255;
        cArray[51] = 63;
        cArray[52] = 255;
        cArray[53] = 61;
        cArray[54] = 56;
        cArray[55] = 255;
        cArray[56] = 255;
        cArray[57] = 62;
        cArray[58] = 57;
        cArray[59] = 255;
        cArray[60] = 133;
        cArray[61] = 255;
        cArray[62] = 255;
        cArray[63] = 255;
        cArray[64] = 255;
        cArray[65] = 255;
        cArray[66] = 255;
        cArray[67] = 255;
        cArray[68] = 255;
        cArray[69] = 255;
        cArray[70] = 255;
        cArray[71] = 36;
        cArray[72] = 255;
        cArray[73] = 255;
        cArray[74] = 255;
        cArray[75] = 35;
        cArray[76] = 255;
        cArray[77] = 34;
        cArray[78] = 33;
        cArray[79] = 255;
        cArray[80] = 255;
        cArray[81] = 255;
        cArray[82] = 255;
        cArray[83] = 31;
        cArray[84] = 255;
        cArray[85] = 30;
        cArray[86] = 32;
        cArray[87] = 255;
        cArray[88] = 255;
        cArray[89] = 29;
        cArray[90] = 28;
        cArray[91] = 255;
        cArray[92] = 27;
        cArray[93] = 255;
        cArray[94] = 255;
        cArray[95] = 255;
        cArray[96] = 255;
        cArray[97] = 255;
        cArray[98] = 255;
        cArray[99] = 25;
        cArray[100] = 255;
        cArray[101] = 24;
        cArray[102] = 26;
        cArray[103] = 255;
        cArray[104] = 255;
        cArray[105] = 23;
        cArray[106] = 22;
        cArray[107] = 255;
        cArray[108] = 21;
        cArray[109] = 255;
        cArray[110] = 255;
        cArray[111] = 255;
        cArray[112] = 255;
        cArray[113] = 37;
        cArray[114] = 20;
        cArray[115] = 255;
        cArray[116] = 19;
        cArray[117] = 255;
        cArray[118] = 255;
        cArray[119] = 255;
        cArray[120] = 50;
        cArray[121] = 255;
        cArray[122] = 255;
        cArray[123] = 255;
        cArray[124] = 255;
        cArray[125] = 255;
        cArray[126] = 255;
        cArray[127] = 255;
        cArray[128] = 255;
        cArray[129] = 255;
        cArray[130] = 255;
        cArray[131] = 255;
        cArray[132] = 255;
        cArray[133] = 255;
        cArray[134] = 255;
        cArray[135] = 130;
        cArray[136] = 255;
        cArray[137] = 255;
        cArray[138] = 255;
        cArray[139] = 14;
        cArray[140] = 255;
        cArray[141] = 13;
        cArray[142] = 12;
        cArray[143] = 255;
        cArray[144] = 255;
        cArray[145] = 255;
        cArray[146] = 255;
        cArray[147] = 10;
        cArray[148] = 255;
        cArray[149] = 9;
        cArray[150] = 11;
        cArray[151] = 255;
        cArray[152] = 255;
        cArray[153] = 8;
        cArray[154] = 7;
        cArray[155] = 255;
        cArray[156] = 6;
        cArray[157] = 255;
        cArray[158] = 255;
        cArray[159] = 255;
        cArray[160] = 255;
        cArray[161] = 255;
        cArray[162] = 255;
        cArray[163] = 4;
        cArray[164] = 255;
        cArray[165] = 3;
        cArray[166] = 5;
        cArray[167] = 255;
        cArray[168] = 255;
        cArray[169] = 2;
        cArray[170] = '\u0001';
        cArray[171] = 255;
        cArray[173] = 255;
        cArray[174] = 255;
        cArray[175] = 255;
        cArray[176] = 255;
        cArray[177] = 15;
        cArray[178] = 16;
        cArray[179] = 255;
        cArray[180] = 17;
        cArray[181] = 255;
        cArray[182] = 255;
        cArray[183] = 255;
        cArray[184] = 18;
        cArray[185] = 255;
        cArray[186] = 255;
        cArray[187] = 255;
        cArray[188] = 255;
        cArray[189] = 255;
        cArray[190] = 255;
        cArray[191] = 255;
        cArray[192] = 255;
        cArray[193] = 255;
        cArray[194] = 255;
        cArray[195] = 131;
        cArray[196] = 255;
        cArray[197] = 43;
        cArray[198] = 48;
        cArray[199] = 255;
        cArray[200] = 255;
        cArray[201] = 42;
        cArray[202] = 47;
        cArray[203] = 255;
        cArray[204] = 49;
        cArray[205] = 255;
        cArray[206] = 255;
        cArray[207] = 255;
        cArray[208] = 255;
        cArray[209] = 41;
        cArray[210] = 46;
        cArray[211] = 255;
        cArray[212] = 45;
        cArray[213] = 255;
        cArray[214] = 255;
        cArray[215] = 255;
        cArray[216] = 44;
        cArray[217] = 255;
        cArray[218] = 255;
        cArray[219] = 255;
        cArray[220] = 255;
        cArray[221] = 255;
        cArray[222] = 255;
        cArray[223] = 255;
        cArray[224] = 255;
        cArray[225] = 134;
        cArray[226] = 40;
        cArray[227] = 255;
        cArray[228] = 39;
        cArray[229] = 255;
        cArray[230] = 255;
        cArray[231] = 255;
        cArray[232] = 38;
        cArray[233] = 255;
        cArray[234] = 255;
        cArray[235] = 255;
        cArray[236] = 255;
        cArray[237] = 255;
        cArray[238] = 255;
        cArray[239] = 255;
        cArray[240] = 132;
        cArray[241] = 255;
        cArray[242] = 255;
        cArray[243] = 255;
        cArray[244] = 255;
        cArray[245] = 255;
        cArray[246] = 255;
        cArray[247] = 255;
        cArray[248] = 255;
        cArray[249] = 255;
        cArray[250] = 255;
        cArray[251] = 255;
        cArray[252] = 255;
        cArray[253] = 255;
        cArray[254] = 255;
        cArray[255] = 255;
        decode = cArray;
        log = LoggerFactory.getLogger(Dcc4PcReporter.class);
    }

    public Dcc4PcReporter(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    void setPacket(int[] arraytemp, int dcc_addr_type, int dcc_addr, int cvNumber, int speed, int packetTypeCmd) {
        if (log.isDebugEnabled()) {
            log.debug("{} dcc_addr {} {} {}", new Object[]{this.getDisplayName(), dcc_addr, cvNumber, speed});
        }
        RailComPacket rc = new RailComPacket(arraytemp, dcc_addr_type, dcc_addr, cvNumber, speed);
        this.decodeRailComInfo(rc, packetTypeCmd);
        this.rcPacket[2] = this.rcPacket[1];
        this.rcPacket[1] = this.rcPacket[0];
        this.rcPacket[0] = rc;
        if (log.isDebugEnabled()) {
            log.debug("Packets Seen {} in error {}", (Object)packetseen, (Object)packetsinerror);
        }
    }

    void duplicatePacket(int dup) {
        switch (dup) {
            case 0: {
                break;
            }
            case 2: {
                RailComPacket temp = this.rcPacket[1];
                this.rcPacket[1] = this.rcPacket[0];
                this.rcPacket[0] = temp;
                break;
            }
            case 3: {
                RailComPacket temp = this.rcPacket[2];
                this.rcPacket[2] = this.rcPacket[1];
                this.rcPacket[1] = this.rcPacket[0];
                this.rcPacket[0] = temp;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRailComState(int ori) {
        if (this.state == ori) {
            return;
        }
        this.state = ori;
        if (ori == 4 || ori == 1) {
            Dcc4PcReporter dcc4PcReporter = this;
            synchronized (dcc4PcReporter) {
                this.addr = 0;
                this.address_part_1 = 256;
                this.address_part_2 = -1;
                this.addr_type = -1;
                this.actual_speed = -1;
                this.actual_load = -1;
                this.actual_temperature = -1;
                this.fuelLevel = -1;
                this.waterLevel = -1;
                this.location = -1;
                this.routing_no = -1;
            }
            this.cvNumber = -1;
            this.cvValues = new Hashtable();
            this.setReport(null);
        } else if (ori == 16 || ori == 32) {
            if (super.getCurrentReport() != null && super.getCurrentReport() instanceof RailCom) {
                ((RailCom)super.getCurrentReport()).setOrientation(this.state);
            }
            this.firePropertyChange("currentReport", null, null);
        }
    }

    public int getRailComState() {
        return this.state;
    }

    public String getReport() {
        if (super.getCurrentReport() != null && super.getCurrentReport() instanceof RailCom) {
            return ((RailCom)super.getCurrentReport()).getTagID();
        }
        if (this.getRailComState() < 16 || this.rcPacket[0] == null || this.rcPacket[0].getPacket() == null) {
            return "";
        }
        return "";
    }

    void setPacketLength(int i) {
        this.packetLength = i;
    }

    int getPacketLength() {
        return this.packetLength;
    }

    synchronized void decodeRailComInfo(RailComPacket rc, int packetTypeCmd) {
        if (log.isDebugEnabled()) {
            log.debug("{} {}", (Object)this.getDisplayName(), (Object)packetTypeCmd);
        }
        ++this.addressp1found;
        RailCom rcTag = null;
        if (log.isDebugEnabled()) {
            log.debug("{} {}", (Object)this.getDisplayName(), super.getCurrentReport());
        }
        if (super.getCurrentReport() instanceof RailCom) {
            rcTag = (RailCom)super.getCurrentReport();
        }
        int[] packet = rc.getPacket();
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < packet.length) {
                buf.append(packet[i]);
                ++i;
            }
            String s = buf.toString();
            log.debug("Rail Comm Packets {}", (Object)s);
        }
        int i = 0;
        while (i < packet.length) {
            ++packetseen;
            char chbyte = (char)packet[i];
            if ((chbyte = decode[chbyte]) == '\u00ff') {
                if (log.isDebugEnabled()) {
                    log.debug("{} Error packet stage 1: {}", (Object)this.getDisplayName(), (Object)Integer.toHexString(packet[i]));
                }
                ++packetsinerror;
                return;
            }
            ++i;
            if ((chbyte & 0x80) == 128) {
                chbyte = (char)packet[i];
                ++i;
                if ((chbyte = decode[chbyte]) == '\u00ff') {
                    if (log.isDebugEnabled()) {
                        log.debug("{} Error packet stage 2", (Object)this.getDisplayName());
                    }
                    ++packetsinerror;
                    return;
                }
                if ((chbyte & 0x80) == 128) {
                    if (packet.length <= i + 1) {
                        log.debug("No further data to process Only had the ack 1");
                        break;
                    }
                    chbyte = (char)packet[i];
                    ++i;
                    chbyte = decode[chbyte];
                }
            }
            if (packet.length <= i) break;
            char type = chbyte;
            chbyte = (char)packet[i];
            if ((chbyte = decode[chbyte]) == '\u00ff' || (chbyte & 0x80) == 128) {
                if (log.isDebugEnabled()) {
                    log.debug("{} Error packet stage 3 {}\n{}", new Object[]{this.getDisplayName(), Integer.toHexString(packet[i]), rc.toHexString()});
                }
                ++i;
                ++packetsinerror;
                return;
            }
            chbyte = (char)((type & 3) << 6 | chbyte & 0x3F);
            type = (char)(type >> 2 & 0xF);
            switch (type) {
                case '\u0000': {
                    if (log.isDebugEnabled()) {
                        log.debug("{} CV Value {}{}", new Object[]{this.getDisplayName(), (int)chbyte, rcTag});
                    }
                    this.cvvalue = chbyte;
                    if (rcTag == null) break;
                    rcTag.setWhereLastSeen(this);
                    if (rcTag.getExpectedCv() != -1) {
                        rcTag.setCvValue(chbyte);
                        break;
                    }
                    rcTag.setCV(rc.getCvNumber(), chbyte);
                    break;
                }
                case '\u0004': {
                    if (log.isDebugEnabled()) {
                        log.debug("{} Create/Get id tag for {}", (Object)this.getDisplayName(), (Object)rc.getDccAddress());
                    }
                    this.addr = rc.getDccAddress();
                    this.addr_type = rc.getAddressType();
                    break;
                }
                case '\u0001': {
                    if (log.isDebugEnabled()) {
                        log.debug("Address Byte 1");
                    }
                    this.address_part_1 = 0x100 | chbyte;
                    this.addressp1found = 0;
                    break;
                }
                case '\u0002': {
                    if (log.isDebugEnabled()) {
                        log.debug("{} Address part 2:", (Object)this.getDisplayName());
                    }
                    this.address_part_2 = chbyte;
                    if (packetTypeCmd == 3) {
                        log.debug("Type three packet so shouldn't not pair part one with part two if it came from the previous packet");
                    }
                    if ((this.address_part_1 & 0x100) != 256) {
                        log.debug("{} Break at Address part 1, part one not complete", (Object)this.getDisplayName());
                        break;
                    }
                    rcTag = this.decodeAddress();
                    break;
                }
                case '\u0003': {
                    if ((chbyte & 0x80) == 128) {
                        this.actual_speed = chbyte & 0x7F;
                        log.debug("{} Actual Speed: {}", (Object)this.getDisplayName(), (Object)this.actual_speed);
                    } else {
                        this.actual_load = chbyte & 0x7F;
                        log.debug("{} Actual Load: {}", (Object)this.getDisplayName(), (Object)this.actual_load);
                    }
                    if (rcTag == null) break;
                    rcTag.setActualLoad(this.actual_load);
                    rcTag.setActualSpeed(this.actual_speed);
                    rcTag.setWhereLastSeen(this);
                    break;
                }
                case '\u0005': {
                    this.routing_no = chbyte;
                    if (rcTag == null) break;
                    rcTag.setRoutingNo(this.routing_no);
                    rcTag.setWhereLastSeen(this);
                    break;
                }
                case '\u0006': {
                    this.location = chbyte;
                    if (rcTag == null) break;
                    rcTag.setLocation(this.location);
                    rcTag.setWhereLastSeen(this);
                    break;
                }
                case '\u0007': {
                    if ((chbyte & 0x80) == 128) {
                        this.fuelLevel = chbyte & 0x7F;
                    } else {
                        this.waterLevel = chbyte & 0x7F;
                    }
                    if (rcTag == null) break;
                    rcTag.setWaterLevel(this.waterLevel);
                    rcTag.setFuelLevel(this.fuelLevel);
                    rcTag.setWhereLastSeen(this);
                    break;
                }
                case '\b': {
                    if ((chbyte & 0x80) != 128) {
                        this.actual_temperature = chbyte & 0x7F;
                    }
                    if (rcTag == null) break;
                    rcTag.setActualTemperature(this.actual_temperature);
                    rcTag.setWhereLastSeen(this);
                    break;
                }
                case '\u000f': {
                    log.debug("{} CV Address and value:", (Object)this.getDisplayName());
                    i += 2;
                    break;
                }
                default: {
                    log.info("unknown railcom type packet {}", (Object)Character.valueOf(type));
                }
            }
            ++i;
        }
    }

    RailCom decodeAddress() {
        if (log.isDebugEnabled()) {
            log.debug("{} Create/Get id tag for {}", (Object)this.getDisplayName(), (Object)this.addr);
        }
        RailCom rcTag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + this.addr);
        if (this.fuelLevel != -1) {
            rcTag.setFuelLevel(this.fuelLevel);
        }
        if (this.waterLevel != -1) {
            rcTag.setWaterLevel(this.waterLevel);
        }
        if (this.routing_no != -1) {
            rcTag.setRoutingNo(this.routing_no);
        }
        if (this.location != -1) {
            rcTag.setLocation(this.location);
        }
        if (this.actual_temperature != -1) {
            rcTag.setActualTemperature(this.actual_temperature);
        }
        if (this.actual_load != -1) {
            rcTag.setActualLoad(this.actual_load);
        }
        if (this.actual_speed != -1) {
            rcTag.setActualSpeed(this.actual_speed);
        }
        for (Map.Entry<Integer, Integer> entry : this.cvValues.entrySet()) {
            rcTag.setCV(entry.getKey(), entry.getValue());
            if (this.cvvalue == -1) continue;
            rcTag.setCvValue(this.cvvalue);
        }
        this.address_part_1 = 0;
        this.address_part_2 = -1;
        this.notify(rcTag);
        return rcTag;
    }

    RailCom provideTag(int address, int addr_type) {
        log.debug("provide Tag");
        RailCom rcTag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + address);
        this.notify(rcTag);
        return rcTag;
    }

    static class RailComPacket {
        final transient int[] rcPacket;
        int dcc_addr_type;
        int dccAddress;
        int cvNumber;
        int speed;

        RailComPacket(int[] array, int dcc_addr_type, int dcc_addr, int cvNumber, int speed) {
            this.rcPacket = array;
            this.dcc_addr_type = dcc_addr_type;
            this.dccAddress = dcc_addr;
            this.cvNumber = cvNumber;
            this.speed = speed;
        }

        int[] getPacket() {
            return this.rcPacket;
        }

        int getAddressType() {
            return this.dcc_addr_type;
        }

        int getDccAddress() {
            return this.dccAddress;
        }

        int getCvNumber() {
            return this.cvNumber;
        }

        int getSpeed() {
            return this.speed;
        }

        String toHexString() {
            StringBuilder buf = new StringBuilder();
            buf.append("0x" + Integer.toHexString(0xFF & this.rcPacket[0]));
            int i = 1;
            while (i < this.rcPacket.length) {
                buf.append(", 0x" + Integer.toHexString(0xFF & this.rcPacket[i]));
                ++i;
            }
            return buf.toString();
        }
    }
}

