/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.InstanceManager;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.jmrix.AbstractProgrammer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcOpsModeProgrammer
extends AbstractProgrammer
implements PropertyChangeListener,
AddressedProgrammer {
    int pAddress = 0;
    boolean pLongAddress;
    int progState = 0;
    RailCom rcTag;
    int value;
    int cv;
    ProgListener progListener = null;
    protected static final int DCC4PC_PROGRAMMER_TIMEOUT = 2000;
    AddressedProgrammerManager defaultManager;
    Programmer defaultProgrammer;
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcOpsModeProgrammer.class);

    public Dcc4PcOpsModeProgrammer(boolean pLongAddress, int pAddress, AddressedProgrammerManager dp) {
        this.defaultManager = dp;
        this.defaultProgrammer = this.defaultManager.getAddressedProgrammer(pLongAddress, pAddress);
        this.pAddress = pAddress;
        this.pLongAddress = pLongAddress;
        this.rcTag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + pAddress);
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        this.rcTag.setExpectedCv(CV);
        this.progListener = p;
        this.defaultProgrammer.writeCV(CVname, val, new ProxyProgList());
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        this.rcTag.addPropertyChangeListener(this);
        this.rcTag.setExpectedCv(CV);
        this.progListener = p;
        this.cv = CV;
        this.startLongTimer();
        this.defaultProgrammer.readCV(CVname, new ProxyProgList());
        this.notifyProgListenerEnd(this.progListener, CV, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmCV(String cvName, int val, ProgListener p) throws ProgrammerException {
        int cvValue = Integer.parseInt(cvName);
        this.rcTag.addPropertyChangeListener(this);
        this.rcTag.setExpectedCv(cvValue);
        Dcc4PcOpsModeProgrammer dcc4PcOpsModeProgrammer = this;
        synchronized (dcc4PcOpsModeProgrammer) {
            this.progListener = p;
        }
        this.cv = cvValue;
        this.defaultProgrammer.confirmCV(cvName, val, new ProxyProgList());
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        return this.defaultProgrammer.getSupportedModes();
    }

    @Override
    protected synchronized void timeout() {
        this.rcTag.removePropertyChangeListener(this);
        this.rcTag.setExpectedCv(-1);
        this.notifyProgListenerEnd(this.progListener, 0, 128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() != this.rcTag) {
            log.error("Unexpected source");
        }
        if (e.getPropertyName().equals("cvvalue")) {
            int repliedCv = (Integer)e.getOldValue();
            log.info("{} {}", e.getOldValue(), e.getNewValue());
            if (repliedCv == this.cv) {
                int newValue = (Integer)e.getNewValue();
                this.stopTimer();
                this.rcTag.removePropertyChangeListener(this);
                Dcc4PcOpsModeProgrammer dcc4PcOpsModeProgrammer = this;
                synchronized (dcc4PcOpsModeProgrammer) {
                    this.notifyProgListenerEnd(this.progListener, newValue, 0);
                }
            } else {
                log.error("Unexpected cv {} returned, was expecting CV {}", (Object)repliedCv, (Object)this.cv);
            }
        }
    }

    @Override
    public boolean getLongAddress() {
        return this.pLongAddress;
    }

    @Override
    public int getAddressNumber() {
        return this.pAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    static class ProxyProgList
    implements ProgListener {
        ProxyProgList() {
        }

        @Override
        public void programmingOpReply(int value, int status) {
        }
    }
}

