/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import jmri.jmrix.AbstractMRMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcMessage
extends AbstractMRMessage {
    public static final int MAXSIZE = 515;
    boolean childBoard = false;
    boolean isResponse = false;
    int board = -1;
    int messageType = -1;
    static final int INFO = 0;
    static final int DESC = 1;
    static final int SERIAL = 2;
    static final int CHILDENABLEDINPUTS = 7;
    static final int CHILDRESET = 9;
    static final int CHILDPOLL = 10;
    static final int RESPONSE = 12;
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcMessage.class);

    public Dcc4PcMessage(int i) {
        if (i < 1) {
            log.error("invalid length in call to ctor");
        }
        this._nDataChars = i;
        this._dataChars = new int[i];
        this.setBinary(true);
        this.setRetries(3);
    }

    public Dcc4PcMessage(byte[] packet) {
        this(packet.length);
        int i = 0;
        this.setBinary(true);
        int j = 0;
        while (j < packet.length) {
            this.setElement(i, packet[i]);
            ++i;
            ++j;
        }
        this.setRetries(1);
    }

    public Dcc4PcMessage(String s) {
        this._nDataChars = s.length();
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = s.charAt(i);
            ++i;
        }
        this.setBinary(true);
        this.setRetries(3);
    }

    public Dcc4PcMessage(Dcc4PcMessage m) {
        if (m == null) {
            log.error("copy ctor of null message");
            return;
        }
        this._nDataChars = m._nDataChars;
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = m._dataChars[i];
            ++i;
        }
        this.setBinary(true);
        this.setRetries(1);
    }

    public void setForChildBoard(boolean boo) {
        this.childBoard = boo;
    }

    public boolean isForChildBoard() {
        return this.childBoard;
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("0x");
        buf.append(Integer.toHexString(0xFF & this._dataChars[0]));
        int i = 1;
        while (i < this._nDataChars) {
            buf.append(".0x");
            buf.append(Integer.toHexString(0xFF & this._dataChars[i]));
            ++i;
        }
        return buf.toString();
    }

    public byte[] getFormattedMessage() {
        int len = this.getNumDataElements();
        int cr = 0;
        byte[] msg = new byte[len + cr];
        int i = 0;
        while (i < len) {
            msg[i] = (byte)this.getElement(i);
            ++i;
        }
        return msg;
    }

    public static Dcc4PcMessage getProgMode() {
        Dcc4PcMessage m = new Dcc4PcMessage(1);
        return m;
    }

    public static Dcc4PcMessage getExitProgMode() {
        Dcc4PcMessage m = new Dcc4PcMessage(1);
        return m;
    }

    public boolean isGetResponse() {
        return this.isResponse;
    }

    public int getBoard() {
        return this.board;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public static Dcc4PcMessage getInfo(int address) {
        byte[] byArray = new byte[3];
        byArray[0] = 11;
        byArray[1] = (byte)address;
        Dcc4PcMessage m = new Dcc4PcMessage(byArray);
        m.childBoard = true;
        m.board = address;
        m.messageType = 0;
        m.setRetries(2);
        return m;
    }

    public static Dcc4PcMessage getDescription(int address) {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{11, (byte)address, 1});
        m.childBoard = true;
        m.board = address;
        m.messageType = 1;
        return m;
    }

    public static Dcc4PcMessage getSerialNumber(int address) {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{11, (byte)address, 2});
        m.childBoard = true;
        m.board = address;
        m.messageType = 2;
        return m;
    }

    public static Dcc4PcMessage resetBoardData(int address) {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{11, (byte)address, 9});
        m.childBoard = true;
        m.board = address;
        m.messageType = 9;
        return m;
    }

    public static Dcc4PcMessage pollBoard(int address) {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{11, (byte)address, 10});
        m.childBoard = true;
        m.setTimeout(500);
        m.board = address;
        m.messageType = 10;
        return m;
    }

    public static Dcc4PcMessage getEnabledInputs(int address) {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{11, (byte)address, 7});
        m.childBoard = true;
        m.board = address;
        m.messageType = 7;
        return m;
    }

    public static Dcc4PcMessage getInfo() {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[1]);
        m.messageType = 0;
        return m;
    }

    public static Dcc4PcMessage getResponse() {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{12});
        m.isResponse = true;
        m.messageType = 12;
        return m;
    }

    public static Dcc4PcMessage getDescription() {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{1});
        m.messageType = 1;
        return m;
    }

    public static Dcc4PcMessage getSerialNumber() {
        Dcc4PcMessage m = new Dcc4PcMessage(new byte[]{2});
        m.messageType = 2;
        return m;
    }
}

