/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import jmri.jmrix.dcc4pc.Dcc4PcListener;
import jmri.jmrix.dcc4pc.Dcc4PcMessage;
import jmri.jmrix.dcc4pc.Dcc4PcReply;
import jmri.jmrix.dcc4pc.Dcc4PcSensorManager;
import jmri.jmrix.dcc4pc.Dcc4PcTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcBoardManager
implements Dcc4PcListener {
    private static final int MINRC = 0;
    private static final int MAXRC = 4;
    ArrayList<Integer> boardsToDiscover = new ArrayList();
    Dcc4PcTrafficController tc;
    Dcc4PcSensorManager senManager;
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcBoardManager.class);

    public Dcc4PcBoardManager(Dcc4PcTrafficController tc, Dcc4PcSensorManager senManager) {
        this.tc = tc;
        this.senManager = senManager;
        int x = 0;
        while (x < 4) {
            this.addBoard(x);
            ++x;
        }
    }

    public void notifyReply(Dcc4PcReply m) {
    }

    public void notifyMessage(Dcc4PcMessage m) {
    }

    protected void addBoard(int newBoard) {
        if (!this.senManager.isBoardCreated(newBoard) && !this.boardsToDiscover.contains(newBoard)) {
            this.boardsToDiscover.add(newBoard);
            Dcc4PcMessage m = Dcc4PcMessage.getInfo(newBoard);
            m.setTimeout(1000);
            m.setRetries(2);
            this.tc.sendDcc4PcMessage(m, this);
        }
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="See issue #6132")
    public void reply(Dcc4PcReply r) {
        if (log.isDebugEnabled()) {
            log.debug("Reply details sm: {}", (Object)r.toHexString());
        }
        if (r.getBoard() == -1) {
            return;
        }
        if (r.getNumDataElements() == 0 && r.getElement(0) == 0) {
            return;
        }
        int board = r.getBoard();
        if (r.isError()) {
            this.boardsToDiscover.remove((Object)board);
        } else if (r.getMessageType() == 0) {
            log.debug("Get Info for board {}: {}", (Object)board, (Object)r.toString());
            int i = 0;
            StringBuilder buf = new StringBuilder();
            while (i < 4) {
                buf.append((char)r.getElement(i));
                ++i;
            }
            String str = buf.toString();
            if (str.equals("RCRD")) {
                str = String.valueOf(str) + " ver ";
                str = String.valueOf(str) + r.getElement(i += 2) + ".";
                String version = String.valueOf(r.getElement(i)) + "." + r.getElement(i + 1);
                str = String.valueOf(str) + r.getElement(++i) + ", Inputs : ";
                int inputs = r.getElement(++i);
                str = String.valueOf(str) + r.getElement(i) + ", Encoding : ";
                int encoding = r.getElement(++i);
                str = (r.getElement(i) & 1) == 1 ? String.valueOf(str) + "Supports Cooked RailCom Encoding" : String.valueOf(str) + "Supports Raw RailCom Encoding";
                this.senManager.addActiveBoard(board, version, inputs, encoding);
                Dcc4PcMessage m = Dcc4PcMessage.getDescription(board);
                m.setTimeout(2000);
                this.tc.sendDcc4PcMessage(m, this);
                this.boardsToDiscover.remove((Object)board);
            }
        } else if (r.getMessageType() == 1) {
            log.debug("Get Description for board {}: {}", (Object)board, (Object)r.toString());
            this.senManager.setBoardDescription(board, r.toString());
            Dcc4PcMessage m = Dcc4PcMessage.getEnabledInputs(board);
            m.setTimeout(2000);
            m.setRetries(2);
            log.debug(m.toString());
            this.tc.sendDcc4PcMessage(m, this);
        } else if (r.getMessageType() == 7) {
            log.debug("Make Sensors for board {}: {}", (Object)board, (Object)r.toString());
            this.senManager.createSensorsForBoard(r);
        }
    }

    @Override
    public void handleTimeout(Dcc4PcMessage m) {
        if (log.isDebugEnabled()) {
            log.debug("timeout received to our last message {}", (Object)m.toString());
        }
        log.debug("Timeout to message {} for board {}", (Object)m.toString(), (Object)m.getBoard());
    }

    @Override
    public void message(Dcc4PcMessage m) {
    }
}

