/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.configurexml;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.XmlAdapter;
import jmri.jmrit.symbolicprog.ProgDefault;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.JmrixConfigPane;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmrixConfigPaneXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(JmrixConfigPaneXml.class);

    @Override
    public Element store(Object o) {
        ConnectionConfig oprime = ((JmrixConfigPane)o).getCurrentObject();
        if (oprime == null) {
            return null;
        }
        String adapter = ConfigXmlManager.adapterName(oprime);
        log.debug("forward to {}", (Object)adapter);
        try {
            XmlAdapter x = (XmlAdapter)Class.forName(adapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return x.store(oprime);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public Element store(Object o, boolean shared) {
        return this.store(o);
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        boolean result = true;
        UIManager.LookAndFeelInfo[] plafs = UIManager.getInstalledLookAndFeels();
        Hashtable<String, String> installedLAFs = new Hashtable<String, String>(plafs.length);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = plafs;
        int n = plafs.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo plaf = lookAndFeelInfoArray[n2];
            installedLAFs.put(plaf.getName(), plaf.getClassName());
            ++n2;
        }
        String name = shared.getAttribute("LAFclass").getValue();
        String className = (String)installedLAFs.get(name);
        log.debug("GUI selection: {} class name: {}", (Object)name, (Object)className);
        if (className != null) {
            try {
                if (!className.equals(UIManager.getLookAndFeel().getClass().getName())) {
                    log.debug("set GUI to {},{}", (Object)name, (Object)className);
                    this.updateLookAndFeel(name, className);
                } else {
                    log.debug("skip updateLAF as already has className=={}", (Object)className);
                }
            }
            catch (Exception ex) {
                log.error("Exception while setting GUI look & feel: {}", (Throwable)ex);
                result = false;
            }
        }
        return result;
    }

    public void updateLookAndFeel(String name, String className) {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            String errMsg = "The " + name + " look-and-feel ";
            errMsg = e instanceof UnsupportedLookAndFeelException ? String.valueOf(errMsg) + "is not supported on this platform." : (e instanceof ClassNotFoundException ? String.valueOf(errMsg) + "could not be found." : String.valueOf(errMsg) + "could not be loaded.");
            log.error(errMsg);
        }
    }

    @Override
    public void load(Element element, Object o) {
        ProgDefault.setDefaultProgFile(element.getAttribute("defaultFile").getValue());
    }
}

