/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.configurexml;

import javax.annotation.Nonnull;
import jmri.jmrix.NetworkPortAdapter;
import jmri.jmrix.configurexml.AbstractConnectionConfigXml;
import jmri.jmrix.configurexml.Bundle;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetworkConnectionConfigXml
extends AbstractConnectionConfigXml {
    protected NetworkPortAdapter adapter;
    private static final Logger log = LoggerFactory.getLogger(AbstractNetworkConnectionConfigXml.class);

    protected void getInstance(Object object) {
        this.getInstance();
    }

    @Override
    public Element store(Object o) {
        this.getInstance(o);
        Element e = new Element("connection");
        this.storeCommon(e, this.adapter);
        if (this.adapter.getMdnsConfigure()) {
            if (this.adapter.getHostName() != null && !this.adapter.getHostName().equals("")) {
                e.setAttribute("address", this.adapter.getHostName());
            }
            e.setAttribute("mdnsConfigure", "true");
            if (this.adapter.getAdvertisementName() != null) {
                e.setAttribute("advertisementName", this.adapter.getAdvertisementName());
            }
            if (this.adapter.getServiceType() != null) {
                e.setAttribute("serviceType", this.adapter.getServiceType());
            }
        } else {
            e.setAttribute("mdnsConfigure", "false");
            if (this.adapter.getHostName() != null) {
                e.setAttribute("address", this.adapter.getHostName());
            } else {
                e.setAttribute("address", Bundle.getMessage("noneSelected"));
            }
            if (this.adapter.getPort() != 0) {
                e.setAttribute("port", "" + this.adapter.getPort());
            } else {
                e.setAttribute("port", Bundle.getMessage("noneSelected"));
            }
        }
        this.setOutputInterval(this.adapter, e);
        e.setAttribute("class", this.getClass().getName());
        this.extendElement(e);
        return e;
    }

    @Override
    protected void extendElement(Element e) {
    }

    @Override
    public boolean load(@Nonnull Element shared, Element perNode) {
        String hostName;
        boolean result = true;
        this.getInstance();
        boolean mdnsConfig = false;
        try {
            mdnsConfig = shared.getAttribute("mdnsConfigure").getValue().equals("true");
        }
        catch (NullPointerException nullPointerException) {}
        this.adapter.setMdnsConfigure(mdnsConfig);
        if (mdnsConfig) {
            try {
                hostName = shared.getAttribute("address").getValue();
                this.adapter.setHostName(hostName);
            }
            catch (NullPointerException nullPointerException) {}
            try {
                String serviceType = shared.getAttribute("serviceType").getValue();
                this.adapter.setServiceType(serviceType);
            }
            catch (NullPointerException nullPointerException) {}
            try {
                String advertisementName = shared.getAttribute("advertisementName").getValue();
                this.adapter.setAdvertisementName(advertisementName);
            }
            catch (NullPointerException nullPointerException) {}
            this.adapter.autoConfigure();
        } else {
            hostName = null;
            try {
                hostName = shared.getAttribute("address").getValue();
            }
            catch (NullPointerException nullPointerException) {}
            this.adapter.setHostName(hostName);
            try {
                int port = shared.getAttribute("port").getIntValue();
                this.adapter.setPort(port);
            }
            catch (DataConversionException dataConversionException) {
                log.warn("Could not parse port attribute: {}", (Object)shared.getAttribute("port"));
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.loadCommon(shared, perNode, this.adapter);
        this.register();
        if (this.adapter.getDisabled()) {
            this.unpackElement(shared, perNode);
            return result;
        }
        try {
            log.trace("start adapter.connect()");
            this.adapter.connect();
        }
        catch (Exception ex) {
            log.debug("Caught exception in adapter.connect", (Throwable)ex);
            this.handleException(ex.getMessage(), "opening connection", null, null, ex);
            return false;
        }
        log.trace("start adapter.configure()");
        this.adapter.configure();
        log.trace("start unpackElement");
        if (perNode.getAttribute("turnoutInterval") != null) {
            this.adapter.getSystemConnectionMemo().setOutputInterval(Integer.parseInt(perNode.getAttribute("turnoutInterval").getValue()));
        }
        this.unpackElement(shared, perNode);
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("method with two args invoked");
    }
}

