/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.serialdriver.configurexml;

import java.util.List;
import java.util.StringTokenizer;
import jmri.jmrix.AbstractSerialConnectionConfig;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import jmri.jmrix.cmri.serial.cmrinetmetrics.CMRInetMetricsCollector;
import jmri.jmrix.cmri.serial.serialdriver.ConnectionConfig;
import jmri.jmrix.cmri.serial.serialdriver.SerialDriverAdapter;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    CMRInetMetricsCollector metricsCollector;
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    protected void extendElement(Element e) {
        StringBuilder polllist = new StringBuilder("");
        SerialTrafficController tcPL = ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController();
        SerialNode plNode = (SerialNode)tcPL.getNode(0);
        int index = 1;
        while (plNode != null) {
            if (index != 1) {
                polllist.append(",");
            }
            polllist.append(Integer.toString(plNode.getNodeAddress()));
            plNode = (SerialNode)tcPL.getNode(index);
            ++index;
        }
        Element l = new Element("polllist");
        l.setAttribute("pollseq", polllist.toString());
        e.addContent((Content)l);
        SerialTrafficController tc = ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController();
        SerialNode node = (SerialNode)tc.getNode(0);
        index = 1;
        while (node != null) {
            Element n = new Element("node");
            n.setAttribute("name", Integer.toString(node.getNodeAddress()));
            e.addContent((Content)n);
            n.addContent((Content)this.makeParameter("nodetype", Integer.toString(node.getNodeType())));
            n.addContent((Content)this.makeParameter("bitspercard", Integer.toString(node.getNumBitsPerCard())));
            n.addContent((Content)this.makeParameter("transmissiondelay", Integer.toString(node.getTransmissionDelay())));
            n.addContent((Content)this.makeParameter("num2lsearchlights", Integer.toString(node.getNum2LSearchLights())));
            n.addContent((Content)this.makeParameter("pulsewidth", Integer.toString(node.getPulseWidth())));
            StringBuilder value = new StringBuilder();
            int i = 0;
            while (i < node.getLocSearchLightBits().length) {
                value.append(Integer.toHexString(node.getLocSearchLightBits()[i] & 0xF));
                ++i;
            }
            n.addContent((Content)this.makeParameter("locsearchlightbits", value.toString()));
            value = new StringBuilder();
            i = 0;
            while (i < node.getCardTypeLocation().length) {
                value.append(Integer.toHexString(node.getCardTypeLocation()[i] & 0xF));
                ++i;
            }
            n.addContent((Content)this.makeParameter("cardtypelocation", value.toString()));
            log.debug("Node {} Card Type Written = {}", (Object)node.nodeAddress, (Object)value);
            value = new StringBuilder("");
            i = 0;
            while (i < 16) {
                value.append(Integer.toHexString(node.getCMRInetOpts(i) & 0xF));
                ++i;
            }
            n.addContent((Content)this.makeParameter("cmrinetoptions", value.toString().toUpperCase()));
            log.debug("Node {} NET Options Written = {}", (Object)node.nodeAddress, (Object)value);
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                value = new StringBuilder();
                i = 0;
                while (i < 16) {
                    value.append(Integer.toHexString(node.getcpnodeOpts(i) & 0xF));
                    ++i;
                }
                n.addContent((Content)this.makeParameter("cpnodeoptions", value.toString().toUpperCase()));
                log.debug("Node {} NODE Options Written = {}", (Object)node.nodeAddress, (Object)value);
            }
            n.addContent((Content)this.makeParameter("cmrinodedesc", node.getcmriNodeDesc()));
            node = (SerialNode)tc.getNode(index);
            ++index;
        }
    }

    protected Element makeParameter(String name, String value) {
        Element p = new Element("parameter");
        p.setAttribute("name", name);
        p.addContent(value);
        return p;
    }

    @Override
    protected void getInstance() {
        if (this.adapter == null) {
            this.adapter = new SerialDriverAdapter();
        }
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((AbstractSerialConnectionConfig)object).getAdapter();
    }

    @Override
    protected void unpackElement(Element shared, Element perNode) {
        String pseq;
        Element ps;
        List pl = shared.getChildren("polllist");
        if (!pl.isEmpty() && (ps = (Element)pl.get(0)) != null && (pseq = ps.getAttributeValue("pollseq")) != null) {
            StringTokenizer nodes = new StringTokenizer(pseq, " ,");
            SerialTrafficController tcPL = ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController();
            while (nodes.hasMoreTokens()) {
                tcPL.cmriNetPollList.add(Integer.parseInt(nodes.nextToken()));
            }
            log.debug("Poll List = {}", tcPL.cmriNetPollList);
        }
        int pollListSize = ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().cmriNetPollList.size();
        int nextPollPos = pollListSize + 1;
        List l = shared.getChildren("node");
        int i = 0;
        while (i < l.size()) {
            int j;
            Element n = (Element)l.get(i);
            int addr = Integer.parseInt(n.getAttributeValue("name"));
            int type = Integer.parseInt(this.findParmValue(n, "nodetype"));
            int bpc = Integer.parseInt(this.findParmValue(n, "bitspercard"));
            int delay = Integer.parseInt(this.findParmValue(n, "transmissiondelay"));
            int num2l = Integer.parseInt(this.findParmValue(n, "num2lsearchlights"));
            int pulseWidth = 500;
            if (this.findParmValue(n, "pulsewidth") != null) {
                pulseWidth = Integer.parseInt(this.findParmValue(n, "pulsewidth"));
            }
            String slb = this.findParmValue(n, "locsearchlightbits");
            String ctl = this.findParmValue(n, "cardtypelocation");
            String opts = "";
            SerialNode node = new SerialNode(addr, type, ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController());
            node.setNumBitsPerCard(bpc);
            node.setTransmissionDelay(delay);
            node.setNum2LSearchLights(num2l);
            node.setPulseWidth(pulseWidth);
            boolean assigned = false;
            if (pollListSize > 0) {
                int pls = 0;
                while (pls < pollListSize) {
                    if (((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().cmriNetPollList.get(pls).intValue() == node.getNodeAddress()) {
                        node.setPollListPosition(pls + 1);
                        assigned = true;
                    }
                    ++pls;
                }
                if (!assigned) {
                    node.setPollListPosition(nextPollPos++);
                }
            }
            if (this.findParmValue(n, "cmrinetoptions") != null) {
                opts = this.findParmValue(n, "cmrinetoptions");
                j = 0;
                while (j < 16) {
                    node.setCMRInetOpts(j, opts.charAt(j) - 48);
                    ++j;
                }
                log.debug("Node {} NET Options Read = {}", (Object)node.nodeAddress, (Object)opts);
            } else {
                j = 0;
                while (j < 16) {
                    node.setCMRInetOpts(j, 0);
                    ++j;
                }
                node.setOptNet_AUTOPOLL(1);
                log.debug("Node {} AUTO POLL Set ", (Object)node.nodeAddress);
            }
            j = 0;
            while (j < slb.length()) {
                node.setLocSearchLightBits(j, slb.charAt(j) - 48);
                ++j;
            }
            j = 0;
            while (j < ctl.length()) {
                node.setCardTypeLocation(j, ctl.charAt(j) - 48);
                ++j;
            }
            if (type == 3 || type == 4) {
                if (this.findParmValue(n, "cpnodeoptions") != null) {
                    opts = this.findParmValue(n, "cpnodeoptions");
                    j = 0;
                    while (j < 16) {
                        node.setcpnodeOpts(j, opts.charAt(j) - 48);
                        ++j;
                    }
                }
                log.debug("Node {} NODE Options Read = {}", (Object)node.nodeAddress, (Object)opts);
            }
            if (this.findParmValue(n, "cmrinodedesc") != null) {
                node.setcmriNodeDesc(this.findParmValue(n, "cmrinodedesc"));
            } else {
                log.debug("No Description - Node {}", (Object)addr);
            }
            ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().initializeSerialNode(node);
            ++i;
        }
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

