/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.nodeconfigmanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.nodeconfigmanager.Bundle;
import jmri.jmrix.cmri.serial.nodeiolist.NodeIOListFrame;
import jmri.util.JmriJFrame;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfigManagerFrame
extends JmriJFrame {
    ArrayList<SerialNode> cmriNode = new ArrayList();
    public int numConfigNodes = 0;
    public int numBits = 48;
    public int numInputBits = 24;
    public int numOutputBits = 48;
    protected int selectedNodeAddr = -1;
    protected int selectedTableRow = -1;
    protected boolean doingPrint = false;
    JLabel nodeLabel = new JLabel(String.valueOf(Bundle.getMessage("NodeBoxLabel")) + " ");
    protected JPanel nodeTablePanel = null;
    protected Border inputBorder = BorderFactory.createEtchedBorder();
    protected NodeTableModel nodeTableModel = null;
    protected JTable nodeTable = null;
    JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
    JButton printButton = new JButton(Bundle.getMessage("PrintButtonText"));
    NodeConfigManagerFrame curFrame;
    protected JTextField nodeAddrField = new JTextField(3);
    protected JLabel nodeAddrStatic = new JLabel("000");
    protected JComboBox<String> nodeTypeBox;
    protected JTextField receiveDelayField = new JTextField(3);
    protected JTextField nodeDescription = new JTextField(32);
    protected JTextField pulseWidthField = new JTextField(4);
    protected JComboBox<String> cardSizeBox;
    protected JComboBox<String> cardSize8Box;
    protected JLabel cardSizeText = new JLabel("   " + Bundle.getMessage("LabelCardSize"));
    protected JLabel onBoardBytesText = new JLabel(String.valueOf(Bundle.getMessage("LabelOnBoardBytes")) + " 3 Input Bytes, 6 Output Bytes");
    protected JButton addNodeButton = new JButton(Bundle.getMessage("ButtonAdd"));
    protected JButton editNodeButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected JButton deleteNodeButton = new JButton(Bundle.getMessage("ButtonDelete"));
    protected JButton doneNodeButton = new JButton(Bundle.getMessage("ButtonDone"));
    protected JButton updateNodeButton = new JButton(Bundle.getMessage("ButtonUpdate"));
    protected JButton cancelNodeButton = new JButton(Bundle.getMessage("ButtonCancel"));
    protected JLabel statusText1 = new JLabel();
    protected JLabel statusText2 = new JLabel();
    protected JLabel statusText3 = new JLabel();
    protected JPanel panel2 = new JPanel();
    protected JPanel panel2a = new JPanel();
    protected JPanel panel2b = new JPanel();
    protected JPanel panel2c = new JPanel();
    protected JPanel panelnodeDescBox = new JPanel();
    protected JPanel panelnodeDesc = new JPanel();
    protected JPanel panelnetOpt = new JPanel();
    protected JPanel panelnetOptBox = new JPanel();
    protected JPanel panelnodeOpt = new JPanel();
    protected boolean changedNode = false;
    protected boolean editMode = false;
    protected SerialNode curNode = null;
    protected int nodeAddress = 0;
    protected int nodeType = 1;
    protected int bitsPerCard = 24;
    protected int receiveDelay = 0;
    protected int pulseWidth = 500;
    protected int num2LSearchLights = 0;
    protected int numCards = 0;
    protected int cpNodeOnboard = 4;
    protected int osNodeOnboard = 8;
    protected boolean errorInStatus1 = false;
    protected boolean errorInStatus2 = false;
    protected String editStatus1 = Bundle.getMessage("NotesEdit1");
    protected String editStatus2 = Bundle.getMessage("NotesEdit2");
    protected String editStatus3 = Bundle.getMessage("NotesEdit3");
    protected String addStatus1 = Bundle.getMessage("NotesAdd1");
    protected String addStatus2 = Bundle.getMessage("NotesAdd2");
    protected String addStatus3 = Bundle.getMessage("NotesAdd3");
    protected String delStatus1 = Bundle.getMessage("NotesDel1");
    protected String delStatus2 = Bundle.getMessage("NotesDel2");
    protected String delStatus3 = Bundle.getMessage("NotesDel3");
    protected String nodeDescText = "";
    protected int deleteNodeAddress = 0;
    HandlerClass nodeOptHandler = new HandlerClass();
    protected JCheckBox cbx_cmrinetopt_AUTOPOLL = new JCheckBox(Bundle.getMessage("cmrinetOpt0"), true);
    protected JCheckBox cbx_cmrinetopt_USECMRIX = new JCheckBox(Bundle.getMessage("cmrinetOpt1"));
    protected JCheckBox cbx_cmrinetopt_USEBCC = new JCheckBox(Bundle.getMessage("cmrinetOpt2"));
    protected JCheckBox cbx_cmrinetopt_BIT8 = new JCheckBox(Bundle.getMessage("cmrinetOpt8"));
    protected JCheckBox cbx_cmrinetopt_BIT15 = new JCheckBox(Bundle.getMessage("cmrinetOpt15"));
    protected JCheckBox cbx_cpnodeopt_SENDEOT = new JCheckBox(Bundle.getMessage("cpnodeOpt0"));
    protected JCheckBox cbx_cpnodeopt_BIT1 = new JCheckBox(Bundle.getMessage("cpnodeOpt1"));
    protected JCheckBox cbx_cpnodeopt_BIT2 = new JCheckBox(Bundle.getMessage("cpnodeOpt2"));
    protected JCheckBox cbx_cpnodeopt_BIT8 = new JCheckBox(Bundle.getMessage("cpnodeOpt8"));
    protected JCheckBox cbx_cpnodeopt_BIT15 = new JCheckBox(Bundle.getMessage("cpnodeOpt15"));
    private CMRISystemConnectionMemo _memo = null;
    private String[] nodeTableColumnsNames = new String[]{"Address", "   Type", "Bits per Card", "IN Cards", "OUT Cards", "IN Bits", "OUT Bits", " ", "  Description"};
    private String[] nodeTableTypes = new String[]{"--", "SMINI", "SUSIC", "CPNODE", "CPMEGA"};
    private final String[] cardConfigColumnNames = new String[]{Bundle.getMessage("HeadingCardAddress"), Bundle.getMessage("HeadingCardType")};
    private final String[] cardType = new String[64];
    private final String[] onBoardType = new String[16];
    private final String[] searchlightConfigColumnNames = new String[]{Bundle.getMessage("HeadingPort"), "0", "1", "2", "3", "4", "5", "6", "7"};
    private final boolean[] searchlightBits = new boolean[48];
    private final boolean[] firstSearchlight = new boolean[48];
    private final String[] cpnodeConfigColumnNames = new String[]{"Card", "IOX Addr Port", "Port Type"};
    private final String[] osnodeConfigColumnNames = new String[]{"  Byte ", "Port Type"};
    private final int[] cpnodeOpts = new int[16];
    private final int[] cmrinetOpts = new int[16];
    private static final Logger log = LoggerFactory.getLogger(NodeConfigManagerFrame.class);

    public NodeConfigManagerFrame(CMRISystemConnectionMemo memo) {
        this._memo = memo;
        this.curFrame = this;
        int i = 0;
        while (i < 64) {
            this.cardType[i] = Bundle.getMessage("CardTypeNone");
            ++i;
        }
        i = 0;
        while (i < 48) {
            this.searchlightBits[i] = false;
            this.firstSearchlight[i] = false;
            ++i;
        }
    }

    @Override
    public void initComponents() {
        this.setTitle(String.valueOf(Bundle.getMessage("WindowTitle")) + Bundle.getMessage("WindowConnectionMemo") + this._memo.getUserName());
        this.setSize(500, 150);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.initializeNodes();
        this.nodeTablePanel = new JPanel();
        this.nodeTablePanel.setLayout(new BoxLayout(this.nodeTablePanel, 1));
        this.nodeTableModel = new NodeTableModel();
        this.nodeTable = new JTable(this.nodeTableModel);
        this.nodeTable.setShowGrid(true);
        this.nodeTable.setGridColor(Color.black);
        this.nodeTable.setRowSelectionAllowed(false);
        this.nodeTable.setFont(new Font("Arial", 0, 14));
        this.nodeTable.setRowHeight(30);
        this.nodeTable.getTableHeader().setReorderingAllowed(false);
        this.nodeTable.setPreferredScrollableViewportSize(new Dimension(300, 350));
        TableColumnModel assignmentColumnModel = this.nodeTable.getColumnModel();
        DefaultTableCellRenderer dtcen = new DefaultTableCellRenderer();
        dtcen.setHorizontalAlignment(0);
        DefaultTableCellRenderer dtrt = new DefaultTableCellRenderer();
        dtrt.setHorizontalAlignment(4);
        TableCellRenderer rendererFromHeader = this.nodeTable.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)rendererFromHeader);
        headerLabel.setHorizontalAlignment(0);
        headerLabel.setBackground(Color.LIGHT_GRAY);
        TableColumn nodenumColumn = assignmentColumnModel.getColumn(0);
        nodenumColumn.setMinWidth(40);
        nodenumColumn.setMaxWidth(80);
        nodenumColumn.setCellRenderer(dtcen);
        nodenumColumn.setResizable(false);
        TableColumn nodetypeColumn = assignmentColumnModel.getColumn(1);
        nodetypeColumn.setMinWidth(40);
        nodetypeColumn.setMaxWidth(80);
        nodetypeColumn.setCellRenderer(dtcen);
        nodetypeColumn.setResizable(false);
        TableColumn numbitsColumn = assignmentColumnModel.getColumn(2);
        numbitsColumn.setMinWidth(40);
        numbitsColumn.setMaxWidth(120);
        numbitsColumn.setCellRenderer(dtcen);
        numbitsColumn.setResizable(false);
        TableColumn numinputsColumn = assignmentColumnModel.getColumn(3);
        numinputsColumn.setMinWidth(40);
        numinputsColumn.setMaxWidth(80);
        numinputsColumn.setCellRenderer(dtcen);
        numinputsColumn.setResizable(false);
        TableColumn numoutputsColumn = assignmentColumnModel.getColumn(4);
        numoutputsColumn.setMinWidth(10);
        numoutputsColumn.setMaxWidth(100);
        numoutputsColumn.setCellRenderer(dtcen);
        numoutputsColumn.setResizable(false);
        TableColumn numinbytesColumn = assignmentColumnModel.getColumn(5);
        numinbytesColumn.setMinWidth(10);
        numinbytesColumn.setMaxWidth(80);
        numinbytesColumn.setCellRenderer(dtcen);
        numinbytesColumn.setResizable(false);
        TableColumn numoutbytesColumn = assignmentColumnModel.getColumn(6);
        numoutbytesColumn.setMinWidth(10);
        numoutbytesColumn.setMaxWidth(100);
        numoutbytesColumn.setCellRenderer(dtcen);
        numoutbytesColumn.setResizable(false);
        TableColumn selectColumn = assignmentColumnModel.getColumn(7);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem(Bundle.getMessage("SelectSelect"));
        comboBox.addItem(Bundle.getMessage("SelectEdit"));
        comboBox.addItem(Bundle.getMessage("SelectInfo"));
        comboBox.addItem(Bundle.getMessage("SelectDelete"));
        selectColumn.setCellEditor(new DefaultCellEditor(comboBox));
        selectColumn.setMinWidth(40);
        selectColumn.setMaxWidth(90);
        selectColumn.setCellRenderer(dtcen);
        selectColumn.setResizable(false);
        TableColumn nodedescColumn = assignmentColumnModel.getColumn(8);
        nodedescColumn.setMinWidth(40);
        nodedescColumn.setMaxWidth(350);
        nodedescColumn.setResizable(true);
        JScrollPane nodeTableScrollPane = new JScrollPane(this.nodeTable);
        TitledBorder inputBorderTitled = BorderFactory.createTitledBorder(this.inputBorder, " ", 1, 1);
        this.nodeTablePanel.add((Component)nodeTableScrollPane, "Center");
        this.nodeTablePanel.setBorder(inputBorderTitled);
        this.setPreferredSize(new Dimension(950, 550));
        this.nodeTable.setAutoCreateRowSorter(true);
        this.nodeTable.getRowSorter().toggleSortOrder(0);
        contentPane.add(this.nodeTablePanel);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 2));
        panel3.setPreferredSize(new Dimension(950, 50));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("AddButtonTip"));
        this.addButton.addActionListener(e -> this.addButtonActionPerformed(e));
        panel3.add(this.addButton);
        this.printButton.setVisible(true);
        this.printButton.setToolTipText(Bundle.getMessage("PrintButtonTip"));
        if (this.numConfigNodes > 0) {
            this.printButton.addActionListener(e -> this.printButtonActionPerformed(e));
        }
        panel3.add(this.printButton);
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("DoneButtonTip"));
        this.doneButton.addActionListener(e -> this.doneButtonActionPerformed());
        panel3.add(this.doneButton);
        contentPane.add(panel3);
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.nodeconfigmanager.NodeConfigManagerFrame", true);
        this.pack();
        this.nodeTablePanel.setVisible(true);
    }

    public int getSelectedNodeAddr() {
        return (Integer)this.nodeTable.getValueAt(this.nodeTable.getSelectedRow(), 0);
    }

    public void doneButtonActionPerformed() {
        this.changedNode = false;
        this.setVisible(false);
        this.dispose();
    }

    public void addButtonActionPerformed(ActionEvent e) {
        NodeConfigManagerFrame f = new NodeConfigManagerFrame(this._memo);
        try {
            f.initNodeConfigWindow();
        }
        catch (Exception ex) {
            log.info("addButtonActionPerformed Exception-C2: {}", (Object)ex.toString());
        }
        f.nodeTableModel = this.nodeTableModel;
        f.initNodeVariables();
        f.buttonSet_ADD();
        f.setLocation(100, 100);
        f.setVisible(true);
    }

    public void printButtonActionPerformed(ActionEvent e) {
        int[] colWidth = new int[10];
        TableColumnModel nodeTableColumnModel = this.nodeTable.getColumnModel();
        colWidth[0] = nodeTableColumnModel.getColumn(0).getWidth();
        colWidth[1] = nodeTableColumnModel.getColumn(1).getWidth();
        colWidth[2] = nodeTableColumnModel.getColumn(2).getWidth();
        colWidth[3] = nodeTableColumnModel.getColumn(3).getWidth();
        colWidth[4] = nodeTableColumnModel.getColumn(4).getWidth();
        colWidth[5] = nodeTableColumnModel.getColumn(7).getWidth();
        colWidth[6] = nodeTableColumnModel.getColumn(2).getWidth();
        colWidth[7] = nodeTableColumnModel.getColumn(2).getWidth();
        colWidth[8] = nodeTableColumnModel.getColumn(2).getWidth();
        colWidth[9] = nodeTableColumnModel.getColumn(2).getWidth();
        String head = "CMRInet Node Table";
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(this.curFrame, head, 10, 0.8, 0.5, 0.5, 0.5, false);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            return;
        }
        writer.increaseLineSpacing(20);
        this.nodeTableModel.printTable(writer, colWidth);
    }

    public void editActionSelected() {
        this.selectedNodeAddr = this.getSelectedNodeAddr();
        NodeConfigManagerFrame f = new NodeConfigManagerFrame(this._memo);
        f.nodeTableModel = this.nodeTableModel;
        f.selectedTableRow = this.nodeTable.convertRowIndexToModel(this.nodeTable.getSelectedRow());
        try {
            f.initNodeConfigWindow();
            f.editNodeButtonActionPerformed(this.selectedNodeAddr);
        }
        catch (Exception ex) {
            log.info("editActionSelected", (Throwable)ex);
        }
        f.setLocation(200, 200);
        f.buttonSet_EDIT();
        f.setVisible(true);
    }

    public void deleteActionSelected() {
        this.selectedNodeAddr = this.getSelectedNodeAddr();
        NodeConfigManagerFrame f = new NodeConfigManagerFrame(this._memo);
        f.nodeTableModel = this.nodeTableModel;
        f.selectedTableRow = this.nodeTable.convertRowIndexToModel(this.nodeTable.getSelectedRow());
        try {
            f.initNodeConfigWindow();
            f.deleteNodeButtonActionPerformed(this.selectedNodeAddr);
        }
        catch (Exception ex) {
            log.info("deleteActionSelected", (Throwable)ex);
        }
        f.setLocation(200, 200);
        f.buttonSet_DELETE();
        f.setVisible(true);
    }

    public void infoActionSelected() {
        this.selectedNodeAddr = this.getSelectedNodeAddr();
        NodeIOListFrame f = new NodeIOListFrame(this._memo);
        try {
            f.initComponents();
            f.displayNodeIOBits(this.selectedNodeAddr);
        }
        catch (Exception ex) {
            log.info("infoActionSelected Exception-C2: {}", (Object)ex.toString());
        }
        f.setLocation(100, 100);
        f.setVisible(true);
    }

    public void initializeNodes() {
        if (!this.cmriNode.isEmpty()) {
            this.cmriNode.clear();
        }
        SerialNode node = (SerialNode)this._memo.getTrafficController().getNode(0);
        int index = 1;
        while (node != null) {
            this.cmriNode.add(node);
            node = (SerialNode)this._memo.getTrafficController().getNode(index);
            ++index;
        }
        this.numConfigNodes = this.cmriNode.size();
    }

    public void initNodeVariables() {
        int i = 0;
        while (i < 64) {
            this.cardType[i] = Bundle.getMessage("CardTypeNone");
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.onBoardType[i] = Bundle.getMessage("CardTypeNone");
            ++i;
        }
        i = 0;
        while (i < 48) {
            this.searchlightBits[i] = false;
            this.firstSearchlight[i] = false;
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.cmrinetOpts[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.cpnodeOpts[i] = 0;
            ++i;
        }
        this.nodeDescText = "";
    }

    public void initNodeConfigWindow() {
        this.setTitle(Bundle.getMessage("WindowTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout());
        panel11.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeAddress")) + " "));
        panel11.add(this.nodeAddrField);
        this.nodeAddrField.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        this.nodeAddrField.setText("-1");
        panel11.add(this.nodeAddrStatic);
        this.nodeAddrStatic.setVisible(false);
        panel11.add(new JLabel("   " + Bundle.getMessage("LabelNodeType") + " "));
        this.nodeTypeBox = new JComboBox();
        panel11.add(this.nodeTypeBox);
        this.nodeTypeBox.addItem("SMINI");
        this.nodeTypeBox.addItem("USIC_SUSIC");
        this.nodeTypeBox.addItem("CPNODE");
        this.nodeTypeBox.addItem("CPMEGA");
        this.nodeTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String s = (String)NodeConfigManagerFrame.this.nodeTypeBox.getSelectedItem();
                if (s.equals("SMINI")) {
                    NodeConfigManagerFrame.this.panel2.setVisible(false);
                    NodeConfigManagerFrame.this.panel2a.setVisible(true);
                    NodeConfigManagerFrame.this.panel2b.setVisible(false);
                    NodeConfigManagerFrame.this.panel2c.setVisible(false);
                    NodeConfigManagerFrame.this.cardSizeText.setVisible(false);
                    NodeConfigManagerFrame.this.cardSizeBox.setVisible(false);
                    NodeConfigManagerFrame.this.cardSize8Box.setVisible(false);
                    NodeConfigManagerFrame.this.panelnodeDescBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeDesc.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOpt.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOptBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeOpt.setVisible(false);
                    NodeConfigManagerFrame.this.nodeType = 1;
                    NodeConfigManagerFrame.this.onBoardBytesText.setText(String.valueOf(Bundle.getMessage("LabelOnBoardBytes")) + " 3 Input, 6 Output");
                } else if (s.equals("USIC_SUSIC")) {
                    NodeConfigManagerFrame.this.panel2.setVisible(true);
                    NodeConfigManagerFrame.this.panel2a.setVisible(false);
                    NodeConfigManagerFrame.this.panel2b.setVisible(false);
                    NodeConfigManagerFrame.this.panel2c.setVisible(false);
                    NodeConfigManagerFrame.this.cardSizeText.setVisible(true);
                    NodeConfigManagerFrame.this.cardSizeBox.setVisible(true);
                    NodeConfigManagerFrame.this.cardSize8Box.setVisible(false);
                    NodeConfigManagerFrame.this.panelnodeDescBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeDesc.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOpt.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOptBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeOpt.setVisible(false);
                    NodeConfigManagerFrame.this.nodeType = 2;
                    NodeConfigManagerFrame.this.onBoardBytesText.setText("  ");
                } else if (s.equals("CPNODE")) {
                    NodeConfigManagerFrame.this.panel2.setVisible(false);
                    NodeConfigManagerFrame.this.panel2a.setVisible(false);
                    NodeConfigManagerFrame.this.panel2b.setVisible(true);
                    NodeConfigManagerFrame.this.panel2c.setVisible(false);
                    NodeConfigManagerFrame.this.cardSizeText.setVisible(true);
                    NodeConfigManagerFrame.this.cardSizeBox.setVisible(false);
                    NodeConfigManagerFrame.this.cardSize8Box.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeDescBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeDesc.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOpt.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOptBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeOpt.setVisible(true);
                    NodeConfigManagerFrame.this.nodeType = 3;
                    NodeConfigManagerFrame.this.onBoardBytesText.setText(String.valueOf(Bundle.getMessage("LabelOnBoardBytes")) + " 2 Bytes");
                } else if (s.equals("CPMEGA")) {
                    NodeConfigManagerFrame.this.panel2.setVisible(false);
                    NodeConfigManagerFrame.this.panel2a.setVisible(false);
                    NodeConfigManagerFrame.this.panel2b.setVisible(true);
                    NodeConfigManagerFrame.this.panel2c.setVisible(true);
                    NodeConfigManagerFrame.this.cardSizeText.setVisible(true);
                    NodeConfigManagerFrame.this.cardSizeBox.setVisible(false);
                    NodeConfigManagerFrame.this.cardSize8Box.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeDescBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeDesc.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOpt.setVisible(true);
                    NodeConfigManagerFrame.this.panelnetOptBox.setVisible(true);
                    NodeConfigManagerFrame.this.panelnodeOpt.setVisible(true);
                    NodeConfigManagerFrame.this.nodeType = 4;
                    NodeConfigManagerFrame.this.onBoardBytesText.setText(String.valueOf(Bundle.getMessage("LabelOnBoardBytes")) + " 8 Bytes");
                }
                NodeConfigManagerFrame.this.resetNotes();
            }
        });
        this.nodeTypeBox.setToolTipText(Bundle.getMessage("TipNodeType"));
        JPanel panel12 = new JPanel();
        panel12.setLayout(new FlowLayout());
        panel12.add(new JLabel(String.valueOf(Bundle.getMessage("LabelDelay")) + " "));
        panel12.add(this.receiveDelayField);
        this.receiveDelayField.setToolTipText(Bundle.getMessage("TipDelay"));
        this.receiveDelayField.setText("0");
        panel12.add(this.cardSizeText);
        this.cardSizeBox = new JComboBox();
        this.cardSize8Box = new JComboBox();
        panel12.add(this.cardSizeBox);
        panel12.add(this.cardSize8Box);
        this.cardSizeBox.addItem(Bundle.getMessage("CardSize24"));
        this.cardSizeBox.addItem(Bundle.getMessage("CardSize32"));
        this.cardSize8Box.addItem(Bundle.getMessage("CardSize8"));
        this.cardSizeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String s = (String)NodeConfigManagerFrame.this.cardSizeBox.getSelectedItem();
                if (s.equals(Bundle.getMessage("CardSize24"))) {
                    NodeConfigManagerFrame.this.bitsPerCard = 24;
                } else if (s.equals(Bundle.getMessage("CardSize32"))) {
                    NodeConfigManagerFrame.this.bitsPerCard = 32;
                } else if (s.equals(Bundle.getMessage("CardSize8"))) {
                    NodeConfigManagerFrame.this.bitsPerCard = 8;
                }
            }
        });
        this.cardSizeBox.setToolTipText(Bundle.getMessage("TipCardSize"));
        this.cardSizeText.setVisible(false);
        this.cardSizeBox.setVisible(false);
        this.cardSize8Box.setVisible(false);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new FlowLayout());
        panel13.add(new JLabel(String.valueOf(Bundle.getMessage("LabelPulseWidth")) + " "));
        panel13.add(this.pulseWidthField);
        this.pulseWidthField.setToolTipText(Bundle.getMessage("TipPulseWidth"));
        this.pulseWidthField.setText("500");
        panel13.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
        JPanel panel14 = new JPanel();
        panel14.add(this.onBoardBytesText);
        panel14.setVisible(true);
        panel1.add(panel11);
        panel1.add(panel12);
        panel1.add(panel13);
        panel1.add(panel14);
        contentPane.add(panel1);
        JPanel panel21 = new JPanel();
        panel21.setLayout(new BoxLayout(panel21, 1));
        panel21.add(new JLabel(Bundle.getMessage("HintCardTypePartA")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartB")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartC")));
        panel21.add(new JLabel("   "));
        panel21.add(new JLabel(Bundle.getMessage("HintCardTypePartD")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartE")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartF")));
        this.panel2.add(panel21);
        CardConfigModel cardConfigModel = new CardConfigModel();
        JTable cardConfigTable = new JTable(cardConfigModel);
        cardConfigTable.setRowSelectionAllowed(false);
        cardConfigTable.setPreferredScrollableViewportSize(new Dimension(180, 95));
        JComboBox<String> cardTypeCombo = new JComboBox<String>();
        cardTypeCombo.addItem(Bundle.getMessage("CardTypeOutput"));
        cardTypeCombo.addItem(Bundle.getMessage("CardTypeInput"));
        cardTypeCombo.addItem(Bundle.getMessage("CardTypeNone"));
        TableColumnModel typeColumnModel = cardConfigTable.getColumnModel();
        TableColumn addressColumn = typeColumnModel.getColumn(0);
        addressColumn.setMinWidth(70);
        addressColumn.setMaxWidth(80);
        TableColumn cardTypeColumn = typeColumnModel.getColumn(1);
        cardTypeColumn.setCellEditor(new DefaultCellEditor(cardTypeCombo));
        cardTypeColumn.setResizable(false);
        cardTypeColumn.setMinWidth(90);
        cardTypeColumn.setMaxWidth(100);
        JScrollPane cardScrollPane = new JScrollPane(cardConfigTable);
        this.panel2.add((Component)cardScrollPane, "Center");
        contentPane.add(this.panel2);
        this.panel2.setVisible(false);
        JPanel panel2a1 = new JPanel();
        panel2a1.setLayout(new BoxLayout(panel2a1, 1));
        panel2a1.add(new JLabel(Bundle.getMessage("HintSearchlightPartA")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartB")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartC")));
        panel2a1.add(new JLabel("   "));
        panel2a1.add(new JLabel(Bundle.getMessage("HintSearchlightPartD")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartE")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartF")));
        this.panel2a.add(panel2a1);
        SearchlightConfigModel searchlightConfigModel = new SearchlightConfigModel();
        JTable searchlightConfigTable = new JTable(searchlightConfigModel);
        searchlightConfigTable.setRowSelectionAllowed(false);
        searchlightConfigTable.setPreferredScrollableViewportSize(new Dimension(208, 100));
        TableColumnModel searchlightColumnModel = searchlightConfigTable.getColumnModel();
        TableColumn portColumn = searchlightColumnModel.getColumn(0);
        portColumn.setMinWidth(90);
        portColumn.setMaxWidth(100);
        JScrollPane searchlightScrollPane = new JScrollPane(searchlightConfigTable);
        this.panel2a.add((Component)searchlightScrollPane, "Center");
        contentPane.add(this.panel2a);
        this.panel2.setVisible(false);
        JPanel panel2b3 = new JPanel();
        panel2b3.setLayout(new BoxLayout(panel2b3, 1));
        panel2b3.add(new JLabel("Assign Onboard Bytes"));
        this.panel2c.add(panel2b3);
        OSnodeConfigModel osnodeConfigModel = new OSnodeConfigModel();
        JTable osnodeConfigTable = new JTable(osnodeConfigModel);
        osnodeConfigTable.setRowSelectionAllowed(false);
        osnodeConfigTable.setPreferredScrollableViewportSize(new Dimension(170, 95));
        JComboBox<String> osnodeTypeCombo = new JComboBox<String>();
        osnodeTypeCombo.addItem(Bundle.getMessage("CardTypeOutput"));
        osnodeTypeCombo.addItem(Bundle.getMessage("CardTypeInput"));
        osnodeTypeCombo.addItem(Bundle.getMessage("CardTypeNone"));
        TableColumnModel osnodePortModel = osnodeConfigTable.getColumnModel();
        TableColumn x11Column = osnodePortModel.getColumn(0);
        x11Column.setMinWidth(50);
        x11Column.setMaxWidth(90);
        TableColumn x21Column = osnodePortModel.getColumn(1);
        x21Column.setCellEditor(new DefaultCellEditor(osnodeTypeCombo));
        x21Column.setResizable(false);
        x21Column.setMinWidth(80);
        x21Column.setMaxWidth(100);
        JScrollPane osnodeScrollPane = new JScrollPane(osnodeConfigTable);
        this.panel2c.add((Component)osnodeScrollPane, "Center");
        contentPane.add(this.panel2c);
        this.panel2.setVisible(false);
        JPanel panel2b1 = new JPanel();
        panel2b1.setLayout(new BoxLayout(panel2b1, 1));
        panel2b1.add(new JLabel("Assign IOX Ports"));
        this.panel2b.add(panel2b1);
        CPnodeConfigModel cpnodeConfigModel = new CPnodeConfigModel();
        JTable cpnodeConfigTable = new JTable(cpnodeConfigModel);
        cpnodeConfigTable.setRowSelectionAllowed(false);
        cpnodeConfigTable.setPreferredScrollableViewportSize(new Dimension(240, 130));
        JComboBox<String> cpnodeTypeCombo = new JComboBox<String>();
        cpnodeTypeCombo.addItem(Bundle.getMessage("CardTypeOutput"));
        cpnodeTypeCombo.addItem(Bundle.getMessage("CardTypeInput"));
        cpnodeTypeCombo.addItem(Bundle.getMessage("CardTypeNone"));
        TableColumnModel cpnodePortModel = cpnodeConfigTable.getColumnModel();
        TableColumn x0Column = cpnodePortModel.getColumn(0);
        x0Column.setMinWidth(30);
        x0Column.setMaxWidth(50);
        TableColumn x1Column = cpnodePortModel.getColumn(1);
        x1Column.setMinWidth(70);
        x1Column.setMaxWidth(120);
        TableColumn x2Column = cpnodePortModel.getColumn(2);
        x2Column.setCellEditor(new DefaultCellEditor(cpnodeTypeCombo));
        x2Column.setResizable(false);
        x2Column.setMinWidth(80);
        x2Column.setMaxWidth(100);
        JScrollPane cpnodeScrollPane = new JScrollPane(cpnodeConfigTable);
        this.panel2b.add((Component)cpnodeScrollPane, "Center");
        contentPane.add(this.panel2b);
        this.panel2b.setVisible(false);
        this.panelnodeDescBox.setLayout(new BoxLayout(this.panelnodeDescBox, 1));
        this.panelnodeDesc.setLayout(new FlowLayout());
        this.panelnodeDesc.add(new JLabel("Description:"));
        this.nodeDescription.setVisible(true);
        this.panelnodeDesc.add(this.nodeDescription);
        this.panelnodeDesc.setVisible(true);
        contentPane.add(this.panelnodeDesc);
        this.panelnetOpt.setLayout(new GridLayout(0, 2));
        this.panelnetOpt.add(this.cbx_cmrinetopt_AUTOPOLL);
        this.cbx_cmrinetopt_AUTOPOLL.addItemListener(this.nodeOptHandler);
        this.panelnetOpt.add(this.cbx_cmrinetopt_USECMRIX);
        this.cbx_cmrinetopt_USECMRIX.addItemListener(this.nodeOptHandler);
        this.cbx_cmrinetopt_USECMRIX.setVisible(false);
        this.panelnetOpt.add(this.cbx_cmrinetopt_USEBCC);
        this.cbx_cmrinetopt_USEBCC.addItemListener(this.nodeOptHandler);
        this.cbx_cmrinetopt_USEBCC.setVisible(false);
        this.panelnetOpt.add(this.cbx_cmrinetopt_BIT8);
        this.cbx_cmrinetopt_BIT8.addItemListener(this.nodeOptHandler);
        this.cbx_cmrinetopt_BIT8.setVisible(false);
        this.panelnetOpt.add(this.cbx_cmrinetopt_BIT15);
        this.cbx_cmrinetopt_BIT15.addItemListener(this.nodeOptHandler);
        this.cbx_cmrinetopt_BIT15.setVisible(false);
        Border panelnetOptBorder = BorderFactory.createEtchedBorder();
        TitledBorder panelnetOptTitled = BorderFactory.createTitledBorder(panelnetOptBorder, "CMRInet Options");
        this.panelnetOpt.setBorder(panelnetOptTitled);
        this.panelnetOpt.setVisible(true);
        contentPane.add(this.panelnetOpt);
        this.panelnetOptBox.add(Box.createHorizontalStrut(50));
        contentPane.add(this.panelnetOptBox);
        this.panelnodeOpt.setLayout(new GridLayout(0, 2));
        this.panelnodeOpt.add(this.cbx_cpnodeopt_SENDEOT);
        this.cbx_cpnodeopt_SENDEOT.addItemListener(this.nodeOptHandler);
        this.cbx_cpnodeopt_SENDEOT.setVisible(true);
        this.panelnodeOpt.add(this.cbx_cpnodeopt_BIT1);
        this.cbx_cpnodeopt_BIT1.addItemListener(this.nodeOptHandler);
        this.cbx_cpnodeopt_BIT1.setVisible(false);
        this.panelnodeOpt.add(this.cbx_cpnodeopt_BIT2);
        this.cbx_cpnodeopt_BIT2.addItemListener(this.nodeOptHandler);
        this.cbx_cpnodeopt_BIT2.setVisible(false);
        this.panelnodeOpt.add(this.cbx_cpnodeopt_BIT8);
        this.cbx_cpnodeopt_BIT8.addItemListener(this.nodeOptHandler);
        this.cbx_cpnodeopt_BIT8.setVisible(false);
        this.panelnodeOpt.add(this.cbx_cpnodeopt_BIT15);
        this.cbx_cpnodeopt_BIT15.addItemListener(this.nodeOptHandler);
        this.cbx_cpnodeopt_BIT15.setVisible(false);
        Border panelnodeOptBorder = BorderFactory.createEtchedBorder();
        TitledBorder panelnodeOptTitled = BorderFactory.createTitledBorder(panelnodeOptBorder, "cpNode Options");
        this.panelnodeOpt.setBorder(panelnodeOptTitled);
        this.panelnodeOpt.setVisible(false);
        contentPane.add(this.panelnodeOpt);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        this.statusText1.setVisible(false);
        panel31.add(this.statusText1);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new FlowLayout());
        this.statusText2.setVisible(false);
        panel32.add(this.statusText2);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout());
        this.statusText3.setVisible(false);
        panel33.add(this.statusText3);
        panel3.add(panel31);
        panel3.add(panel32);
        panel3.add(panel33);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("BoxLabelNotes"));
        panel3.setBorder(panel3Titled);
        contentPane.add(panel3);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addNodeButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addNodeButton.setVisible(false);
        this.addNodeButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addNodeButton.addActionListener(e -> this.addNodeButtonActionPerformed());
        panel4.add(this.addNodeButton);
        this.deleteNodeButton.setText(Bundle.getMessage("ButtonDelete"));
        this.deleteNodeButton.setVisible(false);
        this.deleteNodeButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        this.deleteNodeButton.addActionListener(e -> this.deleteNodeButtonActionConfirm());
        panel4.add(this.deleteNodeButton);
        this.updateNodeButton.setText(Bundle.getMessage("ButtonUpdate"));
        this.updateNodeButton.setVisible(false);
        this.updateNodeButton.setToolTipText(Bundle.getMessage("TipUpdateButton"));
        this.updateNodeButton.addActionListener(e -> this.updateNodeButtonActionPerformed());
        panel4.add(this.updateNodeButton);
        this.cancelNodeButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelNodeButton.setVisible(false);
        this.cancelNodeButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        this.cancelNodeButton.addActionListener(e -> this.cancelNodeButtonActionPerformed());
        panel4.add(this.cancelNodeButton);
        this.doneNodeButton.setText(Bundle.getMessage("ButtonDone"));
        this.doneNodeButton.setVisible(false);
        this.doneNodeButton.setToolTipText(Bundle.getMessage("TipDoneButton"));
        this.doneNodeButton.addActionListener(e -> this.doneNodeButtonActionPerformed());
        panel4.add(this.doneNodeButton);
        contentPane.add(panel4);
        this.pack();
    }

    public void buttonSet_ADD() {
        this.setTitle("ADD NODE");
        this.statusText1.setText(this.addStatus1);
        this.statusText1.setVisible(true);
        this.statusText2.setText(this.addStatus2);
        this.statusText2.setVisible(true);
        this.statusText3.setText(this.addStatus3);
        this.statusText3.setVisible(false);
        this.panel2c.setVisible(false);
        this.addNodeButton.setVisible(true);
        this.deleteNodeButton.setVisible(false);
        this.updateNodeButton.setVisible(false);
        this.doneNodeButton.setVisible(false);
        this.cancelNodeButton.setVisible(true);
    }

    public void buttonSet_EDIT() {
        this.setTitle("EDIT NODE");
        this.statusText1.setText(this.editStatus1);
        this.statusText1.setVisible(true);
        this.statusText2.setText(this.editStatus2);
        this.statusText2.setVisible(true);
        this.statusText3.setText(this.editStatus3);
        this.statusText3.setVisible(false);
        this.addNodeButton.setVisible(false);
        this.deleteNodeButton.setVisible(false);
        this.updateNodeButton.setVisible(true);
        this.doneNodeButton.setVisible(false);
        this.cancelNodeButton.setVisible(true);
    }

    public void buttonSet_DELETE() {
        this.setTitle("DELETE NODE");
        this.statusText1.setText(this.delStatus1);
        this.statusText1.setVisible(true);
        this.statusText2.setText(this.delStatus2);
        this.statusText2.setVisible(true);
        this.statusText3.setText(this.delStatus3);
        this.statusText3.setVisible(false);
        this.addNodeButton.setVisible(false);
        this.deleteNodeButton.setVisible(true);
        this.updateNodeButton.setVisible(false);
        this.doneNodeButton.setVisible(false);
        this.cancelNodeButton.setVisible(true);
    }

    public void addNodeButtonActionPerformed() {
        this.curNode = null;
        int nodeAddress = this.readNodeAddress();
        if (nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode != null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error1", Integer.toString(nodeAddress)), "", 0);
            this.statusText1.setText(Bundle.getMessage("Error1", Integer.toString(nodeAddress)));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (!this.readReceiveDelay()) {
            return;
        }
        if (!this.readPulseWidth()) {
            return;
        }
        if (!this.checkConsistency()) {
            return;
        }
        this.curNode = new SerialNode(nodeAddress, this.nodeType, this._memo.getTrafficController());
        this.nodeTableModel.addRow(this.curNode);
        this.setNodeParameters();
        if (this._memo.getSensorManager() != null) {
            this._memo.getSensorManager().registerSensorsForNode(this.curNode);
        }
        this.resetNotes();
        this.changedNode = true;
        log.info("changedNode = {}", (Object)this.changedNode);
        this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackAdd")) + " " + Integer.toString(nodeAddress));
        this.statusText2.setVisible(false);
        this.statusText3.setVisible(true);
        this.doneNodeButton.setVisible(true);
        this.cancelNodeButton.setVisible(false);
        this.errorInStatus1 = true;
    }

    public void setupNodeInformationWindow(int nodeaddr) {
        int i;
        this.nodeAddress = nodeaddr;
        if (this.nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(this.nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        this.nodeAddrStatic.setText(Integer.toString(this.nodeAddress));
        this.nodeAddrField.setVisible(false);
        this.nodeAddrStatic.setVisible(true);
        this.nodeType = this.curNode.getNodeType();
        switch (this.nodeType) {
            case 1: {
                this.nodeTypeBox.setSelectedItem("SMINI");
                this.bitsPerCard = 24;
                this.cardSizeBox.setSelectedItem(Bundle.getMessage("CardSize24"));
                this.onBoardBytesText.setText(String.valueOf(Bundle.getMessage("LabelOnBoardBytes")) + " 3 Input Bytes, 6 Output Bytes");
                this.num2LSearchLights = 0;
                i = 0;
                while (i < 48) {
                    if (this.curNode.isSearchLightBit(i)) {
                        this.searchlightBits[i] = true;
                        this.searchlightBits[i + 1] = true;
                        this.firstSearchlight[i] = true;
                        this.firstSearchlight[i + 1] = false;
                        ++this.num2LSearchLights;
                        ++i;
                    } else {
                        this.searchlightBits[i] = false;
                        this.firstSearchlight[i] = false;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                this.nodeTypeBox.setSelectedItem("USIC_SUSIC");
                this.bitsPerCard = this.curNode.getNumBitsPerCard();
                if (this.bitsPerCard == 24) {
                    this.cardSizeBox.setSelectedItem(Bundle.getMessage("CardSize24"));
                }
                if (this.bitsPerCard == 32) {
                    this.cardSizeBox.setSelectedItem(Bundle.getMessage("CardSize32"));
                }
                this.onBoardBytesText.setText("  ");
                break;
            }
            case 3: {
                this.nodeTypeBox.setSelectedItem("CPNODE");
                this.bitsPerCard = 8;
                this.cardSize8Box.setSelectedItem(Bundle.getMessage("CardSize8"));
                this.onBoardBytesText.setText(String.valueOf(Bundle.getMessage("LabelOnBoardBytes")) + " 2 Bytes");
                this.cbx_cpnodeopt_SENDEOT.setSelected(this.curNode.iscpnodeBit(1));
                this.cbx_cpnodeopt_BIT1.setSelected(false);
                this.cbx_cpnodeopt_BIT2.setSelected(false);
                this.cbx_cpnodeopt_BIT8.setSelected(this.curNode.iscpnodeBit(8));
                this.cbx_cpnodeopt_BIT15.setSelected(this.curNode.iscpnodeBit(15));
                break;
            }
            case 4: {
                this.nodeTypeBox.setSelectedItem("CPMEGA");
                this.bitsPerCard = 8;
                this.cardSize8Box.setSelectedItem(Bundle.getMessage("CardSize8"));
                this.onBoardBytesText.setText(String.valueOf(Bundle.getMessage("LabelOnBoardBytes")) + " 8 Bytes");
                this.cbx_cpnodeopt_SENDEOT.setSelected(this.curNode.iscpnodeBit(1));
                this.cbx_cpnodeopt_BIT1.setSelected(false);
                this.cbx_cpnodeopt_BIT2.setSelected(false);
                this.cbx_cpnodeopt_BIT8.setSelected(this.curNode.iscpnodeBit(8));
                this.cbx_cpnodeopt_BIT15.setSelected(this.curNode.iscpnodeBit(15));
                break;
            }
            default: {
                log.error("Unknown Node Type {}", (Object)this.nodeType);
            }
        }
        this.cbx_cmrinetopt_AUTOPOLL.setSelected(this.curNode.isCMRInetBit(0));
        this.cbx_cmrinetopt_USECMRIX.setSelected(this.curNode.isCMRInetBit(1));
        this.cbx_cmrinetopt_USEBCC.setSelected(this.curNode.isCMRInetBit(2));
        this.cbx_cmrinetopt_BIT8.setSelected(this.curNode.isCMRInetBit(8));
        this.cbx_cmrinetopt_BIT15.setSelected(this.curNode.isCMRInetBit(15));
        this.receiveDelay = this.curNode.getTransmissionDelay();
        this.receiveDelayField.setText(Integer.toString(this.receiveDelay));
        this.pulseWidth = this.curNode.getPulseWidth();
        this.pulseWidthField.setText(Integer.toString(this.pulseWidth));
        this.nodeDescText = this.curNode.getcmriNodeDesc();
        this.nodeDescription.setText(this.nodeDescText);
        i = 0;
        while (i < 64) {
            this.cardType[i] = this.curNode.isOutputCard(i) ? Bundle.getMessage("CardTypeOutput") : (this.curNode.isInputCard(i) ? Bundle.getMessage("CardTypeInput") : Bundle.getMessage("CardTypeNone"));
            ++i;
        }
        if (this.nodeType == 4) {
            i = 0;
            while (i < 8) {
                this.onBoardType[i] = this.curNode.isOutputCard(i) ? Bundle.getMessage("CardTypeOutput") : (this.curNode.isInputCard(i) ? Bundle.getMessage("CardTypeInput") : Bundle.getMessage("CardTypeNone"));
                ++i;
            }
        }
        this.panel2.setVisible(false);
        this.panel2a.setVisible(false);
        if (this.nodeType == 2) {
            this.panel2.setVisible(true);
        } else if (this.nodeType == 1) {
            this.panel2a.setVisible(true);
        } else if (this.nodeType == 3) {
            this.panel2c.setVisible(false);
            this.panel2b.setVisible(true);
        } else if (this.nodeType == 4) {
            this.panel2c.setVisible(true);
            this.panel2b.setVisible(false);
        }
    }

    public void editNodeButtonActionPerformed(int nodeaddr) {
        this.nodeAddress = nodeaddr;
        if (this.nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(this.nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        this.setupNodeInformationWindow(this.nodeAddress);
        this.editMode = true;
        this.statusText1.setText(this.editStatus1);
        this.statusText1.setVisible(true);
        this.statusText2.setText(this.editStatus2);
        this.statusText2.setVisible(true);
        this.statusText3.setText(this.editStatus3);
        this.statusText3.setVisible(true);
    }

    public void updateNodeButtonActionPerformed() {
        if (!this.readReceiveDelay()) {
            return;
        }
        if (!this.readPulseWidth()) {
            return;
        }
        if (!this.checkConsistency()) {
            return;
        }
        if (this.curNode.getNodeType() != this.nodeType) {
            this.curNode.setNodeType(this.nodeType);
        }
        this.curNode.setcmriNodeDesc(this.nodeDescription.getText());
        this.setNodeParameters();
        this.nodeTableModel.changeRow(this.selectedTableRow, this.curNode);
        this.changedNode = true;
        this.doneNodeButton.setVisible(true);
        this.updateNodeButton.setVisible(true);
        this.cancelNodeButton.setVisible(true);
        this.nodeAddrField.setVisible(false);
        this.nodeAddrStatic.setVisible(true);
        this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackUpdate")) + " " + Integer.toString(this.nodeAddress));
        this.statusText2.setVisible(false);
        this.cancelNodeButton.setVisible(false);
        this.errorInStatus1 = true;
    }

    public void deleteNodeButtonActionConfirm() {
        if (JOptionPane.showConfirmDialog(this, String.valueOf(Bundle.getMessage("ConfirmDelete1")) + "\n" + Bundle.getMessage("ConfirmDelete2"), Bundle.getMessage("ConfirmDeleteTitle"), 2, 2) == 0) {
            this._memo.getTrafficController().deleteNode(this.deleteNodeAddress);
            this.nodeTableModel.removeRow(this.selectedTableRow);
            this.initializeNodes();
            this.resetNotes();
            this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackDelete")) + " " + Integer.toString(this.deleteNodeAddress));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.changedNode = true;
            this.deleteNodeButton.setVisible(false);
            this.doneNodeButton.setVisible(true);
            this.cancelNodeButton.setVisible(false);
            this.statusText2.setVisible(false);
        } else {
            this.resetNotes();
        }
    }

    public void deleteNodeButtonActionPerformed(int nodeAddr) {
        this.nodeAddress = nodeAddr;
        this.nodeAddrStatic.setText(Integer.toString(this.nodeAddress));
        this.nodeAddrField.setVisible(false);
        this.nodeAddrStatic.setVisible(true);
        if (this.nodeAddress < 0) {
            log.info("nodeAddress < 0");
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(this.nodeAddress);
        this.deleteNodeAddress = nodeAddr;
        this.setupNodeInformationWindow(this.nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
        } else {
            this.statusText1.setText(Bundle.getMessage("NotesDel3"));
            this.statusText1.setVisible(true);
        }
    }

    public void doneNodeButtonActionPerformed() {
        if (this.editMode) {
            this.editMode = false;
            this.curNode = null;
            this.addNodeButton.setVisible(false);
            this.editNodeButton.setVisible(false);
            this.deleteNodeButton.setVisible(false);
            this.doneNodeButton.setVisible(true);
            this.updateNodeButton.setVisible(false);
            this.cancelNodeButton.setVisible(false);
            this.nodeAddrField.setVisible(false);
            this.nodeAddrStatic.setVisible(false);
        }
        if (this.changedNode) {
            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("Reminder1")) + "\n" + Bundle.getMessage("Reminder2"), Bundle.getMessage("ReminderTitle"), 1);
        }
        this.changedNode = false;
        this.setVisible(false);
        this.dispose();
    }

    public void cancelNodeButtonActionPerformed() {
        this.editMode = false;
        this.changedNode = false;
        this.curNode = null;
        this.addNodeButton.setVisible(false);
        this.editNodeButton.setVisible(false);
        this.deleteNodeButton.setVisible(false);
        this.doneNodeButton.setVisible(false);
        this.updateNodeButton.setVisible(false);
        this.cancelNodeButton.setVisible(false);
        this.nodeAddrField.setVisible(false);
        this.nodeAddrStatic.setVisible(false);
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.doneNodeButtonActionPerformed();
        super.windowClosing(e);
    }

    void setNodeParameters() {
        int numInput = 0;
        int numOutput = 0;
        this.curNode.setTransmissionDelay(this.receiveDelay);
        this.curNode.setPulseWidth(this.pulseWidth);
        switch (this.nodeType) {
            case 1: {
                int numSet = 0;
                int j = 0;
                while (j < 47) {
                    if (this.curNode.isSearchLightBit(j)) {
                        if (!this.firstSearchlight[j]) {
                            this.curNode.clear2LeadSearchLight(j);
                            ++j;
                        } else {
                            ++j;
                        }
                    }
                    ++j;
                }
                int i = 0;
                while (i < 47) {
                    if (this.firstSearchlight[i]) {
                        if (!this.curNode.isSearchLightBit(i)) {
                            this.curNode.set2LeadSearchLight(i);
                        }
                        ++numSet;
                    }
                    ++i;
                }
                if (numSet != this.num2LSearchLights) {
                    log.error("Inconsistent numbers of 2-lead searchlights. numSet = {}, num2LSearchLights = {}", (Object)Integer.toString(numSet), (Object)Integer.toString(this.num2LSearchLights));
                }
                this.curNode.setOptNet_AUTOPOLL(1);
                break;
            }
            case 2: {
                this.curNode.setNumBitsPerCard(this.bitsPerCard);
                numInput = 0;
                numOutput = 0;
                int i = 0;
                while (i < 64) {
                    if ("No Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 0);
                    } else if ("Input Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 1);
                        ++numInput;
                    } else if ("Output Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 2);
                        ++numOutput;
                    } else {
                        log.error("Unexpected card type - {}", (Object)this.cardType[i]);
                    }
                    ++i;
                }
                if (this.numCards != numOutput + numInput) {
                    log.error("Inconsistent numbers of cards - setNodeParameters.");
                }
                this.curNode.setOptNet_AUTOPOLL(1);
                break;
            }
            case 3: {
                this.bitsPerCard = 8;
                this.curNode.setNumBitsPerCard(this.bitsPerCard);
                numInput = 2;
                numOutput = 2;
                int i = 4;
                while (i < 64) {
                    if ("No Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 0);
                    } else if ("Input Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 1);
                        ++numInput;
                    } else if ("Output Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 2);
                        ++numOutput;
                    } else {
                        log.error("Unexpected card type - {}", (Object)this.cardType[i]);
                    }
                    ++i;
                }
                this.curNode.setOptNet_AUTOPOLL(this.cbx_cmrinetopt_AUTOPOLL.isSelected() ? 1 : 0);
                this.curNode.setOptNode_SENDEOT(this.cbx_cpnodeopt_SENDEOT.isSelected() ? 1 : 0);
                this.curNode.setOptNode_USECMRIX(this.cbx_cmrinetopt_USECMRIX.isSelected() ? 1 : 0);
                this.curNode.setOptNode_USEBCC(this.cbx_cmrinetopt_USEBCC.isSelected() ? 1 : 0);
                this.curNode.setOptNode_BIT8(this.cbx_cpnodeopt_BIT8.isSelected() ? 1 : 0);
                this.curNode.setOptNode_BIT15(this.cbx_cpnodeopt_BIT15.isSelected() ? 1 : 0);
                break;
            }
            case 4: {
                this.bitsPerCard = 8;
                this.curNode.setNumBitsPerCard(this.bitsPerCard);
                numInput = 0;
                numOutput = 0;
                int i = 0;
                while (i < 8) {
                    if ("No Card".equals(this.onBoardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 0);
                    } else if ("Input Card".equals(this.onBoardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 1);
                        ++numInput;
                    } else if ("Output Card".equals(this.onBoardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 2);
                        ++numOutput;
                    } else {
                        log.error("Unexpected card type - {}", (Object)this.onBoardType[i]);
                    }
                    ++i;
                }
                i = 8;
                while (i < 64) {
                    if ("No Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 0);
                    } else if ("Input Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 1);
                        ++numInput;
                    } else if ("Output Card".equals(this.cardType[i])) {
                        this.curNode.setCardTypeByAddress(i, 2);
                        ++numOutput;
                    } else {
                        log.error("Unexpected card type - {}", (Object)this.cardType[i]);
                    }
                    ++i;
                }
                this.curNode.setOptNet_AUTOPOLL(1);
                this.curNode.setOptNode_SENDEOT(this.cbx_cpnodeopt_SENDEOT.isSelected() ? 1 : 0);
                this.curNode.setOptNode_USECMRIX(this.cbx_cmrinetopt_USECMRIX.isSelected() ? 1 : 0);
                this.curNode.setOptNode_USEBCC(this.cbx_cmrinetopt_USEBCC.isSelected() ? 1 : 0);
                this.curNode.setOptNode_BIT8(this.cbx_cpnodeopt_BIT8.isSelected() ? 1 : 0);
                this.curNode.setOptNode_BIT15(this.cbx_cpnodeopt_BIT15.isSelected() ? 1 : 0);
                break;
            }
            default: {
                log.error("Unexpected node type in setNodeParameters- {}", (Object)Integer.toString(this.nodeType));
            }
        }
        this.curNode.setcmriNodeDesc(this.nodeDescription.getText());
        this._memo.getTrafficController().initializeSerialNode(this.curNode);
    }

    private void resetNotes() {
        if (this.errorInStatus1) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus1);
            }
            this.errorInStatus1 = false;
        }
        this.resetNotes2();
    }

    private void resetNotes2() {
        if (this.errorInStatus2) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus2);
            }
            this.errorInStatus2 = false;
        }
    }

    private int readNodeAddress() {
        int addr = -1;
        try {
            addr = Integer.parseInt(this.nodeAddrField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.statusText1.setText(Bundle.getMessage("Error5"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return -1;
        }
        if (addr < 0 || addr > 127) {
            this.errorInStatus1 = true;
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error6"), "", 0);
            this.resetNotes2();
            return -1;
        }
        return addr;
    }

    protected boolean readReceiveDelay() {
        try {
            this.receiveDelay = Integer.parseInt(this.receiveDelayField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.statusText1.setText(Bundle.getMessage("Error7"));
            this.statusText1.setVisible(true);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error7"), "", 0);
            this.receiveDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.receiveDelay < 0) {
            this.statusText1.setText(Bundle.getMessage("Error8"));
            this.statusText1.setVisible(true);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error8"), "", 0);
            this.receiveDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.receiveDelay > 65535) {
            this.statusText1.setText(Bundle.getMessage("Error9"));
            this.statusText1.setVisible(true);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error9"), "", 0);
            this.receiveDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }

    protected boolean readPulseWidth() {
        try {
            this.pulseWidth = Integer.parseInt(this.pulseWidthField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.statusText1.setText(Bundle.getMessage("Error18"));
            this.statusText1.setVisible(true);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error18"), "", 0);
            this.pulseWidth = 500;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.pulseWidth < 100) {
            this.statusText1.setText(Bundle.getMessage("Error16"));
            this.statusText1.setVisible(true);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error16"), "", 0);
            this.pulseWidth = 100;
            this.pulseWidthField.setText(Integer.toString(this.pulseWidth));
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.pulseWidth > 10000) {
            this.statusText1.setText(Bundle.getMessage("Error17"));
            this.statusText1.setVisible(true);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error17"), "", 0);
            this.pulseWidth = 500;
            this.pulseWidthField.setText(Integer.toString(this.pulseWidth));
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }

    protected boolean checkConsistency() {
        switch (this.nodeType) {
            case 1: {
                int numBits = 0;
                int i = 0;
                while (i < 48) {
                    if (this.searchlightBits[i]) {
                        ++numBits;
                    }
                    ++i;
                }
                if (2 * this.num2LSearchLights == numBits) break;
                this.statusText1.setText(Bundle.getMessage("Error10"));
                this.statusText1.setVisible(true);
                JOptionPane.showMessageDialog(this, Bundle.getMessage("Error10"), "", 0);
                this.errorInStatus1 = true;
                this.resetNotes2();
                return false;
            }
            case 2: {
                int numInput;
                int numOutput;
                this.numCards = 0;
                boolean atNoCard = false;
                int i = 0;
                while (i < 64) {
                    if (this.cardType[i].equals(Bundle.getMessage("CardTypeOutput")) || this.cardType[i].equals(Bundle.getMessage("CardTypeInput"))) {
                        if (atNoCard) {
                            this.statusText1.setText(Bundle.getMessage("Error11"));
                            this.statusText1.setVisible(true);
                            this.statusText2.setText(Bundle.getMessage("Error12"));
                            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("Error11")) + Bundle.getMessage("Error12"), "", 0);
                            this.errorInStatus1 = true;
                            this.errorInStatus2 = true;
                            return false;
                        }
                        ++this.numCards;
                    } else if (this.cardType[i].equals(Bundle.getMessage("CardTypeNone"))) {
                        atNoCard = true;
                    }
                    ++i;
                }
                if (this.numCards <= 0) {
                    this.statusText1.setText(Bundle.getMessage("Error13"));
                    this.statusText2.setText(Bundle.getMessage("Error14"));
                    this.statusText1.setVisible(true);
                    JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("Error13")) + Bundle.getMessage("Error14"), "", 0);
                    this.errorInStatus1 = true;
                    this.errorInStatus2 = true;
                    return false;
                }
                if (this.bitsPerCard != 24 && this.bitsPerCard != 32) {
                    this.statusText1.setText(Bundle.getMessage("Error15"));
                    this.statusText1.setVisible(true);
                    this.errorInStatus1 = true;
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("Error15"), "", 0);
                    this.resetNotes2();
                    return false;
                }
                if (!this.editMode || this.numCards >= (numOutput = this.curNode.numOutputCards()) + (numInput = this.curNode.numInputCards()) || 1 != JOptionPane.showConfirmDialog(this, String.valueOf(Bundle.getMessage("ConfirmUpdate1")) + "\n" + Bundle.getMessage("ConfirmUpdate2") + "\n" + Bundle.getMessage("ConfirmUpdate3"), Bundle.getMessage("ConfirmUpdateTitle"), 0, 2)) break;
                return false;
            }
            case 3: {
                int j = 0;
                while (j < 64) {
                    if (this.cardType[j].equals(Bundle.getMessage("CardTypeOutput")) || this.cardType[j].equals(Bundle.getMessage("CardTypeInput"))) {
                        ++this.numCards;
                    }
                    ++j;
                }
                break;
            }
            case 4: {
                int j = 0;
                while (j < 64) {
                    if (this.cardType[j].equals(Bundle.getMessage("CardTypeOutput")) || this.cardType[j].equals(Bundle.getMessage("CardTypeInput"))) {
                        ++this.numCards;
                    }
                    ++j;
                }
                break;
            }
            default: {
                log.warn("Unexpected node type - {}", (Object)this.nodeType);
            }
        }
        return true;
    }

    public class CPnodeConfigModel
    extends AbstractTableModel {
        public static final int CARD_COLUMN = 0;
        public static final int CARDNUM_COLUMN = 1;
        public static final int CARDTYPE_COLUMN = 2;

        @Override
        public String getColumnName(int c) {
            return NodeConfigManagerFrame.this.cpnodeConfigColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return 16;
        }

        @Override
        public Object getValueAt(int r, int c) {
            String[] cdPort = new String[]{"  A", "  B"};
            String val = "     ";
            switch (c) {
                case 0: {
                    val = Integer.toString(r + 2);
                    return "   " + val;
                }
                case 1: {
                    int i = r / 2;
                    if (r % 2 == 0) {
                        val = String.valueOf(Integer.toHexString(32 + i)) + " ";
                    }
                    return "    " + val + "     " + cdPort[r % 2];
                }
                case 2: {
                    return " " + NodeConfigManagerFrame.this.cardType[r + NodeConfigManagerFrame.this.cpNodeOnboard];
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c == 2) {
                ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).cardType[r + NodeConfigManagerFrame.this.cpNodeOnboard] = (String)type;
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2;
        }
    }

    public class CardConfigModel
    extends AbstractTableModel {
        public static final int ADDRESS_COLUMN = 0;
        public static final int TYPE_COLUMN = 1;

        @Override
        public String getColumnName(int c) {
            return NodeConfigManagerFrame.this.cardConfigColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return 64;
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (c == 0) {
                return "       " + Integer.toString(r);
            }
            if (c == 1) {
                return "  " + NodeConfigManagerFrame.this.cardType[r];
            }
            return "";
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c == 1) {
                ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).cardType[r] = (String)type;
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }
    }

    private class HandlerClass
    implements ItemListener {
        private HandlerClass() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox checkbox = (JCheckBox)e.getSource();
            if (checkbox == NodeConfigManagerFrame.this.cbx_cmrinetopt_AUTOPOLL) {
                NodeConfigManagerFrame.this.curNode.setCMRInetOpts(0, NodeConfigManagerFrame.this.cbx_cmrinetopt_AUTOPOLL.isSelected() ? 1 : 0);
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cmrinetopt_USECMRIX) {
                NodeConfigManagerFrame.this.curNode.setCMRInetOpts(1, NodeConfigManagerFrame.this.cbx_cmrinetopt_USECMRIX.isSelected() ? 1 : 0);
                NodeConfigManagerFrame.this.curNode.setcpnodeOpts(1, NodeConfigManagerFrame.this.curNode.getCMRInetOpts(1));
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cmrinetopt_USEBCC) {
                NodeConfigManagerFrame.this.curNode.setCMRInetOpts(2, NodeConfigManagerFrame.this.cbx_cmrinetopt_USEBCC.isSelected() ? 1 : 0);
                NodeConfigManagerFrame.this.curNode.setcpnodeOpts(2, NodeConfigManagerFrame.this.curNode.getCMRInetOpts(2));
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cmrinetopt_BIT8) {
                NodeConfigManagerFrame.this.curNode.setCMRInetOpts(8, NodeConfigManagerFrame.this.cbx_cmrinetopt_BIT8.isSelected() ? 1 : 0);
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cmrinetopt_BIT15) {
                NodeConfigManagerFrame.this.curNode.setCMRInetOpts(15, NodeConfigManagerFrame.this.cbx_cmrinetopt_BIT15.isSelected() ? 1 : 0);
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cpnodeopt_SENDEOT) {
                NodeConfigManagerFrame.this.curNode.setcpnodeOpts(1, NodeConfigManagerFrame.this.cbx_cpnodeopt_SENDEOT.isSelected() ? 1 : 0);
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT1) {
                NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT1.setSelected(false);
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT2) {
                NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT2.setSelected(false);
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT8) {
                NodeConfigManagerFrame.this.curNode.setcpnodeOpts(8, NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT8.isSelected() ? 1 : 0);
            } else if (checkbox == NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT15) {
                NodeConfigManagerFrame.this.curNode.setcpnodeOpts(15, NodeConfigManagerFrame.this.cbx_cpnodeopt_BIT15.isSelected() ? 1 : 0);
            }
            NodeConfigManagerFrame.this.changedNode = true;
        }
    }

    public class NodeTableModel
    extends AbstractTableModel {
        public static final int NODENUM_COLUMN = 0;
        public static final int NODETYPE_COLUMN = 1;
        public static final int NUMBITS_COLUMN = 2;
        public static final int NUMINCARDS_COLUMN = 3;
        public static final int NUMOUTCARDS_COLUMN = 4;
        public static final int NUMINBYTES_COLUMN = 5;
        public static final int NUMOUTBYTES_COLUMN = 6;
        public static final int SELECT_COLUMN = 7;
        public static final int NODEDESC_COLUMN = 8;
        public static final int NUM_COLUMNS = 9;

        @Override
        public String getColumnName(int c) {
            return NodeConfigManagerFrame.this.nodeTableColumnsNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return Integer.class;
                }
                case 7: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 7;
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public int getRowCount() {
            return NodeConfigManagerFrame.this.cmriNode.size();
        }

        public void removeRow(int row) {
            NodeConfigManagerFrame.this.cmriNode.remove(row);
            NodeConfigManagerFrame.this.numConfigNodes = NodeConfigManagerFrame.this.cmriNode.size();
            this.fireTableRowsDeleted(row, row);
        }

        public void addRow(SerialNode newNode) {
            NodeConfigManagerFrame.this.cmriNode.add(newNode);
            NodeConfigManagerFrame.this.numConfigNodes = NodeConfigManagerFrame.this.cmriNode.size();
            this.fireTableDataChanged();
        }

        public void changeRow(int row, SerialNode aNode) {
            NodeConfigManagerFrame.this.cmriNode.set(row, aNode);
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 7) {
                if (Bundle.getMessage("SelectEdit").equals(value)) {
                    NodeConfigManagerFrame.this.editActionSelected();
                } else if (Bundle.getMessage("SelectInfo").equals(value)) {
                    NodeConfigManagerFrame.this.infoActionSelected();
                } else if (Bundle.getMessage("SelectDelete").equals(value)) {
                    NodeConfigManagerFrame.this.deleteActionSelected();
                }
            } else {
                log.info("setValueAt Row{} value {}", (Object)row, value);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    if (!NodeConfigManagerFrame.this.doingPrint) {
                        return NodeConfigManagerFrame.this.cmriNode.get(r).getNodeAddress();
                    }
                    return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).getNodeAddress());
                }
                case 1: {
                    return "  " + NodeConfigManagerFrame.this.nodeTableTypes[NodeConfigManagerFrame.this.cmriNode.get(r).getNodeType()];
                }
                case 2: {
                    return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).getNumBitsPerCard());
                }
                case 3: {
                    if (NodeConfigManagerFrame.this.cmriNode.get(r).getNodeType() == 1) {
                        return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).numInputCards() * 3);
                    }
                    return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).numInputCards());
                }
                case 4: {
                    if (NodeConfigManagerFrame.this.cmriNode.get(r).getNodeType() == 1) {
                        return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).numOutputCards() * 3);
                    }
                    return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).numOutputCards());
                }
                case 5: {
                    return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).getNumBitsPerCard() * NodeConfigManagerFrame.this.cmriNode.get(r).numInputCards());
                }
                case 6: {
                    return Integer.toString(NodeConfigManagerFrame.this.cmriNode.get(r).getNumBitsPerCard() * NodeConfigManagerFrame.this.cmriNode.get(r).numOutputCards());
                }
                case 7: {
                    return "Select";
                }
                case 8: {
                    return " " + NodeConfigManagerFrame.this.cmriNode.get(r).getcmriNodeDesc();
                }
            }
            return "";
        }

        public void printTable(HardcopyWriter w, int[] colWidth) {
            int[] columnSize = new int[9];
            int charPerLine = w.getCharactersPerLine();
            int tableLineWidth = 0;
            int totalColWidth = 0;
            NodeConfigManagerFrame.this.doingPrint = true;
            int j = 0;
            while (j < 9) {
                if (j != 7) {
                    totalColWidth += colWidth[j];
                }
                ++j;
            }
            float ratio = (float)charPerLine / (float)totalColWidth;
            int j2 = 0;
            while (j2 < 9) {
                if (j2 != 7) {
                    columnSize[j2] = (int)((float)colWidth[j2] * ratio) - 1;
                    tableLineWidth += columnSize[j2] + 1;
                }
                ++j2;
            }
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            String[] columnStrings = new String[9];
            int i = 0;
            while (i < 9) {
                if (i != 7) {
                    columnStrings[i] = this.getColumnName(i);
                }
                ++i;
            }
            this.printColumns(w, columnStrings, columnSize);
            w.setFontStyle(0);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            String[] spaces = new String[9];
            int k = 0;
            while (k < 9) {
                if (k != 7) {
                    spaces[k] = "";
                    int i2 = 0;
                    while (i2 < columnSize[k]) {
                        spaces[k] = String.valueOf(spaces[k]) + " ";
                        ++i2;
                    }
                }
                ++k;
            }
            int i3 = 0;
            while (i3 < this.getRowCount()) {
                int j3 = 0;
                while (j3 < 9) {
                    if (j3 != 7) {
                        columnStrings[j3] = this.getValueAt(i3, j3) == null ? spaces[j3] : (String)this.getValueAt(i3, j3);
                    }
                    ++j3;
                }
                this.printColumns(w, columnStrings, columnSize);
                w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
                ++i3;
            }
            NodeConfigManagerFrame.this.doingPrint = false;
            w.close();
        }

        protected void printColumns(HardcopyWriter w, String[] columnStrings, int[] columnSize) {
            String columnString = "";
            StringBuilder lineString = new StringBuilder("");
            String[] spaces = new String[9];
            int k = 0;
            while (k < 9) {
                if (k != 7) {
                    spaces[k] = "";
                    int i = 0;
                    while (i < columnSize[k]) {
                        spaces[k] = String.valueOf(spaces[k]) + " ";
                        ++i;
                    }
                }
                ++k;
            }
            boolean complete = false;
            while (!complete) {
                int k2;
                complete = true;
                int i = 0;
                while (i < 9) {
                    if (i != 7) {
                        if (columnStrings[i].length() > columnSize[i]) {
                            boolean noWord = true;
                            k2 = columnSize[i];
                            while (k2 >= 1) {
                                if (columnStrings[i].substring(k2 - 1, k2).equals(" ") || columnStrings[i].substring(k2 - 1, k2).equals("-") || columnStrings[i].substring(k2 - 1, k2).equals("_")) {
                                    columnString = String.valueOf(columnStrings[i].substring(0, k2)) + spaces[i].substring(columnStrings[i].substring(0, k2).length());
                                    columnStrings[i] = columnStrings[i].substring(k2);
                                    noWord = false;
                                    complete = false;
                                    break;
                                }
                                --k2;
                            }
                            if (noWord) {
                                columnString = columnStrings[i].substring(0, columnSize[i]);
                                columnStrings[i] = columnStrings[i].substring(columnSize[i]);
                                complete = false;
                            }
                        } else {
                            columnString = String.valueOf(columnStrings[i]) + spaces[i].substring(columnStrings[i].length());
                            columnStrings[i] = "";
                        }
                        lineString.append(columnString).append(" ");
                    }
                    ++i;
                }
                try {
                    w.write(lineString.toString());
                    int iLine = w.getCurrentLineNumber();
                    int i2 = 0;
                    k2 = 0;
                    while (i2 < w.getCharactersPerLine()) {
                        if (k2 != 7) {
                            w.write(iLine, i2, iLine + 1, i2);
                            i2 = k2 < 9 ? i2 + columnSize[k2] + 1 : w.getCharactersPerLine();
                        }
                        ++k2;
                    }
                    w.write("\n");
                    lineString = new StringBuilder("");
                }
                catch (IOException e) {
                    log.warn("error during printing: ", (Throwable)e);
                }
            }
        }
    }

    public class OSnodeConfigModel
    extends AbstractTableModel {
        public static final int CARDNUM_COLUMN = 0;
        public static final int CARDTYPE_COLUMN = 1;

        @Override
        public String getColumnName(int c) {
            return NodeConfigManagerFrame.this.osnodeConfigColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return 8;
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    int i = r;
                    return "    " + i + " ";
                }
                case 1: {
                    return " " + NodeConfigManagerFrame.this.onBoardType[r];
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c == 1) {
                ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).onBoardType[r] = (String)type;
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }
    }

    public class SearchlightConfigModel
    extends AbstractTableModel {
        public static final int PORT_COLUMN = 0;

        @Override
        public String getColumnName(int c) {
            return NodeConfigManagerFrame.this.searchlightConfigColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c > 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public int getRowCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (c == 0) {
                switch (r) {
                    case 0: {
                        return "Card 0 Port A";
                    }
                    case 1: {
                        return "Card 0 Port B";
                    }
                    case 2: {
                        return "Card 0 Port C";
                    }
                    case 3: {
                        return "Card 1 Port A";
                    }
                    case 4: {
                        return "Card 1 Port B";
                    }
                    case 5: {
                        return "Card 1 Port C";
                    }
                }
                return "";
            }
            int index = r * 8 + (c - 1);
            return NodeConfigManagerFrame.this.searchlightBits[index];
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c > 0) {
                int index = r * 8 + (c - 1);
                if (!((Boolean)type).booleanValue()) {
                    ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).searchlightBits[index] = false;
                    if (NodeConfigManagerFrame.this.firstSearchlight[index]) {
                        ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).searchlightBits[index + 1] = false;
                        ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).firstSearchlight[index] = false;
                    } else {
                        ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).searchlightBits[index - 1] = false;
                        ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).firstSearchlight[index - 1] = false;
                    }
                    --NodeConfigManagerFrame.this.num2LSearchLights;
                } else if (index < 47 && !NodeConfigManagerFrame.this.searchlightBits[index] && !NodeConfigManagerFrame.this.searchlightBits[index + 1]) {
                    ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).searchlightBits[index] = true;
                    ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).searchlightBits[index + 1] = true;
                    ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).firstSearchlight[index] = true;
                    ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).firstSearchlight[index + 1] = false;
                    if (index > 0) {
                        ((NodeConfigManagerFrame)NodeConfigManagerFrame.this).firstSearchlight[index - 1] = false;
                    }
                    ++NodeConfigManagerFrame.this.num2LSearchLights;
                }
                NodeConfigManagerFrame.this.panel2a.setVisible(false);
                NodeConfigManagerFrame.this.panel2a.setVisible(true);
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c != 0;
        }
    }
}

