/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.nodeconfig;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.nodeconfig.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NodeConfigFrame
extends JmriJFrame {
    protected JTextField nodeAddrField = new JTextField(3);
    protected JLabel nodeAddrStatic = new JLabel("000");
    protected JComboBox<String> nodeTypeBox;
    protected JTextField receiveDelayField = new JTextField(3);
    protected JTextField pulseWidthField = new JTextField(4);
    protected JComboBox<String> cardSizeBox;
    protected JLabel cardSizeText = new JLabel("   " + Bundle.getMessage("LabelCardSize"));
    protected JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    protected JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    protected JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
    protected JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
    protected JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    protected JLabel statusText1 = new JLabel();
    protected JLabel statusText2 = new JLabel();
    protected JLabel statusText3 = new JLabel();
    protected JPanel panel2 = new JPanel();
    protected JPanel panel2a = new JPanel();
    protected boolean changedNode = false;
    protected boolean editMode = false;
    protected transient SerialNode curNode = null;
    protected int nodeAddress = 0;
    protected int nodeType = 1;
    protected int bitsPerCard = 24;
    protected int receiveDelay = 0;
    protected int pulseWidth = 500;
    protected int num2LSearchLights = 0;
    protected int numCards = 0;
    protected boolean errorInStatus1 = false;
    protected boolean errorInStatus2 = false;
    protected String stdStatus1 = Bundle.getMessage("NotesStd1", Bundle.getMessage("ButtonAdd"));
    protected String stdStatus2 = Bundle.getMessage("NotesStd2", Bundle.getMessage("ButtonEdit"));
    protected String stdStatus3 = Bundle.getMessage("NotesStd3", Bundle.getMessage("ButtonDelete"));
    protected String editStatus1 = Bundle.getMessage("NotesEdit1");
    protected String editStatus2 = Bundle.getMessage("NotesEdit2", Bundle.getMessage("ButtonUpdate"));
    protected String editStatus3 = Bundle.getMessage("NotesEdit3", Bundle.getMessage("ButtonCancel"));
    private final transient CMRISystemConnectionMemo _memo;
    private final String[] cardConfigColumnNames = new String[]{Bundle.getMessage("HeadingCardAddress"), Bundle.getMessage("HeadingCardType")};
    private final String[] cardType = new String[64];
    private final String[] searchlightConfigColumnNames = new String[]{Bundle.getMessage("HeadingPort"), "0", "1", "2", "3", "4", "5", "6", "7"};
    private final boolean[] searchlightBits = new boolean[48];
    private final boolean[] firstSearchlight = new boolean[48];
    private static final Logger log = LoggerFactory.getLogger(NodeConfigFrame.class);

    public NodeConfigFrame(@Nonnull CMRISystemConnectionMemo memo) {
        this._memo = memo;
        int i = 0;
        while (i < 64) {
            this.cardType[i] = Bundle.getMessage("CardTypeNone");
            ++i;
        }
        i = 0;
        while (i < 48) {
            this.searchlightBits[i] = false;
            this.firstSearchlight[i] = false;
            ++i;
        }
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.nodeconfig.NodeConfigFrame", true);
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("ConfigureNodesTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout());
        panel11.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeAddress")) + " "));
        panel11.add(this.nodeAddrField);
        this.nodeAddrField.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        this.nodeAddrField.setText("0");
        panel11.add(this.nodeAddrStatic);
        this.nodeAddrStatic.setVisible(false);
        panel11.add(new JLabel("   " + Bundle.getMessage("LabelNodeType") + " "));
        this.nodeTypeBox = new JComboBox();
        panel11.add(this.nodeTypeBox);
        this.nodeTypeBox.addItem("SMINI");
        this.nodeTypeBox.addItem("USIC_SUSIC");
        this.nodeTypeBox.addActionListener(event -> {
            String s = (String)this.nodeTypeBox.getSelectedItem();
            if (s.equals("SMINI")) {
                this.panel2.setVisible(false);
                this.panel2a.setVisible(true);
                this.cardSizeText.setVisible(false);
                this.cardSizeBox.setVisible(false);
                this.nodeType = 1;
            } else if (s.equals("USIC_SUSIC")) {
                this.panel2.setVisible(true);
                this.panel2a.setVisible(false);
                this.cardSizeText.setVisible(true);
                this.cardSizeBox.setVisible(true);
                this.nodeType = 2;
            }
            this.resetNotes();
        });
        this.nodeTypeBox.setToolTipText(Bundle.getMessage("TipNodeType"));
        JPanel panel12 = new JPanel();
        panel12.setLayout(new FlowLayout());
        panel12.add(new JLabel(String.valueOf(Bundle.getMessage("LabelDelay")) + " "));
        panel12.add(this.receiveDelayField);
        this.receiveDelayField.setToolTipText(Bundle.getMessage("TipDelay"));
        this.receiveDelayField.setText("0");
        panel12.add(this.cardSizeText);
        this.cardSizeBox = new JComboBox();
        panel12.add(this.cardSizeBox);
        this.cardSizeBox.addItem(Bundle.getMessage("CardSize24"));
        this.cardSizeBox.addItem(Bundle.getMessage("CardSize32"));
        this.cardSizeBox.addActionListener(event -> {
            String s = (String)this.cardSizeBox.getSelectedItem();
            if (s.equals(Bundle.getMessage("CardSize24"))) {
                this.bitsPerCard = 24;
            } else if (s.equals(Bundle.getMessage("CardSize32"))) {
                this.bitsPerCard = 32;
            }
        });
        this.cardSizeBox.setToolTipText(Bundle.getMessage("TipCardSize"));
        this.cardSizeText.setVisible(false);
        this.cardSizeBox.setVisible(false);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new FlowLayout());
        panel13.add(new JLabel(String.valueOf(Bundle.getMessage("LabelPulseWidth")) + " "));
        panel13.add(this.pulseWidthField);
        this.pulseWidthField.setToolTipText(Bundle.getMessage("TipPulseWidth"));
        this.pulseWidthField.setText("500");
        panel13.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
        panel1.add(panel11);
        panel1.add(panel12);
        panel1.add(panel13);
        contentPane.add(panel1);
        JPanel panel21 = new JPanel();
        panel21.setLayout(new BoxLayout(panel21, 1));
        panel21.add(new JLabel(Bundle.getMessage("HintCardTypePartA")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartB")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartC")));
        panel21.add(new JLabel("   "));
        panel21.add(new JLabel(Bundle.getMessage("HintCardTypePartD")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartE")));
        panel21.add(new JLabel(" " + Bundle.getMessage("HintCardTypePartF")));
        this.panel2.add(panel21);
        CardConfigModel cardConfigModel = new CardConfigModel();
        JTable cardConfigTable = new JTable(cardConfigModel);
        cardConfigTable.setRowSelectionAllowed(false);
        cardConfigTable.setPreferredScrollableViewportSize(new Dimension(180, 100));
        JComboBox<String> cardTypeCombo = new JComboBox<String>();
        cardTypeCombo.addItem(Bundle.getMessage("CardTypeOutput"));
        cardTypeCombo.addItem(Bundle.getMessage("CardTypeInput"));
        cardTypeCombo.addItem(Bundle.getMessage("CardTypeNone"));
        TableColumnModel typeColumnModel = cardConfigTable.getColumnModel();
        TableColumn addressColumn = typeColumnModel.getColumn(0);
        addressColumn.setMinWidth(70);
        addressColumn.setMaxWidth(80);
        TableColumn cardTypeColumn = typeColumnModel.getColumn(1);
        cardTypeColumn.setCellEditor(new DefaultCellEditor(cardTypeCombo));
        cardTypeColumn.setResizable(false);
        cardTypeColumn.setMinWidth(90);
        cardTypeColumn.setMaxWidth(100);
        JScrollPane cardScrollPane = new JScrollPane(cardConfigTable);
        this.panel2.add((Component)cardScrollPane, "Center");
        contentPane.add(this.panel2);
        this.panel2.setVisible(false);
        JPanel panel2a1 = new JPanel();
        panel2a1.setLayout(new BoxLayout(panel2a1, 1));
        panel2a1.add(new JLabel(Bundle.getMessage("HintSearchlightPartA")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartB")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartC")));
        panel2a1.add(new JLabel("   "));
        panel2a1.add(new JLabel(Bundle.getMessage("HintSearchlightPartD")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartE")));
        panel2a1.add(new JLabel(" " + Bundle.getMessage("HintSearchlightPartF")));
        this.panel2a.add(panel2a1);
        SearchlightConfigModel searchlightConfigModel = new SearchlightConfigModel();
        JTable searchlightConfigTable = new JTable(searchlightConfigModel);
        searchlightConfigTable.setRowSelectionAllowed(false);
        searchlightConfigTable.setPreferredScrollableViewportSize(new Dimension(208, 100));
        TableColumnModel searchlightColumnModel = searchlightConfigTable.getColumnModel();
        TableColumn portColumn = searchlightColumnModel.getColumn(0);
        portColumn.setMinWidth(90);
        portColumn.setMaxWidth(100);
        JScrollPane searchlightScrollPane = new JScrollPane(searchlightConfigTable);
        this.panel2a.add((Component)searchlightScrollPane, "Center");
        contentPane.add(this.panel2a);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        this.statusText1.setText(this.stdStatus1);
        this.statusText1.setVisible(true);
        panel31.add(this.statusText1);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new FlowLayout());
        this.statusText2.setText(this.stdStatus2);
        this.statusText2.setVisible(true);
        panel32.add(this.statusText2);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout());
        this.statusText3.setText(this.stdStatus3);
        this.statusText3.setVisible(true);
        panel33.add(this.statusText3);
        panel3.add(panel31);
        panel3.add(panel32);
        panel3.add(panel33);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("BoxLabelNotes"));
        panel3.setBorder(panel3Titled);
        contentPane.add(panel3);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addButton.addActionListener(e -> this.addButtonActionPerformed());
        panel4.add(this.addButton);
        this.editButton.setText(Bundle.getMessage("ButtonEdit"));
        this.editButton.setVisible(true);
        this.editButton.setToolTipText(Bundle.getMessage("TipEditButton"));
        panel4.add(this.editButton);
        this.editButton.addActionListener(e -> this.editButtonActionPerformed());
        panel4.add(this.deleteButton);
        this.deleteButton.setText(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.setVisible(true);
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        panel4.add(this.deleteButton);
        this.deleteButton.addActionListener(e -> this.deleteButtonActionPerformed());
        panel4.add(this.doneButton);
        this.doneButton.setText(Bundle.getMessage("ButtonDone"));
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("TipDoneButton"));
        panel4.add(this.doneButton);
        this.doneButton.addActionListener(e -> this.doneButtonActionPerformed());
        panel4.add(this.updateButton);
        this.updateButton.setText(Bundle.getMessage("ButtonUpdate"));
        this.updateButton.setVisible(true);
        this.updateButton.setToolTipText(Bundle.getMessage("TipUpdateButton"));
        panel4.add(this.updateButton);
        this.updateButton.addActionListener(e -> this.updateButtonActionPerformed());
        this.updateButton.setVisible(false);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed());
        this.cancelButton.setVisible(false);
        contentPane.add(panel4);
        this.pack();
    }

    public void addButtonActionPerformed() {
        int nodeAddress = this.readNodeAddress();
        if (nodeAddress < 0) {
            return;
        }
        if (this._memo == null || this._memo.getTrafficController() == null) {
            log.error("Not properly set up: _memo {}", (Object)this._memo, (Object)new NullPointerException());
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode != null) {
            this.statusText1.setText(String.valueOf(Bundle.getMessage("Error1")) + Integer.toString(nodeAddress) + Bundle.getMessage("Error2"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (!this.readReceiveDelay()) {
            return;
        }
        if (!this.readPulseWidth()) {
            return;
        }
        if (!this.checkConsistency()) {
            return;
        }
        this.curNode = new SerialNode(nodeAddress, this.nodeType, this._memo.getTrafficController());
        this.setNodeParameters();
        if (this._memo.getSensorManager() != null) {
            this._memo.getSensorManager().registerSensorsForNode(this.curNode);
        }
        this.resetNotes();
        this.changedNode = true;
        this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackAdd")) + " " + Integer.toString(nodeAddress));
        this.errorInStatus1 = true;
    }

    public void editButtonActionPerformed() {
        int i;
        this.nodeAddress = this.readNodeAddress();
        if (this.nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(this.nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        this.nodeAddrStatic.setText(Integer.toString(this.nodeAddress));
        this.nodeAddrField.setVisible(false);
        this.nodeAddrStatic.setVisible(true);
        this.nodeType = this.curNode.getNodeType();
        if (this.nodeType == 1) {
            this.nodeTypeBox.setSelectedItem("SMINI");
        } else if (this.nodeType == 2) {
            this.nodeTypeBox.setSelectedItem("USIC_SUSIC");
        }
        if (this.nodeType == 2) {
            this.bitsPerCard = this.curNode.getNumBitsPerCard();
            if (this.bitsPerCard == 24) {
                this.cardSizeBox.setSelectedItem(Bundle.getMessage("CardSize24"));
            }
            if (this.bitsPerCard == 32) {
                this.cardSizeBox.setSelectedItem(Bundle.getMessage("CardSize32"));
            }
        } else if (this.nodeType == 1) {
            this.bitsPerCard = 24;
            this.cardSizeBox.setSelectedItem(Bundle.getMessage("CardSize24"));
            this.num2LSearchLights = 0;
            i = 0;
            while (i < 48) {
                if (this.curNode.isSearchLightBit(i)) {
                    this.searchlightBits[i] = true;
                    this.searchlightBits[i + 1] = true;
                    this.firstSearchlight[i] = true;
                    this.firstSearchlight[i + 1] = false;
                    ++this.num2LSearchLights;
                    ++i;
                } else {
                    this.searchlightBits[i] = false;
                    this.firstSearchlight[i] = false;
                }
                ++i;
            }
        }
        this.receiveDelay = this.curNode.getTransmissionDelay();
        this.receiveDelayField.setText(Integer.toString(this.receiveDelay));
        this.pulseWidth = this.curNode.getPulseWidth();
        this.pulseWidthField.setText(Integer.toString(this.pulseWidth));
        i = 0;
        while (i < 64) {
            this.cardType[i] = this.curNode.isOutputCard(i) ? Bundle.getMessage("CardTypeOutput") : (this.curNode.isInputCard(i) ? Bundle.getMessage("CardTypeInput") : Bundle.getMessage("CardTypeNone"));
            ++i;
        }
        this.panel2.setVisible(false);
        this.panel2a.setVisible(false);
        if (this.nodeType == 2) {
            this.panel2.setVisible(true);
        } else if (this.nodeType == 1) {
            this.panel2a.setVisible(true);
        }
        this.editMode = true;
        this.addButton.setVisible(false);
        this.editButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.doneButton.setVisible(false);
        this.updateButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.statusText1.setText(this.editStatus1);
        this.statusText2.setText(this.editStatus2);
        this.statusText3.setText(this.editStatus3);
    }

    public void deleteButtonActionPerformed() {
        int nodeAddress = this.readNodeAddress();
        if (nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (JOptionPane.showConfirmDialog(this, String.valueOf(Bundle.getMessage("ConfirmDelete1")) + "\n" + Bundle.getMessage("ConfirmDelete2"), Bundle.getMessage("ConfirmDeleteTitle"), 2, 2) == 0) {
            this._memo.getTrafficController().deleteNode(nodeAddress);
            this.resetNotes();
            this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackDelete")) + " " + Integer.toString(nodeAddress));
            this.errorInStatus1 = true;
            this.changedNode = true;
        } else {
            this.resetNotes();
        }
    }

    public void doneButtonActionPerformed() {
        if (this.editMode) {
            this.editMode = false;
            this.curNode = null;
            this.addButton.setVisible(true);
            this.editButton.setVisible(true);
            this.deleteButton.setVisible(true);
            this.doneButton.setVisible(true);
            this.updateButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.nodeAddrField.setVisible(true);
            this.nodeAddrStatic.setVisible(false);
        }
        if (this.changedNode) {
            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("ReminderNode1")) + "\n" + Bundle.getMessage("Reminder2", Bundle.getMessage("ButtonSave")), Bundle.getMessage("ReminderTitle"), 1);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void updateButtonActionPerformed() {
        if (!this.readReceiveDelay()) {
            return;
        }
        if (!this.readPulseWidth()) {
            return;
        }
        if (!this.checkConsistency()) {
            return;
        }
        if (this.curNode.getNodeType() != this.nodeType) {
            this.curNode.setNodeType(this.nodeType);
        }
        this.setNodeParameters();
        this.changedNode = true;
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.nodeAddrField.setVisible(true);
        this.nodeAddrStatic.setVisible(false);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
        this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackUpdate")) + " " + Integer.toString(this.nodeAddress));
        this.errorInStatus1 = true;
    }

    public void cancelButtonActionPerformed() {
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.nodeAddrField.setVisible(true);
        this.nodeAddrStatic.setVisible(false);
        this.statusText1.setText(this.stdStatus1);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.doneButtonActionPerformed();
        super.windowClosing(e);
    }

    /*
     * Unable to fully structure code
     */
    void setNodeParameters() {
        this.curNode.setTransmissionDelay(this.receiveDelay);
        this.curNode.setPulseWidth(this.pulseWidth);
        switch (this.nodeType) {
            case 1: {
                numSet = 0;
                j = 0;
                while (j < 47) {
                    if (this.curNode.isSearchLightBit(j)) {
                        if (!this.firstSearchlight[j]) {
                            this.curNode.clear2LeadSearchLight(j);
                            ++j;
                        } else {
                            ++j;
                        }
                    }
                    ++j;
                }
                i = 0;
                while (i < 47) {
                    if (this.firstSearchlight[i]) {
                        if (!this.curNode.isSearchLightBit(i)) {
                            this.curNode.set2LeadSearchLight(i);
                        }
                        ++numSet;
                    }
                    ++i;
                }
                if (numSet == this.num2LSearchLights) break;
                NodeConfigFrame.log.error("Inconsistent numbers of 2-lead searchlights. numSet = {}, num2LSearchLights = {}", (Object)numSet, (Object)this.num2LSearchLights);
                break;
            }
            case 2: {
                this.curNode.setNumBitsPerCard(this.bitsPerCard);
                numInput = 0;
                numOutput = 0;
                i = 0;
                while (i < 64) {
                    if (this.cardType[i] != null) ** GOTO lbl36
                    NodeConfigFrame.log.error("Unexpected card type - {}", (Object)this.cardType[i]);
                    ** GOTO lbl69
lbl36:
                    // 1 sources

                    var5_6 = this.cardType[i];
                    tmp = -1;
                    switch (var5_6.hashCode()) {
                        case -974474778: {
                            if (var5_6.equals("Input Card")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case -579675633: {
                            if (var5_6.equals("No Card")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 783804111: {
                            if (var5_6.equals("Output Card")) {
                                tmp = 3;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 2: {
                            this.curNode.setCardTypeByAddress(i, 0);
                            break;
                        }
                        case 1: {
                            this.curNode.setCardTypeByAddress(i, 1);
                            ++numInput;
                            break;
                        }
                        case 3: {
                            this.curNode.setCardTypeByAddress(i, 2);
                            ++numOutput;
                            break;
                        }
                        default: {
                            NodeConfigFrame.log.error("Unexpected card type - {}", (Object)this.cardType[i]);
                        }
                    }
lbl69:
                    // 5 sources

                    ++i;
                }
                if (this.numCards == numOutput + numInput) break;
                NodeConfigFrame.log.error("Inconsistent numbers of cards - setNodeParameters.");
                break;
            }
            default: {
                NodeConfigFrame.log.error("Unexpected node type in setNodeParameters- {}", (Object)this.nodeType);
            }
        }
        this._memo.getTrafficController().initializeSerialNode(this.curNode);
    }

    private void resetNotes() {
        if (this.errorInStatus1) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus1);
            } else {
                this.statusText1.setText(this.stdStatus1);
            }
            this.errorInStatus1 = false;
        }
        this.resetNotes2();
    }

    private void resetNotes2() {
        if (this.errorInStatus2) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus2);
            } else {
                this.statusText2.setText(this.stdStatus2);
            }
            this.errorInStatus2 = false;
        }
    }

    private int readNodeAddress() {
        int addr;
        try {
            addr = Integer.parseInt(this.nodeAddrField.getText());
            if (addr < 0 || addr > 127) {
                this.statusText1.setText(Bundle.getMessage("Error6"));
                this.statusText1.setVisible(true);
                this.errorInStatus1 = true;
                this.resetNotes2();
                addr = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.statusText1.setText(Bundle.getMessage("Error5"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            addr = -1;
        }
        return addr;
    }

    protected boolean readReceiveDelay() {
        try {
            this.receiveDelay = Integer.parseInt(this.receiveDelayField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.statusText1.setText(Bundle.getMessage("Error7"));
            this.statusText1.setVisible(true);
            this.receiveDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.receiveDelay < 0) {
            this.statusText1.setText(Bundle.getMessage("Error8"));
            this.statusText1.setVisible(true);
            this.receiveDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.receiveDelay > 65535) {
            this.statusText1.setText(Bundle.getMessage("Error9"));
            this.statusText1.setVisible(true);
            this.receiveDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }

    protected boolean readPulseWidth() {
        try {
            this.pulseWidth = Integer.parseInt(this.pulseWidthField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.statusText1.setText(Bundle.getMessage("Error18"));
            this.statusText1.setVisible(true);
            this.pulseWidth = 500;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.pulseWidth < 100) {
            this.statusText1.setText(Bundle.getMessage("Error16"));
            this.statusText1.setVisible(true);
            this.pulseWidth = 100;
            this.pulseWidthField.setText(Integer.toString(this.pulseWidth));
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.pulseWidth > 10000) {
            this.statusText1.setText(Bundle.getMessage("Error17"));
            this.statusText1.setVisible(true);
            this.pulseWidth = 500;
            this.pulseWidthField.setText(Integer.toString(this.pulseWidth));
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }

    protected boolean checkConsistency() {
        switch (this.nodeType) {
            case 1: {
                int numBits = 0;
                int i = 0;
                while (i < 48) {
                    if (this.searchlightBits[i]) {
                        ++numBits;
                    }
                    ++i;
                }
                if (2 * this.num2LSearchLights == numBits) break;
                this.statusText1.setText(Bundle.getMessage("Error10"));
                this.statusText1.setVisible(true);
                this.errorInStatus1 = true;
                this.resetNotes2();
                return false;
            }
            case 2: {
                int numInput;
                int numOutput;
                this.numCards = 0;
                boolean atNoCard = false;
                int i = 0;
                while (i < 64) {
                    if (this.cardType[i].equals(Bundle.getMessage("CardTypeOutput")) || this.cardType[i].equals(Bundle.getMessage("CardTypeInput"))) {
                        if (atNoCard) {
                            this.statusText1.setText(Bundle.getMessage("Error11"));
                            this.statusText1.setVisible(true);
                            this.statusText2.setText(Bundle.getMessage("Error12"));
                            this.errorInStatus1 = true;
                            this.errorInStatus2 = true;
                            return false;
                        }
                        ++this.numCards;
                    } else if (this.cardType[i].equals(Bundle.getMessage("CardTypeNone"))) {
                        atNoCard = true;
                    }
                    ++i;
                }
                if (this.numCards <= 0) {
                    this.statusText1.setText(Bundle.getMessage("Error13"));
                    this.statusText2.setText(Bundle.getMessage("Error14"));
                    this.statusText1.setVisible(true);
                    this.errorInStatus1 = true;
                    this.errorInStatus2 = true;
                    return false;
                }
                if (this.bitsPerCard != 24 && this.bitsPerCard != 32) {
                    this.statusText1.setText(Bundle.getMessage("Error15"));
                    this.statusText1.setVisible(true);
                    this.errorInStatus1 = true;
                    this.resetNotes2();
                    return false;
                }
                if (!this.editMode || this.numCards >= (numOutput = this.curNode.numOutputCards()) + (numInput = this.curNode.numInputCards()) || 1 != JOptionPane.showConfirmDialog(this, String.valueOf(Bundle.getMessage("ConfirmUpdate1")) + "\n" + Bundle.getMessage("ConfirmUpdate2") + "\n" + Bundle.getMessage("ConfirmUpdate3"), Bundle.getMessage("ConfirmUpdateTitle"), 0, 2)) break;
                return false;
            }
            default: {
                log.warn("Unexpected node type - {}", (Object)this.nodeType);
            }
        }
        return true;
    }

    public class CardConfigModel
    extends AbstractTableModel {
        public static final int ADDRESS_COLUMN = 0;
        public static final int TYPE_COLUMN = 1;

        @Override
        public String getColumnName(int c) {
            return NodeConfigFrame.this.cardConfigColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return 64;
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (c == 0) {
                return Integer.toString(r);
            }
            if (c == 1) {
                return NodeConfigFrame.this.cardType[r];
            }
            return "";
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c == 1) {
                ((NodeConfigFrame)NodeConfigFrame.this).cardType[r] = (String)type;
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }
    }

    public class SearchlightConfigModel
    extends AbstractTableModel {
        public static final int PORT_COLUMN = 0;

        @Override
        public String getColumnName(int c) {
            return NodeConfigFrame.this.searchlightConfigColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c > 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public int getRowCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (c == 0) {
                switch (r) {
                    case 0: {
                        return "Card 0 Port A";
                    }
                    case 1: {
                        return "Card 0 Port B";
                    }
                    case 2: {
                        return "Card 0 Port C";
                    }
                    case 3: {
                        return "Card 1 Port A";
                    }
                    case 4: {
                        return "Card 1 Port B";
                    }
                    case 5: {
                        return "Card 1 Port C";
                    }
                }
                return "";
            }
            int index = r * 8 + (c - 1);
            return NodeConfigFrame.this.searchlightBits[index];
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c > 0) {
                int index = r * 8 + (c - 1);
                if (!((Boolean)type).booleanValue()) {
                    ((NodeConfigFrame)NodeConfigFrame.this).searchlightBits[index] = false;
                    if (NodeConfigFrame.this.firstSearchlight[index]) {
                        ((NodeConfigFrame)NodeConfigFrame.this).searchlightBits[index + 1] = false;
                        ((NodeConfigFrame)NodeConfigFrame.this).firstSearchlight[index] = false;
                    } else {
                        ((NodeConfigFrame)NodeConfigFrame.this).searchlightBits[index - 1] = false;
                        ((NodeConfigFrame)NodeConfigFrame.this).firstSearchlight[index - 1] = false;
                    }
                    --NodeConfigFrame.this.num2LSearchLights;
                } else if (index < 47 && !NodeConfigFrame.this.searchlightBits[index] && !NodeConfigFrame.this.searchlightBits[index + 1]) {
                    ((NodeConfigFrame)NodeConfigFrame.this).searchlightBits[index] = true;
                    ((NodeConfigFrame)NodeConfigFrame.this).searchlightBits[index + 1] = true;
                    ((NodeConfigFrame)NodeConfigFrame.this).firstSearchlight[index] = true;
                    ((NodeConfigFrame)NodeConfigFrame.this).firstSearchlight[index + 1] = false;
                    if (index > 0) {
                        ((NodeConfigFrame)NodeConfigFrame.this).firstSearchlight[index - 1] = false;
                    }
                    ++NodeConfigFrame.this.num2LSearchLights;
                }
                NodeConfigFrame.this.panel2a.setVisible(false);
                NodeConfigFrame.this.panel2a.setVisible(true);
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c != 0;
        }
    }
}

