/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.networkdriver.configurexml;

import java.util.List;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import jmri.jmrix.cmri.serial.networkdriver.ConnectionConfig;
import jmri.jmrix.cmri.serial.networkdriver.NetworkDriverAdapter;
import jmri.jmrix.configurexml.AbstractNetworkConnectionConfigXml;
import org.jdom2.Content;
import org.jdom2.Element;

public class ConnectionConfigXml
extends AbstractNetworkConnectionConfigXml {
    @Override
    protected void getInstance() {
        if (this.adapter == null) {
            this.adapter = new NetworkDriverAdapter();
        }
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void extendElement(Element e) {
        SerialTrafficController tc = ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController();
        SerialNode node = (SerialNode)tc.getNode(0);
        int index = 1;
        while (node != null) {
            Element n = new Element("node");
            n.setAttribute("name", "" + node.getNodeAddress());
            e.addContent((Content)n);
            n.addContent((Content)this.makeParameter("nodetype", "" + node.getNodeType()));
            n.addContent((Content)this.makeParameter("bitspercard", "" + node.getNumBitsPerCard()));
            n.addContent((Content)this.makeParameter("transmissiondelay", "" + node.getTransmissionDelay()));
            n.addContent((Content)this.makeParameter("num2lsearchlights", "" + node.getNum2LSearchLights()));
            n.addContent((Content)this.makeParameter("pulsewidth", "" + node.getPulseWidth()));
            StringBuilder value = new StringBuilder("");
            int i = 0;
            while (i < node.getLocSearchLightBits().length) {
                value.append(Integer.toHexString(node.getLocSearchLightBits()[i] & 0xF));
                ++i;
            }
            n.addContent((Content)this.makeParameter("locsearchlightbits", value.toString()));
            value = new StringBuilder("");
            i = 0;
            while (i < node.getCardTypeLocation().length) {
                value.append(Integer.toHexString(node.getCardTypeLocation()[i] & 0xF));
                ++i;
            }
            n.addContent((Content)this.makeParameter("cardtypelocation", value.toString()));
            node = (SerialNode)tc.getNode(index);
            ++index;
        }
    }

    protected Element makeParameter(String name, String value) {
        Element p = new Element("parameter");
        p.setAttribute("name", name);
        p.addContent(value);
        return p;
    }

    @Override
    protected void unpackElement(Element shared, Element perNode) {
        List l = shared.getChildren("node");
        int i = 0;
        while (i < l.size()) {
            Element n = (Element)l.get(i);
            int addr = Integer.parseInt(n.getAttributeValue("name"));
            int type = Integer.parseInt(this.findParmValue(n, "nodetype"));
            int bpc = Integer.parseInt(this.findParmValue(n, "bitspercard"));
            int delay = Integer.parseInt(this.findParmValue(n, "transmissiondelay"));
            int num2l = Integer.parseInt(this.findParmValue(n, "num2lsearchlights"));
            int pulseWidth = 500;
            if (this.findParmValue(n, "pulsewidth") != null) {
                pulseWidth = Integer.parseInt(this.findParmValue(n, "pulsewidth"));
            }
            String slb = this.findParmValue(n, "locsearchlightbits");
            String ctl = this.findParmValue(n, "cardtypelocation");
            SerialNode node = new SerialNode(addr, type, ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController());
            node.setNumBitsPerCard(bpc);
            node.setTransmissionDelay(delay);
            node.setNum2LSearchLights(num2l);
            node.setPulseWidth(pulseWidth);
            int j = 0;
            while (j < slb.length()) {
                node.setLocSearchLightBits(j, slb.charAt(j) - 48);
                ++j;
            }
            j = 0;
            while (j < ctl.length()) {
                node.setCardTypeLocation(j, ctl.charAt(j) - 48);
                ++j;
            }
            ((CMRISystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().initializeSerialNode(node);
            ++i;
        }
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

