/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.cmrinetmetrics;

public class CMRInetMetricsData {
    public static int _DGACK = 65;
    public static int _CODELINE = 67;
    public static int _DGREAD = 68;
    public static int _EOT = 69;
    public static int _INIT = 73;
    public static int _POLL = 80;
    public static int _QUERY = 81;
    public static int _READ = 82;
    public static int _TRANSMIT = 84;
    public static int _DGWRITE = 87;
    public static final String[] CMRInetMetricErrName = new String[]{"Timeout", "Truncated Receive", "Truncated Reply", "Unrecognized Response", "Unrecognized Command"};
    public static final int CMRInetMetricTimeout = 0;
    public static final int CMRInetMetricTruncRecv = 1;
    public static final int CMRInetMetricTruncReply = 2;
    public static final int CMRInetMetricUnrecResponse = 3;
    public static final int CMRInetMetricUnrecCommand = 4;
    public static final int CMRInetMetricErrLAST = 5;
    public int[] CMRInetMetricErrCount = new int[6];
    public static final String[] CMRInetMetricDataName = new String[]{"Poll/Response Time (ms)", "Init Messages"};
    public static int CMRInetMetricPollResponse = 0;
    public static int CMRInetMetricInitMsgs = 1;
    public static int CMRInetMetricDataLAST = CMRInetMetricInitMsgs + 1;
    public int[] CMRInetMetricDataCount = new int[2];
    public long pollTicks;
    public int pollIntervalMS;
    public int pollCnt;
    public int pollCntMax = 10;

    public synchronized int getMetricErrValue(int metricName) {
        return this.CMRInetMetricErrCount[metricName];
    }

    public synchronized void setMetricErrValue(int metricName, int value) {
        this.CMRInetMetricErrCount[metricName] = value;
    }

    public synchronized void incMetricErrValue(int metricName) {
        int n = metricName;
        this.CMRInetMetricErrCount[n] = this.CMRInetMetricErrCount[n] + 1;
    }

    public synchronized void zeroMetricErrValue(int metricName) {
        this.CMRInetMetricErrCount[metricName] = 0;
    }

    public synchronized void clearAllErrMetrics() {
        int i = 0;
        while (i != 5) {
            this.CMRInetMetricErrCount[i] = 0;
            ++i;
        }
    }

    public synchronized int getMetricErrorCount(int metricName) {
        return this.CMRInetMetricErrCount[metricName];
    }

    public synchronized int getMetricDataValue(int metricName) {
        return this.CMRInetMetricDataCount[metricName];
    }

    public synchronized void setMetricDataValue(int metricName, int value) {
        this.CMRInetMetricDataCount[metricName] = value;
    }

    public synchronized void incMetricDataValue(int metricName) {
        int n = metricName;
        this.CMRInetMetricDataCount[n] = this.CMRInetMetricDataCount[n] + 1;
    }

    public synchronized void zeroMetricDataValue(int metricName) {
        this.CMRInetMetricDataCount[metricName] = 0;
    }

    public synchronized void setMetricErrorValue(int metricName, int value) {
        this.CMRInetMetricErrCount[metricName] = value;
    }

    public synchronized void clearAllDataMetrics() {
        int i = 0;
        while (i != CMRInetMetricDataLAST) {
            this.CMRInetMetricDataCount[i] = 0;
            ++i;
        }
        this.pollTicks = 0L;
        this.pollIntervalMS = 0;
        this.pollCnt = 0;
    }

    public void startPollIntervalTimer() {
        this.pollTicks = System.currentTimeMillis();
    }

    public void computePollInterval() {
        long curTicks = System.currentTimeMillis();
        if (this.pollCnt++ <= this.pollCntMax) {
            if (this.pollTicks == 0L) {
                this.pollTicks = curTicks;
            }
            this.pollIntervalMS += (int)(curTicks - this.pollTicks);
            this.pollTicks = curTicks;
        } else {
            this.pollIntervalMS /= this.pollCntMax;
            this.CMRInetMetricDataCount[CMRInetMetricsData.CMRInetMetricPollResponse] = this.pollIntervalMS;
            this.pollIntervalMS = 0;
            this.pollCnt = 0;
        }
    }
}

