/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.cmrinetmanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import jmri.jmrix.cmri.serial.cmrinetmanager.Bundle;
import jmri.jmrix.cmri.serial.serialmon.SerialMonAction;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMRInetManagerFrame
extends JmriJFrame {
    ArrayList<SerialNode> cmriNode = new ArrayList();
    protected boolean inputSelected = false;
    protected SerialNode selNode = null;
    protected String selNodeID = "x";
    public int selNodeNum = 0;
    protected int selectedNodeAddr = -1;
    protected JPanel pollListPanel = null;
    protected Border pollListBorder = BorderFactory.createEtchedBorder();
    protected JTable nodeTable = null;
    protected TableModel nodeTableModel = null;
    protected JPanel CMRInetParams = new JPanel();
    JButton monitorButton = new JButton(Bundle.getMessage("MonitorButtonText"));
    JButton doneButton = new JButton(Bundle.getMessage("DoneButtonText"));
    JButton haltPollButton = new JButton(Bundle.getMessage("HaltPollButtonText"));
    JButton netStatsButton = new JButton(Bundle.getMessage("NetStatsButtonText"));
    private CMRISystemConnectionMemo _memo = null;
    protected JTextField pollIntervalField = new JTextField();
    private String[] pollListColumnsNames = new String[]{"Poll Seq", "Enabled", "Node", "Type", "Status", "Description"};
    private String[] nodeTypes = new String[]{"--", "SMINI", "SUSIC", "CPNODE", "PiNODE"};
    private String[] pollStatus = new String[]{"ERROR", "IDLE", "POLLING", "TIMEOUT", "INIT"};
    private static final Logger log = LoggerFactory.getLogger(CMRInetManagerFrame.class);

    public CMRInetManagerFrame(CMRISystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        this.initializeNodes();
        this.setTitle(String.valueOf(Bundle.getMessage("WindowTitle")) + " - Connection " + this._memo.getUserName());
        this.setSize(1200, 300);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new FlowLayout());
        this.pollListPanel = new JPanel();
        this.pollListPanel.setLayout(new BoxLayout(this.pollListPanel, 1));
        this.nodeTableModel = new NodeTableModel();
        this.nodeTable = new JTable(this.nodeTableModel);
        this.nodeTable.setShowGrid(true);
        this.nodeTable.setGridColor(Color.black);
        this.nodeTable.setRowSelectionAllowed(false);
        this.nodeTable.setFont(new Font("Lucida Grande", 0, 13));
        this.nodeTable.setPreferredScrollableViewportSize(new Dimension(300, 350));
        this.nodeTable.setRowHeight(30);
        this.nodeTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel pollListColumnModel = this.nodeTable.getColumnModel();
        DefaultTableCellRenderer dtcen = new DefaultTableCellRenderer();
        dtcen.setHorizontalAlignment(0);
        DefaultTableCellRenderer dtlft = new DefaultTableCellRenderer();
        dtlft.setHorizontalAlignment(2);
        TableCellRenderer rendererFromHeader = this.nodeTable.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)rendererFromHeader);
        headerLabel.setHorizontalAlignment(0);
        TableColumn pollseqColumn = pollListColumnModel.getColumn(0);
        pollseqColumn.setMinWidth(40);
        pollseqColumn.setMaxWidth(80);
        pollseqColumn.setCellRenderer(dtcen);
        pollseqColumn.setResizable(false);
        TableColumn enabledColumn = pollListColumnModel.getColumn(1);
        enabledColumn.setMinWidth(40);
        enabledColumn.setMaxWidth(80);
        enabledColumn.setResizable(false);
        TableColumn nodenumColumn = pollListColumnModel.getColumn(2);
        nodenumColumn.setMinWidth(40);
        nodenumColumn.setMaxWidth(70);
        nodenumColumn.setCellRenderer(dtcen);
        nodenumColumn.setResizable(false);
        TableColumn nodetypeColumn = pollListColumnModel.getColumn(3);
        nodetypeColumn.setMinWidth(40);
        nodetypeColumn.setMaxWidth(80);
        nodetypeColumn.setCellRenderer(dtcen);
        nodetypeColumn.setResizable(false);
        TableColumn statusColumn = pollListColumnModel.getColumn(4);
        statusColumn.setMinWidth(10);
        statusColumn.setMaxWidth(80);
        statusColumn.setCellRenderer(dtcen);
        statusColumn.setResizable(false);
        TableColumn nodedescColumn = pollListColumnModel.getColumn(5);
        nodedescColumn.setMinWidth(10);
        nodedescColumn.setMaxWidth(350);
        nodedescColumn.setCellRenderer(dtlft);
        nodedescColumn.setResizable(false);
        JScrollPane nodeTableScrollPane = new JScrollPane(this.nodeTable);
        TitledBorder pollListBorderTitled = BorderFactory.createTitledBorder(this.pollListBorder, " ", 1, 1);
        this.pollListPanel.add((Component)nodeTableScrollPane, "East");
        this.pollListPanel.setBorder(pollListBorderTitled);
        this.setPreferredSize(new Dimension(750, 500));
        this.nodeTable.setAutoCreateRowSorter(true);
        this.nodeTable.getRowSorter().toggleSortOrder(0);
        this.nodeTable.setDragEnabled(true);
        contentPane.add(this.pollListPanel);
        this.CMRInetParams.add(this.haltPollButton);
        contentPane.add(this.CMRInetParams);
        Container contentPane13 = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane13, 1));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 2));
        panel3.setPreferredSize(new Dimension(600, 45));
        this.haltPollButton.setVisible(true);
        this.haltPollButton.setToolTipText(Bundle.getMessage("HaltPollButtonTip"));
        this.haltPollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CMRInetManagerFrame.this.haltpollButtonActionPerformed(e);
            }
        });
        SerialTrafficController stc = this._memo.getTrafficController();
        if (stc.getPollNetwork()) {
            this.haltPollButton.setText(Bundle.getMessage("HaltPollButtonText"));
        } else {
            this.haltPollButton.setText(Bundle.getMessage("ResumePollButtonText"));
        }
        panel3.add(this.haltPollButton);
        this.monitorButton.setVisible(true);
        this.monitorButton.setToolTipText(Bundle.getMessage("MonitorButtonTip"));
        this.monitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CMRInetManagerFrame.this.monitorButtonActionPerformed(e);
            }
        });
        panel3.add(this.monitorButton);
        this.netStatsButton.setVisible(false);
        this.netStatsButton.setToolTipText(Bundle.getMessage("NetStatsButtonTip"));
        this.netStatsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CMRInetManagerFrame.this.netStatsButtonActionPerformed(e);
            }
        });
        panel3.add(this.netStatsButton);
        panel3.add(Box.createRigidArea(new Dimension(30, 0)));
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("DoneButtonTip"));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CMRInetManagerFrame.this.doneButtonActionPerformed();
            }
        });
        panel3.add(this.doneButton);
        contentPane13.add(panel3);
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.cmrinetmanager.CMRInetManagerFrame", true);
        this.pack();
    }

    public void initializeNodes() {
        SerialNode node = (SerialNode)this._memo.getTrafficController().getNode(0);
        int index = 1;
        while (node != null) {
            this.cmriNode.add(node);
            if (this.cmriNode.get(index - 1).getPollListPosition() == 0) {
                this.cmriNode.get(index - 1).setPollListPosition(index);
            }
            node = (SerialNode)this._memo.getTrafficController().getNode(index);
            ++index;
        }
    }

    public int getSelectedNodeAddr() {
        return (Integer)this.nodeTable.getValueAt(this.nodeTable.getSelectedRow(), 1);
    }

    public void doneButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    public void monitorButtonActionPerformed(ActionEvent e) {
        SerialMonAction f = new SerialMonAction(this._memo);
        try {
            f.actionPerformed(e);
        }
        catch (Exception ex) {
            log.info("Exception-C2: {}", (Object)ex.toString());
        }
    }

    public void netStatsButtonActionPerformed(ActionEvent e) {
        try {
            this.netStatsButton.setEnabled(false);
        }
        catch (Exception ex) {
            log.info("Exception-C2: {}", (Object)ex.toString());
        }
    }

    public void haltpollButtonActionPerformed(ActionEvent e) {
        SerialTrafficController stc;
        stc.setPollNetwork(!(stc = this._memo.getTrafficController()).getPollNetwork());
        if (stc.getPollNetwork()) {
            this.haltPollButton.setText(Bundle.getMessage("HaltPollButtonText"));
        } else {
            this.haltPollButton.setText(Bundle.getMessage("ResumePollButtonText"));
        }
    }

    public class NodeTableModel
    extends AbstractTableModel {
        public static final int POLLSEQ_COLUMN = 0;
        public static final int ENABLED_COLUMN = 1;
        public static final int NODENUM_COLUMN = 2;
        public static final int NODETYPE_COLUMN = 3;
        public static final int STATUS_COLUMN = 4;
        public static final int NODEDESC_COLUMN = 5;
        public static final int NUM_COLUMNS = 6;

        @Override
        public String getColumnName(int c) {
            return CMRInetManagerFrame.this.pollListColumnsNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 1: {
                    return Boolean.class;
                }
                case 0: {
                    return Integer.class;
                }
                case 2: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            return CMRInetManagerFrame.this.cmriNode.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return CMRInetManagerFrame.this.cmriNode.get(r).getPollListPosition();
                }
                case 1: {
                    if (CMRInetManagerFrame.this.cmriNode.get(r).getPollingEnabled()) {
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return CMRInetManagerFrame.this.cmriNode.get(r).getNodeAddress();
                }
                case 3: {
                    return "  " + CMRInetManagerFrame.this.nodeTypes[CMRInetManagerFrame.this.cmriNode.get(r).getNodeType()];
                }
                case 4: {
                    this.fireTableDataChanged();
                    return CMRInetManagerFrame.this.pollStatus[CMRInetManagerFrame.this.cmriNode.get(r).getPollStatus()];
                }
                case 5: {
                    return " " + CMRInetManagerFrame.this.cmriNode.get(r).getcmriNodeDesc();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int r, int c) {
            switch (c) {
                case 0: {
                    CMRInetManagerFrame.this.cmriNode.get(r).setPollListPosition((Integer)value);
                    this.fireTableDataChanged();
                    break;
                }
                case 1: {
                    CMRInetManagerFrame.this.cmriNode.get(r).setPollingEnabled(!CMRInetManagerFrame.this.cmriNode.get(r).getPollingEnabled());
                    break;
                }
                case 4: {
                    CMRInetManagerFrame.this.cmriNode.get(r).setPollStatus(CMRInetManagerFrame.this.cmriNode.get(r).getPollStatus());
                }
            }
        }
    }
}

