/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.Bundle;
import jmri.jmrix.cmri.serial.SerialTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnoutManager
extends AbstractTurnoutManager {
    private int bitNum = 0;
    private int nAddress = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnoutManager.class);

    public SerialTurnoutManager(CMRISystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CMRISystemConnectionMemo getMemo() {
        return (CMRISystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = this.getMemo().normalizeSystemName(systemName);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Cannot create System Name from " + systemName);
        }
        Turnout t = (Turnout)this.getBySystemName(sName);
        if (t != null) {
            return t;
        }
        String altName = this.getMemo().convertSystemNameToAlternate(sName);
        t = (Turnout)this.getBySystemName(altName);
        if (t != null) {
            return t;
        }
        int nAddress = this.getMemo().getNodeAddressFromSystemName(sName);
        if (nAddress == -1) {
            throw new IllegalArgumentException("Cannot get Node Address from System Name " + systemName + " " + sName);
        }
        int bitNum = this.getMemo().getBitFromSystemName(sName);
        if (bitNum == 0) {
            throw new IllegalArgumentException("Cannot get Bit from System Name " + systemName + " " + sName);
        }
        String conflict = this.getMemo().isOutputBitFree(nAddress, bitNum);
        if (!conflict.isEmpty() && !conflict.equals(sName)) {
            log.error("{} assignment conflict with {}.", (Object)sName, (Object)conflict);
            throw new IllegalArgumentException(Bundle.getMessage("ErrorAssignDialog", bitNum, conflict));
        }
        t = new SerialTurnout(sName, userName, this.getMemo());
        if (!this.getMemo().validSystemNameConfig(sName, 'T', this.getMemo().getTrafficController())) {
            log.warn("Turnout '{}' refers to an undefined Serial Node.", (Object)sName);
        }
        return t;
    }

    @Deprecated
    public void notifyTurnoutCreationError(String conflict, int bitNum) {
        JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorAssignDialog", bitNum, conflict)) + "\n" + Bundle.getMessage("ErrorAssignLine2T"), Bundle.getMessage("ErrorAssignTitle"), 1, null);
    }

    @Override
    public int askNumControlBits(@Nonnull String systemName) {
        int iNum = this.selectNumberOfControlBits();
        if (iNum == -1) {
            iNum = 1;
            log.warn("User cancelled without selecting number of output bits. Defaulting to 1.");
        } else {
            ++iNum;
        }
        if (iNum == 2) {
            int nAddress = this.getMemo().getNodeAddressFromSystemName(systemName);
            if (nAddress == -1) {
                return 0;
            }
            int bitNum = this.getMemo().getBitFromSystemName(systemName);
            if (bitNum == 0) {
                return 0;
            }
            String conflict = this.getMemo().isOutputBitFree(nAddress, ++bitNum);
            if (!conflict.equals("")) {
                log.error("Assignment conflict with {}. Turnout not created.", (Object)conflict);
                this.notifySecondBitConflict(conflict, bitNum);
                return 0;
            }
        }
        return iNum;
    }

    @Override
    public int askControlType(@Nonnull String systemName) {
        int iType = this.selectOutputType();
        if (iType == -1) {
            iType = 0;
            log.warn("User cancelled without selecting output type. Defaulting to 'steady state'.");
        }
        return iType;
    }

    public int selectNumberOfControlBits() {
        return JOptionPane.showOptionDialog(null, Bundle.getMessage("QuestionBitsDialog"), Bundle.getMessage("CmriTurnoutTitle"), -1, 3, null, new String[]{Bundle.getMessage("BitOption1"), Bundle.getMessage("BitOption2")}, Bundle.getMessage("BitOption1"));
    }

    public int selectOutputType() {
        return JOptionPane.showOptionDialog(null, Bundle.getMessage("QuestionPulsedDialog"), Bundle.getMessage("CmriBitsTitle"), -1, 3, null, new String[]{Bundle.getMessage("PulsedOptionSteady"), Bundle.getMessage("PulsedOptionPulsed")}, Bundle.getMessage("PulsedOptionSteady"));
    }

    public void notifySecondBitConflict(String conflict, int bitNum) {
        JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorAssign2Dialog", bitNum, conflict)) + "\n" + Bundle.getMessage("ErrorAssignLine2X", Bundle.getMessage("BeanNameTurnout")), Bundle.getMessage("ErrorAssignTitle"), 1, null);
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public boolean isNumControlBitsSupported(@Nonnull String systemName) {
        return true;
    }

    @Override
    public boolean isControlTypeSupported(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String tmpSName;
        int seperator = 0;
        if (curAddress.contains(":")) {
            seperator = curAddress.indexOf(":");
            this.nAddress = Integer.parseInt(curAddress.substring(0, seperator));
            try {
                this.bitNum = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Part 2 of " + curAddress + " is not an integer");
            }
            tmpSName = this.getMemo().makeSystemName("T", this.nAddress, this.bitNum);
        } else if (curAddress.contains("B") || curAddress.contains("b")) {
            curAddress = curAddress.toUpperCase();
            try {
                Integer.parseInt(curAddress.substring(0, 1));
                int b = curAddress.toUpperCase().indexOf("B") + 1;
                Integer.parseInt(curAddress.substring(b));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " to a valid Hardware Address");
            }
            tmpSName = String.valueOf(prefix) + this.typeLetter() + curAddress;
            this.bitNum = this.getMemo().getBitFromSystemName(tmpSName);
            this.nAddress = this.getMemo().getNodeAddressFromSystemName(tmpSName);
        } else {
            try {
                Integer.parseInt(curAddress);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Address " + curAddress + " is not an integer");
            }
            tmpSName = String.valueOf(prefix) + "T" + curAddress;
            this.bitNum = this.getMemo().getBitFromSystemName(tmpSName);
            this.nAddress = this.getMemo().getNodeAddressFromSystemName(tmpSName);
        }
        return tmpSName;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = "";
        try {
            tmpSName = this.validateSystemNameFormat(this.createSystemName(curAddress, prefix));
        }
        catch (JmriException | NamedBean.BadNameException ex) {
            throw new JmriException(ex.getMessage());
        }
        Turnout t = (Turnout)this.getBySystemName(tmpSName);
        if (t == null && !ignoreInitialExisting) {
            int seperator = tmpSName.lastIndexOf("T") + 1;
            return tmpSName.substring(seperator);
        }
        int increment = t == null ? 1 : t.getNumberOutputBits();
        int x = 0;
        while (x < 10) {
            this.bitNum += increment;
            tmpSName = this.getMemo().makeSystemName("T", this.nAddress, this.bitNum);
            t = (Turnout)this.getBySystemName(tmpSName);
            if (t == null) {
                int seperator = tmpSName.lastIndexOf("T") + 1;
                return tmpSName.substring(seperator);
            }
            ++x;
        }
        throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, tmpSName));
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        systemName = this.validateSystemNamePrefix(systemName, locale);
        return this.getMemo().validateSystemNameFormat(super.validateSystemNameFormat(systemName, locale), this.typeLetter(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getMemo().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

