/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRNodeTrafficController;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.cmri.serial.SerialInterface;
import jmri.jmrix.cmri.serial.SerialListener;
import jmri.jmrix.cmri.serial.SerialMessage;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialReply;
import jmri.jmrix.cmri.serial.SerialSensorManager;
import jmri.jmrix.cmri.serial.cmrinetmetrics.CMRInetMetricsCollector;
import jmri.jmrix.cmri.serial.cmrinetmetrics.CMRInetMetricsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTrafficController
extends AbstractMRNodeTrafficController
implements SerialInterface {
    CMRInetMetricsCollector metricsCollector;
    SerialSensorManager mSensorManager = null;
    public boolean pollNetwork = true;
    private int initTimeout = 500;
    private int xmitTimeout = 2;
    public ArrayList<Integer> cmriNetPollList = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(SerialTrafficController.class);

    public SerialTrafficController() {
        super.init(0, 127);
        this.mWaitBeforePoll = 5;
        this.metricsCollector = new CMRInetMetricsCollector();
        this.addSerialListener(this.metricsCollector);
    }

    @Override
    public synchronized void addSerialListener(SerialListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeSerialListener(SerialListener l) {
        this.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSerialNode(SerialNode node) {
        SerialTrafficController serialTrafficController = this;
        synchronized (serialTrafficController) {
            int i = 0;
            while (i < this.getNumNodes()) {
                if (this.getNode(i) == node) {
                    this.setMustInit(i, true);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        log.warn("enterProgMode doesn't make sense for C/MRI serial");
        return null;
    }

    public CMRInetMetricsData getMetricsData() {
        return this.metricsCollector.getMetricData();
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((SerialListener)client).message((SerialMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((SerialListener)client).reply((SerialReply)m);
    }

    public void setSensorManager(SerialSensorManager m) {
        this.mSensorManager = m;
    }

    public void setPollNetwork(boolean OnOff) {
        this.pollNetwork = OnOff;
    }

    public boolean getPollNetwork() {
        return this.pollNetwork;
    }

    public void setInitTimeout(int init_Timeout) {
        this.initTimeout = init_Timeout;
    }

    public int getInitTimeout() {
        return this.initTimeout;
    }

    public void setXmitTimeout(int init_XmitTimeout) {
        this.xmitTimeout = init_XmitTimeout;
    }

    public int getXmitTimeout() {
        return this.xmitTimeout;
    }

    @Override
    protected synchronized AbstractMRMessage pollMessage() {
        log.trace("pollMessage starts");
        if (this.getNumNodes() <= 0) {
            log.trace("pollMessage ends with zero nodes");
            return null;
        }
        if (!this.getPollNetwork()) {
            log.trace("pollMessage ends with getPollNetwork disabled");
            return null;
        }
        int previousPollPointer = this.curSerialNodeIndex;
        this.updatePollPointer();
        SerialNode n = (SerialNode)this.getNode(this.curSerialNodeIndex);
        if (this.getMustInit(this.curSerialNodeIndex)) {
            this.setMustInit(this.curSerialNodeIndex, false);
            AbstractMRMessage m = this.getNode(this.curSerialNodeIndex).createInitPacket();
            log.debug("send init message: {}", (Object)m);
            m.setTimeout(500);
            n.setPollStatus(4);
            log.trace("pollMessage provides Init message");
            return m;
        }
        if (this.getNode(this.curSerialNodeIndex).mustSend()) {
            log.debug("request write command to send");
            this.getNode(this.curSerialNodeIndex).resetMustSend();
            AbstractMRMessage m = this.getNode(this.curSerialNodeIndex).createOutPacket();
            m.setTimeout(2);
            this.curSerialNodeIndex = previousPollPointer;
            log.trace("pollMessage provides Transmit message");
            return m;
        }
        if (!n.getPollingEnabled()) {
            n.setPollStatus(1);
            log.trace("pollMessage ends with getPollingEnabled disabled");
            return null;
        }
        if (this.getNode(this.curSerialNodeIndex).getSensorsActive()) {
            if (n.getPollStatus() != 2) {
                n.setPollStatus(2);
            }
            SerialMessage m = SerialMessage.getPoll(this.getNode(this.curSerialNodeIndex).getNodeAddress());
            log.trace("pollMessage ends with poll message");
            return m;
        }
        log.trace("pollMessage ends with no sensors active");
        return null;
    }

    private void updatePollPointer() {
        ++this.curSerialNodeIndex;
        if (this.curSerialNodeIndex >= this.getNumNodes()) {
            this.curSerialNodeIndex = 0;
        }
    }

    @Override
    protected synchronized void handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        SerialNode n = (SerialNode)this.getNode(this.curSerialNodeIndex);
        if (this.getNode(this.curSerialNodeIndex).handleTimeout(m, l)) {
            if (n.getPollingEnabled()) {
                n.setPollStatus(3);
                this.metricsCollector.getMetricData().incMetricErrValue(0);
            }
            this.setMustInit(this.curSerialNodeIndex, true);
        }
    }

    @Override
    protected synchronized void resetTimeout(AbstractMRMessage m) {
        this.getNode(this.curSerialNodeIndex).resetTimeout(m);
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return this.mSensorManager;
    }

    @Override
    public void sendSerialMessage(SerialMessage m, SerialListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        return new SerialReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        log.error("Not using endOfMessage, should not be called");
        return false;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        int i = 0;
        while (i < msg.maxSize()) {
            byte char1 = this.readByteProtected(istream);
            if (char1 == 3) break;
            if (char1 == 16) {
                char1 = this.readByteProtected(istream);
            }
            msg.setElement(i, char1 & 0xFF);
            ++i;
        }
    }

    @Override
    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
        while (this.readByteProtected(istream) != 2) {
        }
    }

    @Override
    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        msg[0] = -1;
        msg[1] = -1;
        msg[2] = 2;
        return 3;
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
        msg[offset] = 3;
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        int len = m.getNumDataElements();
        int cr = 4;
        return len + cr;
    }
}

