/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.Bundle;
import jmri.jmrix.cmri.serial.SerialListener;
import jmri.jmrix.cmri.serial.SerialMessage;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialReply;
import jmri.jmrix.cmri.serial.SerialSensor;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSensorManager
extends AbstractSensorManager
implements SerialListener {
    static final int SENSORSPERUA = 1000;
    private int bitNum = 0;
    private int nAddress = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialSensorManager.class);

    public SerialSensorManager(CMRISystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CMRISystemConnectionMemo getMemo() {
        return (CMRISystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = this.getMemo().normalizeSystemName(systemName);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Invalid C/MRI Sensor system name - " + systemName);
        }
        Sensor s = this.getBySystemName(sName);
        if (s != null) {
            throw new IllegalArgumentException("C/MRI Sensor with this name already exists - " + systemName);
        }
        String altName = this.getMemo().convertSystemNameToAlternate(sName);
        s = this.getBySystemName(altName);
        if (s != null) {
            throw new IllegalArgumentException("C/MRI Sensor with name  " + systemName + " already exists as " + altName);
        }
        int bit = this.getMemo().getBitFromSystemName(sName);
        if (bit <= 0 || bit >= 1000) {
            throw new IllegalArgumentException("Sensor bit number " + Integer.toString(bit) + " is outside the supported range 1-" + Integer.toString(999));
        }
        s = userName == null ? new SerialSensor(sName) : new SerialSensor(sName, userName);
        SerialNode node = (SerialNode)this.getMemo().getNodeFromSystemName(sName, this.getMemo().getTrafficController());
        if (node == null) {
            log.warn("Sensor {} refers to an undefined Serial Node.", (Object)sName);
            return s;
        }
        node.registerSensor(s, bit - 1);
        return s;
    }

    @Override
    public void message(SerialMessage r) {
        log.warn("unexpected message");
    }

    @Override
    public void reply(SerialReply r) {
        SerialNode node = (SerialNode)this.getMemo().getTrafficController().getNodeFromAddress(r.getUA());
        if (node != null) {
            node.markChanges(r);
        }
    }

    public void registerSensorsForNode(SerialNode node) {
        for (Sensor s : this.getNamedBeanSet()) {
            AbstractNode tNode;
            String sName = s.getSystemName();
            log.debug("system name is {}", (Object)sName);
            if (!sName.startsWith(this.getSystemNamePrefix()) || (tNode = this.getMemo().getNodeFromSystemName(sName, this.getMemo().getTrafficController())) != node) continue;
            node.registerSensor(s, this.getMemo().getBitFromSystemName(sName) - 1);
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String tmpSName = "";
        if (curAddress.contains(":")) {
            int seperator = curAddress.indexOf(":");
            try {
                this.nAddress = Integer.parseInt(curAddress.substring(0, seperator));
                this.bitNum = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " to a number.");
            }
            tmpSName = this.getMemo().makeSystemName("S", this.nAddress, this.bitNum);
        } else if (curAddress.contains("B") || curAddress.contains("b")) {
            curAddress = curAddress.toUpperCase();
            try {
                Integer.parseInt(curAddress.substring(0, 1));
                int b = curAddress.toUpperCase().indexOf("B") + 1;
                Integer.parseInt(curAddress.substring(b));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " to a number");
            }
            tmpSName = String.valueOf(prefix) + this.typeLetter() + curAddress;
            this.bitNum = this.getMemo().getBitFromSystemName(tmpSName);
            this.nAddress = this.getMemo().getNodeAddressFromSystemName(tmpSName);
        } else {
            try {
                Integer.parseInt(curAddress);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " to a valid Hardware Address");
            }
            tmpSName = String.valueOf(prefix) + this.typeLetter() + curAddress;
            this.bitNum = this.getMemo().getBitFromSystemName(tmpSName);
            this.nAddress = this.getMemo().getNodeAddressFromSystemName(tmpSName);
        }
        return tmpSName;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            int x = 1;
            while (x < 10) {
                ++this.bitNum;
                tmpSName = this.getMemo().makeSystemName("S", this.nAddress, this.bitNum);
                s = this.getBySystemName(tmpSName);
                if (s == null) {
                    int seperator = tmpSName.lastIndexOf("S") + 1;
                    curAddress = tmpSName.substring(seperator);
                    return curAddress;
                }
                ++x;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, tmpSName));
        }
        int seperator = tmpSName.lastIndexOf("S") + 1;
        curAddress = tmpSName.substring(seperator);
        return curAddress;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.getMemo().validateSystemNameFormat(super.validateSystemNameFormat(systemName, locale), this.typeLetter(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getMemo().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

