/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import java.util.Arrays;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.cmri.serial.SerialMessage;
import jmri.jmrix.cmri.serial.SerialReply;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNode
extends AbstractNode {
    static final int MAXSENSORS = 999;
    public static final int MAXSEARCHLIGHTBYTES = 48;
    public static final int MAXCARDLOCATIONBYTES = 64;
    public static final int SMINI = 1;
    public static final int USIC_SUSIC = 2;
    public static final int CPNODE = 3;
    public static final int CPMEGA = 4;
    public static final int NDP_USICSUSIC24 = 78;
    public static final int NDP_USICSUSIC32 = 88;
    public static final int NDP_SMINI = 77;
    public static final int NDP_CPNODE = 67;
    public static final int NDP_CPMEGA = 79;
    public static final byte INPUT_CARD = 1;
    public static final byte OUTPUT_CARD = 2;
    public static final byte NO_CARD = 0;
    protected int nodeType = 1;
    protected int bitsPerCard = 24;
    protected int transmissionDelay = 0;
    protected int pulseWidth = 500;
    protected int num2LSearchLights = 0;
    protected byte[] locSearchLightBits = new byte[48];
    protected byte[] cardTypeLocation = new byte[64];
    public static final int INITMSGLEN = 12;
    public static final int NUMCMRINETOPTS = 16;
    public static final int NUMCPNODEOPTS = 16;
    protected int[] cmrinetOptions = new int[16];
    protected int[] cpnodeOptions = new int[16];
    protected String cmriNodeDesc = "";
    protected int pollListPosition = 0;
    public int pollStatus = 1;
    public static final int POLLSTATUS_ERROR = 0;
    public static final int POLLSTATUS_IDLE = 1;
    public static final int POLLSTATUS_POLLING = 2;
    public static final int POLLSTATUS_TIMEOUT = 3;
    public static final int POLLSTATUS_INIT = 4;
    public static final int optbitNet_AUTOPOLL = 0;
    public static final int optbitNet_USECMRIX = 1;
    public static final int optbitNet_USEBCC = 2;
    public static final int optbitNet_BIT8 = 8;
    public static final int optbitNet_BIT15 = 15;
    public static final int optbitNode_USECMRIX = 0;
    public static final int optbitNode_SENDEOT = 1;
    public static final int optbitNode_USEBCC = 2;
    public static final int optbitNode_BIT8 = 8;
    public static final int optbitNode_BIT15 = 15;
    protected byte[] outputArray = new byte[256];
    protected boolean hasActiveSensors = false;
    protected int lastUsedSensor = 0;
    protected Sensor[] sensorArray = new Sensor[1000];
    protected int[] sensorLastSetting = new int[1000];
    protected int[] sensorTempSetting = new int[1000];
    protected boolean monitorNodePackets = true;
    protected boolean[] monitorPacketBits = new boolean[11];
    boolean warned = false;
    int timeout = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialNode.class);

    public SerialNode(SerialTrafficController tc) {
        this(0, 1, tc);
    }

    public SerialNode(int address, int type, SerialTrafficController tc) {
        this.setNodeAddress(address);
        this.setNodeType(type);
        this.bitsPerCard = 24;
        this.transmissionDelay = 0;
        this.num2LSearchLights = 0;
        int i = 0;
        while (i < 48) {
            this.locSearchLightBits[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 1000) {
            this.sensorArray[i] = null;
            this.sensorLastSetting[i] = 1;
            this.sensorTempSetting[i] = 1;
            ++i;
        }
        i = 0;
        while (i < 256) {
            this.outputArray[i] = 0;
            ++i;
        }
        this.setMustSend();
        this.hasActiveSensors = false;
        tc.registerNode(this);
    }

    public int getNum2LSearchLights() {
        return this.num2LSearchLights;
    }

    public void setNum2LSearchLights(int n) {
        this.num2LSearchLights = n;
    }

    public byte[] getLocSearchLightBits() {
        return Arrays.copyOf(this.locSearchLightBits, this.locSearchLightBits.length);
    }

    public void setLocSearchLightBits(int num, int value) {
        this.locSearchLightBits[num] = (byte)(value & 0xFF);
    }

    public byte[] getCardTypeLocation() {
        return Arrays.copyOf(this.cardTypeLocation, this.cardTypeLocation.length);
    }

    public void setCardTypeLocation(int num, int value) {
        if (num < 0 || num >= 64) {
            log.error("setCardTypeLocation - invalid num (index) - {}", (Object)num);
            return;
        }
        int val = value & 0xFF;
        if (val != 0 && val != 1 && val != 2) {
            log.error("setCardTypeLocation - invalid value - {}", (Object)val);
            return;
        }
        this.cardTypeLocation[num] = (byte)val;
    }

    public void setOutputBit(int bitNumber, boolean state) {
        int byteNumber = (bitNumber - 1) / 8;
        if (byteNumber > this.numOutputCards() * (this.bitsPerCard / 8)) {
            this.warn("C/MRI - Output bit out-of-range for defined node");
        }
        if (byteNumber >= 256) {
            byteNumber = 255;
        }
        byte bit = (byte)(1 << (bitNumber - 1) % 8);
        byte oldByte = this.outputArray[byteNumber];
        if (state) {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] & ~bit);
        } else {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] | bit);
        }
        if (oldByte != this.outputArray[byteNumber]) {
            this.setMustSend();
        }
    }

    public boolean getOutputBit(int bitNumber) {
        int byteNumber = (bitNumber - 1) / 8;
        if (byteNumber > this.numOutputCards() * (this.bitsPerCard / 8)) {
            this.warn("C/MRI - Output bit out-of-range for defined node");
        }
        if (byteNumber >= 256) {
            byteNumber = 255;
        }
        byte bit = (byte)(1 << (bitNumber - 1) % 8);
        byte testByte = this.outputArray[byteNumber];
        return (testByte = (byte)(testByte & bit)) == 0;
    }

    @Override
    public boolean getSensorsActive() {
        return this.hasActiveSensors;
    }

    public void setSensorsActive(boolean flag) {
        this.hasActiveSensors = flag;
    }

    public int numInputCards() {
        int result = 0;
        int i = 0;
        while (i < this.cardTypeLocation.length) {
            if (this.cardTypeLocation[i] == 1) {
                ++result;
            }
            ++i;
        }
        switch (this.nodeType) {
            case 1: {
                if (result == 1) break;
                this.warn("C/MRI SMINI with " + result + " INPUT cards");
                break;
            }
            case 2: {
                if (result < 64) break;
                this.warn("C/MRI USIC/SUSIC node with " + result + " INPUT cards");
                break;
            }
            case 3: {
                if (result >= 2) break;
                this.warn("C/MRI CPNODE node with " + result + " INPUT cards");
                break;
            }
            case 4: {
                if (result >= 1) break;
                this.warn("C/MRI CPMEGA node with " + result + " INPUT cards");
                break;
            }
        }
        return result;
    }

    public int numOutputCards() {
        int result = 0;
        int i = 0;
        while (i < this.cardTypeLocation.length) {
            if (this.cardTypeLocation[i] == 2) {
                ++result;
            }
            ++i;
        }
        switch (this.nodeType) {
            case 1: {
                if (result == 2) break;
                this.warn("C/MRI SMINI with " + result + " OUTPUT cards");
                break;
            }
            case 2: {
                if (result < 64) break;
                this.warn("C/MRI  USIC/SUSIC node with " + result + " OUTPUT cards");
                break;
            }
            case 3: {
                if (result >= 2) break;
                this.warn("C/MRI  CPNODE node with " + result + " OUTPUT cards");
                break;
            }
            case 4: {
                if (result >= 1) break;
                this.warn("C/MRI  CPMEGA node with " + result + " OUTPUT cards");
            }
        }
        return result;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int type) {
        switch (type) {
            case 1: {
                this.nodeType = type;
                this.bitsPerCard = 24;
                this.cardTypeLocation[0] = 2;
                this.cardTypeLocation[1] = 2;
                this.cardTypeLocation[2] = 1;
                int i = 3;
                while (i < 64) {
                    this.cardTypeLocation[i] = 0;
                    ++i;
                }
                break;
            }
            case 2: {
                this.nodeType = type;
                int i = 0;
                while (i < 64) {
                    this.cardTypeLocation[i] = 0;
                    ++i;
                }
                break;
            }
            case 3: {
                this.nodeType = type;
                this.bitsPerCard = 8;
                this.cardTypeLocation[0] = 1;
                this.cardTypeLocation[1] = 1;
                this.cardTypeLocation[2] = 2;
                this.cardTypeLocation[3] = 2;
                int i = 4;
                while (i < 64) {
                    this.cardTypeLocation[i] = 0;
                    ++i;
                }
                break;
            }
            case 4: {
                this.nodeType = type;
                this.bitsPerCard = 8;
                this.cardTypeLocation[0] = 1;
                this.cardTypeLocation[1] = 0;
                this.cardTypeLocation[2] = 0;
                this.cardTypeLocation[3] = 0;
                this.cardTypeLocation[4] = 0;
                this.cardTypeLocation[5] = 0;
                this.cardTypeLocation[6] = 0;
                this.cardTypeLocation[7] = 0;
                int i = 8;
                while (i < 64) {
                    this.cardTypeLocation[i] = 0;
                    ++i;
                }
                break;
            }
            default: {
                log.error("Bad node type - {}", (Object)Integer.toString(type));
            }
        }
    }

    public int getNumBitsPerCard() {
        return this.bitsPerCard;
    }

    public void setNumBitsPerCard(int bits) {
        if (bits == 24 || bits == 32 || bits == 16 || bits == 8) {
            this.bitsPerCard = bits;
        } else {
            log.warn("unexpected number of bits per card: {}", (Object)Integer.toString(bits));
            this.bitsPerCard = bits;
        }
    }

    public int getCMRInetOpts(int optionbit) {
        return this.cmrinetOptions[optionbit];
    }

    public void setCMRInetOpts(int optionbit, int val) {
        this.cmrinetOptions[optionbit] = (byte)val;
    }

    public boolean isCMRInetBit(int optionbit) {
        return this.cmrinetOptions[optionbit] == 1;
    }

    public int getcpnodeOpts(int optionbit) {
        return this.cpnodeOptions[optionbit];
    }

    public void setcpnodeOpts(int optionbit, int val) {
        this.cpnodeOptions[optionbit] = (byte)val;
    }

    public boolean iscpnodeBit(int optionbit) {
        return this.cpnodeOptions[optionbit] == 1;
    }

    public boolean getOptNet_AUTOPOLL() {
        return this.cmrinetOptions[0] == 1;
    }

    public boolean getOptNet_USECMRIX() {
        return this.cmrinetOptions[1] == 1;
    }

    public boolean getOptNet_USEBCC() {
        return this.cmrinetOptions[2] == 1;
    }

    public boolean getOptNet_BIT8() {
        return this.cmrinetOptions[8] == 1;
    }

    public boolean getOptNet_BIT15() {
        return this.cmrinetOptions[15] == 1;
    }

    public void setOptNet_AUTOPOLL(int val) {
        this.cmrinetOptions[0] = (byte)val;
    }

    public void setOptNet_USECMRIX(int val) {
        this.cmrinetOptions[1] = (byte)val;
    }

    public void setOptNet_USEBCC(int val) {
        this.cmrinetOptions[2] = (byte)val;
    }

    public void setOptNet_BIT8(int val) {
        this.cmrinetOptions[8] = (byte)val;
    }

    public void setOptNet_BIT15(int val) {
        this.cmrinetOptions[15] = (byte)val;
    }

    public int getOptNet_byte0() {
        return this.cmrinetOptions[0];
    }

    public int getOptNet_byte1() {
        return this.cmrinetOptions[1];
    }

    public boolean getOptNode_SENDEOT() {
        return this.cpnodeOptions[1] == 1;
    }

    public boolean getOptNode_USECMRIX() {
        return this.cpnodeOptions[0] == 1;
    }

    public boolean getOptNode_USEBCC() {
        return this.cpnodeOptions[2] == 1;
    }

    public boolean getOptNode_BIT8() {
        return this.cpnodeOptions[8] == 1;
    }

    public boolean getOptNode_BIT15() {
        return this.cpnodeOptions[15] == 1;
    }

    public void setOptNode_SENDEOT(int val) {
        this.cpnodeOptions[1] = (byte)val;
    }

    public void setOptNode_USECMRIX(int val) {
        this.cpnodeOptions[0] = (byte)val;
    }

    public void setOptNode_USEBCC(int val) {
        this.cpnodeOptions[2] = (byte)val;
    }

    public void setOptNode_BIT8(int val) {
        this.cpnodeOptions[8] = (byte)val;
    }

    public void setOptNode_BIT15(int val) {
        this.cpnodeOptions[15] = (byte)val;
    }

    public int getOptNode_byte0() {
        return this.cpnodeOptions[0];
    }

    public int getOptNode_byte1() {
        return this.cpnodeOptions[1];
    }

    public String getcmriNodeDesc() {
        return this.cmriNodeDesc;
    }

    public void setcmriNodeDesc(String nodeDesc) {
        this.cmriNodeDesc = nodeDesc;
    }

    public int getPollListPosition() {
        return this.pollListPosition;
    }

    public void setPollListPosition(int pos) {
        this.pollListPosition = pos;
    }

    public int getPollStatus() {
        return this.pollStatus;
    }

    public void setPollStatus(int status) {
        this.pollStatus = status;
    }

    public boolean getPollingEnabled() {
        return this.cmrinetOptions[0] == 1;
    }

    public void setPollingEnabled(boolean isEnabled) {
        this.cmrinetOptions[0] = isEnabled ? 1 : 0;
    }

    public boolean getMonitorNodePackets() {
        return this.monitorNodePackets;
    }

    public void setMonitorNodePackets(boolean onoff) {
        this.monitorNodePackets = onoff;
    }

    public void setMonitorPacketBit(int pktTypeBit, boolean onoff) {
        this.monitorPacketBits[pktTypeBit] = onoff;
    }

    public boolean getMonitorPacketBit(int pktTypeBit) {
        return this.monitorPacketBits[pktTypeBit];
    }

    @Override
    protected boolean checkNodeAddress(int address) {
        return address >= 0 && address < 128;
    }

    public int getTransmissionDelay() {
        return this.transmissionDelay;
    }

    public void setTransmissionDelay(int delay) {
        if (delay < 0 || delay > 65535) {
            log.warn("transmission delay out of 0-65535 range: {}", (Object)Integer.toString(delay));
            if (delay < 0) {
                delay = 0;
            }
            if (delay > 65535) {
                delay = 65535;
            }
        }
        this.transmissionDelay = delay;
    }

    public int getPulseWidth() {
        return this.pulseWidth;
    }

    public void setPulseWidth(int width) {
        if (width < 100 || width > 10000) {
            log.warn("pulse width out of 100 - 10000 range: {}", (Object)Integer.toString(width));
            if (width < 100) {
                width = 100;
            }
            if (width > 10000) {
                width = 10000;
            }
        }
        this.pulseWidth = width;
    }

    public void setCardTypeByAddress(int address, int type) {
        if (address < 0 || address > 63) {
            log.error("illegal card address: {}", (Object)Integer.toString(address));
            return;
        }
        if (type != 2 && type != 1 && type != 0) {
            log.error("illegal card type: {}", (Object)Integer.toString(type));
            this.cardTypeLocation[address] = 0;
            return;
        }
        if (this.nodeType == 1 && (address > 2 && type != 0 || address == 2 && type != 1 || address < 2 && type != 2)) {
            log.error("illegal card type/address specification for SMINI");
            return;
        }
        this.cardTypeLocation[address] = (byte)type;
    }

    public boolean isOutputCard(int cardNum) {
        if (cardNum > 63) {
            this.warn("C/MRI - isOutputCard - cardNum out of range");
            return false;
        }
        if (this.nodeType == 1) {
            return cardNum == 0 || cardNum == 1;
        }
        return this.cardTypeLocation[cardNum] == 2;
    }

    public boolean isInputCard(int cardNum) {
        if (cardNum > 63) {
            this.warn("C/MRI - isInputCard - cardNum out of range");
            return false;
        }
        if (this.nodeType == 1) {
            return cardNum == 2;
        }
        return this.cardTypeLocation[cardNum] == 1;
    }

    public int getOutputCardIndex(int cardNum) {
        if (this.nodeType == 1) {
            if (cardNum == 0 || cardNum == 1) {
                return cardNum;
            }
        } else {
            int index = 0;
            int i = 0;
            while (i < this.cardTypeLocation.length) {
                if (this.cardTypeLocation[i] == 2) {
                    if (i == cardNum) {
                        return index;
                    }
                    ++index;
                }
                ++i;
            }
        }
        this.warn("C/MRI - input card to getOutputCardIndex is not an Output Card");
        return 0;
    }

    public int getInputCardIndex(int cardNum) {
        if (this.nodeType == 1) {
            if (cardNum == 2) {
                return 0;
            }
        } else {
            int index = 0;
            int i = 0;
            while (i < this.cardTypeLocation.length) {
                if (this.cardTypeLocation[i] == 1) {
                    if (i == cardNum) {
                        return index;
                    }
                    ++index;
                }
                ++i;
            }
        }
        this.warn("C/MRI - input card to getOutputCardIndex is not an Output Card");
        return 0;
    }

    public void set2LeadSearchLight(int bit) {
        if (this.nodeType != 1) {
            log.error("Invalid setting of Searchlights bits - not SMINI node");
            return;
        }
        if (bit < 0 || bit > 46) {
            log.error("Invalid bit number when setting SMINI Searchlights bits: {}", (Object)Integer.toString(bit));
            return;
        }
        if (this.locSearchLightBits[bit] != 0 || this.locSearchLightBits[bit + 1] != 0) {
            log.error("bit number for SMINI Searchlights bits already set: {}", (Object)Integer.toString(bit));
            return;
        }
        this.locSearchLightBits[bit] = 1;
        this.locSearchLightBits[bit + 1] = 1;
        ++this.num2LSearchLights;
    }

    public void clear2LeadSearchLight(int bit) {
        if (this.nodeType != 1) {
            log.error("Invalid setting of Searchlights bits - not SMINI node");
            return;
        }
        if (bit < 0 || bit > 46) {
            log.error("Invalid bit number when setting SMINI Searchlights bits: {}", (Object)Integer.toString(bit));
            return;
        }
        if (this.locSearchLightBits[bit] != 1 || this.locSearchLightBits[bit + 1] != 1) {
            log.error("bit number for SMINI Searchlights bits already clear: {}", (Object)Integer.toString(bit));
            return;
        }
        this.locSearchLightBits[bit] = 0;
        this.locSearchLightBits[bit + 1] = 0;
        --this.num2LSearchLights;
    }

    public boolean isSearchLightBit(int bit) {
        if (this.nodeType != 1) {
            log.error("Invalid query of Searchlights bits - not SMINI node");
            return false;
        }
        if (bit < 0 || bit > 47) {
            log.error("Invalid bit number in query of SMINI Searchlights bits: {}", (Object)Integer.toString(bit));
            return false;
        }
        return this.locSearchLightBits[bit] == 1;
    }

    @Override
    public AbstractMRMessage createInitPacket() {
        int nInitBytes = 4;
        byte[] initBytes = new byte[20];
        int code = 0;
        switch (this.nodeType) {
            case 1: {
                initBytes[0] = 77;
                break;
            }
            case 2: {
                if (this.bitsPerCard == 24) {
                    initBytes[0] = 78;
                    break;
                }
                if (this.bitsPerCard != 32) break;
                initBytes[0] = 88;
                break;
            }
            case 3: {
                initBytes[0] = 67;
                break;
            }
            case 4: {
                initBytes[0] = 79;
            }
        }
        int firstByte = this.transmissionDelay / 256;
        int secondByte = this.transmissionDelay - firstByte * 256;
        if (firstByte > 255) {
            firstByte = 255;
        }
        initBytes[1] = (byte)firstByte;
        initBytes[2] = (byte)secondByte;
        switch (this.nodeType) {
            case 1: {
                initBytes[3] = (byte)this.num2LSearchLights;
                if (this.num2LSearchLights <= 0) break;
                int i = 0;
                int j = 0;
                while (i < 6) {
                    code = this.locSearchLightBits[j];
                    code += this.locSearchLightBits[j + 1] * 2;
                    code += this.locSearchLightBits[j + 2] * 4;
                    code += this.locSearchLightBits[j + 3] * 8;
                    code += this.locSearchLightBits[j + 4] * 16;
                    code += this.locSearchLightBits[j + 5] * 32;
                    code += this.locSearchLightBits[j + 6] * 64;
                    initBytes[nInitBytes] = (byte)(code += this.locSearchLightBits[j + 7] * 128);
                    ++nInitBytes;
                    ++i;
                    j += 8;
                }
                break;
            }
            case 2: {
                int numCards = this.numInputCards() + this.numOutputCards();
                int numFours = numCards / 4;
                if (numCards - numFours * 4 > 0) {
                    ++numFours;
                }
                initBytes[3] = (byte)numFours;
                int i = 0;
                int j = 0;
                while (i < numFours) {
                    code = this.cardTypeLocation[j];
                    code += this.cardTypeLocation[j + 1] * 4;
                    code += this.cardTypeLocation[j + 2] * 16;
                    initBytes[nInitBytes] = (byte)(code += this.cardTypeLocation[j + 3] * 64);
                    ++nInitBytes;
                    ++i;
                    j += 4;
                }
                break;
            }
            case 3: {
                nInitBytes = 3;
                int i = 0;
                int j = 0;
                while (i < 2) {
                    code = this.cpnodeOptions[j];
                    code += this.cpnodeOptions[j + 1] * 2;
                    code += this.cpnodeOptions[j + 2] * 4;
                    code += this.cpnodeOptions[j + 3] * 8;
                    code += this.cpnodeOptions[j + 4] * 16;
                    code += this.cpnodeOptions[j + 5] * 32;
                    code += this.cpnodeOptions[j + 6] * 64;
                    initBytes[nInitBytes] = (byte)(code += this.cpnodeOptions[j + 7] * 128);
                    ++nInitBytes;
                    ++i;
                    j += 8;
                }
                initBytes[nInitBytes++] = (byte)this.numInputCards();
                initBytes[nInitBytes++] = (byte)this.numOutputCards();
                i = nInitBytes;
                while (i < 13) {
                    initBytes[i] = -1;
                    ++nInitBytes;
                    ++i;
                }
                break;
            }
            case 4: {
                nInitBytes = 3;
                int i = 0;
                int j = 0;
                while (i < 2) {
                    code = this.cpnodeOptions[j];
                    code += this.cpnodeOptions[j + 1] * 2;
                    code += this.cpnodeOptions[j + 2] * 4;
                    code += this.cpnodeOptions[j + 3] * 8;
                    code += this.cpnodeOptions[j + 4] * 16;
                    code += this.cpnodeOptions[j + 5] * 32;
                    code += this.cpnodeOptions[j + 6] * 64;
                    initBytes[nInitBytes] = (byte)(code += this.cpnodeOptions[j + 7] * 128);
                    ++nInitBytes;
                    ++i;
                    j += 8;
                }
                initBytes[nInitBytes++] = (byte)this.numInputCards();
                initBytes[nInitBytes++] = (byte)this.numOutputCards();
                i = nInitBytes;
                while (i < 13) {
                    initBytes[i] = -1;
                    ++nInitBytes;
                    ++i;
                }
                break;
            }
            default: {
                log.error("Invalid node type ({}) in SerialNode Init Message", (Object)this.nodeType);
            }
        }
        int nDLE = 0;
        int i = 1;
        while (i < nInitBytes) {
            if (initBytes[i] == 2 || initBytes[i] == 3 || initBytes[i] == 16) {
                ++nDLE;
            }
            ++i;
        }
        SerialMessage m = new SerialMessage(nInitBytes + nDLE + 2);
        m.setElement(0, this.getNodeAddress() + 65);
        m.setElement(1, 73);
        int k = 2;
        int i2 = 0;
        while (i2 < nInitBytes) {
            if (initBytes[i2] == 2 || initBytes[i2] == 3 || initBytes[i2] == 16) {
                m.setElement(k, 16);
                ++k;
            }
            m.setElement(k, initBytes[i2]);
            ++k;
            ++i2;
        }
        return m;
    }

    @Override
    public AbstractMRMessage createOutPacket() {
        int nOutBytes = this.numOutputCards() * (this.bitsPerCard / 8);
        int nDLE = 0;
        int i = 0;
        while (i < nOutBytes) {
            if (this.outputArray[i] == 2 || this.outputArray[i] == 3 || this.outputArray[i] == 16) {
                ++nDLE;
            }
            ++i;
        }
        SerialMessage m = new SerialMessage(nOutBytes + nDLE + 2);
        m.setElement(0, this.getNodeAddress() + 65);
        m.setElement(1, 84);
        int k = 2;
        int i2 = 0;
        while (i2 < nOutBytes) {
            if (this.outputArray[i2] == 2 || this.outputArray[i2] == 3 || this.outputArray[i2] == 16) {
                m.setElement(k, 16);
                ++k;
            }
            m.setElement(k, this.outputArray[i2]);
            ++k;
            ++i2;
        }
        return m;
    }

    void warn(String s) {
        if (this.warned) {
            return;
        }
        this.warned = true;
        log.warn(s);
    }

    public void markChanges(SerialReply l) {
        try {
            int i = 0;
            while (i <= this.lastUsedSensor) {
                int loc;
                if (this.sensorArray[i] != null && (loc = i / 8) + 2 < l.getNumDataElements()) {
                    int bit = i % 8;
                    boolean value = (l.getElement(loc + 2) >> bit & 1) == 1 ^ this.sensorArray[i].getInverted();
                    if (value) {
                        if ((this.sensorTempSetting[i] == 2 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 2) {
                            this.sensorLastSetting[i] = 2;
                            this.sensorArray[i].setKnownState(2);
                        }
                        this.sensorTempSetting[i] = 2;
                    } else {
                        if ((this.sensorTempSetting[i] == 4 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 4) {
                            this.sensorLastSetting[i] = 4;
                            this.sensorArray[i].setKnownState(4);
                        }
                        this.sensorTempSetting[i] = 4;
                    }
                }
                ++i;
            }
        }
        catch (JmriException e) {
            log.error("exception in markChanges: {}", (Throwable)e);
        }
    }

    public void registerSensor(Sensor s, int i) {
        if (i < 0 || i > this.numInputCards() * this.bitsPerCard - 1 || i > 999) {
            log.error("Unexpected sensor ordinal in registerSensor: {}", (Object)Integer.toString(i + 1));
            return;
        }
        this.hasActiveSensors = true;
        if (this.sensorArray[i] == null) {
            this.sensorArray[i] = s;
            if (this.lastUsedSensor < i) {
                this.lastUsedSensor = i;
            }
        } else {
            log.warn("multiple registration of same sensor: CS{}", (Object)Integer.toString(this.getNodeAddress() * 1000 + i + 1));
        }
    }

    public boolean isPollingOK() {
        return this.timeout == 0;
    }

    @Override
    public boolean handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        ++this.timeout;
        if (m.getElement(1) != 80) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.warn("Timeout to poll for UA={}: consecutive timeouts: {}", (Object)this.getNodeAddress(), (Object)this.timeout);
        }
        if (this.timeout > 5) {
            this.timeout = 1;
            this.setMustSend();
            int i = 0;
            while (i <= this.lastUsedSensor) {
                if (this.sensorArray[i] != null) {
                    this.sensorLastSetting[i] = 1;
                    this.sensorTempSetting[i] = 1;
                    try {
                        this.sensorArray[i].setKnownState(1);
                    }
                    catch (JmriException e) {
                        log.error("unexpected exception setting sensor i={} on node {}e: {}", new Object[]{i, this.getNodeAddress(), e});
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetTimeout(AbstractMRMessage m) {
        if (this.timeout > 0) {
            log.debug("Reset {} timeout count", (Object)this.timeout);
        }
        this.timeout = 0;
    }
}

