/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.Bundle;
import jmri.jmrix.cmri.serial.SerialLight;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLightManager
extends AbstractLightManager {
    private static final Logger log = LoggerFactory.getLogger(SerialLightManager.class);

    public SerialLightManager(CMRISystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CMRISystemConnectionMemo getMemo() {
        return (CMRISystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        SerialLight lgt = null;
        int nAddress = this.getMemo().getNodeAddressFromSystemName(systemName);
        if (nAddress == -1) {
            throw new IllegalArgumentException("Invalid Node Address from System Name: " + systemName);
        }
        int bitNum = this.getMemo().getBitFromSystemName(systemName);
        if (bitNum == 0) {
            throw new IllegalArgumentException("Invalid Bit from System Name: " + systemName);
        }
        String conflict = this.getMemo().isOutputBitFree(nAddress, bitNum);
        if (!conflict.isEmpty()) {
            log.error("Assignment conflict with {}.  Light not created.", (Object)conflict);
            throw new IllegalArgumentException(Bundle.getMessage("ErrorAssignDialog", bitNum, conflict));
        }
        if (this.getMemo().validSystemNameFormat(systemName, 'L') == Manager.NameValidity.VALID) {
            lgt = new SerialLight(systemName, userName, this.getMemo());
            if (!this.getMemo().validSystemNameConfig(systemName, 'L', this.getMemo().getTrafficController())) {
                log.warn("Light system Name does not refer to configured hardware: {}", (Object)systemName);
            }
        } else {
            log.error("Invalid Light system Name format: {}", (Object)systemName);
            throw new IllegalArgumentException("Invalid Light system Name format: " + systemName);
        }
        return lgt;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.getMemo().validateSystemNameFormat(super.validateSystemNameFormat(systemName, locale), this.typeLetter(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getMemo().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return this.getMemo().validSystemNameConfig(systemName, 'L', this.getMemo().getTrafficController());
    }

    @Override
    @Nonnull
    public String convertSystemNameToAlternate(@Nonnull String systemName) {
        return this.getMemo().convertSystemNameToAlternate(systemName);
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

