/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.implementation.AbstractLight;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLight
extends AbstractLight {
    CMRISystemConnectionMemo _memo = null;
    int mBit = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialLight.class);

    public SerialLight(String systemName, CMRISystemConnectionMemo memo) {
        super(systemName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    public SerialLight(String systemName, String userName, CMRISystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        this.mBit = this._memo.getBitFromSystemName(systemName);
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        SerialNode mNode = (SerialNode)this._memo.getNodeFromSystemName(this.getSystemName(), this._memo.getTrafficController());
        if (mNode != null) {
            if (newState == 2) {
                mNode.setOutputBit(this.mBit, false);
            } else if (newState == 4) {
                mNode.setOutputBit(this.mBit, true);
            } else {
                log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            }
        }
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return CMRISystemConnectionMemo.compareSystemNameSuffix(suffix1, suffix2);
    }
}

