/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri;

import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.cmri.Bundle;
import jmri.jmrix.cmri.serial.SerialLightManager;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialSensorManager;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import jmri.jmrix.cmri.serial.SerialTurnoutManager;
import jmri.jmrix.cmri.swing.CMRIComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMRISystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private SerialTrafficController tc = null;
    ComponentFactory cf = null;
    private static final Logger log = LoggerFactory.getLogger(CMRISystemConnectionMemo.class);

    public CMRISystemConnectionMemo() {
        this("C", "C/MRI");
    }

    public CMRISystemConnectionMemo(@Nonnull String prefix, @Nonnull String userName) {
        super(prefix, userName);
        InstanceManager.store(this, CMRISystemConnectionMemo.class);
        this.cf = new CMRIComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created CMRISystemConnectionMemo");
    }

    public void setTrafficController(SerialTrafficController s) {
        this.tc = s;
    }

    public SerialTrafficController getTrafficController() {
        if (this.tc == null) {
            this.setTrafficController(new SerialTrafficController());
            log.debug("Auto create of SerialTrafficController for initial configuration");
        }
        return this.tc;
    }

    public String getUserNameFromSystemName(String systemName) {
        int offset = this.checkSystemPrefix(systemName);
        if (offset < 1) {
            return "";
        }
        if (systemName.length() < offset + 1) {
            return "";
        }
        switch (systemName.charAt(offset)) {
            case 'S': {
                Sensor s = InstanceManager.sensorManagerInstance().getBySystemName(systemName);
                if (s != null) {
                    return s.getUserName();
                }
                return "";
            }
            case 'T': {
                Turnout t = InstanceManager.turnoutManagerInstance().getBySystemName(systemName);
                if (t != null) {
                    return t.getUserName();
                }
                return "";
            }
            case 'L': {
                Light lgt = InstanceManager.lightManagerInstance().getBySystemName(systemName);
                if (lgt != null) {
                    return lgt.getUserName();
                }
                return "";
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getBitFromSystemName(String systemName) {
        int offset = this.checkSystemPrefix(systemName);
        if (offset < 1) {
            return 0;
        }
        if (this.validSystemNameFormat(systemName, systemName.charAt(offset)) != Manager.NameValidity.VALID) {
            return 0;
        }
        int k = 0;
        int i = offset + 1;
        while (i < systemName.length() && k == 0) {
            if (systemName.charAt(i) == 'B') {
                k = i + 1;
            }
            ++i;
        }
        if (k == 0) {
            int num;
            try {
                num = Integer.parseInt(systemName.substring(offset + 1));
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("invalid character in number field of system name: {}", (Object)systemName);
                return 0;
            }
            if (num > 0) {
                return num - num / 1000 * 1000;
            }
            log.warn("invalid CMRI system name: {}", (Object)systemName);
            return 0;
        }
        try {
            return Integer.parseInt(systemName.substring(k));
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("invalid character in bit number field of CMRI system name: {}", (Object)systemName);
            return 0;
        }
    }

    public int checkSystemPrefix(String systemName) {
        if (!systemName.startsWith(this.getSystemPrefix())) {
            return -1;
        }
        return this.getSystemPrefix().length();
    }

    public String isOutputBitFree(int nAddress, int bitNum) {
        if (nAddress < 0 || nAddress > 127) {
            log.warn("invalid node address in free bit test");
            return "";
        }
        if (bitNum < 1 || bitNum > 2048) {
            log.warn("invalid bit number in free bit test");
            return "";
        }
        String sysName = this.makeSystemName("T", nAddress, bitNum);
        Turnout t = InstanceManager.turnoutManagerInstance().getBySystemName(sysName);
        if (t != null) {
            return sysName;
        }
        String altName = this.convertSystemNameToAlternate(sysName);
        t = InstanceManager.turnoutManagerInstance().getBySystemName(altName);
        if (t != null) {
            return altName;
        }
        if (bitNum > 1) {
            sysName = this.makeSystemName("T", nAddress, bitNum - 1);
            t = InstanceManager.turnoutManagerInstance().getBySystemName(sysName);
            if (t != null) {
                if (t.getNumberOutputBits() == 2) {
                    return sysName;
                }
            } else {
                altName = this.convertSystemNameToAlternate(sysName);
                t = InstanceManager.turnoutManagerInstance().getBySystemName(altName);
                if (t != null && t.getNumberOutputBits() == 2) {
                    return altName;
                }
            }
        }
        sysName = this.makeSystemName("L", nAddress, bitNum);
        Light lgt = InstanceManager.lightManagerInstance().getBySystemName(sysName);
        if (lgt != null) {
            return sysName;
        }
        altName = this.convertSystemNameToAlternate(sysName);
        lgt = InstanceManager.lightManagerInstance().getBySystemName(altName);
        if (lgt != null) {
            return altName;
        }
        return "";
    }

    public String normalizeSystemName(String systemName) {
        String nName;
        int offset = this.checkSystemPrefix(systemName);
        if (offset < 1) {
            return "";
        }
        if (this.validSystemNameFormat(systemName, systemName.charAt(offset)) != Manager.NameValidity.VALID) {
            return "";
        }
        String s = "";
        int k = 0;
        boolean noB = true;
        int i = offset + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(offset + 1, i);
                k = i + 1;
                noB = false;
            }
            ++i;
        }
        if (noB) {
            int num = Integer.parseInt(systemName.substring(offset + 1));
            int nAddress = num / 1000;
            int bitNum = num - nAddress * 1000;
            nName = String.valueOf(systemName.substring(0, offset + 1)) + Integer.toString(nAddress * 1000 + bitNum);
        } else {
            int nAddress = Integer.parseInt(s);
            int bitNum = Integer.parseInt(systemName.substring(k, systemName.length()));
            nName = String.valueOf(systemName.substring(0, offset + 1)) + Integer.toString(nAddress) + "B" + Integer.toString(bitNum);
        }
        return nName;
    }

    public String convertSystemNameToAlternate(String systemName) {
        String altName;
        int offset = this.checkSystemPrefix(systemName);
        if (offset < 1) {
            log.error("invalid system prefix in CMRI system name: {}", (Object)systemName);
            return "";
        }
        if (this.validSystemNameFormat(systemName, systemName.charAt(offset)) != Manager.NameValidity.VALID) {
            return "";
        }
        String s = "";
        int k = 0;
        boolean noB = true;
        int i = offset + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(offset + 1, i);
                k = i + 1;
                noB = false;
            }
            ++i;
        }
        if (noB) {
            int num = Integer.parseInt(systemName.substring(offset + 1));
            int nAddress = num / 1000;
            int bitNum = num - nAddress * 1000;
            altName = String.valueOf(systemName.substring(0, offset + 1)) + Integer.toString(nAddress) + "B" + Integer.toString(bitNum);
        } else {
            int nAddress = Integer.parseInt(s);
            int bitNum = Integer.parseInt(systemName.substring(k, systemName.length()));
            if (bitNum > 999) {
                return "";
            }
            altName = String.valueOf(systemName.substring(0, offset + 1)) + Integer.toString(nAddress * 1000 + bitNum);
        }
        return altName;
    }

    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type) {
        int num;
        int offset = this.checkSystemPrefix(systemName);
        if (offset < 1) {
            log.debug("invalid system prefix in CMRI system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        if (systemName.charAt(offset) != type) {
            log.debug("invalid type character in CMRI system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        String s = "";
        int k = 0;
        boolean noB = true;
        int i = offset + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(offset + 1, i);
                k = i + 1;
                noB = false;
            }
            ++i;
        }
        if (noB) {
            try {
                num = Integer.parseInt(systemName.substring(offset + 1));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("invalid character in number field of CMRI system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 1 || num >= 128000) {
                log.debug("number field out of range in CMRI system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num - num / 1000 * 1000 == 0) {
                log.debug("bit number not in range 1 - 999 in CMRI system name: {}", (Object)systemName);
                if (systemName.length() <= offset + 6) {
                    return Manager.NameValidity.VALID_AS_PREFIX_ONLY;
                }
                return Manager.NameValidity.INVALID;
            }
        } else {
            if (s.length() == 0) {
                log.debug("no node address before 'B' in CMRI system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            try {
                num = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("invalid character in node address field of CMRI system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 0 || num >= 128) {
                log.debug("node address field out of range in CMRI system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            try {
                num = Integer.parseInt(systemName.substring(k));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("invalid character in bit number field of CMRI system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num == 0) {
                return Manager.NameValidity.VALID_AS_PREFIX_ONLY;
            }
            if (num < 1 || num > 2048) {
                log.debug("bit number field out of range in CMRI system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        return Manager.NameValidity.VALID;
    }

    public String validateSystemNameFormat(String systemName, char type, Locale locale) throws IllegalArgumentException {
        String prefix = String.valueOf(this.getSystemPrefix()) + type;
        if (!systemName.startsWith(prefix)) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidPrefix", systemName), Bundle.getMessage(locale, "InvalidSystemNameInvalidPrefix", systemName));
        }
        String address = systemName.substring(prefix.length());
        int node = 0;
        int bit = 0;
        if (!address.contains("B") && !address.contains(":")) {
            try {
                int num = Integer.parseInt(address);
                node = num / 1000;
                bit = num - num / 1000 * 1000;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNotInteger", systemName, prefix), Bundle.getMessage(locale, "InvalidSystemNameNotInteger", systemName, prefix));
            }
        }
        String[] parts = address.split("B");
        if (parts.length != 2 && (parts = address.split(":")).length != 2) {
            if (address.indexOf(":") == 0 && address.indexOf("B") == 0) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, ""), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, ""));
            }
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, ""), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, ""));
        }
        try {
            node = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, parts[0]), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, parts[0]));
        }
        try {
            bit = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, parts[1]), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, parts[1]));
        }
        if (node < 0 || node >= 128) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, node), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, node));
        }
        if (bit < 1 || bit > 2048) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, bit), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, bit));
        }
        return systemName;
    }

    public String isInputBitFree(int nAddress, int bitNum) {
        if (nAddress < 0 || nAddress > 127) {
            log.warn("invalid node address in free bit test");
            return "";
        }
        if (bitNum < 1 || bitNum > 2048) {
            log.warn("invalid bit number in free bit test");
            return "";
        }
        String sysName = this.makeSystemName("S", nAddress, bitNum);
        Sensor s = InstanceManager.sensorManagerInstance().getBySystemName(sysName);
        if (s != null) {
            return sysName;
        }
        String altName = this.convertSystemNameToAlternate(sysName);
        s = InstanceManager.sensorManagerInstance().getBySystemName(altName);
        if (s != null) {
            return altName;
        }
        return "";
    }

    public String makeSystemName(String type, int nAddress, int bitNum) {
        String nName = "";
        if (!(type.equals("S") || type.equals("L") || type.equals("T"))) {
            log.error("invalid type character proposed for system name");
            return nName;
        }
        if (nAddress < 0 || nAddress > 127) {
            log.warn("invalid node address proposed for system name");
            return nName;
        }
        if (bitNum < 1 || bitNum > 2048) {
            log.warn("invalid bit number proposed for system name");
            return nName;
        }
        nName = bitNum < 1000 ? String.valueOf(this.getSystemPrefix()) + type + Integer.toString(nAddress * 1000 + bitNum) : String.valueOf(this.getSystemPrefix()) + type + Integer.toString(nAddress) + "B" + Integer.toString(bitNum);
        return nName;
    }

    public AbstractNode getNodeFromSystemName(String systemName, SerialTrafficController tc) {
        int ua = this.getNodeAddressFromSystemName(systemName);
        if (ua == -1) {
            return null;
        }
        return tc.getNodeFromAddress(ua);
    }

    public boolean validSystemNameConfig(String systemName, char type, SerialTrafficController tc) {
        if (this.validSystemNameFormat(systemName, type) != Manager.NameValidity.VALID) {
            return false;
        }
        SerialNode node = (SerialNode)this.getNodeFromSystemName(systemName, tc);
        if (node == null) {
            return false;
        }
        int bit = this.getBitFromSystemName(systemName);
        if (type == 'T' || type == 'L') {
            if (bit <= 0 || bit > node.numOutputCards() * node.getNumBitsPerCard()) {
                return false;
            }
        } else if (type == 'S') {
            if (bit <= 0 || bit > node.numInputCards() * node.getNumBitsPerCard()) {
                return false;
            }
        } else {
            log.error("Invalid type specification in validSystemNameConfig call");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNodeAddressFromSystemName(String systemName) {
        int offset = this.checkSystemPrefix(systemName);
        if (offset < 1) {
            return -1;
        }
        if (systemName.charAt(offset) != 'L' && systemName.charAt(offset) != 'S' && systemName.charAt(offset) != 'T') {
            log.error("invalid character in header field of system name: {}", (Object)systemName);
            return -1;
        }
        String s = "";
        boolean noB = true;
        int i = offset + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(offset + 1, i);
                noB = false;
            }
            ++i;
        }
        if (noB) {
            int num = Integer.parseInt(systemName.substring(offset + 1));
            if (num > 0) {
                return num / 1000;
            }
            log.warn("invalid CMRI system name: {}", (Object)systemName);
            return -1;
        }
        if (s.length() == 0) {
            log.warn("no node address before 'B' in CMRI system name: {}", (Object)systemName);
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("invalid character in CMRI system name: {}", (Object)systemName);
            return -1;
        }
    }

    @CheckReturnValue
    public static int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2) {
        int bit2;
        int len;
        int bit1;
        int node1 = 0;
        int node2 = 0;
        int t = suffix1.indexOf("B");
        if (t < 0) {
            t = suffix1.indexOf(":");
        }
        if (t >= 0) {
            bit1 = Integer.parseInt(suffix1.substring(t + 1));
            if (t > 0) {
                node1 = Integer.parseInt(suffix1.substring(0, t));
            }
        } else {
            len = suffix1.length();
            bit1 = Integer.parseInt(suffix1.substring(Math.max(0, len - 3)));
            if (len > 3) {
                node1 = Integer.parseInt(suffix1.substring(0, len - 3));
            }
        }
        if ((t = suffix2.indexOf("B")) < 0) {
            t = suffix2.indexOf(":");
        }
        if (t >= 0) {
            bit2 = Integer.parseInt(suffix2.substring(t + 1));
            if (t > 0) {
                node2 = Integer.parseInt(suffix2.substring(0, t));
            }
        } else {
            len = suffix2.length();
            bit2 = Integer.parseInt(suffix2.substring(Math.max(0, len - 3)));
            if (len > 3) {
                node2 = Integer.parseInt(suffix2.substring(0, len - 3));
            }
        }
        if (node1 != node2) {
            return Integer.signum(node1 - node2);
        }
        return Integer.signum(bit1 - bit2);
    }

    @Override
    public void configureManagers() {
        InstanceManager.setSensorManager(this.getSensorManager());
        this.getTrafficController().setSensorManager(this.getSensorManager());
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setLightManager(this.getLightManager());
        this.register();
    }

    public SerialTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (SerialTurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> new SerialTurnoutManager(this));
    }

    public SerialSensorManager getSensorManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (SerialSensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> new SerialSensorManager(this));
    }

    public SerialLightManager getLightManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (SerialLightManager)this.classObjectMap.computeIfAbsent(LightManager.class, c -> new SerialLightManager(this));
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.cmri.CmriActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this, CMRISystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }
}

