/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.swing.send;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.jmrix.can.swing.send.Bundle;
import jmri.util.StringUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class CanSendPane
extends CanPanel {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    JCheckBox cbusPriorityCheckbox = new JCheckBox(Bundle.getMessage("AddCbusPriorFull"));
    JCheckBox sendAsMessage = new JCheckBox(Bundle.getMessage("SendAsMessage"));
    JCheckBox sendAsReply = new JCheckBox(Bundle.getMessage("SendAsReply"));
    static final int MAXSEQUENCE = 4;
    JTextField[] mPacketField = new JTextField[4];
    JCheckBox[] mUseField = new JCheckBox[4];
    JSpinner[] numberSpinner = new JSpinner[4];
    JToggleButton mRunButton = new JToggleButton(Bundle.getMessage("ButtonStart"));
    static final Color[] FILTERCOLORS = new Color[]{new Color(110, 235, 131), new Color(68, 235, 255), new Color(228, 255, 26), new Color(255, 132, 84)};
    int mNextSequenceElement = 0;
    Timer timer = null;
    private TrafficController tc = null;

    public CanSendPane() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel topPane = new JPanel();
        topPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SendFrameTitle")));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        JPanel entry = new JPanel();
        this.jLabel1.setText(Bundle.getMessage("FrameLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("SendToolTip"));
        entry.add(this.jLabel1);
        entry.add(this.packetTextField);
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterFrameToolTip"));
        topPane.add(entry);
        topPane.add(this.sendButton);
        ActionListener l = ae -> this.sendButtonActionPerformed(ae);
        this.sendButton.addActionListener(l);
        this.packetTextField.addActionListener(l);
        JPanel bottomPane = new JPanel();
        bottomPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SendSeqTitle")));
        bottomPane.setLayout(new BoxLayout(bottomPane, 1));
        JPanel pane2 = new JPanel();
        pane2.setLayout(new GridLayout(6, 3));
        pane2.add(new JLabel(" "));
        pane2.add(new JLabel(Bundle.getMessage("PacketLabel")));
        pane2.add(new JLabel(Bundle.getMessage("WaitLabel")));
        int i = 0;
        while (i < 4) {
            JPanel numbercheckboxpane = new JPanel();
            numbercheckboxpane.add(new JLabel(String.valueOf(Integer.toString(i + 1)) + " ", 4));
            this.mUseField[i] = new JCheckBox();
            this.mPacketField[i] = new JTextField(14);
            this.numberSpinner[i] = new JSpinner(new SpinnerNumberModel(1500, 1, 1000000, 1));
            numbercheckboxpane.add(this.mUseField[i]);
            pane2.add(numbercheckboxpane);
            pane2.add(this.mPacketField[i]);
            this.mPacketField[i].setToolTipText(Bundle.getMessage("EnterFrameToolTip"));
            pane2.add(this.numberSpinner[i]);
            ++i;
        }
        pane2.add(new JLabel(" "));
        pane2.add(this.mRunButton);
        bottomPane.add(pane2);
        JPanel optionholder = new JPanel();
        optionholder.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("Options")));
        JPanel optionlist = new JPanel();
        optionlist.setLayout(new BoxLayout(optionlist, 1));
        optionlist.add(this.cbusPriorityCheckbox);
        optionlist.add(this.sendAsMessage);
        optionlist.add(this.sendAsReply);
        this.cbusPriorityCheckbox.setSelected(true);
        this.sendAsMessage.setSelected(true);
        optionholder.add(optionlist);
        this.add(topPane);
        this.add(bottomPane);
        this.add(optionholder);
        this.mRunButton.setToolTipText(Bundle.getMessage("StartToolTip"));
        this.mRunButton.addActionListener(this::runButtonActionPerformed);
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.tc = memo.getTrafficController();
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.swing.send.CanSendFrame";
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemSendFrame"));
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        try {
            CanMessage m = this.createPacket(input.replaceAll("\\s", ""));
            if (this.cbusPriorityCheckbox.isSelected()) {
                CbusMessage.setPri(m, 11);
            }
            if (this.sendAsMessage.isSelected()) {
                this.tc.sendCanMessage(m, null);
            }
            if (this.sendAsReply.isSelected()) {
                CanReply mr = new CanReply(m);
                this.tc.sendCanReply(mr, null);
            }
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException ex) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("NoMakeFrame", ex.getMessage()), Bundle.getMessage("WarningTitle"), 0);
        }
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, e -> this.sendNextItem());
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    protected synchronized void timeout() {
        this.sendNextItem();
    }

    public void runButtonActionPerformed(ActionEvent e) {
        if (!this.mRunButton.isSelected()) {
            this.mRunButton.setText(Bundle.getMessage("ButtonStart"));
            return;
        }
        boolean ok = false;
        int i = 0;
        while (i < 4) {
            if (this.mUseField[i].isSelected()) {
                ok = true;
            }
            ++i;
        }
        if (!ok) {
            this.mRunButton.setSelected(false);
            this.mRunButton.setText(Bundle.getMessage("ButtonStart"));
            JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSelectionDialog"), Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        this.mNextSequenceElement = 0;
        this.mRunButton.setText(Bundle.getMessage("ButtonStop"));
        this.sendNextItem();
    }

    private void startSequenceDelay() {
        int delay = (Integer)this.numberSpinner[this.mNextSequenceElement].getValue();
        ++this.mNextSequenceElement;
        this.restartTimer(delay);
    }

    private void sendNextItem() {
        int i = 0;
        while (i < 4) {
            this.mPacketField[i].setBackground(this.packetTextField.getBackground());
            ++i;
        }
        if (!this.mRunButton.isSelected()) {
            this.mRunButton.setText(Bundle.getMessage("ButtonStart"));
            return;
        }
        if (this.mNextSequenceElement >= 4) {
            this.mNextSequenceElement = 0;
        }
        if (this.mUseField[this.mNextSequenceElement].isSelected()) {
            this.mPacketField[this.mNextSequenceElement].setBackground(FILTERCOLORS[this.mNextSequenceElement]);
            try {
                CanMessage m = this.createPacket(this.mPacketField[this.mNextSequenceElement].getText().replaceAll("\\s", ""));
                if (this.cbusPriorityCheckbox.isSelected()) {
                    CbusMessage.setPri(m, 11);
                }
                if (this.sendAsMessage.isSelected()) {
                    this.tc.sendCanMessage(m, null);
                }
                if (this.sendAsReply.isSelected()) {
                    CanReply mr = new CanReply(m);
                    this.tc.sendCanReply(mr, null);
                }
                this.startSequenceDelay();
            }
            catch (IllegalArgumentException | StringIndexOutOfBoundsException ex) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("NoMakeFrame", ex.getMessage()), Bundle.getMessage("WarningTitle"), 0);
                this.mRunButton.setSelected(false);
                this.mRunButton.setText(Bundle.getMessage("ButtonStart"));
            }
        } else {
            ++this.mNextSequenceElement;
            this.sendNextItem();
        }
    }

    CanMessage createPacket(String s) {
        CanMessage m;
        CbusAddress a = new CbusAddress(s);
        if (a.check()) {
            m = a.makeMessage(this.tc.getCanid());
        } else {
            String h;
            int i;
            m = new CanMessage(this.tc.getCanid());
            if (s.charAt(0) == '[') {
                m.setExtended(true);
                i = s.indexOf(93);
                h = s.substring(1, i);
                m.setHeader(Integer.parseInt(h, 16));
                s = s.substring(i + 1, s.length());
            } else if (s.charAt(0) == '(') {
                i = s.indexOf(41);
                h = s.substring(1, i);
                m.setHeader(Integer.parseInt(h, 16));
                s = s.substring(i + 1, s.length());
            }
            byte[] b = StringUtil.bytesFromHexString(s);
            m.setNumDataElements(b.length);
            int i2 = 0;
            while (i2 < b.length) {
                m.setElement(i2, b[i2] & 0xFF);
                ++i2;
            }
        }
        return m;
    }

    @Override
    public void dispose() {
        this.mRunButton.setSelected(false);
        super.dispose();
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemSendFrame"), new JmriJFrameInterface(), CanSendPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

