/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.swing.monitor;

import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.can.swing.monitor.Bundle;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorPane
extends AbstractMonPane
implements CanListener,
CanPanelInterface {
    CanSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(MonitorPane.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof CanSystemConnectionMemo) {
            this.initComponents((CanSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getTrafficController().addCanListener(this);
        try {
            this.initComponents();
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("CanMonitorTitle");
    }

    @Override
    public void init() {
    }

    @Override
    public synchronized void message(CanMessage l) {
        if (log.isDebugEnabled()) {
            log.debug("Message: {}", (Object)l.toString());
        }
        this.logMessage("M: ", l);
    }

    @Override
    public synchronized void reply(CanReply l) {
        if (log.isDebugEnabled()) {
            log.debug("Reply: {}", (Object)l.toString());
        }
        this.logMessage("R: ", l);
    }

    @Override
    public void dispose() {
        this.memo.getTrafficController().removeCanListener(this);
        super.dispose();
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("CanMonitorTitle"), new JmriJFrameInterface(), MonitorPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

