/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.simulator.CbusSimulator;
import jmri.jmrix.can.cbus.swing.simulator.Bundle;
import jmri.jmrix.can.cbus.swing.simulator.CsPane;
import jmri.jmrix.can.cbus.swing.simulator.EvResponderPane;
import jmri.jmrix.can.cbus.swing.simulator.NdPane;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class SimulatorPane
extends CanPanel {
    private CbusSimulator _sim;
    private JPanel p1;
    private JPanel _csPanes;
    private JPanel _ndPanes;
    private JPanel _evPanes;
    private Boolean _disposeSimOnWindowClose = false;
    private JScrollPane mainScroll;

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        try {
            this._sim = InstanceManager.getDefault(CbusSimulator.class);
        }
        catch (NullPointerException nullPointerException) {
            ThreadingUtil.runOnLayout(() -> {
                this._sim = new CbusSimulator(memo);
            });
        }
        this.init();
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemNetworkSim"));
    }

    private void init() {
        JPanel thispane;
        this._disposeSimOnWindowClose = false;
        this.setLayout(new BoxLayout(this, 1));
        this.p1 = new JPanel();
        this.p1.setLayout(new BoxLayout(this.p1, 1));
        this._csPanes = new JPanel();
        this._evPanes = new JPanel();
        this._ndPanes = new JPanel();
        this._csPanes.setLayout(new BoxLayout(this._csPanes, 1));
        this._evPanes.setLayout(new BoxLayout(this._evPanes, 1));
        this._ndPanes.setLayout(new BoxLayout(this._ndPanes, 1));
        this._csPanes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CmndStations")));
        this._evPanes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ResponseEvents")));
        this._ndPanes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CbusNodes")));
        int i = 0;
        while (i < this._sim.getNumCS()) {
            thispane = new CsPane(this._sim.getCS(i));
            this._csPanes.add(thispane);
            thispane.setVisible(true);
            ++i;
        }
        i = 0;
        while (i < this._sim.getNumNd()) {
            NdPane thispanend = new NdPane(this._sim.getNd(i));
            this._ndPanes.add(thispanend);
            thispanend.setVisible(true);
            ++i;
        }
        i = 0;
        while (i < this._sim.getNumEv()) {
            thispane = new EvResponderPane(this._sim.getEv(i));
            this._evPanes.add(thispane);
            thispane.setVisible(true);
            ++i;
        }
        this._csPanes.setVisible(true);
        this._evPanes.setVisible(true);
        this._ndPanes.setVisible(true);
        this.p1.add(this._csPanes);
        this.p1.add(this._ndPanes);
        this.p1.add(this._evPanes);
        this.mainScroll = new JScrollPane(this.p1);
        this.add(this.mainScroll);
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        JMenu optionsMenu = new JMenu(Bundle.getMessage("OptionsMenu"));
        JMenu addMenu = new JMenu(Bundle.getMessage("MenuAdd"));
        JCheckBoxMenuItem closeSimOnDispose = new JCheckBoxMenuItem(Bundle.getMessage("StopSimWinClose"));
        closeSimOnDispose.setSelected(false);
        closeSimOnDispose.addActionListener(e -> {
            this._disposeSimOnWindowClose = closeSimOnDispose.isSelected();
        });
        JMenuItem newCs = new JMenuItem(Bundle.getMessage("CommandStation"));
        newCs.addActionListener(e -> {
            CsPane thispane = new CsPane(this._sim.getNewCS());
            this._csPanes.add(thispane);
            this.revalidate();
        });
        JMenuItem newEv = new JMenuItem(Bundle.getMessage("EventResponders"));
        newEv.addActionListener(e -> {
            EvResponderPane thispane = new EvResponderPane(this._sim.getNewEv());
            this._evPanes.add(thispane);
            this.revalidate();
        });
        JMenuItem newNd = new JMenuItem(Bundle.getMessage("CbusNode"));
        newNd.addActionListener(e -> {
            NdPane thispanend = new NdPane(this._sim.getNewNd());
            this._ndPanes.add(thispanend);
            this.revalidate();
        });
        optionsMenu.add(closeSimOnDispose);
        addMenu.add(newCs);
        addMenu.add(newEv);
        addMenu.add(newNd);
        menuList.add(optionsMenu);
        menuList.add(addMenu);
        return menuList;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.simulator.SimulatorPane";
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._disposeSimOnWindowClose.booleanValue()) {
            this._sim.dispose();
        }
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemNetworkSim"), new JmriJFrameInterface(), SimulatorPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

