/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.can.cbus.node.CbusNodeCanListener;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.simulator.CbusDummyNode;
import jmri.jmrix.can.cbus.simulator.CbusSimCanListener;
import jmri.jmrix.can.cbus.swing.simulator.DirectionPane;
import jmri.util.swing.ComboBoxToolTipRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdPane
extends JPanel {
    private JComboBox<String> _selectNd;
    private CbusDummyNode _node;
    private JButton _resetNd;
    private JLabel _sessionText;
    private ArrayList<String> tooltips;
    private static final Logger log = LoggerFactory.getLogger(NdPane.class);

    public NdPane(CbusDummyNode nd) {
        this._node = nd;
        this.init();
    }

    public NdPane() {
    }

    private void init() {
        this._sessionText = new JLabel();
        this._selectNd = new JComboBox();
        this._selectNd.setEditable(false);
        ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
        this._selectNd.setRenderer(renderer);
        this._node.setPane(this);
        this.tooltips = new ArrayList();
        String getSelected = "";
        int i = 0;
        while (i < CbusDummyNode.getNodeTypes().size()) {
            int intoption = CbusDummyNode.getNodeTypes().get(i);
            String option = CbusNodeConstants.getModuleType(165, intoption);
            this._selectNd.addItem(option);
            this.tooltips.add(CbusNodeConstants.getModuleTypeExtra(165, intoption));
            if (intoption == this._node.getNodeParamManager().getParameter(3)) {
                getSelected = option;
            }
            ++i;
        }
        this._selectNd.setSelectedItem(getSelected);
        this._selectNd.addActionListener(e -> {
            String chosen = (String)this._selectNd.getSelectedItem();
            int i = 0;
            while (i < CbusDummyNode.getNodeTypes().size()) {
                int intoption = CbusDummyNode.getNodeTypes().get(i);
                String option = CbusNodeConstants.getModuleType(165, intoption);
                if (option.equals(chosen)) {
                    log.debug("chosen {} {}", (Object)i, (Object)chosen);
                    this._node.setDummyType(165, intoption);
                }
                ++i;
            }
            this.updateNode();
        });
        renderer.setTooltips(this.tooltips);
        this._resetNd = new JButton("FLiM");
        JPanel topPane = new JPanel();
        topPane.add(this._selectNd);
        topPane.add(this._sessionText);
        topPane.add(this._resetNd);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(topPane);
        CbusNodeCanListener cbncl = this._node.getCanListener();
        if (cbncl instanceof CbusSimCanListener) {
            CbusSimCanListener cbcl = (CbusSimCanListener)cbncl;
            this.add(new DirectionPane(cbcl));
        }
        this._resetNd.addActionListener(e -> this._node.flimButton());
        this.updateNode();
    }

    private void updateNode() {
        if (this._node.getNodeParamManager().getParameter(3) > 0) {
            this._resetNd.setEnabled(true);
        } else {
            this._resetNd.setEnabled(false);
        }
        this._sessionText.setText("<html> <h2> " + this._node.getNodeNumber() + " </h2> </html>");
    }

    public void setNodeNum(int num) {
        this._node.setNodeNumber(num);
        this.updateNode();
    }
}

