/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import jmri.jmrix.can.cbus.simulator.CbusEventResponder;
import jmri.jmrix.can.cbus.swing.simulator.Bundle;
import jmri.jmrix.can.cbus.swing.simulator.DirectionPane;
import jmri.util.swing.ComboBoxToolTipRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvResponderPane
extends JPanel {
    private final CbusEventResponder _evr;
    private JComboBox<String> _selectMode;
    private int _mode;
    private ArrayList<String> tooltips;
    private JSpinner _spinner;
    private static final Logger log = LoggerFactory.getLogger(EvResponderPane.class);

    public EvResponderPane(CbusEventResponder evr) {
        this._evr = evr;
        if (this._evr != null) {
            this.init();
        }
    }

    private void init() {
        this._mode = this._evr.getMode();
        JLabel _nodeLabel = new JLabel("<html><h3>" + Bundle.getMessage("CbusNode") + " : </h3></html>");
        _nodeLabel.setToolTipText(Bundle.getMessage("simNodeSelect"));
        this._selectMode = new JComboBox();
        this._selectMode.setEditable(false);
        ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
        this._selectMode.setRenderer(renderer);
        this.tooltips = new ArrayList();
        String getSelected = "";
        int i = 0;
        while (i < this._evr.evModes.size()) {
            String option = this._evr.evModes.get(i);
            this._selectMode.addItem(option);
            this.tooltips.add(this._evr.evModesTip.get(i));
            if (i == this._mode) {
                getSelected = option;
            }
            ++i;
        }
        this._selectMode.setSelectedItem(getSelected);
        this._selectMode.addActionListener(e -> {
            String chosen = (String)this._selectMode.getSelectedItem();
            int i = 0;
            while (i < this._evr.evModes.size()) {
                String option = this._evr.evModes.get(i);
                if (option.equals(chosen)) {
                    log.debug("chosen {} {}", (Object)i, (Object)chosen);
                    this._evr.setMode(i);
                }
                ++i;
            }
        });
        renderer.setTooltips(this.tooltips);
        this._spinner = new JSpinner(new SpinnerNumberModel(this._evr.getNode(), -1, 65535, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this._spinner, "#");
        this._spinner.setEditor(editor);
        JFormattedTextField field = (JFormattedTextField)editor.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this._spinner.addChangeListener(e -> {
            int minmax = (Integer)this._spinner.getValue();
            log.debug("value {}", (Object)minmax);
            this._evr.setNode(minmax);
        });
        this._spinner.setToolTipText(Bundle.getMessage("simNodeSelect"));
        DirectionPane dp = new DirectionPane(this._evr);
        JPanel topPane = new JPanel();
        topPane.add(this._selectMode);
        topPane.add(_nodeLabel);
        topPane.add(this._spinner);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(topPane);
        this.add(dp);
    }
}

