/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.can.cbus.simulator.CbusDummyCS;
import jmri.jmrix.can.cbus.swing.simulator.Bundle;
import jmri.jmrix.can.cbus.swing.simulator.DirectionPane;
import jmri.util.swing.ComboBoxToolTipRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsPane
extends JPanel {
    private final CbusDummyCS _cs;
    private JComboBox<String> _selectCs;
    private int _id;
    private int _type;
    private int _numSessions;
    private JButton _resetCs;
    private JLabel _sessionText;
    private ArrayList<String> tooltips;
    private static final Logger log = LoggerFactory.getLogger(CsPane.class);

    public CsPane(CbusDummyCS cs) {
        this._cs = cs;
        if (this._cs != null) {
            this.init();
        }
    }

    private void init() {
        this._type = this._cs.getDummyType();
        this._numSessions = this._cs.getNumberSessions();
        this._sessionText = new JLabel();
        this._sessionText.setToolTipText(Bundle.getMessage("ActiveSess"));
        this._selectCs = new JComboBox();
        this._selectCs.setEditable(false);
        ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
        this._selectCs.setRenderer(renderer);
        this.updateSessionTotal();
        this._cs.setPane(this);
        this.tooltips = new ArrayList();
        String getSelected = "";
        int i = 0;
        while (i < this._cs.csTypes.size()) {
            String option = this._cs.csTypes.get(i);
            this._selectCs.addItem(option);
            this.tooltips.add(this._cs.csTypesTip.get(i));
            if (i == this._type) {
                getSelected = option;
            }
            ++i;
        }
        this._selectCs.setSelectedItem(getSelected);
        this._selectCs.addActionListener(e -> {
            String chosen = (String)this._selectCs.getSelectedItem();
            int i = 0;
            while (i < this._cs.csTypes.size()) {
                if (this._cs.csTypes.get(i).equals(chosen)) {
                    log.debug("chosen {} {}", (Object)i, (Object)chosen);
                    this._cs.setDummyType(i);
                }
                ++i;
            }
        });
        renderer.setTooltips(this.tooltips);
        this._resetCs = new JButton(Bundle.getMessage("Reset"));
        JPanel topPane = new JPanel();
        topPane.add(this._selectCs);
        topPane.add(this._sessionText);
        topPane.add(this._resetCs);
        DirectionPane dp = new DirectionPane(this._cs);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(topPane);
        this.add(dp);
        this._resetCs.addActionListener(e -> this._cs.resetCS());
    }

    void updateSessionTotal() {
        this._sessionText.setText("<html> <h2> " + this._numSessions + " </h2> </html>");
    }

    public void setNumSessions(int num) {
        this._numSessions = num;
        this.updateSessionTotal();
    }

    public int getId() {
        return this._id;
    }
}

