/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusSend;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTimerManager;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeBackupsPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeConfigTab;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEditEventFrame;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEditNVarPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEventVarPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeInfoPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeRestoreFcuFrame;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeSetupPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeUserCommentsPane;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.BusyDialog;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfigToolPane
extends CanPanel
implements PropertyChangeListener {
    public CbusNodeTableDataModel nodeModel;
    public JTable nodeTable;
    private CbusPreferences preferences;
    protected CbusNodeTablePane nodeTablePane;
    private CbusNodeRestoreFcuFrame fcuFrame;
    private CbusNodeEditEventFrame _editEventFrame;
    private JScrollPane eventScroll;
    private JSplitPane split;
    protected JTabbedPane tabbedPane;
    private ArrayList<CbusNodeConfigTab> tabbedPanes;
    private int _selectedNode;
    private BusyDialog busy_dialog;
    public int NODE_SEARCH_TIMEOUT = 5000;
    private JMenuItem teachNodeFromFcuFile;
    private JMenuItem searchForNodesMenuItem;
    private JCheckBoxMenuItem nodeNumRequestMenuItem;
    private JRadioButtonMenuItem backgroundDisabled;
    private JRadioButtonMenuItem backgroundSlow;
    private JRadioButtonMenuItem backgroundFast;
    private JCheckBoxMenuItem addCommandStationMenuItem;
    private JCheckBoxMenuItem addNodesMenuItem;
    private JCheckBoxMenuItem startupCommandStationMenuItem;
    private JCheckBoxMenuItem startupNodesMenuItem;
    private JCheckBoxMenuItem startupNodesXmlMenuItem;
    private JRadioButtonMenuItem zeroBackups;
    private JRadioButtonMenuItem fiveBackups;
    private JRadioButtonMenuItem tenBackups;
    private JRadioButtonMenuItem twentyBackups;
    private final JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
    private boolean _clearEvents;
    private boolean _teachEvents;
    private CbusNode _fromNode;
    private CbusNode _toNode;
    private JFrame _frame;
    private static final Logger log = LoggerFactory.getLogger(NodeConfigToolPane.class);

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.nodeModel = InstanceManager.getNullableDefault(CbusNodeTableDataModel.class);
        if (this.nodeModel == null) {
            ThreadingUtil.runOnLayout(() -> {
                this.nodeModel = new CbusNodeTableDataModel(memo, 5, 14);
                InstanceManager.store(this.nodeModel, CbusNodeTableDataModel.class);
                this.nodeModel.startup();
            });
        }
        CbusConfigPaneProvider.loadInstances();
        this._selectedNode = -1;
        this.preferences = InstanceManager.getDefault(CbusPreferences.class);
        this.init();
    }

    protected final ArrayList<CbusNodeConfigTab> getTabs() {
        if (this.tabbedPanes == null) {
            this.tabbedPanes = new ArrayList(6);
            this.tabbedPanes.add(new CbusNodeInfoPane(this));
            this.tabbedPanes.add(new CbusNodeUserCommentsPane(this));
            this.tabbedPanes.add(new CbusNodeEditNVarPane(this));
            this.tabbedPanes.add(new CbusNodeEventVarPane(this));
            this.tabbedPanes.add(new CbusNodeSetupPane(this));
            this.tabbedPanes.add(new CbusNodeBackupsPane(this));
        }
        return new ArrayList<CbusNodeConfigTab>(this.tabbedPanes);
    }

    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel _pane1 = new JPanel();
        _pane1.setLayout(new BorderLayout());
        this.nodeTablePane = new CbusNodeTablePane();
        this.nodeTablePane.initComponents(this.memo);
        this.nodeTable = this.nodeTablePane.nodeTable;
        this.eventScroll = new JScrollPane(this.nodeTablePane);
        JPanel mainNodePane = new JPanel();
        mainNodePane.setLayout(new BorderLayout());
        mainNodePane.add(this.eventScroll);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setEnabled(false);
        this.getTabs().forEach(pn -> this.tabbedPane.addTab(pn.getTitle(), (Component)pn));
        Dimension minimumSize = new Dimension(40, 40);
        mainNodePane.setMinimumSize(minimumSize);
        this.tabbedPane.setMinimumSize(minimumSize);
        this.setPreferredSize(new Dimension(700, 450));
        this.split = new JSplitPane(0, mainNodePane, this.tabbedPane);
        this.split.setDividerLocation(this.preferences.getNodeTableSplit());
        this.split.setContinuousLayout(true);
        _pane1.add((Component)this.split, "Center");
        this.split.addPropertyChangeListener(changeEvent -> {
            JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
            String propertyName = changeEvent.getPropertyName();
            if (propertyName.equals("dividerLocation")) {
                this.preferences.setNodeTableSplit(sourceSplitPane.getDividerLocation());
            }
        });
        this.add(_pane1);
        _pane1.setVisible(true);
        this.tabbedPane.addChangeListener(e -> this.userViewChanged());
        this.nodeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.userViewChanged();
            }
        });
        this.userViewChanged();
        this.tabbedPane.setTransferHandler(new TransferHandler());
        this.nodeTable.setTransferHandler(new TransferHandler());
        this.revalidate();
    }

    public void notifyNodeSearchComplete(int csfound, int ndfound) {
        this.busy_dialog.finish();
        this.busy_dialog = null;
        JOptionPane pane = new JOptionPane("<html><h3>Node Responses : " + ndfound + "</h3><p>Of which Command Stations: " + csfound + "</p></html>");
        pane.setMessageType(1);
        JDialog dialog = pane.createDialog(this, "Node Search Complete");
        dialog.setModal(false);
        dialog.setVisible(true);
        this.searchForNodesMenuItem.setEnabled(true);
    }

    protected void userViewChanged() {
        int sel = this.nodeTable.getSelectedRow();
        int rowBefore = this.nodeTable.getSelectedRow() - 1;
        int rowAfter = this.nodeTable.getSelectedRow() + 1;
        if (sel > -1) {
            this.tabbedPane.setEnabled(true);
            this._selectedNode = (Integer)this.nodeTable.getModel().getValueAt(this.nodeTable.convertRowIndexToModel(sel), 0);
            int tabindex = this.tabbedPane.getSelectedIndex();
            int nodeBefore = -1;
            int nodeAfter = -1;
            if (rowBefore > -1) {
                nodeBefore = (Integer)this.nodeTable.getModel().getValueAt(rowBefore, 0);
            }
            if (rowAfter < this.nodeTable.getRowCount()) {
                nodeAfter = (Integer)this.nodeTable.getModel().getValueAt(rowAfter, 0);
            }
            log.debug("node {} selected tab index {} , node before {} node after {}", new Object[]{this._selectedNode, tabindex, nodeBefore, nodeAfter});
            boolean veto = false;
            for (CbusNodeConfigTab tab : this.getTabs()) {
                if (!tab.getActiveDialog() && !tab.getVetoBeingChanged()) continue;
                veto = true;
                break;
            }
            if (veto) {
                return;
            }
            this.tabbedPane.setSelectedIndex(tabindex);
            this.nodeTable.setRowSelectionInterval(sel, sel);
            this.nodeModel.setUrgentFetch(this._selectedNode, nodeBefore, nodeAfter);
            this.getTabs().get(tabindex).setNode(this.nodeModel.getNodeByNodeNum(this._selectedNode));
        } else {
            this.tabbedPane.setEnabled(false);
        }
    }

    private void setMenuOptions() {
        this.nodeNumRequestMenuItem.setSelected(this.preferences.getAllocateNNListener());
        this.backgroundDisabled.setSelected(false);
        this.backgroundSlow.setSelected(false);
        this.backgroundFast.setSelected(false);
        switch ((int)this.preferences.getNodeBackgroundFetchDelay()) {
            case 0: {
                this.backgroundDisabled.setSelected(true);
                break;
            }
            case 50: {
                this.backgroundFast.setSelected(true);
                break;
            }
            case 100: {
                this.backgroundSlow.setSelected(true);
                break;
            }
        }
        this.addCommandStationMenuItem.setSelected(this.preferences.getAddCommandStations());
        this.addNodesMenuItem.setSelected(this.preferences.getAddNodes());
        this.startupCommandStationMenuItem.setSelected(this.preferences.getStartupSearchForCs());
        this.startupNodesMenuItem.setSelected(this.preferences.getStartupSearchForNodes());
        this.startupNodesXmlMenuItem.setSelected(this.preferences.getSearchForNodesBackupXmlOnStartup());
        this.zeroBackups.setSelected(false);
        this.fiveBackups.setSelected(false);
        this.tenBackups.setSelected(false);
        this.twentyBackups.setSelected(false);
        switch (this.preferences.getMinimumNumBackupsToKeep()) {
            case 0: {
                this.zeroBackups.setSelected(true);
                break;
            }
            case 5: {
                this.fiveBackups.setSelected(true);
                break;
            }
            case 10: {
                this.tenBackups.setSelected(true);
                break;
            }
            case 20: {
                this.twentyBackups.setSelected(true);
                break;
            }
        }
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        this.teachNodeFromFcuFile = new JMenuItem("Restore Node / Import Data from FCU XML");
        fileMenu.add(this.teachNodeFromFcuFile);
        JMenu optionsMenu = new JMenu("Options");
        this.searchForNodesMenuItem = new JMenuItem("Search for Nodes and Command Stations");
        JMenuItem sendSysResetMenuItem = new JMenuItem("Send System Reset");
        this.searchForNodesMenuItem.setToolTipText("Timeout set to " + this.NODE_SEARCH_TIMEOUT + "ms.");
        this.nodeNumRequestMenuItem = new JCheckBoxMenuItem("Listen for Node Number Requests");
        this.nodeNumRequestMenuItem.setToolTipText("Also adds a check for any node already awaiting a number when performing node searches.");
        this.addCommandStationMenuItem = new JCheckBoxMenuItem("Add Command Stations when found");
        this.addNodesMenuItem = new JCheckBoxMenuItem("Add Nodes when found");
        JMenu backgroundFetchMenu = new JMenu("Node Info Fetch Speed");
        ButtonGroup backgroundFetchGroup = new ButtonGroup();
        this.backgroundDisabled = new JRadioButtonMenuItem(Bundle.getMessage("HighlightDisabled"));
        this.backgroundSlow = new JRadioButtonMenuItem("Slow");
        this.backgroundFast = new JRadioButtonMenuItem("Fast");
        this.startupCommandStationMenuItem = new JCheckBoxMenuItem("Search Command Stations on Startup");
        this.startupNodesMenuItem = new JCheckBoxMenuItem("Search Nodes on Startup");
        this.startupNodesXmlMenuItem = new JCheckBoxMenuItem("Add previously seen Nodes on Startup");
        JMenu numBackupsMenu = new JMenu("Min. Auto Backups to retain");
        ButtonGroup minNumBackupsGroup = new ButtonGroup();
        this.zeroBackups = new JRadioButtonMenuItem("0");
        this.fiveBackups = new JRadioButtonMenuItem("5");
        this.tenBackups = new JRadioButtonMenuItem("10");
        this.twentyBackups = new JRadioButtonMenuItem("20");
        minNumBackupsGroup.add(this.zeroBackups);
        minNumBackupsGroup.add(this.fiveBackups);
        minNumBackupsGroup.add(this.tenBackups);
        minNumBackupsGroup.add(this.twentyBackups);
        numBackupsMenu.add(this.zeroBackups);
        numBackupsMenu.add(this.fiveBackups);
        numBackupsMenu.add(this.tenBackups);
        numBackupsMenu.add(this.twentyBackups);
        backgroundFetchGroup.add(this.backgroundDisabled);
        backgroundFetchGroup.add(this.backgroundSlow);
        backgroundFetchGroup.add(this.backgroundFast);
        backgroundFetchMenu.add(this.backgroundDisabled);
        backgroundFetchMenu.add(this.backgroundSlow);
        backgroundFetchMenu.add(this.backgroundFast);
        optionsMenu.add(this.searchForNodesMenuItem);
        optionsMenu.add(new JSeparator());
        optionsMenu.add(sendSysResetMenuItem);
        optionsMenu.add(new JSeparator());
        optionsMenu.add(backgroundFetchMenu);
        optionsMenu.add(new JSeparator());
        optionsMenu.add(this.nodeNumRequestMenuItem);
        optionsMenu.add(new JSeparator());
        optionsMenu.add(this.addCommandStationMenuItem);
        optionsMenu.add(this.addNodesMenuItem);
        optionsMenu.add(new JSeparator());
        optionsMenu.add(this.startupCommandStationMenuItem);
        optionsMenu.add(this.startupNodesMenuItem);
        optionsMenu.add(this.startupNodesXmlMenuItem);
        optionsMenu.add(new JSeparator());
        optionsMenu.add(numBackupsMenu);
        menuList.add(fileMenu);
        menuList.add(optionsMenu);
        ActionListener teachNodeFcu = ae -> {
            this.fcuFrame = new CbusNodeRestoreFcuFrame(this);
            this.fcuFrame.initComponents(this.memo);
        };
        this.teachNodeFromFcuFile.addActionListener(teachNodeFcu);
        ActionListener updatenodes = ae -> {
            this.searchForNodesMenuItem.setEnabled(false);
            this.busy_dialog = new BusyDialog(this.topFrame, "Node Search", false);
            this.busy_dialog.start();
            this.nodeModel.startASearchForNodes(this, this.NODE_SEARCH_TIMEOUT);
        };
        this.searchForNodesMenuItem.addActionListener(updatenodes);
        ActionListener systemReset = ae -> {
            new CbusSend(this.memo).aRST();
            this.busy_dialog = new BusyDialog(this.topFrame, "System Reset", false);
            this.busy_dialog.start();
            ThreadingUtil.runOnGUIDelayed(() -> {
                this.busy_dialog.finish();
                this.busy_dialog = null;
            }, 300);
        };
        sendSysResetMenuItem.addActionListener(systemReset);
        ActionListener nodeRequestActive = ae -> {
            this.nodeModel.setBackgroundAllocateListener(this.nodeNumRequestMenuItem.isSelected());
            this.preferences.setAllocateNNListener(this.nodeNumRequestMenuItem.isSelected());
        };
        this.nodeNumRequestMenuItem.addActionListener(nodeRequestActive);
        ActionListener fetchListener = ae -> {
            if (this.backgroundDisabled.isSelected()) {
                this.preferences.setNodeBackgroundFetchDelay(0L);
                this.nodeModel.startBackgroundFetch();
            } else if (this.backgroundSlow.isSelected()) {
                this.preferences.setNodeBackgroundFetchDelay(100L);
                this.nodeModel.startBackgroundFetch();
            } else if (this.backgroundFast.isSelected()) {
                this.preferences.setNodeBackgroundFetchDelay(50L);
                this.nodeModel.startBackgroundFetch();
            }
        };
        this.backgroundDisabled.addActionListener(fetchListener);
        this.backgroundSlow.addActionListener(fetchListener);
        this.backgroundFast.addActionListener(fetchListener);
        ActionListener addCsListener = ae -> this.preferences.setAddCommandStations(this.addCommandStationMenuItem.isSelected());
        this.addCommandStationMenuItem.addActionListener(addCsListener);
        ActionListener addNodeListener = ae -> this.preferences.setAddNodes(this.addNodesMenuItem.isSelected());
        this.addNodesMenuItem.addActionListener(addNodeListener);
        ActionListener addstartupCommandStationMenuItem = ae -> this.preferences.setStartupSearchForCs(this.startupCommandStationMenuItem.isSelected());
        this.startupCommandStationMenuItem.addActionListener(addstartupCommandStationMenuItem);
        ActionListener addstartupNodesMenuItem = ae -> this.preferences.setStartupSearchForNodes(this.startupNodesMenuItem.isSelected());
        this.startupNodesMenuItem.addActionListener(addstartupNodesMenuItem);
        ActionListener addstartupNodesXmlMenuItem = ae -> this.preferences.setSearchForNodesBackupXmlOnStartup(this.startupNodesXmlMenuItem.isSelected());
        this.startupNodesXmlMenuItem.addActionListener(addstartupNodesXmlMenuItem);
        ActionListener minBackupsListener = ae -> {
            if (this.zeroBackups.isSelected()) {
                this.preferences.setMinimumNumBackupsToKeep(0);
            } else if (this.fiveBackups.isSelected()) {
                this.preferences.setMinimumNumBackupsToKeep(5);
            } else if (this.tenBackups.isSelected()) {
                this.preferences.setMinimumNumBackupsToKeep(10);
            } else if (this.twentyBackups.isSelected()) {
                this.preferences.setMinimumNumBackupsToKeep(10);
            }
        };
        this.zeroBackups.addActionListener(minBackupsListener);
        this.fiveBackups.addActionListener(minBackupsListener);
        this.tenBackups.addActionListener(minBackupsListener);
        this.twentyBackups.addActionListener(minBackupsListener);
        this.setMenuOptions();
        return menuList;
    }

    protected void setRestoreFcuActive(boolean isActive) {
        this.teachNodeFromFcuFile.setEnabled(!isActive);
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemNodeConfig"));
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane";
    }

    @Override
    public void dispose() {
        if (this._toNode != null) {
            this._toNode.removePropertyChangeListener(this);
        }
        this.getTabs().forEach(pn -> {
            if (pn instanceof CbusNodeEditNVarPane) {
                pn.dispose();
            }
        });
        super.dispose();
    }

    private boolean openNewOrEditEventFrame(String eventInJmriFormat) {
        String validatedAddr;
        try {
            validatedAddr = CbusAddress.validateSysName(eventInJmriFormat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (this.nodeModel == null) {
            log.warn("No Node Model");
            return false;
        }
        CbusNode _node = this.nodeModel.getNodeByNodeNum(this._selectedNode);
        if (_node == null) {
            log.warn("No Node");
            return false;
        }
        CanMessage m = new CbusAddress(validatedAddr).makeMessage(18);
        CbusNodeEvent newev = new CbusNodeEvent(this.memo, CbusMessage.getNodeNumber(m), CbusMessage.getEvent(m), this._selectedNode, -1, _node.getNodeParamManager().getParameter(5));
        Arrays.fill(newev.getEvVarArray(), 0);
        log.debug("dragged nodeevent {} ", (Object)newev);
        ThreadingUtil.runOnGUI(() -> this.getEditEvFrame().initComponents(this.memo, newev));
        return true;
    }

    public CbusNodeEditEventFrame getEditEvFrame() {
        if (this._editEventFrame == null) {
            this._editEventFrame = new CbusNodeEditEventFrame(this);
        }
        return this._editEventFrame;
    }

    protected void clearEditEventFrame() {
        this._editEventFrame = null;
    }

    protected void showConfirmThenSave(CbusNode fromNode, CbusNode toNode, boolean teachNVs, boolean clearEvents, boolean teachEvents, JFrame frame) {
        this._clearEvents = clearEvents;
        this._teachEvents = teachEvents;
        this._fromNode = fromNode;
        this._toNode = toNode;
        if (frame == null) {
            frame = this.topFrame;
        }
        this._frame = frame;
        StringBuilder buf = new StringBuilder();
        buf.append("<html> ").append("Please Confirm Write ").append("to <br>").append(this._toNode.toString()).append("<hr>");
        if (teachNVs) {
            buf.append("Teaching ").append(this._toNode.getNodeNvManager().getNvDifference(this._fromNode)).append(" of ").append(this._fromNode.getNodeNvManager().getTotalNVs()).append(" NV's<br>");
        }
        if (this._clearEvents) {
            buf.append("Clearing ").append(Math.max(0, this._toNode.getNodeEventManager().getTotalNodeEvents())).append(" Events<br>");
        }
        if (this._teachEvents) {
            buf.append("Teaching ").append(Math.max(0, this._fromNode.getNodeEventManager().getTotalNodeEvents())).append(" Events<br>");
        }
        buf.append("</html>");
        int response = JOptionPane.showConfirmDialog(frame, buf.toString(), "Please Confirm Write to Node", 2, 3);
        if (response == 0) {
            this._toNode.addPropertyChangeListener(this);
            this.busy_dialog = new BusyDialog(frame, "Write NVs " + this._fromNode.toString(), false);
            this.busy_dialog.start();
            this._toNode.setNameIfNoName(this._fromNode.getUserName());
            if (teachNVs) {
                this._toNode.getNodeNvManager().sendNvsToNode(this._fromNode.getNodeNvManager().getNvArray());
            } else {
                this.nVTeachComplete(0);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("TEACHNVCOMPLETE")) {
            ThreadingUtil.runOnGUIEventually(() -> this.nVTeachComplete((Integer)ev.getNewValue()));
        } else if (ev.getPropertyName().equals("ADDALLEVCOMPLETE")) {
            ThreadingUtil.runOnGUIEventually(() -> this.teachEventsComplete((Integer)ev.getNewValue()));
        }
    }

    private void nVTeachComplete(int numErrors) {
        if (numErrors > 0) {
            JOptionPane.showMessageDialog(this._frame, Bundle.getMessage("NVSetFailTitle", numErrors), Bundle.getMessage("WarningTitle"), 0);
        }
        if (this._clearEvents) {
            this.busy_dialog.setTitle("Clear Events");
            this._toNode.send.nodeEnterLearnEvMode(this._toNode.getNodeNumber());
            ThreadingUtil.runOnLayoutDelayed(() -> this._toNode.send.nNCLR(this._toNode.getNodeNumber()), 150);
            ThreadingUtil.runOnLayoutDelayed(() -> this._toNode.send.nodeExitLearnEvMode(this._toNode.getNodeNumber()), CbusNodeTimerManager.SINGLE_MESSAGE_TIMEOUT_TIME);
            ThreadingUtil.runOnGUIDelayed(() -> this.clearEventsComplete(), CbusNodeTimerManager.SINGLE_MESSAGE_TIMEOUT_TIME + 150);
        } else {
            this.clearEventsComplete();
        }
    }

    private void clearEventsComplete() {
        ArrayList<CbusNodeEvent> arL = this._fromNode.getNodeEventManager().getEventArray();
        if (this._teachEvents) {
            if (arL == null) {
                log.error("No Event Array on Node {}", (Object)this._fromNode);
                this.teachEventsComplete(1);
                return;
            }
            this.busy_dialog.setTitle("Teach Events");
            this._toNode.getNodeEventManager().sendNewEvSToNode(arL);
        } else {
            this.teachEventsComplete(0);
        }
    }

    private void teachEventsComplete(int numErrors) {
        this._toNode.removePropertyChangeListener(this);
        this.busy_dialog.finish();
        this.busy_dialog = null;
        if (numErrors != 0) {
            JOptionPane.showMessageDialog(this._frame, Bundle.getMessage("NdEvVarWriteError"), Bundle.getMessage("WarningTitle"), 0);
        }
        this._frame = null;
        this._toNode = null;
    }

    protected CbusNodeTableDataModel getNodeModel() {
        return InstanceManager.getDefault(CbusNodeTableDataModel.class);
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemNodeConfig"), new JmriJFrameInterface(), NodeConfigToolPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }

    private class TransferHandler
    extends javax.swing.TransferHandler {
        private TransferHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] transferFlavors) {
            if (c instanceof JTabbedPane && NodeConfigToolPane.this._selectedNode < 1) {
                return false;
            }
            DataFlavor[] dataFlavorArray = transferFlavors;
            int n = transferFlavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor flavor = dataFlavorArray[n2];
                if (DataFlavor.stringFlavor.equals(flavor)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            if (this.canImport(c, t.getTransferDataFlavors())) {
                String eventInJmriFormat;
                try {
                    eventInJmriFormat = (String)t.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    log.error("unable to get dragged address {}", (Throwable)e);
                    return false;
                }
                return NodeConfigToolPane.this.openNewOrEditEventFrame(eventInJmriFormat);
            }
            return false;
        }
    }
}

