/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeConfigTab;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;

public class CbusNodeUserCommentsPane
extends CbusNodeConfigTab
implements KeyListener {
    private JScrollPane eventScroll;
    private ActionListener setNameListener;
    private ActionListener resetCommentListener;
    private JTextArea textFieldName;
    private JButton saveTextButton;
    private JButton resetTextButton;

    protected CbusNodeUserCommentsPane(NodeConfigToolPane main) {
        super(main);
        this.initPane();
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("NodeComments");
    }

    private void initPane() {
        this.initButtons();
        JPanel evMenuPane = new JPanel();
        evMenuPane.add(this.saveTextButton);
        evMenuPane.add(this.resetTextButton);
        this.textFieldName = new JTextArea();
        this.textFieldName.setMargin(new Insets(10, 10, 10, 10));
        this.textFieldName.addKeyListener(this);
        this.eventScroll = new JScrollPane(this.textFieldName);
        this.add((Component)evMenuPane, "First");
        this.add((Component)this.eventScroll, "Center");
    }

    private void initButtons() {
        this.saveTextButton = new JButton(Bundle.getMessage("SaveCommentsButton"));
        this.saveTextButton.setEnabled(false);
        this.resetTextButton = new JButton(Bundle.getMessage("ResetCommentButton"));
        this.resetTextButton.setEnabled(false);
        this.setNameListener = ae -> this.saveOption();
        this.saveTextButton.addActionListener(this.setNameListener);
        this.resetCommentListener = ae -> this.cancelOption();
        this.resetTextButton.addActionListener(this.resetCommentListener);
    }

    @Override
    public void changedNode(CbusNode node) {
        this.textFieldName.setText(this.nodeOfInterest.getUserComment());
        this.resetCommentButtons();
    }

    @Override
    public void saveOption() {
        this.nodeOfInterest.setUserComment(this.textFieldName.getText());
        this.resetCommentButtons();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.resetCommentButtons();
    }

    private void resetCommentButtons() {
        this.saveTextButton.setEnabled(!this.nodeOfInterest.getUserComment().equals(this.textFieldName.getText()));
        this.resetTextButton.setEnabled(!this.nodeOfInterest.getUserComment().equals(this.textFieldName.getText()));
    }

    public boolean areCommentsDirty() {
        if (this.saveTextButton != null) {
            return this.saveTextButton.isEnabled();
        }
        return false;
    }

    @Override
    protected void cancelOption() {
        this.textFieldName.setText(this.nodeOfInterest.getUserComment());
        this.resetCommentButtons();
    }

    @Override
    protected boolean getVetoBeingChanged() {
        if (this.areCommentsDirty()) {
            return this.getCancelSaveEditDialog(Bundle.getMessage("CommentsEditUnsaved"));
        }
        return false;
    }
}

