/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.util.ThreadingUtil;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.JTableWithColumnToolTips;
import jmri.util.table.ProgressCellRender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeTablePane
extends JPanel {
    private CbusNodeTableDataModel nodeModel;
    protected JTable nodeTable;
    private TableRowSorter<CbusNodeTableDataModel> sorter;
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm EEE d MMM");
    private static final Logger log = LoggerFactory.getLogger(CbusNodeTablePane.class);

    public void initComponents(CanSystemConnectionMemo memo) {
        try {
            this.nodeModel = InstanceManager.getDefault(CbusNodeTableDataModel.class);
        }
        catch (NullPointerException nullPointerException) {
            log.error("Unable to get Node Table from Instance Manager");
        }
        this.init();
    }

    public void init() {
        this.nodeTable = new JTableWithColumnToolTips(this.nodeModel, CbusNodeTableDataModel.COLUMNTOOLTIPS){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                int modelRow = this.convertRowIndexToModel(row);
                int modelColumn = this.convertColumnIndexToModel(column);
                Component comp = super.prepareRenderer(renderer, row, column);
                if (!(this.isRowSelected(modelRow) || modelColumn != 9 && modelColumn != 10)) {
                    comp.setBackground(row % 2 == 0 ? this.getBackground() : CbusCommonSwing.WHITE_GREEN);
                }
                return comp;
            }
        };
        XTableColumnModel tcm = new XTableColumnModel();
        this.nodeTable.setColumnModel(tcm);
        this.sorter = new TableRowSorter<CbusNodeTableDataModel>(this.nodeModel);
        this.nodeTable.setRowSorter(this.sorter);
        CbusCommonSwing.configureTable(this.nodeTable);
        tcm.getColumn(0).setCellRenderer(this.getRenderer());
        tcm.getColumn(1).setCellRenderer(this.getRenderer());
        tcm.getColumn(2).setCellRenderer(this.getRenderer());
        tcm.getColumn(6).setCellRenderer(this.getRenderer());
        tcm.getColumn(4).setCellRenderer(this.getRenderer());
        tcm.getColumn(5).setCellRenderer(this.getRenderer());
        tcm.getColumn(8).setCellRenderer(this.getRenderer());
        tcm.getColumn(7).setCellRenderer(new ProgressCellRender(CbusCommonSwing.WHITE_GREEN));
        tcm.getColumn(12).setCellRenderer(this.getRenderer());
        tcm.getColumn(11).setCellRenderer(this.getRenderer());
        tcm.getColumn(13).setCellRenderer(this.getRenderer());
        tcm.getColumn(3).setCellEditor(new ButtonEditor(new JButton()));
        tcm.getColumn(3).setCellRenderer(new ButtonRenderer());
        ((JComponent)((Object)tcm.getColumn(3).getCellRenderer())).setOpaque(false);
        this.setLayout(new BorderLayout());
        JScrollPane eventScroll = new JScrollPane(this.nodeTable);
        eventScroll.setVisible(true);
        eventScroll.setPreferredSize(new Dimension(300, 40));
        this.add(eventScroll);
        this.validate();
        this.repaint();
        this.nodeModel.addTableModelListener(e -> {
            if (this.nodeModel.getRequestNodeRowToDisplay() > -1) {
                this.setRowToNode();
            }
        });
        this.nodeModel.fireTableDataChanged();
    }

    private void setRowToNode() {
        ThreadingUtil.runOnGUIEventually(() -> {
            int newRow = this.nodeModel.getRequestNodeRowToDisplay();
            if (newRow > -1) {
                this.nodeTable.setRowSelectionInterval(newRow, newRow);
                this.nodeTable.scrollRectToVisible(this.nodeTable.getCellRect(newRow, 0, true));
                this.nodeModel.setRequestNodeDisplay(-1);
            }
        });
    }

    private TableCellRenderer getRenderer() {
        return new TableCellRenderer(){
            JTextField f = new JTextField();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
                if (arg1 != null) {
                    String string = arg1.toString();
                    this.f.setText(string);
                    this.f.setHorizontalAlignment(0);
                    CbusCommonSwing.hideNumbersLessThan(0, string, this.f);
                    CbusCommonSwing.setCellFromDate(arg1, this.f, CbusNodeTablePane.this.DATE_FORMAT);
                    CbusCommonSwing.setCellFromBackupEnum(arg1, this.f);
                } else {
                    this.f.setText("");
                }
                CbusCommonSwing.setCellBackground(isSelected, this.f, table, row);
                CbusCommonSwing.setCellFocus(hasFocus, this.f, table);
                return this.f;
            }
        };
    }

    public void dispose() {
        this.nodeTable = null;
    }
}

