/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTimerManager;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeConfigTab;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.ThreadingUtil;
import jmri.util.swing.BusyDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeSetupPane
extends CbusNodeConfigTab {
    private ActionListener setNameListener;
    private ActionListener removeListener;
    private ActionListener setCanIdListener;
    private ActionListener selfEnumerateListener;
    private ActionListener clearAllEventsListener;
    private BusyDialog busy_dialog;
    private JButton setNameButton;
    private JButton removeNodeButton;
    private JButton selfCanEnumerateButton;
    private JButton setCanIdButton;
    private JButton clearAllEventsButton;
    private JTextField textFieldName;
    private boolean CANID_DIALOGUE_OPEN = false;
    private JFormattedTextField rqfield;
    private JLabel rqNNspinnerlabel;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeSetupPane.class);

    protected CbusNodeSetupPane(NodeConfigToolPane main) {
        super(main);
        this.getInitPane();
    }

    @Override
    public String getTitle() {
        return "Node Setup";
    }

    @Override
    public void changedNode(CbusNode newNode) {
        this.textFieldName.setText(this.nodeOfInterest.getUserName());
        this.validate();
        this.repaint();
    }

    private void getInitPane() {
        JPanel evPane = new JPanel();
        evPane.setLayout(new BoxLayout(evPane, 1));
        this.initListeners();
        JPanel nodeEventsPanel = new JPanel();
        nodeEventsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("EventCol")));
        this.clearAllEventsButton = new JButton("Clear All Events");
        this.clearAllEventsButton.addActionListener(this.clearAllEventsListener);
        nodeEventsPanel.add(this.clearAllEventsButton);
        evPane.add(this.getNamePanel());
        evPane.add(this.getCanIdPanel());
        evPane.add(nodeEventsPanel);
        evPane.add(this.getRemovePanel());
        JScrollPane eventScroll = new JScrollPane(evPane);
        this.add((Component)eventScroll, "Center");
    }

    private JPanel getNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JMRI Node User Name"));
        this.setNameButton = new JButton("Set Module User Name");
        this.textFieldName = new JTextField(20);
        namePanel.add(this.textFieldName);
        namePanel.add(this.setNameButton);
        this.setNameButton.addActionListener(this.setNameListener);
        return namePanel;
    }

    private JPanel getCanIdPanel() {
        JPanel canIdPanel = new JPanel();
        canIdPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "CAN ID"));
        this.selfCanEnumerateButton = new JButton("CAN ID Self Enumeration");
        this.selfCanEnumerateButton.addActionListener(this.selfEnumerateListener);
        this.setCanIdButton = new JButton("Force set CAN ID");
        this.setCanIdButton.addActionListener(this.setCanIdListener);
        canIdPanel.add(this.selfCanEnumerateButton);
        canIdPanel.add(this.setCanIdButton);
        return canIdPanel;
    }

    private JPanel getRemovePanel() {
        JPanel removePanel = new JPanel();
        removePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Node Manager"));
        this.removeNodeButton = new JButton("Remove from Table");
        removePanel.add(this.removeNodeButton);
        this.removeNodeButton.addActionListener(this.removeListener);
        return removePanel;
    }

    private void initListeners() {
        this.setNameListener = ae -> {
            this.nodeOfInterest.setUserName(this.textFieldName.getText());
            this.changedNode(this.nodeOfInterest);
        };
        this.removeListener = ae -> {
            JCheckBox checkbox = new JCheckBox("Remove node xml File");
            int oldRow = Math.max(0, this.getNodeRow() - 1);
            int option = JOptionPane.showOptionDialog(null, new Object[]{"Remove Node from Manager?", checkbox}, "Please Confirm", 2, 3, null, null, null);
            if (option == 0) {
                this.getMainPane().getNodeModel().removeRow(this.getMainPane().getNodeModel().getNodeRowFromNodeNum(this.nodeOfInterest.getNodeNumber()), checkbox.isSelected());
                if (this.getMainPane().nodeTable.getRowCount() > 0) {
                    this.getMainPane().nodeTable.getSelectionModel().setSelectionInterval(oldRow, oldRow);
                    this.getMainPane().tabbedPane.setSelectedIndex(0);
                }
            }
        };
        this.selfEnumerateListener = ae -> {
            this.busy_dialog = new BusyDialog(null, "CAN ID", false);
            this.busy_dialog.start();
            this.nodeOfInterest.send.eNUM(this.nodeOfInterest.getNodeNumber());
            ThreadingUtil.runOnGUIDelayed(() -> {
                this.changedNode(this.nodeOfInterest);
                this.busy_dialog.finish();
                this.busy_dialog = null;
            }, CbusNodeTimerManager.SINGLE_MESSAGE_TIMEOUT_TIME);
        };
        this.setCanIdListener = ae -> this.newCanIdDialogue();
        this.clearAllEventsListener = ae -> {
            int option = JOptionPane.showOptionDialog(null, "Delete All Events from Node?", "Please Confirm", 2, 3, null, null, null);
            if (option == 0) {
                if (this.getMainPane().getNodeModel().getAnyNodeInLearnMode() > -1) {
                    log.warn("Cancelling action, node {} is already in learn mode", (Object)this.getMainPane().getNodeModel().getAnyNodeInLearnMode());
                    return;
                }
                this.busy_dialog = new BusyDialog(null, "Clear All Events", false);
                this.busy_dialog.start();
                this.nodeOfInterest.send.nodeEnterLearnEvMode(this.nodeOfInterest.getNodeNumber());
                ThreadingUtil.runOnLayoutDelayed(() -> this.nodeOfInterest.send.nNCLR(this.nodeOfInterest.getNodeNumber()), 150);
                ThreadingUtil.runOnLayoutDelayed(() -> this.nodeOfInterest.send.nodeExitLearnEvMode(this.nodeOfInterest.getNodeNumber()), CbusNodeTimerManager.SINGLE_MESSAGE_TIMEOUT_TIME);
                ThreadingUtil.runOnGUIDelayed(() -> {
                    this.busy_dialog.finish();
                    this.busy_dialog = null;
                    this.nodeOfInterest.send.rQEVN(this.nodeOfInterest.getNodeNumber());
                }, CbusNodeTimerManager.SINGLE_MESSAGE_TIMEOUT_TIME + 150);
            }
        };
    }

    private void newCanIdDialogue() {
        if (this.CANID_DIALOGUE_OPEN) {
            return;
        }
        log.debug("allocating new can id");
        this.CANID_DIALOGUE_OPEN = true;
        JPanel rqNNpane = new JPanel();
        JPanel bottomrqNNpane = new JPanel();
        String spinnerlabel = "";
        this.rqNNspinnerlabel = new JLabel(spinnerlabel);
        bottomrqNNpane.setLayout(new GridLayout(2, 1));
        rqNNpane.setLayout(new BorderLayout());
        String popuplabel = "Please Select a new CAN ID";
        JSpinner rqnnSpinner = new JSpinner(new SpinnerNumberModel(Math.min(99, Math.max(1, this.nodeOfInterest.getNodeCanId())), 1, 99, 1));
        JComponent rqcomp = rqnnSpinner.getEditor();
        this.rqfield = (JFormattedTextField)rqcomp.getComponent(0);
        DefaultFormatter rqformatter = (DefaultFormatter)this.rqfield.getFormatter();
        rqformatter.setCommitsOnValidEdit(true);
        this.rqfield.setBackground(Color.white);
        rqnnSpinner.addChangeListener(e -> {
            int newval = (Integer)rqnnSpinner.getValue();
            log.debug("new canid selected value {}", (Object)newval);
            this.updateSpinnerFeedback(newval);
        });
        bottomrqNNpane.add(this.rqNNspinnerlabel);
        bottomrqNNpane.add(rqnnSpinner);
        rqNNpane.add((Component)bottomrqNNpane, "Center");
        this.updateSpinnerFeedback(Math.min(99, Math.max(1, this.nodeOfInterest.getNodeCanId())));
        int option = JOptionPane.showOptionDialog(null, rqNNpane, popuplabel, 2, 3, null, null, null);
        if (option == 2) {
            this.CANID_DIALOGUE_OPEN = false;
        } else if (option == 0) {
            int newval = (Integer)rqnnSpinner.getValue();
            this.busy_dialog = new BusyDialog(null, "CAN ID", false);
            this.busy_dialog.start();
            this.nodeOfInterest.send.cANID(this.nodeOfInterest.getNodeNumber(), newval);
            ThreadingUtil.runOnGUIDelayed(() -> {
                this.changedNode(this.nodeOfInterest);
                this.busy_dialog.finish();
                this.busy_dialog = null;
                this.CANID_DIALOGUE_OPEN = false;
            }, CbusNodeTimerManager.SINGLE_MESSAGE_TIMEOUT_TIME);
        }
    }

    private void updateSpinnerFeedback(int newval) {
        if (this.getMainPane().getNodeModel().getNodeNameFromCanId(newval).isEmpty()) {
            this.rqfield.setBackground(Color.white);
            this.rqNNspinnerlabel.setText("");
        } else {
            this.rqfield.setBackground(Color.yellow);
            this.rqNNspinnerlabel.setText("In Use by " + this.getMainPane().getNodeModel().getNodeNameFromCanId(newval));
        }
    }
}

