/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.node.CbusNodeEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeFromBackup;
import jmri.jmrix.can.cbus.node.CbusNodeFromFcuTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEventTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeFcuTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeInfoPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeNVEditTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CbusNodeRestoreFcuFrame
extends JmriJFrame {
    private CbusNodeFromFcuTableDataModel cbusNodeFcuDataModel;
    private JPanel infoPane = new JPanel();
    private JTabbedPane tabbedPane;
    private CbusNodeTableDataModel nodeModel;
    private CanSystemConnectionMemo _memo;
    private final NodeConfigToolPane mainpane;
    private CbusNodeNVEditTablePane nodevarPane;
    private CbusNodeEventTablePane nodeEventPane;
    private JSplitPane split;
    private CbusNodeInfoPane nodeinfoPane;
    private JTable nodeTable;
    private JButton openFCUButton;
    private JButton nodeToBeTaughtButton;
    private JButton importNodeNamesButton;
    private JButton importEventNamesButton;
    private JLabel fileLocationDisplayLabel;
    private JList<Object> list;
    private JCheckBox teachNvsCheckBox;
    private JCheckBox teachEventsCheckBox;
    private JCheckBox resetEventsBeforeTeach;
    private static JFileChooser chooser;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(CbusNodeRestoreFcuFrame.class);
    }

    public CbusNodeRestoreFcuFrame(NodeConfigToolPane main) {
        this.mainpane = main;
    }

    public void initComponents(CanSystemConnectionMemo memo) {
        this._memo = memo;
        this.cbusNodeFcuDataModel = new CbusNodeFromFcuTableDataModel(this._memo, 2, 6);
        this.nodeModel = InstanceManager.getDefault(CbusNodeTableDataModel.class);
        this.initMainPane();
    }

    private void initMainPane() {
        this.mainpane.setRestoreFcuActive(true);
        this.infoPane = new JPanel();
        this.infoPane.setLayout(new BorderLayout());
        JPanel nvMenuPane = new JPanel();
        nvMenuPane.setLayout(new BoxLayout(nvMenuPane, 1));
        JPanel buttonPane = new JPanel();
        this.openFCUButton = new JButton("Select FCU File");
        this.importNodeNamesButton = new JButton("Import Node Names");
        this.importEventNamesButton = new JButton("Import event Names");
        this.importNodeNamesButton.setEnabled(false);
        this.importEventNamesButton.setEnabled(false);
        this.importEventNamesButton.setToolTipText("No File Selected");
        this.importNodeNamesButton.setToolTipText("No File Selected");
        buttonPane.add(this.openFCUButton);
        buttonPane.add(this.importEventNamesButton);
        buttonPane.add(this.importNodeNamesButton);
        this.updateImportEventsButton();
        nvMenuPane.add(buttonPane);
        CbusNodeFcuTablePane fcuTablePane = new CbusNodeFcuTablePane();
        fcuTablePane.initComponents(this._memo, this.cbusNodeFcuDataModel);
        this.nodeTable = fcuTablePane.nodeTable;
        JPanel fcuPane = new JPanel();
        fcuPane.setLayout(new BoxLayout(fcuPane, 1));
        fcuPane.add(fcuTablePane);
        JPanel fileLabelPane = new JPanel();
        this.fileLocationDisplayLabel = new JLabel("");
        fileLabelPane.add(this.fileLocationDisplayLabel);
        nvMenuPane.add(fileLabelPane);
        JPanel nodeToBeTaughtPane = new JPanel();
        nodeToBeTaughtPane.setLayout(new BoxLayout(nodeToBeTaughtPane, 1));
        ArrayList<String> nodeTableNodeArr = new ArrayList<String>();
        this.nodeModel.getListOfNodeNumberNames().forEach(ref -> nodeTableNodeArr.add((String)ref));
        if (nodeTableNodeArr.isEmpty()) {
            nodeTableNodeArr.add("<html><span style='color:red'>Node Table Empty</span></html>");
        }
        Object[] strArray = new Object[nodeTableNodeArr.size()];
        nodeTableNodeArr.toArray(strArray);
        this.list = new JList<Object>(strArray);
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(-1);
        this.list.setSelectionMode(0);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(300, 80));
        nodeToBeTaughtPane.add(listScroller);
        JPanel nodeToBeTaughtButtonPane = new JPanel();
        nodeToBeTaughtButtonPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select Node to Teach"));
        JPanel nodeToBeTaughtCheckboxPane = new JPanel();
        nodeToBeTaughtCheckboxPane.setLayout(new BoxLayout(nodeToBeTaughtCheckboxPane, 1));
        nodeToBeTaughtButtonPane.add(nodeToBeTaughtPane);
        this.nodeToBeTaughtButton = new JButton(Bundle.getMessage("UpdateNodeButton"));
        this.teachNvsCheckBox = new JCheckBox("Teach NV's");
        this.teachEventsCheckBox = new JCheckBox("Teach Events");
        this.resetEventsBeforeTeach = new JCheckBox("Wipe existing events");
        this.teachNvsCheckBox.setSelected(true);
        this.teachEventsCheckBox.setSelected(true);
        this.resetEventsBeforeTeach.setSelected(true);
        nodeToBeTaughtCheckboxPane.add(this.teachNvsCheckBox);
        nodeToBeTaughtCheckboxPane.add(this.resetEventsBeforeTeach);
        nodeToBeTaughtCheckboxPane.add(this.teachEventsCheckBox);
        nodeToBeTaughtButtonPane.add(nodeToBeTaughtCheckboxPane);
        nodeToBeTaughtButtonPane.add(this.nodeToBeTaughtButton);
        this.tabbedPane = new JTabbedPane();
        this.nodeinfoPane = new CbusNodeInfoPane(null);
        CbusNodeNVTableDataModel nodeNVModel = new CbusNodeNVTableDataModel(this._memo, 5, 8);
        this.nodevarPane = new CbusNodeNVEditTablePane(nodeNVModel);
        this.nodevarPane.setNonEditable();
        CbusNodeEventTableDataModel nodeEvModel = new CbusNodeEventTableDataModel(null, this._memo, 10, 7);
        this.nodeEventPane = new CbusNodeEventTablePane(nodeEvModel);
        this.nodeEventPane.setHideEditButton();
        this.nodeEventPane.initComponents(this._memo);
        this.tabbedPane.addTab("Node Info", this.nodeinfoPane);
        this.tabbedPane.addTab("Node Variables", this.nodevarPane);
        this.tabbedPane.addTab("Node Events", this.nodeEventPane);
        this.tabbedPane.addChangeListener(e -> this.updateTabs());
        this.split = new JSplitPane(0, fcuPane, this.tabbedPane);
        this.split.setContinuousLayout(true);
        this.infoPane.add((Component)nvMenuPane, "First");
        this.infoPane.add((Component)this.split, "Center");
        this.infoPane.add((Component)nodeToBeTaughtButtonPane, "Last");
        this.add(this.infoPane);
        fcuPane.setPreferredSize(new Dimension(200, 150));
        this.pack();
        this.setResizable(true);
        this.validate();
        this.repaint();
        this.setTitle(this.getTitle());
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CbusNodeRestoreFcuFrame.this.mainpane.setRestoreFcuActive(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                CbusNodeRestoreFcuFrame.this.mainpane.setRestoreFcuActive(false);
            }
        });
        ActionListener save = ae -> {
            this.mainpane.showConfirmThenSave(this.nodeFromSelectedRow(), this.nodeFromSelectedList(), this.teachNvsCheckBox.isSelected(), this.resetEventsBeforeTeach.isSelected(), this.teachEventsCheckBox.isSelected(), this);
            if (this.teachEventsCheckBox.isSelected()) {
                this.teachJmriEventNamesFromNode(this.nodeFromSelectedRow());
            }
        };
        this.nodeToBeTaughtButton.addActionListener(save);
        ActionListener importFcuNodeNames = ae -> this.selectInputFile();
        this.openFCUButton.addActionListener(importFcuNodeNames);
        ActionListener importEventNames = ae -> {
            log.info("Importing All Event Names");
            int i = 0;
            while (i < this.cbusNodeFcuDataModel.getRowCount()) {
                this.teachJmriEventNamesFromNode(this.cbusNodeFcuDataModel.getNodeByRowNum(i));
                ++i;
            }
            this.importEventNamesButton.setEnabled(false);
        };
        this.importEventNamesButton.addActionListener(importEventNames);
        ActionListener importNodeNames = ae -> {
            log.info("Importing Node Names");
            int i = 0;
            while (i < this.cbusNodeFcuDataModel.getRowCount()) {
                this.nodeModel.provideNodeByNodeNum(this.cbusNodeFcuDataModel.getNodeByRowNum(i).getNodeNumber()).setNameIfNoName(this.cbusNodeFcuDataModel.getNodeByRowNum(i).getUserName());
                ++i;
            }
            this.importNodeNamesButton.setEnabled(false);
        };
        this.importNodeNamesButton.addActionListener(importNodeNames);
        this.nodeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateTabs();
                this.updateRestoreNodeButton();
            }
        });
        this.list.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateRestoreNodeButton();
            }
        });
        this.updateRestoreNodeButton();
    }

    private CbusNode nodeFromSelectedRow() {
        int sel = this.nodeTable.getSelectedRow();
        if (sel > -1) {
            int modelIndex = this.nodeTable.convertRowIndexToModel(sel);
            int nodenum = (Integer)this.nodeTable.getModel().getValueAt(modelIndex, 0);
            return this.cbusNodeFcuDataModel.getNodeByNodeNum(nodenum);
        }
        return null;
    }

    private CbusNode nodeFromSelectedList() {
        Object obj = this.list.getSelectedValue();
        if (obj == null) {
            return null;
        }
        String listSelected = obj.toString();
        int _targetnodenum = StringUtil.getFirstIntFromString(listSelected);
        return this.nodeModel.getNodeByNodeNum(_targetnodenum);
    }

    private void updateTabs() {
        if (this.nodeTable.getSelectedRow() > -1) {
            switch (this.tabbedPane.getSelectedIndex()) {
                case 1: {
                    this.nodevarPane.setNode(this.nodeFromSelectedRow());
                    break;
                }
                case 2: {
                    this.nodeEventPane.setNode(this.nodeFromSelectedRow());
                    break;
                }
                default: {
                    this.nodeinfoPane.setNode(this.nodeFromSelectedRow());
                    break;
                }
            }
        } else {
            this.nodeinfoPane.setNode(null);
        }
    }

    private void updateRestoreNodeButton() {
        if (this.nodeFromSelectedRow() == null) {
            this.nodeToBeTaughtButton.setEnabled(false);
            this.nodeToBeTaughtButton.setToolTipText("Select a Node from file in top table");
            return;
        }
        if (this.nodeFromSelectedList() == null) {
            this.nodeToBeTaughtButton.setEnabled(false);
            this.nodeToBeTaughtButton.setToolTipText("Select a target Node from list on left");
            return;
        }
        if (this.nodeFromSelectedRow().getNodeNvManager().getTotalNVs() == this.nodeFromSelectedList().getNodeNvManager().getTotalNVs() && this.nodeFromSelectedRow().getNodeParamManager().getParameter(5) == this.nodeFromSelectedList().getNodeParamManager().getParameter(5)) {
            this.nodeToBeTaughtButton.setEnabled(true);
            this.nodeToBeTaughtButton.setToolTipText(null);
            return;
        }
        this.nodeToBeTaughtButton.setEnabled(false);
        this.nodeToBeTaughtButton.setToolTipText("Both nodes must have same amount of NV's");
    }

    private void selectInputFile() {
        if (chooser == null) {
            chooser = XmlFile.userFileChooser("XML Files", "xml", "XML");
        }
        chooser.rescanCurrentDirectory();
        int retVal = chooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        File testForXml = chooser.getSelectedFile();
        if (!testForXml.getPath().toUpperCase().endsWith("XML")) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ImportNotXml"), Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        this.addFile(testForXml);
    }

    private void addFile(File inputFile) {
        this.fileLocationDisplayLabel.setText(inputFile.toString());
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("userNodes");
            int temp = 0;
            while (temp < nodeList.getLength()) {
                Node nNode = nodeList.item(temp);
                Element eElement = (Element)nNode;
                String nodeNum = eElement.getElementsByTagName("nodeNum").item(0).getTextContent();
                String nodeName = eElement.getElementsByTagName("nodeName").item(0).getTextContent();
                String moduleIdNum = eElement.getElementsByTagName("moduleId").item(0).getTextContent();
                String moduleNvString = eElement.getElementsByTagName("NodeVars").item(0).getTextContent();
                String nodeVersion = eElement.getElementsByTagName("Version").item(0).getTextContent();
                int nodenum = Integer.parseInt(nodeNum);
                int nodetype = Integer.parseInt(moduleIdNum);
                if (nodenum > 0) {
                    CbusNodeFromBackup actualnode = this.cbusNodeFcuDataModel.provideNodeByNodeNum(nodenum);
                    actualnode.setNameIfNoName(nodeName);
                    actualnode.getNodeEventManager().resetNodeEvents();
                    log.debug("node version {}", (Object)nodeVersion);
                    int[] nvArray = StringUtil.intBytesWithTotalFromNonSpacedHexString(moduleNvString, true);
                    int[] myarray = new int[]{7, 165, -1, nodetype, -1, -1, nvArray[0], -1};
                    actualnode.getNodeParamManager().setParameters(myarray);
                    if (nvArray.length > 1) {
                        actualnode.getNodeNvManager().setNVs(nvArray);
                    }
                }
                ++temp;
            }
            NodeList eventList = doc.getElementsByTagName("userEvents");
            int temp2 = 0;
            while (temp2 < eventList.getLength()) {
                Node nNode = eventList.item(temp2);
                Element eElement = (Element)nNode;
                String hostNodeNumString = eElement.getElementsByTagName("ownerNode").item(0).getTextContent();
                String event = eElement.getElementsByTagName("eventValue").item(0).getTextContent();
                String eventNode = eElement.getElementsByTagName("eventNode").item(0).getTextContent();
                String eventName = eElement.getElementsByTagName("eventName").item(0).getTextContent();
                String eventVars = eElement.getElementsByTagName("Values").item(0).getTextContent();
                int hostNodeNum = Integer.parseInt(hostNodeNumString);
                if (hostNodeNum > 0) {
                    int eventNum = Integer.parseInt(event);
                    int eventNodeNum = Integer.parseInt(eventNode);
                    log.debug("event host {} event {} event node {} vars {}", new Object[]{hostNodeNum, eventNum, eventNodeNum, eventVars});
                    CbusNodeFromBackup hostNode = this.cbusNodeFcuDataModel.provideNodeByNodeNum(hostNodeNum);
                    if (!eventVars.isEmpty()) {
                        int[] evVarArray = StringUtil.intBytesWithTotalFromNonSpacedHexString(eventVars, false);
                        if (hostNode.getNodeParamManager().getParameter(5) < 0) {
                            hostNode.getNodeParamManager().setParameter(5, evVarArray.length);
                        }
                        CbusNodeEvent ev = new CbusNodeEvent(this._memo, eventNodeNum, eventNum, hostNodeNum, -1, hostNode.getNodeParamManager().getParameter(5));
                        ev.setEvArr(evVarArray);
                        ev.setName(eventName);
                        ev.setTempFcuNodeName(this.cbusNodeFcuDataModel.getNodeName(eventNodeNum));
                        hostNode.getNodeEventManager().addNewEvent(ev);
                    }
                }
                ++temp2;
            }
            this.updateImportEventsButton();
        }
        catch (IOException | NumberFormatException | ParserConfigurationException | DOMException | SAXException e) {
            log.warn("Error importing xml file. Valid xml? {}", (Throwable)e);
            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("ImportError")) + " Valid XML?", Bundle.getMessage("WarningTitle"), 0);
        }
    }

    private boolean eventsOnTable() {
        int i = 0;
        while (i < this.cbusNodeFcuDataModel.getRowCount()) {
            if ((Integer)this.cbusNodeFcuDataModel.getValueAt(i, 3) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateImportEventsButton() {
        CbusEventTableDataModel eventModel = InstanceManager.getNullableDefault(CbusEventTableDataModel.class);
        if (eventModel == null) {
            this.importEventNamesButton.setEnabled(false);
            this.importEventNamesButton.setToolTipText("CBUS Event Table Not Running");
        } else if (this.eventsOnTable()) {
            this.importEventNamesButton.setEnabled(true);
            this.importEventNamesButton.setToolTipText(null);
        } else {
            this.importEventNamesButton.setEnabled(false);
            this.importEventNamesButton.setToolTipText("No Events to Import");
        }
    }

    private void teachJmriEventNamesFromNode(CbusNode nodeWithEvents) {
        CbusEventTableDataModel eventModel = InstanceManager.getNullableDefault(CbusEventTableDataModel.class);
        if (eventModel == null) {
            log.info("CBUS Event Table not running, no Event Names imported.");
            return;
        }
        ArrayList<CbusNodeEvent> evList = nodeWithEvents.getNodeEventManager().getEventArray();
        if (evList != null) {
            int i = 0;
            while (i < evList.size()) {
                if (!evList.get(i).getName().isEmpty()) {
                    eventModel.provideEvent(evList.get(i).getNn(), evList.get(i).getEn()).setName(evList.get(i).getName());
                }
                ++i;
            }
        }
        eventModel.fireTableDataChanged();
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("FcuImportTitle");
    }
}

