/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEventTableDataModel;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.jmrix.can.cbus.swing.CbusTableRowEventDnDHandler;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class CbusNodeEventTablePane
extends CanPanel {
    private final CbusNodeEventTableDataModel nodeEventModel;
    private JScrollPane eventVarScroll;
    private JPanel pane1;
    private JTable nodeEventTable;
    private TableRowSorter<CbusNodeEventTableDataModel> sorter;
    private CbusTableRowEventDnDHandler eventDragHandler;
    private boolean hideEditButton = false;

    public CbusNodeEventTablePane(CbusNodeEventTableDataModel model) {
        this.nodeEventModel = model;
        this.nodeEventTable = new JTable(this.nodeEventModel);
    }

    public void setNode(CbusNode node) {
        if (node == null && this.pane1 != null) {
            this.pane1.setVisible(false);
            return;
        }
        this.nodeEventModel.setNode(node);
        this.nodeEventTable = new JTable(this.nodeEventModel);
        this.init();
    }

    public void init() {
        if (this.pane1 != null) {
            this.pane1.setVisible(false);
        }
        this.pane1 = null;
        if (this.nodeEventTable == null) {
            return;
        }
        TableColumnModel tcm = this.nodeEventTable.getColumnModel();
        this.sorter = null;
        if (this.nodeEventModel.getRowCount() > 0) {
            this.nodeEventTable.setAutoCreateRowSorter(true);
            this.sorter = new TableRowSorter<CbusNodeEventTableDataModel>(this.nodeEventModel);
            this.nodeEventTable.setRowSorter(this.sorter);
        }
        CbusCommonSwing.configureTable(this.nodeEventTable);
        this.setColumnRenderers(tcm);
        this.pane1 = new JPanel();
        this.setLayout(new BorderLayout());
        this.pane1.setLayout(new BorderLayout());
        this.eventVarScroll = new JScrollPane(this.nodeEventTable);
        this.pane1.add(this.eventVarScroll);
        this.add(this.pane1);
        this.pane1.setVisible(true);
        this.nodeEventTable.setDragEnabled(true);
        this.nodeEventTable.setDropMode(DropMode.ON);
        this.eventDragHandler = new CbusTableRowEventDnDHandler(this.memo, this.nodeEventTable);
        this.nodeEventTable.setTransferHandler(this.eventDragHandler);
    }

    private void setColumnRenderers(TableColumnModel tcm) {
        int i = 0;
        while (i < 7) {
            if (2 == i) {
                tcm.getColumn(i).setCellEditor(new ButtonEditor(new JButton()));
                tcm.getColumn(i).setCellRenderer(new ButtonRenderer());
            } else {
                tcm.getColumn(i).setCellRenderer(this.getRenderer());
            }
            ++i;
        }
        TableColumn delBColumn = tcm.getColumn(2);
        if (this.hideEditButton) {
            delBColumn.setMinWidth(0);
            delBColumn.setMaxWidth(0);
            delBColumn.setWidth(0);
        }
    }

    protected void setHideEditButton() {
        this.hideEditButton = true;
    }

    private TableCellRenderer getRenderer() {
        return new TableCellRenderer(){
            JTextField f = new JTextField();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
                this.f.setHorizontalAlignment(0);
                this.f.setBorder(table.getBorder());
                if (arg1 != null) {
                    String string = arg1.toString();
                    this.f.setText(string);
                    CbusCommonSwing.hideNumbersLessThan(0, string, this.f);
                } else {
                    this.f.setText("");
                }
                CbusCommonSwing.setCellBackground(isSelected, this.f, table, row);
                CbusCommonSwing.setCellFocus(hasFocus, this.f, table);
                return this.f;
            }
        };
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemEventTable"));
    }

    @Override
    public void dispose() {
        this.eventDragHandler.dispose();
        this.eventVarScroll = null;
    }
}

