/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.sprogdcc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Bundle;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Sprog3PlusEditNVPane;

public class Sprog3PlusPaneProvider
extends CbusConfigPaneProvider {
    String type = "CANSPROG3P";
    public static final int CMD_STATION_NUMBER = 1;
    public static final int USER_FLAGS = 2;
    public static final int OPERATIONS_FLAGS = 3;
    public static final int DEBUG_FLAGS = 4;
    public static final int PROG_TRACK_POWER_MODE = 5;
    public static final int PROG_TRACK_CURRENT_LIMIT = 6;
    public static final int INPUT_VOLTAGE = 7;
    public static final int MAIN_TRACK_CURRENT = 8;
    public static final int ACCY_PACKET_REPEAT_COUNT = 9;
    public static final int MULTIMETER_MODE = 10;
    public static final int NN_MAP_DCC_HI = 11;
    public static final int NN_MAP_DCC_LO = 12;
    public static final int MAIN_TRACK_CURRENT_LIMIT = 13;
    public static final int PROG_TRACK_CURRENT = 14;
    public static final int MAIN_HIGH_WATER_MARK = 15;
    public static final int PROG_HIGH_WATER_MARK = 16;
    public static final int SETUP = 17;
    public static final int CANID = 18;
    public static final int NN_HI = 19;
    public static final int NN_LO = 20;
    public static final int DCC_PREAMBLE = 21;
    public static final int CAN_DISABLE = 22;
    private static final Map<Integer, String> nvMap = Sprog3PlusPaneProvider.createNvMap();

    @Override
    @Nonnull
    public String getModuleType() {
        return this.type;
    }

    private static Map<Integer, String> createNvMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "Error - invalid NV index");
        result.put(1, Bundle.getMessage("CmdStaNo"));
        result.put(2, Bundle.getMessage("UserFlags"));
        result.put(3, Bundle.getMessage("OperationsFlags"));
        result.put(4, Bundle.getMessage("DebugFlags"));
        result.put(5, Bundle.getMessage("ProgTrackPowerMode"));
        result.put(6, Bundle.getMessage("ProgTrackCurrentLimit"));
        result.put(7, Bundle.getMessage("InputVoltage"));
        result.put(8, Bundle.getMessage("MainTrackCurrent"));
        result.put(9, Bundle.getMessage("AccessoryPacketRepeatCount"));
        result.put(10, Bundle.getMessage("MultimeterMode"));
        result.put(11, Bundle.getMessage("NnMapToDccHi"));
        result.put(12, Bundle.getMessage("NnMapToDccLo"));
        result.put(13, Bundle.getMessage("MainTrackCurrentLimit"));
        result.put(14, Bundle.getMessage("ProgTackCurrent"));
        result.put(15, Bundle.getMessage("MainTrackCurrentHWM"));
        result.put(16, Bundle.getMessage("ProgTrackCurrentHWM"));
        result.put(17, Bundle.getMessage("SetupMode"));
        result.put(18, Bundle.getMessage("CanId"));
        result.put(19, Bundle.getMessage("NodeNumberHi"));
        result.put(20, Bundle.getMessage("NodeNumberLo"));
        result.put(21, Bundle.getMessage("DccPreambleBits"));
        result.put(22, Bundle.getMessage("CanDisable"));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public String getNVNameByIndex(int index) {
        String nv = nvMap.get(index);
        if (nv == null) {
            return Bundle.getMessage("UnknownNv");
        }
        return nv;
    }

    @Override
    public AbstractEditNVPane getEditNVFrameInstance() {
        return this._nVarEditFrame;
    }

    @Override
    public AbstractEditNVPane getEditNVFrame(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        this._nVarEditFrame = new Sprog3PlusEditNVPane(dataModel, node);
        return this._nVarEditFrame.getContent();
    }
}

