/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.sprogdcc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CbusModulesCommon;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Bundle;

public class Sprog3PlusEditNVPane
extends AbstractEditNVPane {
    private static final int USER_FLAGS = 0;
    private static final int OPS_FLAGS = 1;
    private static final int DEBUG_FLAGS = 2;
    private CbusModulesCommon.CmdStaFlags[] csFlags = new CbusModulesCommon.CmdStaFlags[3];
    private final CbusModulesCommon.UpdateNV cmdStaNoUpdateFn = new UpdateCmdStaNo();
    private final CbusModulesCommon.UpdateNV canIdUpdateFn = new UpdateCanId();
    private final CbusModulesCommon.UpdateNV nodeNumberUpdateFn = new UpdateNodeNumber();
    private final CbusModulesCommon.UpdateNV currentLimitUpdateFn = new UpdateCurrentLimit();
    private final CbusModulesCommon.UpdateNV accyPktUpdateFn = new UpdateAccyCount();
    private final CbusModulesCommon.UpdateNV nnMapUpdateFn = new UpdateNnMap();
    private final CbusModulesCommon.UpdateNV preambleUpdateFn = new UpdatePreamble();
    private final CbusModulesCommon.UpdateNV powerModeUpdateFn = new UpdatePowerMode();
    private final CbusModulesCommon.UpdateNV meterUpdateFn = new UpdateMeter();
    private final CbusModulesCommon.UpdateNV flagUpdateFn = new UpdateFlags();
    private CbusModulesCommon.TitledSpinner cmdStaNoSpinner;
    private JComboBox<String> powerModeList;
    private CbusModulesCommon.TitledSpinner mainSpinner;
    private CbusModulesCommon.TitledSpinner progSpinner;
    private CbusModulesCommon.TitledSpinner accyPktSpinner;
    private JRadioButton meter;
    private CbusModulesCommon.TitledSpinner nnMapDccSpinner;
    private JRadioButton setup;
    private CbusModulesCommon.TitledSpinner canIdSpinner;
    private CbusModulesCommon.TitledSpinner nodeNumberSpinner;
    private CbusModulesCommon.TitledSpinner preambleSpinner;
    private JRadioButton disable;
    protected String[] flagTitleStrings = new String[]{Bundle.getMessage("UserFlags"), Bundle.getMessage("OperationsFlags"), Bundle.getMessage("DebugFlags")};
    protected String[][] flagStrings = new String[][]{{Bundle.getMessage("Reserved"), Bundle.getMessage("PermitSteal"), Bundle.getMessage("PermitShare"), Bundle.getMessage("Reserved"), Bundle.getMessage("MapEvents"), Bundle.getMessage("StopOnTimeout"), Bundle.getMessage("StartOfDay"), Bundle.getMessage("AutoPower")}, {Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("ZtcMode"), Bundle.getMessage("AllStopTrackOff"), Bundle.getMessage("BluelineMode"), Bundle.getMessage("AckSensitivity"), Bundle.getMessage("Reserved")}, {Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved")}};
    protected String[][] flagTtStrings = new String[][]{{Bundle.getMessage("ReservedTt"), Bundle.getMessage("PermitStealTt"), Bundle.getMessage("PermitShareTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("MapEventsTt"), Bundle.getMessage("StopOnTimeoutTt"), Bundle.getMessage("StartOfDayTt"), Bundle.getMessage("AutoPowerTt")}, {Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ZtcModeTt"), Bundle.getMessage("AllStopTrackOffTt"), Bundle.getMessage("BluelineModeTt"), Bundle.getMessage("AckSensitivityTt"), Bundle.getMessage("ReservedTt")}, {Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt")}};

    protected Sprog3PlusEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        CmdStaPane cmdStaPane = new CmdStaPane();
        DccPane dccPane = new DccPane();
        CbusPane cbusPane = new CbusPane();
        tabbedPane.addTab(Bundle.getMessage("CmdSta"), cmdStaPane);
        tabbedPane.addTab("DCC", dccPane);
        tabbedPane.addTab("CBUS Diagnostics", cbusPane);
        JScrollPane scroll = new JScrollPane(tabbedPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue(nv);
            switch (nv) {
                case 1: {
                    this.cmdStaNoSpinner.getModel().setValue(value);
                    break;
                }
                case 2: {
                    this.csFlags[0].setFlags(value);
                    break;
                }
                case 3: {
                    this.csFlags[1].setFlags(value);
                    break;
                }
                case 4: {
                    this.csFlags[2].setFlags(value);
                    break;
                }
                case 5: {
                    this.powerModeList.setSelectedIndex(value);
                    break;
                }
                case 6: {
                    double progLimit = (double)value / 100.0;
                    this.progSpinner.getModel().setValue(progLimit);
                    break;
                }
                case 13: {
                    double mainLimit = (double)value / 100.0;
                    this.mainSpinner.getModel().setValue(mainLimit);
                    break;
                }
                case 9: {
                    this.accyPktSpinner.getModel().setValue(value);
                    break;
                }
                case 10: {
                    this.meter.setSelected(value != 0);
                    break;
                }
                case 11: 
                case 12: {
                    this.nnMapDccSpinner.getModel().setValue(this.getSelectValue(11, 12, 0));
                    break;
                }
                case 17: {
                    this.setup.setSelected(value != 0);
                    break;
                }
                case 18: {
                    this.canIdSpinner.getModel().setValue(value);
                    break;
                }
                case 19: 
                case 20: {
                    this.nodeNumberSpinner.getModel().setValue(this.getSelectValue(19, 20, 0));
                    break;
                }
                case 21: {
                    this.preambleSpinner.getModel().setValue(value);
                    break;
                }
                case 22: {
                    this.disable.setEnabled(value != 0);
                    break;
                }
            }
        }
    }

    public class CbusPane
    extends JPanel {
        public CbusPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Sprog3PlusEditNVPane.this.canIdSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("CanId"), 18, Sprog3PlusEditNVPane.this.canIdUpdateFn);
            Sprog3PlusEditNVPane.this.canIdSpinner.setToolTip(Bundle.getMessage("CanIdTt"));
            Sprog3PlusEditNVPane.this.canIdSpinner.init(Sprog3PlusEditNVPane.this.getSelectValue(18, 100), 100.0, 127.0, 1.0);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.canIdSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.nodeNumberSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("NodeNumber"), 19, Sprog3PlusEditNVPane.this.nodeNumberUpdateFn);
            Sprog3PlusEditNVPane.this.nodeNumberSpinner.setToolTip(Bundle.getMessage("NodeNumberTt"));
            int nn = Sprog3PlusEditNVPane.this.getSelectValue(19, 20, 65520);
            Sprog3PlusEditNVPane.this.nodeNumberSpinner.init(nn, 65520.0, 65534.0, 1.0);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.nodeNumberSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.setup = new JRadioButton("SetupMode");
            Sprog3PlusEditNVPane.this.setup.setSelected(false);
            Sprog3PlusEditNVPane.this.setup.setToolTipText(Bundle.getMessage("SetupModeTt"));
            gridPane.add((Component)Sprog3PlusEditNVPane.this.setup, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.disable = new JRadioButton("DisableCan");
            Sprog3PlusEditNVPane.this.disable.setSelected(false);
            Sprog3PlusEditNVPane.this.disable.setToolTipText(Bundle.getMessage("DisableCanTt"));
            gridPane.add((Component)Sprog3PlusEditNVPane.this.disable, c);
            ++c.gridy;
            this.add(gridPane);
        }
    }

    public class CmdStaPane
    extends JPanel {
        public CmdStaPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            JPanel[] flagPane = new JPanel[3];
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            int i = 0;
            while (i < 3) {
                ((Sprog3PlusEditNVPane)Sprog3PlusEditNVPane.this).csFlags[i] = new CbusModulesCommon.CmdStaFlags(i, Sprog3PlusEditNVPane.this.flagTitleStrings[i], Sprog3PlusEditNVPane.this.flagStrings[i], Sprog3PlusEditNVPane.this.flagTtStrings[i], Sprog3PlusEditNVPane.this.flagUpdateFn);
                flagPane[i] = Sprog3PlusEditNVPane.this.csFlags[i].getContents();
                ++i;
            }
            Sprog3PlusEditNVPane.this.csFlags[0].setFlags(Sprog3PlusEditNVPane.this.getSelectValue(2));
            Sprog3PlusEditNVPane.this.csFlags[1].setFlags(Sprog3PlusEditNVPane.this.getSelectValue(3));
            Sprog3PlusEditNVPane.this.csFlags[2].setFlags(Sprog3PlusEditNVPane.this.getSelectValue(4));
            String[] powerModeStrings = new String[]{Bundle.getMessage("ProgOffMode"), Bundle.getMessage("ProgOnMode"), Bundle.getMessage("ProgArMode")};
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Sprog3PlusEditNVPane.this.cmdStaNoSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("CmdStaNo"), 1, Sprog3PlusEditNVPane.this.cmdStaNoUpdateFn);
            Sprog3PlusEditNVPane.this.cmdStaNoSpinner.setToolTip(Bundle.getMessage("CmdStaNoTt"));
            Sprog3PlusEditNVPane.this.cmdStaNoSpinner.init(0.0, 0.0, 255.0, 1.0);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.cmdStaNoSpinner, c);
            ++c.gridy;
            c.gridwidth = 3;
            Sprog3PlusEditNVPane.this.powerModeList = new JComboBox<String>(powerModeStrings);
            Sprog3PlusEditNVPane.this.powerModeList.setSelectedIndex(Sprog3PlusEditNVPane.this.getSelectValue(5));
            Sprog3PlusEditNVPane.this.powerModeList.addActionListener(e -> this.pwrModeActionListener(e));
            gridPane.add((Component)Sprog3PlusEditNVPane.this.powerModeList, c);
            c.gridwidth = 1;
            ++c.gridy;
            Sprog3PlusEditNVPane.this.meter = new JRadioButton(Bundle.getMessage("Multimeter"));
            Sprog3PlusEditNVPane.this.meter.setSelected(false);
            Sprog3PlusEditNVPane.this.meter.setToolTipText(Bundle.getMessage("MultimeterTt"));
            Sprog3PlusEditNVPane.this.meter.addActionListener(e -> this.meterActionListener(e));
            gridPane.add((Component)Sprog3PlusEditNVPane.this.meter, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.mainSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("MainLimit"), 13, Sprog3PlusEditNVPane.this.currentLimitUpdateFn);
            Sprog3PlusEditNVPane.this.mainSpinner.setToolTip(Bundle.getMessage("MainLimitTt"));
            Sprog3PlusEditNVPane.this.mainSpinner.init((double)Sprog3PlusEditNVPane.this.getSelectValue(13, 100) / 100.0, 1.0, 2.5, 0.01);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.mainSpinner, c);
            ++c.gridy;
            gridPane.add((Component)flagPane[0], c);
            ++c.gridx;
            c.gridy = 0;
            ++c.gridy;
            ++c.gridy;
            ++c.gridy;
            Sprog3PlusEditNVPane.this.progSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("ProgLimit"), 6, Sprog3PlusEditNVPane.this.currentLimitUpdateFn);
            Sprog3PlusEditNVPane.this.progSpinner.setToolTip(Bundle.getMessage("ProgLimitTt"));
            Sprog3PlusEditNVPane.this.progSpinner.init((double)Sprog3PlusEditNVPane.this.getSelectValue(6, 100) / 100.0, 1.0, 2.5, 0.01);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.progSpinner, c);
            ++c.gridy;
            gridPane.add((Component)flagPane[1], c);
            ++c.gridx;
            c.gridy = 0;
            ++c.gridy;
            ++c.gridy;
            ++c.gridy;
            ++c.gridy;
            gridPane.add((Component)flagPane[2], c);
            ++c.gridx;
            this.add(gridPane);
        }

        protected void pwrModeActionListener(ActionEvent e) {
            Sprog3PlusEditNVPane.this.powerModeUpdateFn.setNewVal(5);
        }

        protected void meterActionListener(ActionEvent e) {
            Sprog3PlusEditNVPane.this.meterUpdateFn.setNewVal(10);
        }
    }

    public class DccPane
    extends JPanel {
        public DccPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Sprog3PlusEditNVPane.this.accyPktSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("AccyPktCnt"), 9, Sprog3PlusEditNVPane.this.accyPktUpdateFn);
            Sprog3PlusEditNVPane.this.accyPktSpinner.setToolTip(Bundle.getMessage("AccyPktCntTt"));
            Sprog3PlusEditNVPane.this.accyPktSpinner.init(Sprog3PlusEditNVPane.this.getSelectValue(9, 1), 1.0, 7.0, 1.0);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.accyPktSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.nnMapDccSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("NnMapDcc"), 11, Sprog3PlusEditNVPane.this.nnMapUpdateFn);
            Sprog3PlusEditNVPane.this.nnMapDccSpinner.setToolTip(Bundle.getMessage("NnMapDccTt"));
            int nn = Sprog3PlusEditNVPane.this.getSelectValue(11, 12, 0);
            Sprog3PlusEditNVPane.this.nnMapDccSpinner.init(nn, 0.0, 65535.0, 1.0);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.nnMapDccSpinner, c);
            ++c.gridy;
            gridPane.add((Component)Sprog3PlusEditNVPane.this.nnMapDccSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.preambleSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("DccPreambles"), 21, Sprog3PlusEditNVPane.this.preambleUpdateFn);
            Sprog3PlusEditNVPane.this.preambleSpinner.setToolTip(Bundle.getMessage("DccPreamblesTt"));
            Sprog3PlusEditNVPane.this.preambleSpinner.init(Sprog3PlusEditNVPane.this.getSelectValue(21, 14), 14.0, 32.0, 1.0);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.preambleSpinner, c);
            this.add(gridPane);
        }
    }

    protected class UpdateAccyCount
    implements CbusModulesCommon.UpdateNV {
        protected UpdateAccyCount() {
        }

        @Override
        public void setNewVal(int index) {
            int cnt = ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.accyPktSpinner.getModel()).getNumber().intValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(cnt, index - 1, 5);
        }
    }

    protected class UpdateCanId
    implements CbusModulesCommon.UpdateNV {
        protected UpdateCanId() {
        }

        @Override
        public void setNewVal(int index) {
            int canId = ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.canIdSpinner.getModel()).getNumber().intValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(canId, index - 1, 5);
        }
    }

    protected class UpdateCmdStaNo
    implements CbusModulesCommon.UpdateNV {
        protected UpdateCmdStaNo() {
        }

        @Override
        public void setNewVal(int index) {
            int cmdStaNo = ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.cmdStaNoSpinner.getModel()).getNumber().intValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(cmdStaNo, index - 1, 5);
        }
    }

    protected class UpdateCurrentLimit
    implements CbusModulesCommon.UpdateNV {
        protected UpdateCurrentLimit() {
        }

        @Override
        public void setNewVal(int index) {
            float fLimit = index == 13 ? ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.mainSpinner.getModel()).getNumber().floatValue() : ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.progSpinner.getModel()).getNumber().floatValue();
            int limit = (int)((double)(fLimit * 100.0f) + 0.5);
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(limit, index - 1, 5);
        }
    }

    protected class UpdateFlags
    implements CbusModulesCommon.UpdateNV {
        protected UpdateFlags() {
        }

        @Override
        public void setNewVal(int index) {
            int flags = Sprog3PlusEditNVPane.this.csFlags[index].getFlags();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(flags, 2 + index - 1, 5);
        }
    }

    protected class UpdateMeter
    implements CbusModulesCommon.UpdateNV {
        protected UpdateMeter() {
        }

        @Override
        public void setNewVal(int index) {
            int mode = Sprog3PlusEditNVPane.this.meter.isSelected() ? 1 : 0;
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mode, index - 1, 5);
        }
    }

    protected class UpdateNnMap
    implements CbusModulesCommon.UpdateNV {
        protected UpdateNnMap() {
        }

        @Override
        public void setNewVal(int index) {
            int mapNn = ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.nnMapDccSpinner.getModel()).getNumber().intValue();
            int mapNnHi = mapNn / 256;
            int mapNnLo = mapNn % 256;
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mapNnHi, index - 1, 5);
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mapNnLo, index, 5);
        }
    }

    protected class UpdateNodeNumber
    implements CbusModulesCommon.UpdateNV {
        protected UpdateNodeNumber() {
        }

        @Override
        public void setNewVal(int index) {
            int nn = ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.nodeNumberSpinner.getModel()).getNumber().intValue();
            int nnHi = nn / 256;
            int nnLo = nn % 256;
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(nnHi, index - 1, 5);
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(nnLo, index, 5);
        }
    }

    protected class UpdatePowerMode
    implements CbusModulesCommon.UpdateNV {
        protected UpdatePowerMode() {
        }

        @Override
        public void setNewVal(int index) {
            int mode = Sprog3PlusEditNVPane.this.powerModeList.getSelectedIndex();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mode, index - 1, 5);
        }
    }

    protected class UpdatePreamble
    implements CbusModulesCommon.UpdateNV {
        protected UpdatePreamble() {
        }

        @Override
        public void setNewVal(int index) {
            int pre = ((SpinnerNumberModel)Sprog3PlusEditNVPane.this.preambleSpinner.getModel()).getNumber().intValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(pre, index - 1, 5);
        }
    }
}

