/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.merg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.jmrix.can.cbus.swing.modules.merg.Bundle;
import jmri.jmrix.can.cbus.swing.modules.merg.CanCmdEditNVPane;

public class CanCmdPaneProvider
extends CbusConfigPaneProvider {
    String type = "CANCMD";
    public static final int CMD_STATION_NUMBER = 1;
    public static final int USER_FLAGS = 2;
    public static final int OPERATIONS_FLAGS = 3;
    public static final int DEBUG_FLAGS = 4;
    public static final int WALKABOUT_TIMEOUT = 5;
    public static final int MAIN_TRACK_CURRENT_LIMIT = 6;
    public static final int PROG_TRACK_CURRENT_LIMIT = 7;
    public static final int CURRENT_MULTIPLIER = 8;
    public static final int INC_CURRENT_FOR_ACK = 9;
    public static final int UNUSED_NV10 = 10;
    public static final int NN_MAP_DCC_HI = 11;
    public static final int NN_MAP_DCC_LO = 12;
    public static final int SEND_CURRENT_INTERVAL = 13;
    public static final int SOD_DELAY = 14;
    public static final int UNUSED_NV15 = 15;
    public static final int UNUSED_NV16 = 16;
    private static final Map<Integer, String> nvMap = CanCmdPaneProvider.createNvMap();

    @Override
    @Nonnull
    public String getModuleType() {
        return this.type;
    }

    private static Map<Integer, String> createNvMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "Error - invalid NV index");
        result.put(1, Bundle.getMessage("CmdStaNo"));
        result.put(2, Bundle.getMessage("UserFlags"));
        result.put(3, Bundle.getMessage("OperationsFlags"));
        result.put(4, Bundle.getMessage("DebugFlags"));
        result.put(5, Bundle.getMessage("WalkaboutTimeout"));
        result.put(6, Bundle.getMessage("MainTrackCurrentLimit"));
        result.put(7, Bundle.getMessage("ProgTrackCurrentLimit"));
        result.put(8, Bundle.getMessage("CurrentMultiplier"));
        result.put(9, Bundle.getMessage("IncCurrentForAck"));
        result.put(11, Bundle.getMessage("NnMapToDccHi"));
        result.put(12, Bundle.getMessage("NnMapToDccLo"));
        result.put(13, Bundle.getMessage("SendCurrentInterval"));
        result.put(14, Bundle.getMessage("SodDelay"));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public String getNVNameByIndex(int index) {
        String nv = nvMap.get(index);
        if (nv == null) {
            return Bundle.getMessage("UnknownNv");
        }
        return nv;
    }

    @Override
    public AbstractEditNVPane getEditNVFrameInstance() {
        return this._nVarEditFrame;
    }

    @Override
    public AbstractEditNVPane getEditNVFrame(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        this._nVarEditFrame = new CanCmdEditNVPane(dataModel, node);
        return this._nVarEditFrame.getContent();
    }
}

