/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CbusModulesCommon;
import jmri.jmrix.can.cbus.swing.modules.base.Bundle;

public class Sol8BaseEditNVPane
extends AbstractEditNVPane {
    public static final int OUTPUTS = 8;
    public static final int TIME_STEP_SIZE = 10;
    private final CbusModulesCommon.UpdateNV pulseUpdateFn = new UpdatePulse();
    private final CbusModulesCommon.UpdateNV rechargeUpdateFn = new UpdateRecharge();
    private final CbusModulesCommon.UpdateNV fireDelayUpdateFn = new UpdateFireDelay();
    private final CbusModulesCommon.UpdateNV enableDelayUpdateFn = new UpdateEnableDelay();
    private CbusModulesCommon.TitledSpinner[] pulse = new CbusModulesCommon.TitledSpinner[9];
    private CbusModulesCommon.TitledSpinner rechargeSpinner;
    private CbusModulesCommon.TitledSpinner fireDelaySpinner;
    private CbusModulesCommon.TitledSpinner enableDelaySpinner;

    protected Sol8BaseEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JPanel gridPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        int y = 0;
        while (y < 2) {
            c.gridx = 0;
            int x = 0;
            while (x < 4) {
                int index = y * 4 + x + 1;
                this.pulse[index] = new CbusModulesCommon.TitledSpinner(String.valueOf(Bundle.getMessage("OutputX", index)) + " " + Bundle.getMessage("PulseWidthUnits"), index, this.pulseUpdateFn);
                this.pulse[index].setToolTip(Bundle.getMessage("CanSolOutputTt"));
                this.pulse[index].init(this.getSelectValue(index) * 10, 0.0, 2550.0, 10.0);
                gridPane.add((Component)this.pulse[index], c);
                ++c.gridx;
                ++x;
            }
            ++c.gridy;
            ++y;
        }
        c.gridx = 0;
        this.rechargeSpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("RechargeTimeUnits"), 9, this.rechargeUpdateFn);
        this.rechargeSpinner.setToolTip(Bundle.getMessage("RechargeTimeTt"));
        this.rechargeSpinner.init(this.getSelectValue(9) * 10, 0.0, 2550.0, 10.0);
        gridPane.add((Component)this.rechargeSpinner, c);
        ++c.gridx;
        this.fireDelaySpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("FireDelayUnits"), 10, this.fireDelayUpdateFn);
        this.fireDelaySpinner.setToolTip(Bundle.getMessage("FireDelayTt"));
        this.fireDelaySpinner.init(this.getSelectValue(10) * 10, 0.0, 2550.0, 10.0);
        gridPane.add((Component)this.fireDelaySpinner, c);
        ++c.gridx;
        this.enableDelaySpinner = new CbusModulesCommon.TitledSpinner(Bundle.getMessage("EnableDelayUnits"), 11, this.enableDelayUpdateFn);
        this.enableDelaySpinner.setToolTip(Bundle.getMessage("EnableDelayTt"));
        this.enableDelaySpinner.init(this.getSelectValue(11) * 10, 0.0, 2550.0, 10.0);
        gridPane.add((Component)this.enableDelaySpinner, c);
        JScrollPane scroll = new JScrollPane(gridPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue(nv);
            if (nv > 0 && nv <= 8) {
                this.pulse[nv].getModel().setValue(value * 10);
            } else if (nv == 9) {
                this.rechargeSpinner.getModel().setValue(value * 10);
            } else if (nv == 10) {
                this.fireDelaySpinner.getModel().setValue(value * 10);
            } else if (nv == 11) {
                this.enableDelaySpinner.getModel().setValue(value * 10);
            }
        }
    }

    protected class UpdateEnableDelay
    implements CbusModulesCommon.UpdateNV {
        protected UpdateEnableDelay() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = ((SpinnerNumberModel)Sol8BaseEditNVPane.this.enableDelaySpinner.getModel()).getNumber().intValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }

    protected class UpdateFireDelay
    implements CbusModulesCommon.UpdateNV {
        protected UpdateFireDelay() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = ((SpinnerNumberModel)Sol8BaseEditNVPane.this.fireDelaySpinner.getModel()).getNumber().intValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }

    protected class UpdatePulse
    implements CbusModulesCommon.UpdateNV {
        protected UpdatePulse() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = ((SpinnerNumberModel)Sol8BaseEditNVPane.this.pulse[index].getModel()).getNumber().intValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }

    protected class UpdateRecharge
    implements CbusModulesCommon.UpdateNV {
        protected UpdateRecharge() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = ((SpinnerNumberModel)Sol8BaseEditNVPane.this.rechargeSpinner.getModel()).getNumber().intValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }
}

