/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CbusModulesCommon {

    public static class CmdStaFlags
    extends JPanel {
        protected int _index;
        protected String _title;
        protected int flags;
        protected JRadioButton[] buttons;
        protected UpdateNV _flagUpdateFn;

        public CmdStaFlags(int index, String title, String[] flagStrings, String[] flagTtStrings, UpdateNV update) {
            this._index = index;
            this._title = title;
            this._flagUpdateFn = update;
            this.buttons = new JRadioButton[8];
            int i = 0;
            while (i < 8) {
                this.buttons[i] = new JRadioButton(flagStrings[i]);
                this.buttons[i].setToolTipText(flagTtStrings[i]);
                this.buttons[i].addActionListener(e -> this.flagActionListener());
                ++i;
            }
        }

        public JPanel getContents() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder t = BorderFactory.createTitledBorder(border, this._title);
            gridPane.setBorder(t);
            int i = 0;
            while (i < 8) {
                gridPane.add((Component)this.buttons[i], c);
                ++c.gridy;
                ++i;
            }
            this.setButtons();
            return gridPane;
        }

        protected void flagActionListener() {
            int value = this.buttons[7].isSelected() ? 1 : 0;
            int i = 6;
            while (i >= 0) {
                value = (value << 1) + (this.buttons[i].isSelected() ? 1 : 0);
                --i;
            }
            this.setFlags(value);
            this._flagUpdateFn.setNewVal(this._index);
        }

        public void setFlags(int value) {
            this.flags = value;
            this.setButtons();
        }

        public int getFlags() {
            return this.flags;
        }

        protected void setButtons() {
            int i = 0;
            while (i < 8) {
                if ((this.flags & 1 << i) > 0) {
                    this.buttons[i].setSelected(true);
                } else {
                    this.buttons[i].setSelected(false);
                }
                ++i;
            }
        }
    }

    public static class TitledSlider
    extends JPanel
    implements ChangeListener {
        protected JSlider tSlide;
        protected int _index;
        protected String _title;
        protected UpdateNV _update;

        public TitledSlider(String title, int index, UpdateNV update) {
            this._title = title;
            this._index = index;
            this._update = update;
            this.tSlide = new JSlider();
        }

        public void init(int min, int max, int init) {
            GridLayout grid = new GridLayout(1, 1);
            this.setLayout(grid);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titled = BorderFactory.createTitledBorder(border, this._title);
            this.setBorder(titled);
            this.tSlide.setMinimum(min);
            this.tSlide.setMaximum(max);
            this.tSlide.setValue(init);
            this.tSlide.addChangeListener(this);
            this.add(this.tSlide);
        }

        public void setValue(int v) {
            this.tSlide.setValue(v);
        }

        public int getValue() {
            return this.tSlide.getValue();
        }

        public void setToolTip(String tt) {
            this.tSlide.setToolTipText(tt);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            if (!source.getValueIsAdjusting()) {
                this._update.setNewVal(this._index);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            Border border = this.getBorder();
            int borderWidth = 0;
            if (border instanceof TitledBorder) {
                Insets insets = this.getInsets();
                TitledBorder titledBorder = (TitledBorder)border;
                borderWidth = titledBorder.getMinimumSize((Component)this).width + insets.left + insets.right;
            }
            int preferredWidth = Math.max(preferredSize.width, borderWidth);
            return new Dimension(preferredWidth, preferredSize.height);
        }
    }

    public static class TitledSpinner
    extends JPanel
    implements ChangeListener {
        protected JSpinner tSpin;
        protected int _index;
        protected String _title;
        protected double _step;
        protected UpdateNV _update;

        public TitledSpinner(String title, int index, UpdateNV update) {
            this._title = title;
            this._index = index;
            this._update = update;
            this.tSpin = new JSpinner();
        }

        public void init(double init, double min, double max, double step) {
            this._step = step;
            GridLayout grid = new GridLayout(1, 1);
            this.setLayout(grid);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titled = BorderFactory.createTitledBorder(border, this._title);
            this.setBorder(titled);
            SpinnerNumberModel spinModel = new SpinnerNumberModel(init, min, max, this._step);
            this.tSpin.setModel(spinModel);
            this.tSpin.addChangeListener(this);
            this.add(this.tSpin);
        }

        public void setToolTip(String tt) {
            this.tSpin.setToolTipText(tt);
        }

        @Override
        public void setEnabled(boolean b) {
            this.tSpin.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            return this.tSpin.isEnabled();
        }

        public SpinnerModel getModel() {
            return this.tSpin.getModel();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this._update.setNewVal(this._index);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            Border border = this.getBorder();
            int borderWidth = 0;
            if (border instanceof TitledBorder) {
                Insets insets = this.getInsets();
                TitledBorder titledBorder = (TitledBorder)border;
                borderWidth = titledBorder.getMinimumSize((Component)this).width + insets.left + insets.right;
            }
            int preferredWidth = Math.max(preferredSize.width, borderWidth);
            return new Dimension(preferredWidth, preferredSize.height);
        }
    }

    public static interface UpdateNV {
        public void setNewVal(int var1);
    }
}

