/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.UnknownPaneProvider;
import jmri.jmrix.can.swing.CanPanel;
import jmri.spi.JmriServiceProviderInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CbusConfigPaneProvider
extends CanPanel
implements JmriServiceProviderInterface {
    protected AbstractEditNVPane _nVarEditFrame = null;
    static volatile Map<String, CbusConfigPaneProvider> instanceMap = null;
    private static final Logger log = LoggerFactory.getLogger(CbusConfigPaneProvider.class);

    protected CbusConfigPaneProvider() {
    }

    @Nonnull
    public abstract String getModuleType();

    public abstract String getNVNameByIndex(int var1);

    public abstract AbstractEditNVPane getEditNVFrameInstance();

    public abstract AbstractEditNVPane getEditNVFrame(CbusNodeNVTableDataModel var1, CbusNode var2);

    @Override
    public final String toString() {
        return this.getModuleType();
    }

    public static final CbusConfigPaneProvider getProviderByName(String name) {
        CbusConfigPaneProvider p = instanceMap.get(name);
        return p;
    }

    public static final CbusConfigPaneProvider getProviderByNode(CbusNode node) {
        CbusConfigPaneProvider p = instanceMap.get(node.getName());
        if (p != null) {
            return p;
        }
        if (node.getResyncName() != null && (p = instanceMap.get(node.getResyncName())) != null) {
            return p;
        }
        log.info("node gets unknown provider: {}", (Object)node);
        return new UnknownPaneProvider();
    }

    public static final Map<String, CbusConfigPaneProvider> getInstancesMap() {
        if (instanceMap == null) {
            CbusConfigPaneProvider.loadInstances();
        }
        return Collections.unmodifiableMap(instanceMap);
    }

    public static final Collection<CbusConfigPaneProvider> getInstancesCollection() {
        if (instanceMap == null) {
            CbusConfigPaneProvider.loadInstances();
        }
        return Collections.unmodifiableCollection(instanceMap.values());
    }

    public static final void loadInstances() {
        if (instanceMap != null) {
            return;
        }
        instanceMap = new TreeMap<String, CbusConfigPaneProvider>();
        ServiceLoader.load(CbusConfigPaneProvider.class).forEach(pane -> {
            if (!instanceMap.containsKey(pane.getModuleType())) {
                instanceMap.put(pane.getModuleType(), (CbusConfigPaneProvider)pane);
            }
        });
    }
}

