/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modeswitcher;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.swing.modeswitcher.Bundle;
import jmri.jmrix.can.cbus.swing.modeswitcher.SprogCbusModeSwitcherFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCbusSimpleModeSwitcherFrame
extends SprogCbusModeSwitcherFrame {
    protected static final int PROG_MODE = 0;
    protected static final int CMD_MODE = 1;
    private JRadioButton progModeButton;
    private JRadioButton cmdModeButton;
    private boolean _hideProgWarning = false;
    private boolean _hideProgModeWarning = false;
    private static final Logger log = LoggerFactory.getLogger(SprogCbusSimpleModeSwitcherFrame.class);

    public SprogCbusSimpleModeSwitcherFrame(CanSystemConnectionMemo memo) {
        super(memo, Bundle.getMessage("SprogCbusSimpleModeSwitcher"));
    }

    @Override
    public void initComponents() {
        if (this.initSetup()) {
            this.progModeButton = new JRadioButton(Bundle.getMessage("ProgMode"));
            this.cmdModeButton = new JRadioButton(Bundle.getMessage("CmdMode"));
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.progModeButton);
            buttons.add(this.cmdModeButton);
            if (this.pm.isGlobalProgrammerAvailable() && this.preferences.isGlobalProgrammerAvailable()) {
                this.progModeButton.setSelected(true);
                this.cmdModeButton.setSelected(false);
                this.mode = 0;
                this._memo.setMultipleThrottles(false);
            } else if (this.pm.isAddressedModePossible() && this.preferences.isAddressedModePossible()) {
                this.progModeButton.setSelected(false);
                this.cmdModeButton.setSelected(true);
                this.mode = 1;
                this._memo.setMultipleThrottles(true);
            } else {
                this.progModeButton.setSelected(true);
                this.cmdModeButton.setSelected(false);
                this.mode = 0;
                this._memo.setMultipleThrottles(false);
            }
            this.setHardwareMode(this.mode);
            this.preferences.setProgrammersAvailable(this.progModeButton.isSelected(), this.cmdModeButton.isSelected());
            ActionListener listener = ae -> {
                if (this.progModeButton.isSelected() && this.mode != 0) {
                    log.info("Setting Global Programmer Available");
                    this.pm.setGlobalProgrammerAvailable(true);
                    this.pm.setAddressedModePossible(false);
                    this._memo.setMultipleThrottles(false);
                    this.showServiceModeWarningDialogue();
                    this.closeProgrammerWarningDialogue();
                    this.mode = 0;
                } else if (this.cmdModeButton.isSelected() && this.mode != 1) {
                    log.info("Setting Global Programmer Unavailable");
                    this.pm.setGlobalProgrammerAvailable(false);
                    this.pm.setAddressedModePossible(true);
                    this._memo.setMultipleThrottles(true);
                    this.closeProgrammerWarningDialogue();
                    this.mode = 1;
                }
                this.setHardwareMode(this.mode);
                this.preferences.setProgrammersAvailable(this.progModeButton.isSelected(), this.cmdModeButton.isSelected());
            };
            this.progModeButton.addActionListener(listener);
            this.cmdModeButton.addActionListener(listener);
            this.modePane.add(this.progModeButton);
            this.modePane.add(this.cmdModeButton);
            this.panel.add((Component)this.label, "North");
            this.panel.add((Component)this.modePane, "Center");
        }
        this.setHelp();
        this.add(this.panel);
        this.pack();
        this.setVisible(true);
    }

    protected void closeProgrammerWarningDialogue() {
        if (!GraphicsEnvironment.isHeadless() && !this._hideProgWarning) {
            ThreadingUtil.runOnGUI(() -> {
                JCheckBox checkbox = new JCheckBox(Bundle.getMessage("HideFurtherWarnings"));
                Object[] params = new Object[]{Bundle.getMessage("ProgWarning"), checkbox};
                JOptionPane pane = new JOptionPane(params);
                pane.setMessageType(2);
                JDialog dialog = pane.createDialog(null, Bundle.getMessage("switchMode"));
                dialog.setModal(false);
                dialog.setVisible(true);
                dialog.requestFocus();
                dialog.toFront();
                ActionListener progPopUpCheckBox = evt -> this.hideProgWarning(checkbox.isSelected());
                checkbox.addActionListener(progPopUpCheckBox);
            });
        }
    }

    public void hideProgWarning(boolean hide) {
        this._hideProgWarning = hide;
    }

    protected void showServiceModeWarningDialogue() {
        if (!GraphicsEnvironment.isHeadless() && !this._hideProgModeWarning) {
            ThreadingUtil.runOnGUI(() -> {
                JCheckBox checkbox = new JCheckBox(Bundle.getMessage("HideFurtherWarnings"));
                Object[] params = new Object[]{Bundle.getMessage("ProgModeWarning"), checkbox};
                JOptionPane pane = new JOptionPane(params);
                pane.setMessageType(2);
                JDialog dialog = pane.createDialog(null, Bundle.getMessage("switchToProgMode"));
                dialog.setModal(false);
                dialog.setVisible(true);
                dialog.requestFocus();
                dialog.toFront();
                ActionListener progPopUpCheckBox = evt -> this.hideProgModeWarning(checkbox.isSelected());
                checkbox.addActionListener(progPopUpCheckBox);
            });
        }
    }

    public void hideProgModeWarning(boolean hide) {
        this._hideProgModeWarning = hide;
    }

    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.can.cbus.swing.modeswitcher.SprogCbusSimpleModeSwitcherFrame", true);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

