/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventtable;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.util.ThreadingUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventTablePrintAction
extends AbstractAction {
    private static final int[] whichPrintColumns;
    private final String _title;
    private final CbusEventTableDataModel _model;
    private final boolean _preview;
    private static final Logger log;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        whichPrintColumns = nArray;
        log = LoggerFactory.getLogger(CbusEventTablePrintAction.class);
    }

    public CbusEventTablePrintAction(String actionName, @Nonnull CbusEventTableDataModel model, @Nonnull String title, boolean preview) {
        super(actionName);
        this._model = model;
        this._title = title;
        this._preview = preview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ThreadingUtil.runOnGUIEventually(() -> {
            HardcopyWriter writer;
            try {
                writer = new HardcopyWriter(new Frame(), this._title, 10, 0.8, 0.5, 0.5, 0.5, this._preview);
            }
            catch (HardcopyWriter.PrintCanceledException printCanceledException) {
                return;
            }
            writer.increaseLineSpacing(20);
            this.printTable(writer);
            writer.close();
        });
    }

    private void printTable(HardcopyWriter w) {
        String[] columnStrings = new String[whichPrintColumns.length];
        int[] columnWidth = new int[whichPrintColumns.length];
        this.colWidthLoop(columnStrings, columnWidth, w);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine());
        w.setFontStyle(1);
        this.printColumns(w, columnStrings, columnWidth);
        w.setFontStyle(0);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine());
        this.getEachRow(w, columnStrings, columnWidth);
    }

    private void colWidthLoop(String[] columnStrings, int[] columnWidth, HardcopyWriter w) {
        int columnTotal = 0;
        int i = 0;
        while (i < whichPrintColumns.length) {
            columnStrings[i] = this._model.getColumnName(whichPrintColumns[i]);
            int columnworkedon = whichPrintColumns[i];
            if (CbusEventTablePrintAction.getColumnWidth(columnworkedon) == 0) {
                columnWidth[i] = w.getCharactersPerLine() - columnTotal;
            } else {
                columnWidth[i] = CbusEventTablePrintAction.getColumnWidth(columnworkedon);
                columnTotal = columnTotal + columnWidth[i] + 1;
            }
            ++i;
        }
    }

    private void getEachRow(HardcopyWriter w, String[] columnStrings, int[] columnWidth) {
        int i = 0;
        while (i < this._model.getRowCount()) {
            int k = 0;
            while (k < whichPrintColumns.length) {
                int j = whichPrintColumns[k];
                columnStrings[k] = this._model.getValueAt(i, j) instanceof Integer ? this._model.getValueAt(i, j).toString() : (String)this._model.getValueAt(i, j);
                ++k;
            }
            this.printColumns(w, columnStrings, columnWidth);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine());
            ++i;
        }
    }

    private void printColumns(HardcopyWriter w, String[] columnStrings, int[] columnWidth) {
        String columnString = "";
        String lineString = "";
        boolean complete = false;
        while (!complete) {
            complete = true;
            int i = 0;
            while (i < columnStrings.length) {
                StringBuilder buf = new StringBuilder();
                int j = 0;
                while (j < columnWidth[i]) {
                    buf.append(" ");
                    ++j;
                }
                String spaces = buf.toString();
                if (columnStrings[i].length() > columnWidth[i]) {
                    boolean noWord = true;
                    int k = columnWidth[i];
                    while (k >= 1) {
                        if (columnStrings[i].substring(k - 1, k).equals(" ") || columnStrings[i].substring(k - 1, k).equals("-") || columnStrings[i].substring(k - 1, k).equals("_")) {
                            columnString = String.valueOf(columnStrings[i].substring(0, k)) + spaces.substring(k);
                            columnStrings[i] = columnStrings[i].substring(k);
                            noWord = false;
                            complete = false;
                            break;
                        }
                        --k;
                    }
                    if (noWord) {
                        columnString = columnStrings[i].substring(0, columnWidth[i]);
                        columnStrings[i] = columnStrings[i].substring(columnWidth[i]);
                        complete = false;
                    }
                } else {
                    columnString = String.valueOf(columnStrings[i]) + spaces.substring(columnStrings[i].length());
                    columnStrings[i] = "";
                }
                lineString = String.valueOf(lineString) + columnString + " ";
                ++i;
            }
            try {
                w.write(lineString);
                int column = 0;
                int i2 = 0;
                while (i2 < whichPrintColumns.length) {
                    w.write(w.getCurrentLineNumber(), column, w.getCurrentLineNumber() + 1, column);
                    column = column + columnWidth[i2] + 1;
                    ++i2;
                }
                w.write(w.getCurrentLineNumber(), w.getCharactersPerLine(), w.getCurrentLineNumber() + 1, w.getCharactersPerLine());
                lineString = "\n";
                w.write(lineString);
                lineString = "";
            }
            catch (IOException e) {
                log.warn("error during printing: {}", (Throwable)e);
            }
        }
    }

    private static int getColumnWidth(int col) {
        switch (col) {
            case 2: {
                return 14;
            }
            case 4: {
                return 0;
            }
        }
        return 8;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

