/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventtable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.swing.CbusCreateBeanPane;
import jmri.jmrix.can.cbus.swing.CbusNewEventPane;
import jmri.jmrix.can.cbus.swing.CbusSendEventPane;
import jmri.jmrix.can.cbus.swing.eventtable.Bundle;
import jmri.jmrix.can.cbus.swing.eventtable.CbusEventTable;
import jmri.jmrix.can.cbus.swing.eventtable.CbusEventTablePrintAction;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.swing.sdi.JmriJFrameInterface;
import jmri.util.table.JTableToCsvAction;
import jmri.util.table.JTableWithColumnToolTips;

public class CbusEventTablePane
extends CanPanel {
    protected CbusEventTableDataModel eventModel;
    protected JTable eventTable;
    protected CbusPreferences preferences;
    private UserPreferencesManager p;
    private CbusCreateBeanPane newBeanPanel;
    protected CbusNewEventPane neweventcontainer;
    private CbusSendEventPane sendPane;
    protected JPanel filterpanel;
    public CbusEventTable cbEvTable;
    protected final JTextField filterText = new JTextField("", 8);
    protected JButton clearfilterButton;
    protected final JMenu evColMenu = new JMenu(Bundle.getMessage("evColMenuName"));
    protected final JMenu evStatMenu = new JMenu(Bundle.getMessage("evStatMenuName"));
    protected final JMenu evJmMenu = new JMenu(Bundle.getMessage("latestEvCols"));
    protected final JMenu buttonMenu = new JMenu(Bundle.getMessage("buttonCols"));
    private StayOpenCheckBoxItem showfilterpanel;
    private StayOpenCheckBoxItem shownewevent;
    private StayOpenCheckBoxItem showNewBeanPanel;
    private StayOpenCheckBoxItem showSendEventPanel;
    private final XTableColumnModel tcm = new XTableColumnModel();

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.preferences = InstanceManager.getDefault(CbusPreferences.class);
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        CbusEventTableDataModel.checkCreateNewEventModel(memo);
        this.eventModel = InstanceManager.getNullableDefault(CbusEventTableDataModel.class);
        this.eventTable = new JTableWithColumnToolTips((TableModel)this.eventModel, CbusEventTableDataModel.CBUS_EV_TABLE_COL_TOOLTIPS);
        this.eventTable.setColumnModel(this.tcm);
        this.init();
    }

    public final void init() {
        this.setLayout(new BorderLayout());
        JPanel _toppanelcontainer = new JPanel();
        _toppanelcontainer.setLayout(new BoxLayout(_toppanelcontainer, 0));
        JPanel _topToppanelcontainer = new JPanel();
        _topToppanelcontainer.setLayout(new BoxLayout(_topToppanelcontainer, 1));
        this.neweventcontainer = new CbusNewEventPane(this);
        this.cbEvTable = new CbusEventTable(this);
        this.newBeanPanel = new CbusCreateBeanPane(this);
        this.sendPane = new CbusSendEventPane(this);
        _toppanelcontainer.add(this.newBeanPanel);
        _toppanelcontainer.add(this.getFilterPanel());
        _toppanelcontainer.add(this.neweventcontainer);
        _topToppanelcontainer.add(_toppanelcontainer);
        _topToppanelcontainer.add(this.newBeanPanel);
        _topToppanelcontainer.add(this.sendPane);
        this.add((Component)_topToppanelcontainer, "First");
        this.add((Component)this.cbEvTable, "Center");
        this.setVisible(true);
        this.cbEvTable.tableChanged(null);
    }

    private void setPanesVisibleFromSettings() {
        if (this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Notfirstrun")) {
            this.showfilterpanel.setSelected(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Showfilterpanel"));
            this.shownewevent.setSelected(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Shownewevent"));
            this.showNewBeanPanel.setSelected(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".ShowNewBeanPanel"));
            this.showSendEventPanel.setSelected(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".ShowSendEventPanel"));
            this.filterpanel.setVisible(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Showfilterpanel"));
            this.neweventcontainer.setVisible(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Shownewevent"));
            this.newBeanPanel.setVisible(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".ShowNewBeanPanel"));
            this.sendPane.setVisible(this.p.getSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".ShowSendEventPanel"));
        } else {
            this.showfilterpanel.setSelected(true);
            this.shownewevent.setSelected(true);
            this.showNewBeanPanel.setSelected(false);
            this.showSendEventPanel.setSelected(false);
            this.newBeanPanel.setVisible(false);
            this.sendPane.setVisible(false);
        }
    }

    private JPanel getFilterPanel() {
        this.filterpanel = new JPanel();
        this.filterpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("FilterSurround")));
        this.clearfilterButton = new JButton(Bundle.getMessage("ClearFilter"));
        this.clearfilterButton.setEnabled(false);
        this.clearfilterButton.addActionListener(e -> this.filterText.setText(""));
        this.filterText.setMaximumSize(this.filterText.getPreferredSize());
        this.filterpanel.add(this.filterText);
        this.filterpanel.add(this.clearfilterButton);
        this.cbEvTable.addFilterListener(this.filterText);
        return this.filterpanel;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.eventtable.EventTablePane";
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        menuList.add(this.getFileMenu());
        menuList.add(this.getDisplayMenu());
        menuList.add(this.evColMenu);
        menuList.add(this.evJmMenu);
        menuList.add(this.buttonMenu);
        menuList.add(this.evStatMenu);
        return menuList;
    }

    private JMenu getFileMenu() {
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        StayOpenCheckBoxItem saveRestoreEventTableItem = new StayOpenCheckBoxItem(Bundle.getMessage("SaveEvSession"));
        saveRestoreEventTableItem.setSelected(this.preferences.getSaveRestoreEventTable());
        saveRestoreEventTableItem.addActionListener(e -> this.preferences.setSaveRestoreEventTable(saveRestoreEventTableItem.isSelected()));
        fileMenu.add(saveRestoreEventTableItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(new JTableToCsvAction(Bundle.getMessage("ExportCsvAll"), null, this.eventModel, "myevents.csv", CbusEventTableDataModel.BUTTON_COLUMNS));
        fileMenu.add(new JTableToCsvAction(Bundle.getMessage("ExportCsvView"), this.eventTable, this.eventModel, "myevents.csv", CbusEventTableDataModel.BUTTON_COLUMNS));
        fileMenu.add(new JSeparator());
        fileMenu.add(new CbusEventTablePrintAction(Bundle.getMessage("PrintTable"), this.eventModel, this.getTitle(), false));
        fileMenu.add(new CbusEventTablePrintAction(Bundle.getMessage("PreviewTable"), this.eventModel, this.getTitle(), true));
        return fileMenu;
    }

    private JMenu getDisplayMenu() {
        JMenu displayMenu = new JMenu(Bundle.getMessage("Display"));
        this.showNewBeanPanel = new StayOpenCheckBoxItem(Bundle.getMessage("NewTsl"));
        this.showNewBeanPanel.addActionListener(e -> this.newBeanPanel.setVisible(this.showNewBeanPanel.isSelected()));
        this.shownewevent = new StayOpenCheckBoxItem(Bundle.getMessage("NewEvent"));
        this.shownewevent.addActionListener(e -> this.neweventcontainer.setVisible(this.shownewevent.isSelected()));
        this.showfilterpanel = new StayOpenCheckBoxItem(Bundle.getMessage("FilterSurround"));
        this.showfilterpanel.addActionListener(e -> this.filterpanel.setVisible(this.showfilterpanel.isSelected()));
        this.showSendEventPanel = new StayOpenCheckBoxItem(Bundle.getMessage("ButtonSendEvent"));
        this.showSendEventPanel.addActionListener(e -> this.sendPane.setVisible(this.showSendEventPanel.isSelected()));
        this.setPanesVisibleFromSettings();
        displayMenu.add(this.showfilterpanel);
        displayMenu.add(this.shownewevent);
        displayMenu.add(this.showNewBeanPanel);
        displayMenu.add(this.showSendEventPanel);
        return displayMenu;
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("EventTableTitle"));
    }

    @Override
    public void dispose() {
        if (this.cbEvTable != null) {
            this.cbEvTable.dispose();
        }
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.eventTable));
        this.p.setSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Notfirstrun", true);
        this.p.setSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Showfilterpanel", this.showfilterpanel.isSelected());
        this.p.setSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".Shownewevent", this.shownewevent.isSelected());
        this.p.setSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".ShowNewBeanPanel", this.showNewBeanPanel.isSelected());
        this.p.setSimplePreferenceState(String.valueOf(this.getClass().getName()) + ".ShowSendEventPanel", this.showSendEventPanel.isSelected());
        super.dispose();
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemEventTable"), new JmriJFrameInterface(), CbusEventTablePane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

