/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventtable;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBeanRenderer {
    private ImageIcon tOff;
    private ImageIcon tOn;
    private ImageIcon sOff;
    private ImageIcon sOn;
    private ImageIcon lOff;
    private ImageIcon lOn;
    private static final String ROOTPATH = "resources/icons/misc/switchboard/";
    private static final Logger log = LoggerFactory.getLogger(CbusBeanRenderer.class);

    public CbusBeanRenderer(int iconHeight) {
        this.initImages(iconHeight);
    }

    public ImageIcon getBeanIcon(String beanTypeChar, int beanState) {
        ImageIcon img = null;
        switch (beanTypeChar) {
            case "T": {
                img = beanState == 2 ? this.tOn : this.tOff;
                break;
            }
            case "S": {
                img = beanState == 2 ? this.sOn : this.sOff;
                break;
            }
            case "L": {
                img = beanState == 2 ? this.lOn : this.lOff;
                break;
            }
            default: {
                log.error("no image for bean {} state {}", (Object)beanTypeChar, (Object)beanState);
            }
        }
        return img;
    }

    private static ImageIcon getTurnoutIcon(String file, int iconHeight) throws IOException {
        BufferedImage bigImage = ImageIO.read(new File(ROOTPATH + file));
        return new ImageIcon(bigImage.getScaledInstance((int)Math.round((double)iconHeight * 1.5), iconHeight - 2, 1));
    }

    private static ImageIcon getSensorIcon(String file, int iconHeight) throws IOException {
        BufferedImage bufimg = ImageIO.read(new File(ROOTPATH + file));
        BufferedImage img = bufimg.getSubimage(11, 23, 59, 60);
        BufferedImage copyOfImage = new BufferedImage(img.getWidth(), img.getHeight(), 6);
        Graphics2D g = copyOfImage.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        return new ImageIcon(img.getScaledInstance(iconHeight + 2, iconHeight + 2, 1));
    }

    private static ImageIcon getLightIcon(String file, int iconHeight) throws IOException {
        BufferedImage img = ImageIO.read(new File(ROOTPATH + file)).getSubimage(11, 23, 59, 60);
        BufferedImage copyOfImage = new BufferedImage(img.getWidth(), img.getHeight(), 6);
        Graphics2D g = copyOfImage.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        return new ImageIcon(img.getScaledInstance(iconHeight - 3, iconHeight - 3, 1));
    }

    private void initImages(int iconHeight) {
        try {
            this.tOn = CbusBeanRenderer.getTurnoutIcon("T-on-s.png", iconHeight);
            this.tOff = CbusBeanRenderer.getTurnoutIcon("T-off-s.png", iconHeight);
            this.sOn = CbusBeanRenderer.getSensorIcon("S-on-s.png", iconHeight);
            this.sOff = CbusBeanRenderer.getSensorIcon("S-off-s.png", iconHeight);
            this.lOn = CbusBeanRenderer.getLightIcon("L-on-s.png", iconHeight);
            this.lOff = CbusBeanRenderer.getLightIcon("L-off-s.png", iconHeight);
        }
        catch (IOException ex) {
            log.error("Error creating Bean Icon Images: {}", (Throwable)ex);
        }
    }
}

