/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventrequestmonitor;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.CbusOpCodes;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.Bundle;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.CbusEventRequestMonitorEvent;
import jmri.util.ThreadingUtil;
import jmri.util.swing.TextAreaFIFO;

public class CbusEventRequestDataModel
extends AbstractTableModel
implements CanListener {
    private boolean sessionConfirmDeleteRow = true;
    private final int _defaultFeedback = 1;
    protected int _contype = 0;
    protected String _context;
    private final int _defaultfeedbackdelay = 4000;
    private static final int MAX_LINES = 500;
    protected ArrayList<CbusEventRequestMonitorEvent> _mainArray = new ArrayList();
    private final CbusNameService nameService;
    protected TextAreaFIFO tablefeedback = new TextAreaFIFO(500);
    private final TrafficController tc;
    public static final int EVENT_COLUMN = 0;
    public static final int NODE_COLUMN = 1;
    public static final int NAME_COLUMN = 2;
    public static final int LATEST_TIMESTAMP_COLUMN = 3;
    public static final int STATUS_REQUEST_BUTTON_COLUMN = 4;
    public static final int LASTFEEDBACK_COLUMN = 5;
    public static final int FEEDBACKOUTSTANDING_COLUMN = 6;
    public static final int FEEDBACKREQUIRED_COLUMN = 7;
    public static final int FEEDBACKTIMEOUT_COLUMN = 8;
    public static final int FEEDBACKEVENT_COLUMN = 9;
    public static final int FEEDBACKNODE_COLUMN = 10;
    public static final int DELETE_BUTTON_COLUMN = 11;
    public static final int MAX_COLUMN = 12;
    protected static final String[] columnToolTips = new String[]{Bundle.getMessage("EventColTip"), Bundle.getMessage("NodeColTip"), Bundle.getMessage("NameColTip"), String.valueOf(Bundle.getMessage("ColumnLastHeard")) + Bundle.getMessage("TypeColTip"), Bundle.getMessage("ColumnRequestStatusTip"), Bundle.getMessage("FBLastTip"), Bundle.getMessage("FBOutstandingTip"), Bundle.getMessage("FBNumTip"), Bundle.getMessage("FBTimeoutTip"), Bundle.getMessage("FBEventTip"), Bundle.getMessage("FBNodeTip"), Bundle.getMessage("ColumnEventDeleteTip")};

    CbusEventRequestDataModel(CanSystemConnectionMemo memo, int row, int column) {
        this.tc = memo.getTrafficController();
        this.addTc(this.tc);
        this.nameService = new CbusNameService(memo);
    }

    @Override
    public int getRowCount() {
        return this._mainArray.size();
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return Bundle.getMessage("CbusNode");
            }
            case 2: {
                return Bundle.getMessage("ColumnName");
            }
            case 0: {
                return Bundle.getMessage("CbusEvent");
            }
            case 11: {
                return Bundle.getMessage("ColumnEventDelete");
            }
            case 4: {
                return Bundle.getMessage("ColumnStatusRequest");
            }
            case 3: {
                return Bundle.getMessage("ColumnLastHeard");
            }
            case 5: {
                return Bundle.getMessage("FBLast");
            }
            case 7: {
                return Bundle.getMessage("FBRequired");
            }
            case 6: {
                return Bundle.getMessage("FBOutstanding");
            }
            case 9: {
                return Bundle.getMessage("FBEvent");
            }
            case 10: {
                return Bundle.getMessage("FBNode");
            }
            case 8: {
                return Bundle.getMessage("FBTimeout");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
            case 4: 
            case 11: {
                return JButton.class;
            }
            case 3: {
                return Date.class;
            }
            case 5: {
                return Enum.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 1: {
                return this._mainArray.get(row).getNn();
            }
            case 0: {
                return this._mainArray.get(row).getEn();
            }
            case 2: {
                return this.nameService.getEventName(this._mainArray.get(row).getNn(), this._mainArray.get(row).getEn());
            }
            case 4: {
                return Bundle.getMessage("StatusButton");
            }
            case 11: {
                return Bundle.getMessage("ButtonDelete");
            }
            case 3: {
                return this._mainArray.get(row).getDate();
            }
            case 5: {
                return this._mainArray.get(row).getLastFb();
            }
            case 7: {
                return this._mainArray.get(row).getFeedbackTotReqd();
            }
            case 6: {
                return this._mainArray.get(row).getFeedbackOutstanding();
            }
            case 9: {
                return this._mainArray.get(row).getExtraEvent();
            }
            case 10: {
                return this._mainArray.get(row).getExtraNode();
            }
            case 8: {
                return this._mainArray.get(row).getFeedbackTimeout();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 11: {
                this.buttonDeleteClicked(row);
                break;
            }
            case 4: {
                this._mainArray.get(row).sendEvent(CbusEventDataElements.EvState.REQUEST);
                break;
            }
            case 3: {
                this._mainArray.get(row).setDate(new Date());
                this.updateGui(row, col);
                break;
            }
            case 7: {
                this._mainArray.get(row).setFeedbackTotReqd((Integer)value);
                this.updateGui(row, col);
                break;
            }
            case 6: {
                this._mainArray.get(row).setFeedbackOutstanding((Integer)value);
                this.updateGui(row, col);
                break;
            }
            case 9: {
                this._mainArray.get(row).setExtraEvent((Integer)value);
                this.updateGui(row, col);
                break;
            }
            case 10: {
                this._mainArray.get(row).setExtraNode((Integer)value);
                this.updateGui(row, col);
                break;
            }
            case 8: {
                this._mainArray.get(row).setFeedbackTimeout((Integer)value);
                this.updateGui(row, col);
                break;
            }
            case 5: {
                this._mainArray.get(row).setLastFb((CbusEventRequestMonitorEvent.FbState)((Object)value));
                this.updateGui(row, col);
                break;
            }
        }
    }

    private void updateGui(int row, int col) {
        ThreadingUtil.runOnGUIEventually(() -> this.fireTableCellUpdated(row, col));
    }

    @Override
    public void message(CanMessage m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int opc = CbusMessage.getOpcode(m);
        if (CbusOpCodes.isEventRequest(opc)) {
            this.processEvRequest(CbusMessage.getNodeNumber(m), CbusMessage.getEvent(m));
        } else if (CbusOpCodes.isEventNotRequest(opc)) {
            this.processEvent(CbusMessage.getNodeNumber(m), CbusMessage.getEvent(m));
        }
    }

    @Override
    public void reply(CanReply r) {
        if (r.extendedOrRtr()) {
            return;
        }
        CanMessage m = new CanMessage(r);
        this.message(m);
    }

    private void processEvent(int nn, int en) {
        int existingRow = this.eventRow(nn, en);
        int fbRow = this.extraFeedbackRow(nn, en);
        if (existingRow > -1) {
            this._mainArray.get(existingRow).setResponseReceived();
            this.setValueAt(1, existingRow, 3);
        } else if (fbRow > -1) {
            this._mainArray.get(fbRow).setResponseReceived();
        }
    }

    private void processEvRequest(int nn, int en) {
        int existingRow = this.eventRow(nn, en);
        if (existingRow < 0) {
            this.addEvent(nn, en, CbusEventDataElements.EvState.REQUEST, null);
        }
        existingRow = this.eventRow(nn, en);
        this._mainArray.get(existingRow).setRequestReceived();
    }

    protected int eventRow(int nn, int en) {
        return this._mainArray.indexOf(new CbusEvent(nn, en));
    }

    protected int extraFeedbackRow(int nn, int en) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this._mainArray.get(i).matchesFeedback(nn, en).booleanValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addEvent(int node, int event, CbusEventDataElements.EvState state, Date timestamp) {
        CbusEventRequestMonitorEvent newmonitor = new CbusEventRequestMonitorEvent(node, event, state, timestamp, 4000, 1, this);
        this._mainArray.add(newmonitor);
        ThreadingUtil.runOnGUI(() -> this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1));
        this.addToLog(1, String.valueOf(newmonitor.toString()) + Bundle.getMessage("AddedToTable"));
    }

    private void removeRow(int row) {
        this._context = String.valueOf(this._mainArray.get(row).toString()) + Bundle.getMessage("TableConfirmDelete");
        this._mainArray.remove(row);
        ThreadingUtil.runOnGUI(() -> this.fireTableRowsDeleted(row, row));
        this.addToLog(3, this._context);
    }

    private void buttonDeleteClicked(int row) {
        if (this.sessionConfirmDeleteRow) {
            JCheckBox checkbox = new JCheckBox(Bundle.getMessage("PopupSessionConfirmDel"));
            String message = String.valueOf(Bundle.getMessage("DelConfirmOne")) + "\n" + Bundle.getMessage("DelConfirmTwo");
            Object[] params = new Object[]{message, checkbox};
            if (JOptionPane.showConfirmDialog(null, params, Bundle.getMessage("DelEvPopTitle"), 2, 2) == 0) {
                boolean dontShow = checkbox.isSelected();
                if (dontShow) {
                    this.sessionConfirmDeleteRow = false;
                }
                this.removeRow(row);
            }
        } else {
            this.removeRow(row);
        }
    }

    public void addToLog(int cbuserror, String cbustext) {
        ThreadingUtil.runOnGUI(() -> {
            if (cbuserror == 3) {
                this.tablefeedback.append("\n * * * * * * * * * * * * * * * * * * * * * * " + cbustext);
            } else {
                this.tablefeedback.append("\n" + cbustext);
            }
        });
    }

    public void dispose() {
        int i = 0;
        while (i < this.getRowCount()) {
            this._mainArray.get(i).stopTheTimer();
            ++i;
        }
        this._mainArray = null;
        this.tablefeedback.dispose();
        this.tc.removeCanListener(this);
    }

    protected TextAreaFIFO tablefeedback() {
        return this.tablefeedback;
    }
}

