/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;

public class CbusConsoleStatsPane
extends JPanel {
    private JTextField sentCountField;
    private JTextField rcvdCountField;
    private JTextField eventsCountField;
    private JTextField dccCountField;
    private JTextField totalCountField;
    private JButton statsClearButton;
    private transient int _sent;
    private transient int _rcvd;
    private transient int _events;
    private transient int _dcc;
    private transient int _total;

    public CbusConsoleStatsPane(CbusConsolePane mainPane) {
        this.initButtons();
        this.statsClearButtonActionPerformed(null);
        this.addToPanel();
    }

    private void addToPanel() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("StatisticsTitle")));
        this.add(this.sentCountField);
        this.add(this.rcvdCountField);
        this.add(this.totalCountField);
        this.add(this.eventsCountField);
        this.add(this.dccCountField);
        this.add(this.statsClearButton);
        this.statsClearButton.addActionListener(this::statsClearButtonActionPerformed);
    }

    protected void incremenetTotal() {
        this.totalCountField.setText(Integer.toString(++this._total));
    }

    protected void incremenetReceived() {
        this.rcvdCountField.setText(Integer.toString(++this._rcvd));
    }

    protected void incremenetSent() {
        this.sentCountField.setText(Integer.toString(++this._sent));
    }

    protected void incrementEvents() {
        this.eventsCountField.setText(Integer.toString(++this._events));
    }

    protected void incrementDcc() {
        this.dccCountField.setText(Integer.toString(++this._dcc));
    }

    private void initButtons() {
        this.sentCountField = new JTextField("0", 8);
        this.rcvdCountField = new JTextField("0", 8);
        this.eventsCountField = new JTextField("0", 8);
        this.dccCountField = new JTextField("0", 8);
        this.totalCountField = new JTextField("0", 8);
        this.statsClearButton = new JButton();
        this.initButtonBorderToolTips();
    }

    private void initButtonBorderToolTips() {
        this.sentCountField.setToolTipText(Bundle.getMessage("TooltipSent"));
        this.sentCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SentTitle")));
        this.rcvdCountField.setToolTipText(Bundle.getMessage("TooltipReceived"));
        this.rcvdCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("ReceivedTitle")));
        this.eventsCountField.setToolTipText(Bundle.getMessage("eventsCountFieldTip"));
        this.eventsCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CbusEvents")));
        this.dccCountField.setToolTipText(Bundle.getMessage("dccCountFieldTip"));
        this.dccCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("dccCountField")));
        this.totalCountField.setToolTipText(Bundle.getMessage("totalCountFieldTip"));
        this.totalCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("totalCountField")));
        this.statsClearButton.setText(Bundle.getMessage("ButtonClear"));
        this.statsClearButton.setVisible(true);
        this.statsClearButton.setToolTipText(Bundle.getMessage("TooltipClearCounters"));
    }

    private void statsClearButtonActionPerformed(ActionEvent e) {
        this._sent = 0;
        this._rcvd = 0;
        this._events = 0;
        this._dcc = 0;
        this._total = 0;
        this.sentCountField.setText("0");
        this.rcvdCountField.setText("0");
        this.eventsCountField.setText("0");
        this.dccCountField.setText("0");
        this.totalCountField.setText("0");
    }
}

